/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothHeadset;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;

public final class BluetoothHeadset
implements BluetoothProfile {
    public static final String ACTION_AUDIO_STATE_CHANGED = "android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED";
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED";
    public static final String ACTION_VENDOR_SPECIFIC_HEADSET_EVENT = "android.bluetooth.headset.action.VENDOR_SPECIFIC_HEADSET_EVENT";
    public static final int AT_CMD_TYPE_ACTION = 4;
    public static final int AT_CMD_TYPE_BASIC = 3;
    public static final int AT_CMD_TYPE_READ = 0;
    public static final int AT_CMD_TYPE_SET = 2;
    public static final int AT_CMD_TYPE_TEST = 1;
    private static final boolean DBG = true;
    public static final String EXTRA_VENDOR_SPECIFIC_HEADSET_EVENT_ARGS = "android.bluetooth.headset.extra.VENDOR_SPECIFIC_HEADSET_EVENT_ARGS";
    public static final String EXTRA_VENDOR_SPECIFIC_HEADSET_EVENT_CMD = "android.bluetooth.headset.extra.VENDOR_SPECIFIC_HEADSET_EVENT_CMD";
    public static final String EXTRA_VENDOR_SPECIFIC_HEADSET_EVENT_CMD_TYPE = "android.bluetooth.headset.extra.VENDOR_SPECIFIC_HEADSET_EVENT_CMD_TYPE";
    public static final int STATE_AUDIO_CONNECTED = 12;
    public static final int STATE_AUDIO_CONNECTING = 11;
    public static final int STATE_AUDIO_DISCONNECTED = 10;
    private static final String TAG = "BluetoothHeadset";
    private static final boolean VDBG = false;
    public static final String VENDOR_RESULT_CODE_COMMAND_ANDROID = "+ANDROID";
    public static final String VENDOR_SPECIFIC_HEADSET_EVENT_COMPANY_ID_CATEGORY = "android.bluetooth.headset.intent.category.companyid";
    private BluetoothAdapter mAdapter;
    private final IBluetoothStateChangeCallback mBluetoothStateChangeCallback = new IBluetoothStateChangeCallback.Stub(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onBluetoothStateChange(boolean bl) {
            Log.d(BluetoothHeadset.TAG, "onBluetoothStateChange: up=" + bl);
            if (!bl) {
                ServiceConnection serviceConnection = BluetoothHeadset.this.mConnection;
                synchronized (serviceConnection) {
                    try {
                        BluetoothHeadset.access$102(BluetoothHeadset.this, null);
                        BluetoothHeadset.this.mContext.unbindService(BluetoothHeadset.this.mConnection);
                    }
                    catch (Exception exception) {
                        Log.e(BluetoothHeadset.TAG, "", exception);
                    }
                    return;
                }
            }
            ServiceConnection serviceConnection = BluetoothHeadset.this.mConnection;
            synchronized (serviceConnection) {
                try {
                    if (BluetoothHeadset.this.mService == null) {
                        BluetoothHeadset.this.doBind();
                    }
                }
                catch (Exception exception) {
                    Log.e(BluetoothHeadset.TAG, "", exception);
                }
                return;
            }
        }
    };
    private final ServiceConnection mConnection = new ServiceConnection(){

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            Log.d(BluetoothHeadset.TAG, "Proxy object connected");
            BluetoothHeadset.access$102(BluetoothHeadset.this, IBluetoothHeadset.Stub.asInterface(iBinder));
            if (BluetoothHeadset.this.mServiceListener != null) {
                BluetoothHeadset.this.mServiceListener.onServiceConnected(1, BluetoothHeadset.this);
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            Log.d(BluetoothHeadset.TAG, "Proxy object disconnected");
            BluetoothHeadset.access$102(BluetoothHeadset.this, null);
            if (BluetoothHeadset.this.mServiceListener != null) {
                BluetoothHeadset.this.mServiceListener.onServiceDisconnected(1);
            }
        }
    };
    private Context mContext;
    private IBluetoothHeadset mService;
    private BluetoothProfile.ServiceListener mServiceListener;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    BluetoothHeadset(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.mContext = context;
        this.mServiceListener = serviceListener;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager iBluetoothManager = this.mAdapter.getBluetoothManager();
        if (iBluetoothManager != null) {
            try {
                iBluetoothManager.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "", remoteException);
            }
        }
        this.doBind();
    }

    static /* synthetic */ IBluetoothHeadset access$102(BluetoothHeadset bluetoothHeadset, IBluetoothHeadset iBluetoothHeadset) {
        bluetoothHeadset.mService = iBluetoothHeadset;
        return iBluetoothHeadset;
    }

    public static boolean isBluetoothVoiceDialingEnabled(Context context) {
        return context.getResources().getBoolean(17956927);
    }

    private boolean isDisabled() {
        return this.mAdapter.getState() == 10;
    }

    private boolean isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isValidDevice(BluetoothDevice bluetoothDevice) {
        return bluetoothDevice != null && BluetoothAdapter.checkBluetoothAddress(bluetoothDevice.getAddress());
    }

    private static void log(String string2) {
        Log.d(TAG, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean acceptIncomingConnect(BluetoothDevice bluetoothDevice) {
        BluetoothHeadset.log("acceptIncomingConnect");
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.acceptIncomingConnect(bluetoothDevice);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return false;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        Log.d(TAG, Log.getStackTraceString(new Throwable()));
        return false;
    }

    public void clccResponse(int n, int n2, int n3, int n4, boolean bl, String string2, int n5) {
        if (this.mService != null && this.isEnabled()) {
            try {
                this.mService.clccResponse(n, n2, n3, n4, bl, string2, n5);
                return;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        Log.d(TAG, Log.getStackTraceString(new Throwable()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void close() {
        IBluetoothManager iBluetoothManager = this.mAdapter.getBluetoothManager();
        if (iBluetoothManager != null) {
            try {
                iBluetoothManager.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (Exception exception) {
                Log.e(TAG, "", exception);
            }
        }
        ServiceConnection serviceConnection = this.mConnection;
        synchronized (serviceConnection) {
            IBluetoothHeadset iBluetoothHeadset = this.mService;
            if (iBluetoothHeadset != null) {
                try {
                    this.mService = null;
                    this.mContext.unbindService(this.mConnection);
                }
                catch (Exception exception) {
                    Log.e(TAG, "", exception);
                }
            }
        }
        this.mServiceListener = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean connect(BluetoothDevice bluetoothDevice) {
        BluetoothHeadset.log("connect(" + bluetoothDevice + ")");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                boolean bl = this.mService.connect(bluetoothDevice);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        IBluetoothHeadset iBluetoothHeadset = this.mService;
        boolean bl = false;
        if (iBluetoothHeadset != null) return bl;
        Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean connectAudio() {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.connectAudio();
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return false;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        Log.d(TAG, Log.getStackTraceString(new Throwable()));
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean disableWBS() {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.disableWBS();
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return false;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        Log.d(TAG, Log.getStackTraceString(new Throwable()));
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean disconnect(BluetoothDevice bluetoothDevice) {
        BluetoothHeadset.log("disconnect(" + bluetoothDevice + ")");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                boolean bl = this.mService.disconnect(bluetoothDevice);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        IBluetoothHeadset iBluetoothHeadset = this.mService;
        boolean bl = false;
        if (iBluetoothHeadset != null) return bl;
        Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean disconnectAudio() {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.disconnectAudio();
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return false;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        Log.d(TAG, Log.getStackTraceString(new Throwable()));
        return false;
    }

    boolean doBind() {
        Intent intent = new Intent(IBluetoothHeadset.class.getName());
        ComponentName componentName = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(componentName);
        if (componentName == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, Process.myUserHandle())) {
            Log.e(TAG, "Could not bind to Bluetooth Headset Service with " + intent);
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean enableWBS() {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.enableWBS();
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return false;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        Log.d(TAG, Log.getStackTraceString(new Throwable()));
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getAudioState(BluetoothDevice bluetoothDevice) {
        if (this.mService != null && !this.isDisabled()) {
            try {
                return this.mService.getAudioState(bluetoothDevice);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return 10;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        Log.d(TAG, Log.getStackTraceString(new Throwable()));
        return 10;
    }

    public int getBatteryUsageHint(BluetoothDevice bluetoothDevice) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                int n = this.mService.getBatteryUsageHint(bluetoothDevice);
                return n;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return -1;
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        if (this.mService != null && this.isEnabled()) {
            try {
                List<BluetoothDevice> list = this.mService.getConnectedDevices();
                return list;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                int n = this.mService.getConnectionState(bluetoothDevice);
                return n;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        IBluetoothHeadset iBluetoothHeadset = this.mService;
        int n = 0;
        if (iBluetoothHeadset != null) return n;
        Log.w(TAG, "Proxy not attached to service");
        return 0;
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) {
        if (this.mService != null && this.isEnabled()) {
            try {
                List<BluetoothDevice> list = this.mService.getDevicesMatchingConnectionStates(nArray);
                return list;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getPriority(BluetoothDevice bluetoothDevice) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                int n = this.mService.getPriority(bluetoothDevice);
                return n;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        IBluetoothHeadset iBluetoothHeadset = this.mService;
        int n = 0;
        if (iBluetoothHeadset != null) return n;
        Log.w(TAG, "Proxy not attached to service");
        return 0;
    }

    public boolean isAudioConnected(BluetoothDevice bluetoothDevice) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                boolean bl = this.mService.isAudioConnected(bluetoothDevice);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    public boolean isAudioOn() {
        if (this.mService != null && this.isEnabled()) {
            try {
                boolean bl = this.mService.isAudioOn();
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    public void phoneStateChanged(int n, int n2, int n3, String string2, int n4) {
        if (this.mService != null && this.isEnabled()) {
            try {
                this.mService.phoneStateChanged(n, n2, n3, string2, n4);
                return;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        Log.d(TAG, Log.getStackTraceString(new Throwable()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean rejectIncomingConnect(BluetoothDevice bluetoothDevice) {
        BluetoothHeadset.log("rejectIncomingConnect");
        if (this.mService != null) {
            try {
                return this.mService.rejectIncomingConnect(bluetoothDevice);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return false;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        Log.d(TAG, Log.getStackTraceString(new Throwable()));
        return false;
    }

    public boolean sendVendorSpecificResultCode(BluetoothDevice bluetoothDevice, String string2, String string3) {
        BluetoothHeadset.log("sendVendorSpecificResultCode()");
        if (string2 == null) {
            throw new IllegalArgumentException("command is null");
        }
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                boolean bl = this.mService.sendVendorSpecificResultCode(bluetoothDevice, string2, string3);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setPriority(BluetoothDevice bluetoothDevice, int n) {
        BluetoothHeadset.log("setPriority(" + bluetoothDevice + ", " + n + ")");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            if (n != 0 && n != 100) {
                return false;
            }
            try {
                return this.mService.setPriority(bluetoothDevice, n);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (this.mService != null) return false;
        Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean startScoUsingVirtualVoiceCall(BluetoothDevice bluetoothDevice) {
        BluetoothHeadset.log("startScoUsingVirtualVoiceCall()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                return this.mService.startScoUsingVirtualVoiceCall(bluetoothDevice);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return false;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        Log.d(TAG, Log.getStackTraceString(new Throwable()));
        return false;
    }

    public boolean startVoiceRecognition(BluetoothDevice bluetoothDevice) {
        BluetoothHeadset.log("startVoiceRecognition()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                boolean bl = this.mService.startVoiceRecognition(bluetoothDevice);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean stopScoUsingVirtualVoiceCall(BluetoothDevice bluetoothDevice) {
        BluetoothHeadset.log("stopScoUsingVirtualVoiceCall()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                return this.mService.stopScoUsingVirtualVoiceCall(bluetoothDevice);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return false;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        Log.d(TAG, Log.getStackTraceString(new Throwable()));
        return false;
    }

    public boolean stopVoiceRecognition(BluetoothDevice bluetoothDevice) {
        BluetoothHeadset.log("stopVoiceRecognition()");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                boolean bl = this.mService.stopVoiceRecognition(bluetoothDevice);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }
}

