/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public final class ScanFilter
implements Parcelable {
    public static final Parcelable.Creator<ScanFilter> CREATOR = new Parcelable.Creator<ScanFilter>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public ScanFilter createFromParcel(Parcel parcel) {
            Builder builder = new Builder();
            if (parcel.readInt() == 1) {
                builder.setDeviceName(parcel.readString());
            }
            if (parcel.readInt() == 1) {
                builder.setDeviceAddress(parcel.readString());
            }
            if (parcel.readInt() == 1) {
                ParcelUuid parcelUuid = (ParcelUuid)parcel.readParcelable(ParcelUuid.class.getClassLoader());
                builder.setServiceUuid(parcelUuid);
                if (parcel.readInt() == 1) {
                    builder.setServiceUuid(parcelUuid, (ParcelUuid)parcel.readParcelable(ParcelUuid.class.getClassLoader()));
                }
            }
            if (parcel.readInt() == 1) {
                ParcelUuid parcelUuid = (ParcelUuid)parcel.readParcelable(ParcelUuid.class.getClassLoader());
                if (parcel.readInt() == 1) {
                    byte[] byArray = new byte[parcel.readInt()];
                    parcel.readByteArray(byArray);
                    if (parcel.readInt() == 0) {
                        builder.setServiceData(parcelUuid, byArray);
                    } else {
                        byte[] byArray2 = new byte[parcel.readInt()];
                        parcel.readByteArray(byArray2);
                        builder.setServiceData(parcelUuid, byArray, byArray2);
                    }
                }
            }
            int n = parcel.readInt();
            if (parcel.readInt() != 1) return builder.build();
            byte[] byArray = new byte[parcel.readInt()];
            parcel.readByteArray(byArray);
            if (parcel.readInt() == 0) {
                builder.setManufacturerData(n, byArray);
                return builder.build();
            }
            byte[] byArray3 = new byte[parcel.readInt()];
            parcel.readByteArray(byArray3);
            builder.setManufacturerData(n, byArray, byArray3);
            return builder.build();
        }

        public ScanFilter[] newArray(int n) {
            return new ScanFilter[n];
        }
    };
    private final String mDeviceAddress;
    private final String mDeviceName;
    private final byte[] mManufacturerData;
    private final byte[] mManufacturerDataMask;
    private final int mManufacturerId;
    private final byte[] mServiceData;
    private final byte[] mServiceDataMask;
    private final ParcelUuid mServiceDataUuid;
    private final ParcelUuid mServiceUuid;
    private final ParcelUuid mServiceUuidMask;

    private ScanFilter(String string2, String string3, ParcelUuid parcelUuid, ParcelUuid parcelUuid2, ParcelUuid parcelUuid3, byte[] byArray, byte[] byArray2, int n, byte[] byArray3, byte[] byArray4) {
        this.mDeviceName = string2;
        this.mServiceUuid = parcelUuid;
        this.mServiceUuidMask = parcelUuid2;
        this.mDeviceAddress = string3;
        this.mServiceDataUuid = parcelUuid3;
        this.mServiceData = byArray;
        this.mServiceDataMask = byArray2;
        this.mManufacturerId = n;
        this.mManufacturerData = byArray3;
        this.mManufacturerDataMask = byArray4;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean matchesPartialData(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (byArray3 == null || byArray3.length < byArray.length) return false;
        if (byArray2 == null) {
            int n = 0;
            while (true) {
                if (n >= byArray.length) {
                    return true;
                }
                if (byArray3[n] != byArray[n]) return false;
                ++n;
            }
        }
        int n = 0;
        while (n < byArray.length) {
            if ((byArray2[n] & byArray3[n]) != (byArray2[n] & byArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean matchesServiceUuid(UUID uUID, UUID uUID2, UUID uUID3) {
        if (uUID2 == null) {
            return uUID.equals(uUID3);
        }
        long l = (uUID.getLeastSignificantBits() & uUID2.getLeastSignificantBits()) - (uUID3.getLeastSignificantBits() & uUID2.getLeastSignificantBits());
        long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
        boolean bl = false;
        if (l2 != false) return bl;
        long l3 = (uUID.getMostSignificantBits() & uUID2.getMostSignificantBits()) - (uUID3.getMostSignificantBits() & uUID2.getMostSignificantBits());
        long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
        bl = false;
        if (l4 != false) return bl;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean matchesServiceUuids(ParcelUuid parcelUuid, ParcelUuid parcelUuid2, List<ParcelUuid> list) {
        ParcelUuid parcelUuid3;
        UUID uUID;
        if (parcelUuid == null) {
            return true;
        }
        if (list == null) {
            return false;
        }
        Iterator<ParcelUuid> iterator = list.iterator();
        do {
            if (!iterator.hasNext()) {
                return false;
            }
            parcelUuid3 = iterator.next();
            uUID = parcelUuid2 == null ? null : parcelUuid2.getUuid();
        } while (!this.matchesServiceUuid(parcelUuid.getUuid(), uUID, parcelUuid3.getUuid()));
        return true;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (this == object) break block4;
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ScanFilter scanFilter = (ScanFilter)object;
                if (!Objects.equals(this.mDeviceName, scanFilter.mDeviceName) || !Objects.equals(this.mDeviceAddress, scanFilter.mDeviceAddress) || this.mManufacturerId != scanFilter.mManufacturerId || !Objects.deepEquals(this.mManufacturerData, scanFilter.mManufacturerData) || !Objects.deepEquals(this.mManufacturerDataMask, scanFilter.mManufacturerDataMask) || !Objects.deepEquals(this.mServiceDataUuid, scanFilter.mServiceDataUuid) || !Objects.deepEquals(this.mServiceData, scanFilter.mServiceData) || !Objects.deepEquals(this.mServiceDataMask, scanFilter.mServiceDataMask) || !Objects.equals(this.mServiceUuid, scanFilter.mServiceUuid) || !Objects.equals(this.mServiceUuidMask, scanFilter.mServiceUuidMask)) break block5;
            }
            return true;
        }
        return false;
    }

    public String getDeviceAddress() {
        return this.mDeviceAddress;
    }

    public String getDeviceName() {
        return this.mDeviceName;
    }

    public byte[] getManufacturerData() {
        return this.mManufacturerData;
    }

    public byte[] getManufacturerDataMask() {
        return this.mManufacturerDataMask;
    }

    public int getManufacturerId() {
        return this.mManufacturerId;
    }

    public byte[] getServiceData() {
        return this.mServiceData;
    }

    public byte[] getServiceDataMask() {
        return this.mServiceDataMask;
    }

    public ParcelUuid getServiceDataUuid() {
        return this.mServiceDataUuid;
    }

    public ParcelUuid getServiceUuid() {
        return this.mServiceUuid;
    }

    public ParcelUuid getServiceUuidMask() {
        return this.mServiceUuidMask;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.mDeviceName, this.mDeviceAddress, this.mManufacturerId, this.mManufacturerData, this.mManufacturerDataMask, this.mServiceDataUuid, this.mServiceData, this.mServiceDataMask, this.mServiceUuid, this.mServiceUuidMask};
        return Objects.hash(objectArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean matches(ScanResult scanResult) {
        block3: {
            block2: {
                ScanRecord scanRecord;
                if (scanResult == null) break block2;
                BluetoothDevice bluetoothDevice = scanResult.getDevice();
                if (!(this.mDeviceAddress != null && (bluetoothDevice == null || !this.mDeviceAddress.equals(bluetoothDevice.getAddress())) || (scanRecord = scanResult.getScanRecord()) == null && (this.mDeviceName != null || this.mServiceUuid != null || this.mManufacturerData != null || this.mServiceData != null) || this.mDeviceName != null && !this.mDeviceName.equals(scanRecord.getDeviceName()) || this.mServiceUuid != null && !this.matchesServiceUuids(this.mServiceUuid, this.mServiceUuidMask, scanRecord.getServiceUuids()) || this.mServiceDataUuid != null && !this.matchesPartialData(this.mServiceData, this.mServiceDataMask, scanRecord.getServiceData(this.mServiceDataUuid))) && (this.mManufacturerId < 0 || this.matchesPartialData(this.mManufacturerData, this.mManufacturerDataMask, scanRecord.getManufacturerSpecificData(this.mManufacturerId)))) break block3;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        return "BluetoothLeScanFilter [mDeviceName=" + this.mDeviceName + ", mDeviceAddress=" + this.mDeviceAddress + ", mUuid=" + this.mServiceUuid + ", mUuidMask=" + this.mServiceUuidMask + ", mServiceDataUuid=" + Objects.toString(this.mServiceDataUuid) + ", mServiceData=" + Arrays.toString(this.mServiceData) + ", mServiceDataMask=" + Arrays.toString(this.mServiceDataMask) + ", mManufacturerId=" + this.mManufacturerId + ", mManufacturerData=" + Arrays.toString(this.mManufacturerData) + ", mManufacturerDataMask=" + Arrays.toString(this.mManufacturerDataMask) + "]";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = this.mDeviceName == null ? 0 : 1;
        parcel.writeInt(n2);
        if (this.mDeviceName != null) {
            parcel.writeString(this.mDeviceName);
        }
        int n3 = this.mDeviceAddress == null ? 0 : 1;
        parcel.writeInt(n3);
        if (this.mDeviceAddress != null) {
            parcel.writeString(this.mDeviceAddress);
        }
        int n4 = this.mServiceUuid == null ? 0 : 1;
        parcel.writeInt(n4);
        if (this.mServiceUuid != null) {
            parcel.writeParcelable(this.mServiceUuid, n);
            int n5 = this.mServiceUuidMask == null ? 0 : 1;
            parcel.writeInt(n5);
            if (this.mServiceUuidMask != null) {
                parcel.writeParcelable(this.mServiceUuidMask, n);
            }
        }
        int n6 = this.mServiceDataUuid == null ? 0 : 1;
        parcel.writeInt(n6);
        if (this.mServiceDataUuid != null) {
            parcel.writeParcelable(this.mServiceDataUuid, n);
            int n7 = this.mServiceData == null ? 0 : 1;
            parcel.writeInt(n7);
            if (this.mServiceData != null) {
                parcel.writeInt(this.mServiceData.length);
                parcel.writeByteArray(this.mServiceData);
                int n8 = this.mServiceDataMask == null ? 0 : 1;
                parcel.writeInt(n8);
                if (this.mServiceDataMask != null) {
                    parcel.writeInt(this.mServiceDataMask.length);
                    parcel.writeByteArray(this.mServiceDataMask);
                }
            }
        }
        parcel.writeInt(this.mManufacturerId);
        int n9 = this.mManufacturerData == null ? 0 : 1;
        parcel.writeInt(n9);
        if (this.mManufacturerData != null) {
            parcel.writeInt(this.mManufacturerData.length);
            parcel.writeByteArray(this.mManufacturerData);
            byte[] byArray = this.mManufacturerDataMask;
            int n10 = 0;
            if (byArray != null) {
                n10 = 1;
            }
            parcel.writeInt(n10);
            if (this.mManufacturerDataMask != null) {
                parcel.writeInt(this.mManufacturerDataMask.length);
                parcel.writeByteArray(this.mManufacturerDataMask);
            }
        }
    }

    public static final class Builder {
        private String mDeviceAddress;
        private String mDeviceName;
        private byte[] mManufacturerData;
        private byte[] mManufacturerDataMask;
        private int mManufacturerId = -1;
        private byte[] mServiceData;
        private byte[] mServiceDataMask;
        private ParcelUuid mServiceDataUuid;
        private ParcelUuid mServiceUuid;
        private ParcelUuid mUuidMask;

        public ScanFilter build() {
            return new ScanFilter(this.mDeviceName, this.mDeviceAddress, this.mServiceUuid, this.mUuidMask, this.mServiceDataUuid, this.mServiceData, this.mServiceDataMask, this.mManufacturerId, this.mManufacturerData, this.mManufacturerDataMask);
        }

        public Builder setDeviceAddress(String string2) {
            if (string2 != null && !BluetoothAdapter.checkBluetoothAddress(string2)) {
                throw new IllegalArgumentException("invalid device address " + string2);
            }
            this.mDeviceAddress = string2;
            return this;
        }

        public Builder setDeviceName(String string2) {
            this.mDeviceName = string2;
            return this;
        }

        public Builder setManufacturerData(int n, byte[] byArray) {
            if (byArray != null && n < 0) {
                throw new IllegalArgumentException("invalid manufacture id");
            }
            this.mManufacturerId = n;
            this.mManufacturerData = byArray;
            this.mManufacturerDataMask = null;
            return this;
        }

        public Builder setManufacturerData(int n, byte[] byArray, byte[] byArray2) {
            if (byArray != null && n < 0) {
                throw new IllegalArgumentException("invalid manufacture id");
            }
            if (this.mManufacturerDataMask != null) {
                if (this.mManufacturerData == null) {
                    throw new IllegalArgumentException("manufacturerData is null while manufacturerDataMask is not null");
                }
                if (this.mManufacturerData.length != this.mManufacturerDataMask.length) {
                    throw new IllegalArgumentException("size mismatch for manufacturerData and manufacturerDataMask");
                }
            }
            this.mManufacturerId = n;
            this.mManufacturerData = byArray;
            this.mManufacturerDataMask = byArray2;
            return this;
        }

        public Builder setServiceData(ParcelUuid parcelUuid, byte[] byArray) {
            if (parcelUuid == null) {
                throw new IllegalArgumentException("serviceDataUuid is null");
            }
            this.mServiceDataUuid = parcelUuid;
            this.mServiceData = byArray;
            this.mServiceDataMask = null;
            return this;
        }

        public Builder setServiceData(ParcelUuid parcelUuid, byte[] byArray, byte[] byArray2) {
            if (parcelUuid == null) {
                throw new IllegalArgumentException("serviceDataUuid is null");
            }
            if (this.mServiceDataMask != null) {
                if (this.mServiceData == null) {
                    throw new IllegalArgumentException("serviceData is null while serviceDataMask is not null");
                }
                if (this.mServiceData.length != this.mServiceDataMask.length) {
                    throw new IllegalArgumentException("size mismatch for service data and service data mask");
                }
            }
            this.mServiceDataUuid = parcelUuid;
            this.mServiceData = byArray;
            this.mServiceDataMask = byArray2;
            return this;
        }

        public Builder setServiceUuid(ParcelUuid parcelUuid) {
            this.mServiceUuid = parcelUuid;
            this.mUuidMask = null;
            return this;
        }

        public Builder setServiceUuid(ParcelUuid parcelUuid, ParcelUuid parcelUuid2) {
            if (this.mUuidMask != null && this.mServiceUuid == null) {
                throw new IllegalArgumentException("uuid is null while uuidMask is not null!");
            }
            this.mServiceUuid = parcelUuid;
            this.mUuidMask = parcelUuid2;
            return this;
        }
    }
}

