/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import java.lang.ref.WeakReference;

public abstract class AsyncQueryHandler
extends Handler {
    private static final int EVENT_ARG_DELETE = 4;
    private static final int EVENT_ARG_INSERT = 2;
    private static final int EVENT_ARG_QUERY = 1;
    private static final int EVENT_ARG_UPDATE = 3;
    private static final String TAG = "AsyncQuery";
    private static final boolean localLOGV;
    private static Looper sLooper;
    final WeakReference<ContentResolver> mResolver;
    private Handler mWorkerThreadHandler;

    static {
        sLooper = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncQueryHandler(ContentResolver contentResolver) {
        this.mResolver = new WeakReference<ContentResolver>(contentResolver);
        synchronized (AsyncQueryHandler.class) {
            if (sLooper == null) {
                HandlerThread handlerThread = new HandlerThread("AsyncQueryWorker");
                handlerThread.start();
                sLooper = handlerThread.getLooper();
            }
        }
        this.mWorkerThreadHandler = this.createHandler(sLooper);
    }

    public final void cancelOperation(int n) {
        this.mWorkerThreadHandler.removeMessages(n);
    }

    protected Handler createHandler(Looper looper) {
        return new WorkerHandler(looper);
    }

    @Override
    public void handleMessage(Message message) {
        WorkerArgs workerArgs = (WorkerArgs)message.obj;
        int n = message.what;
        switch (message.arg1) {
            default: {
                return;
            }
            case 1: {
                this.onQueryComplete(n, workerArgs.cookie, (Cursor)workerArgs.result);
                return;
            }
            case 2: {
                this.onInsertComplete(n, workerArgs.cookie, (Uri)workerArgs.result);
                return;
            }
            case 3: {
                this.onUpdateComplete(n, workerArgs.cookie, (Integer)workerArgs.result);
                return;
            }
            case 4: 
        }
        this.onDeleteComplete(n, workerArgs.cookie, (Integer)workerArgs.result);
    }

    protected void onDeleteComplete(int n, Object object, int n2) {
    }

    protected void onInsertComplete(int n, Object object, Uri uri) {
    }

    protected void onQueryComplete(int n, Object object, Cursor cursor) {
    }

    protected void onUpdateComplete(int n, Object object, int n2) {
    }

    public final void startDelete(int n, Object object, Uri uri, String string2, String[] stringArray) {
        Message message = this.mWorkerThreadHandler.obtainMessage(n);
        message.arg1 = 4;
        WorkerArgs workerArgs = new WorkerArgs();
        workerArgs.handler = this;
        workerArgs.uri = uri;
        workerArgs.cookie = object;
        workerArgs.selection = string2;
        workerArgs.selectionArgs = stringArray;
        message.obj = workerArgs;
        this.mWorkerThreadHandler.sendMessage(message);
    }

    public final void startInsert(int n, Object object, Uri uri, ContentValues contentValues) {
        Message message = this.mWorkerThreadHandler.obtainMessage(n);
        message.arg1 = 2;
        WorkerArgs workerArgs = new WorkerArgs();
        workerArgs.handler = this;
        workerArgs.uri = uri;
        workerArgs.cookie = object;
        workerArgs.values = contentValues;
        message.obj = workerArgs;
        this.mWorkerThreadHandler.sendMessage(message);
    }

    public void startQuery(int n, Object object, Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        Message message = this.mWorkerThreadHandler.obtainMessage(n);
        message.arg1 = 1;
        WorkerArgs workerArgs = new WorkerArgs();
        workerArgs.handler = this;
        workerArgs.uri = uri;
        workerArgs.projection = stringArray;
        workerArgs.selection = string2;
        workerArgs.selectionArgs = stringArray2;
        workerArgs.orderBy = string3;
        workerArgs.cookie = object;
        message.obj = workerArgs;
        this.mWorkerThreadHandler.sendMessage(message);
    }

    public final void startUpdate(int n, Object object, Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        Message message = this.mWorkerThreadHandler.obtainMessage(n);
        message.arg1 = 3;
        WorkerArgs workerArgs = new WorkerArgs();
        workerArgs.handler = this;
        workerArgs.uri = uri;
        workerArgs.cookie = object;
        workerArgs.values = contentValues;
        workerArgs.selection = string2;
        workerArgs.selectionArgs = stringArray;
        message.obj = workerArgs;
        this.mWorkerThreadHandler.sendMessage(message);
    }

    protected static final class WorkerArgs {
        public Object cookie;
        public Handler handler;
        public String orderBy;
        public String[] projection;
        public Object result;
        public String selection;
        public String[] selectionArgs;
        public Uri uri;
        public ContentValues values;

        protected WorkerArgs() {
        }
    }

    protected class WorkerHandler
    extends Handler {
        public WorkerHandler(Looper looper) {
            super(looper);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void handleMessage(Message var1_1) {
            var2_2 = (ContentResolver)AsyncQueryHandler.this.mResolver.get();
            if (var2_2 == null) {
                return;
            }
            var3_3 = (WorkerArgs)var1_1.obj;
            var4_4 = var1_1.what;
            switch (var1_1.arg1) lbl-1000:
            // 4 sources

            {
                default: lbl-1000:
                // 2 sources

                {
                    while (true) {
                        var5_5 = var3_3.handler.obtainMessage(var4_4);
                        var5_5.obj = var3_3;
                        var5_5.arg1 = var1_1.arg1;
                        var5_5.sendToTarget();
                        return;
                    }
                }
                case 1: {
                    var8_6 = var2_2.query(var3_3.uri, var3_3.projection, var3_3.selection, var3_3.selectionArgs, var3_3.orderBy);
                    if (var8_6 == null) ** GOTO lbl26
                    try {
                        var8_6.getCount();
                    }
                    catch (Exception var6_7) {
                        Log.w("AsyncQuery", "Exception thrown during handling EVENT_ARG_QUERY", var6_7);
                        var8_6 = null;
                        ** continue;
                    }
lbl26:
                    // 3 sources

                    while (true) {
                        var3_3.result = var8_6;
                        ** GOTO lbl-1000
                        break;
                    }
                }
                case 2: {
                    var3_3.result = var2_2.insert(var3_3.uri, var3_3.values);
                    ** GOTO lbl-1000
                }
                case 3: {
                    var3_3.result = var2_2.update(var3_3.uri, var3_3.values, var3_3.selection, var3_3.selectionArgs);
                    ** GOTO lbl-1000
                }
                case 4: 
            }
            var3_3.result = var2_2.delete(var3_3.uri, var3_3.selection, var3_3.selectionArgs);
            ** while (true)
        }
    }
}

