/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentResolver;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.util.ArrayList;
import java.util.Iterator;

public class SyncStatusInfo
implements Parcelable {
    public static final Parcelable.Creator<SyncStatusInfo> CREATOR = new Parcelable.Creator<SyncStatusInfo>(){

        @Override
        public SyncStatusInfo createFromParcel(Parcel parcel) {
            return new SyncStatusInfo(parcel);
        }

        public SyncStatusInfo[] newArray(int n) {
            return new SyncStatusInfo[n];
        }
    };
    private static final String TAG = "Sync";
    static final int VERSION = 2;
    public final int authorityId;
    public long initialFailureTime;
    public boolean initialize;
    public String lastFailureMesg;
    public int lastFailureSource;
    public long lastFailureTime;
    public int lastSuccessSource;
    public long lastSuccessTime;
    public int numSourceLocal;
    public int numSourcePeriodic;
    public int numSourcePoll;
    public int numSourceServer;
    public int numSourceUser;
    public int numSyncs;
    public boolean pending;
    private ArrayList<Long> periodicSyncTimes;
    public long totalElapsedTime;

    public SyncStatusInfo(int n) {
        this.authorityId = n;
    }

    public SyncStatusInfo(SyncStatusInfo syncStatusInfo) {
        this.authorityId = syncStatusInfo.authorityId;
        this.totalElapsedTime = syncStatusInfo.totalElapsedTime;
        this.numSyncs = syncStatusInfo.numSyncs;
        this.numSourcePoll = syncStatusInfo.numSourcePoll;
        this.numSourceServer = syncStatusInfo.numSourceServer;
        this.numSourceLocal = syncStatusInfo.numSourceLocal;
        this.numSourceUser = syncStatusInfo.numSourceUser;
        this.numSourcePeriodic = syncStatusInfo.numSourcePeriodic;
        this.lastSuccessTime = syncStatusInfo.lastSuccessTime;
        this.lastSuccessSource = syncStatusInfo.lastSuccessSource;
        this.lastFailureTime = syncStatusInfo.lastFailureTime;
        this.lastFailureSource = syncStatusInfo.lastFailureSource;
        this.lastFailureMesg = syncStatusInfo.lastFailureMesg;
        this.initialFailureTime = syncStatusInfo.initialFailureTime;
        this.pending = syncStatusInfo.pending;
        this.initialize = syncStatusInfo.initialize;
        if (syncStatusInfo.periodicSyncTimes != null) {
            this.periodicSyncTimes = new ArrayList<Long>(syncStatusInfo.periodicSyncTimes);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public SyncStatusInfo(Parcel parcel) {
        int n = parcel.readInt();
        if (n != 2 && n != 1) {
            Log.w("SyncStatusInfo", "Unknown version: " + n);
        }
        this.authorityId = parcel.readInt();
        this.totalElapsedTime = parcel.readLong();
        this.numSyncs = parcel.readInt();
        this.numSourcePoll = parcel.readInt();
        this.numSourceServer = parcel.readInt();
        this.numSourceLocal = parcel.readInt();
        this.numSourceUser = parcel.readInt();
        this.lastSuccessTime = parcel.readLong();
        this.lastSuccessSource = parcel.readInt();
        this.lastFailureTime = parcel.readLong();
        this.lastFailureSource = parcel.readInt();
        this.lastFailureMesg = parcel.readString();
        this.initialFailureTime = parcel.readLong();
        boolean bl = parcel.readInt() != 0;
        this.pending = bl;
        int n2 = parcel.readInt();
        boolean bl2 = false;
        if (n2 != 0) {
            bl2 = true;
        }
        this.initialize = bl2;
        if (n == 1) {
            this.periodicSyncTimes = null;
            return;
        } else {
            int n3 = parcel.readInt();
            if (n3 < 0) {
                this.periodicSyncTimes = null;
                return;
            }
            this.periodicSyncTimes = new ArrayList();
            for (int i = 0; i < n3; ++i) {
                this.periodicSyncTimes.add(parcel.readLong());
            }
        }
    }

    private void ensurePeriodicSyncTimeSize(int n) {
        if (this.periodicSyncTimes == null) {
            this.periodicSyncTimes = new ArrayList(0);
        }
        int n2 = n + 1;
        if (this.periodicSyncTimes.size() < n2) {
            for (int i = this.periodicSyncTimes.size(); i < n2; ++i) {
                this.periodicSyncTimes.add(0L);
            }
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getLastFailureMesgAsInt(int n) {
        int n2 = ContentResolver.syncErrorStringToInt(this.lastFailureMesg);
        if (n2 > 0) {
            return n2;
        }
        Log.d(TAG, "Unknown lastFailureMesg:" + this.lastFailureMesg);
        return n;
    }

    public long getPeriodicSyncTime(int n) {
        if (this.periodicSyncTimes != null && n < this.periodicSyncTimes.size()) {
            return this.periodicSyncTimes.get(n);
        }
        return 0L;
    }

    public void removePeriodicSyncTime(int n) {
        if (this.periodicSyncTimes != null && n < this.periodicSyncTimes.size()) {
            this.periodicSyncTimes.remove(n);
        }
    }

    public void setPeriodicSyncTime(int n, long l) {
        this.ensurePeriodicSyncTimeSize(n);
        this.periodicSyncTimes.set(n, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        parcel.writeInt(2);
        parcel.writeInt(this.authorityId);
        parcel.writeLong(this.totalElapsedTime);
        parcel.writeInt(this.numSyncs);
        parcel.writeInt(this.numSourcePoll);
        parcel.writeInt(this.numSourceServer);
        parcel.writeInt(this.numSourceLocal);
        parcel.writeInt(this.numSourceUser);
        parcel.writeLong(this.lastSuccessTime);
        parcel.writeInt(this.lastSuccessSource);
        parcel.writeLong(this.lastFailureTime);
        parcel.writeInt(this.lastFailureSource);
        parcel.writeString(this.lastFailureMesg);
        parcel.writeLong(this.initialFailureTime);
        int n3 = this.pending ? n2 : 0;
        parcel.writeInt(n3);
        if (!this.initialize) {
            n2 = 0;
        }
        parcel.writeInt(n2);
        if (this.periodicSyncTimes != null) {
            parcel.writeInt(this.periodicSyncTimes.size());
            Iterator<Long> iterator = this.periodicSyncTimes.iterator();
            while (iterator.hasNext()) {
                parcel.writeLong(iterator.next());
            }
            return;
        } else {
            parcel.writeInt(-1);
        }
    }
}

