/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.FeatureGroupInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.InstrumentationInfo;
import android.content.pm.ManifestDigest;
import android.content.pm.PackageInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageUserState;
import android.content.pm.PathPermission;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.content.pm.VerifierInfo;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.ThemePack;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Build;
import android.os.Bundle;
import android.os.PatternMatcher;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AttributeSet;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import android.util.TypedValue;
import com.android.internal.R;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.StrictJarFile;
import java.util.zip.ZipEntry;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class PackageParser {
    private static final String ANDROID_MANIFEST_FILENAME = "AndroidManifest.xml";
    private static final String ANDROID_RESOURCES = "http://schemas.android.com/apk/res/android";
    private static final boolean DEBUG_BACKUP = false;
    private static final boolean DEBUG_JAR = false;
    private static final boolean DEBUG_PARSER = false;
    public static final NewPermissionInfo[] NEW_PERMISSIONS;
    public static final int PARSE_CHATTY = 2;
    public static final int PARSE_COLLECT_CERTIFICATES = 256;
    private static final int PARSE_DEFAULT_INSTALL_LOCATION = -1;
    public static final int PARSE_FORWARD_LOCK = 16;
    public static final int PARSE_IGNORE_PROCESSES = 8;
    public static final int PARSE_IS_PRIVILEGED = 128;
    public static final int PARSE_IS_SYSTEM = 1;
    public static final int PARSE_IS_SYSTEM_DIR = 64;
    public static final int PARSE_MUST_BE_APK = 4;
    public static final int PARSE_ON_SDCARD = 32;
    public static final int PARSE_TRUSTED_OVERLAY = 512;
    private static final boolean RIGID_PARSER = false;
    private static final String[] SDK_CODENAMES;
    private static final int SDK_VERSION = 0;
    public static final SplitPermissionInfo[] SPLIT_PERMISSIONS;
    private static final String TAG = "PackageParser";
    private static final String THEME_MODULES_PATH = "assets/";
    private static AtomicReference<byte[]> sBuffer;
    private static boolean sCompatibilityModeEnabled;
    private static final Comparator<String> sSplitNameComparator;
    @Deprecated
    private String mArchiveSourcePath;
    private DisplayMetrics mMetrics = new DisplayMetrics();
    private boolean mOnlyCoreApps;
    private ParseComponentArgs mParseActivityAliasArgs;
    private ParseComponentArgs mParseActivityArgs;
    private int mParseError = 1;
    private ParsePackageItemArgs mParseInstrumentationArgs;
    private ParseComponentArgs mParseProviderArgs;
    private ParseComponentArgs mParseServiceArgs;
    private String[] mSeparateProcesses;

    static {
        NewPermissionInfo[] newPermissionInfoArray = new NewPermissionInfo[]{new NewPermissionInfo("android.permission.WRITE_EXTERNAL_STORAGE", 4, 0), new NewPermissionInfo("android.permission.READ_PHONE_STATE", 4, 0)};
        NEW_PERMISSIONS = newPermissionInfoArray;
        SplitPermissionInfo[] splitPermissionInfoArray = new SplitPermissionInfo[]{new SplitPermissionInfo("android.permission.WRITE_EXTERNAL_STORAGE", new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 10001), new SplitPermissionInfo("android.permission.READ_CONTACTS", new String[]{"android.permission.READ_CALL_LOG"}, 16), new SplitPermissionInfo("android.permission.WRITE_CONTACTS", new String[]{"android.permission.WRITE_CALL_LOG"}, 16)};
        SPLIT_PERMISSIONS = splitPermissionInfoArray;
        SDK_VERSION = Build.VERSION.SDK_INT;
        SDK_CODENAMES = Build.VERSION.ACTIVE_CODENAMES;
        sCompatibilityModeEnabled = true;
        sSplitNameComparator = new SplitNameComparator();
        sBuffer = new AtomicReference();
    }

    public PackageParser() {
        this.mMetrics.setToDefaults();
    }

    private static String buildClassName(String string2, CharSequence charSequence, String[] stringArray) {
        if (charSequence == null || charSequence.length() <= 0) {
            stringArray[0] = "Empty class name in package " + string2;
            return null;
        }
        String string3 = charSequence.toString();
        char c = string3.charAt(0);
        if (c == '.') {
            return (string2 + string3).intern();
        }
        if (string3.indexOf(46) < 0) {
            StringBuilder stringBuilder = new StringBuilder(string2);
            stringBuilder.append('.');
            stringBuilder.append(string3);
            return stringBuilder.toString().intern();
        }
        if (c >= 'a' && c <= 'z') {
            return string3.intern();
        }
        stringArray[0] = "Bad class name " + string3 + " in package " + string2;
        return null;
    }

    private static String buildCompoundName(String string2, CharSequence charSequence, String string3, String[] stringArray) {
        String string4 = charSequence.toString();
        char c = string4.charAt(0);
        if (string2 != null && c == ':') {
            if (string4.length() < 2) {
                stringArray[0] = "Bad " + string3 + " name " + string4 + " in package " + string2 + ": must be at least two characters";
                return null;
            }
            String string5 = PackageParser.validateName(string4.substring(1), false);
            if (string5 != null) {
                stringArray[0] = "Invalid " + string3 + " name " + string4 + " in package " + string2 + ": " + string5;
                return null;
            }
            return (string2 + string4).intern();
        }
        String string6 = PackageParser.validateName(string4, true);
        if (string6 != null && !"system".equals(string4)) {
            stringArray[0] = "Invalid " + string3 + " name " + string4 + " in package " + string2 + ": " + string6;
            return null;
        }
        return string4.intern();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String buildProcessName(String string2, String string3, CharSequence charSequence, int n, String[] stringArray, String[] stringArray2) {
        if ((n & 8) != 0 && !"system".equals(charSequence)) {
            if (string3 != null) return string3;
            return string2;
        }
        if (stringArray != null) {
            for (int i = -1 + stringArray.length; i >= 0; --i) {
                String string4 = stringArray[i];
                if (!string4.equals(string2) && !string4.equals(string3) && !string4.equals(charSequence)) continue;
                return string2;
            }
        }
        if (charSequence != null && charSequence.length() > 0) return PackageParser.buildCompoundName(string2, charSequence, "process", stringArray2);
        return string3;
    }

    private static String buildTaskAffinityName(String string2, String string3, CharSequence charSequence, String[] stringArray) {
        if (charSequence == null) {
            return string3;
        }
        if (charSequence.length() <= 0) {
            return null;
        }
        return PackageParser.buildCompoundName(string2, charSequence, "taskAffinity", stringArray);
    }

    private static boolean checkUseInstalledOrHidden(int n, PackageUserState packageUserState) {
        return packageUserState.installed && !packageUserState.hidden || (n & 0x2000) != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void closeQuietly(StrictJarFile strictJarFile) {
        if (strictJarFile == null) return;
        try {
            strictJarFile.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Exception decompiling
     */
    private static void collectCertificates(Package var0, File var1_1, int var2_2) throws PackageParserException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [13, 14, 16, 15 : 116->135)] java.security.GeneralSecurityException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Signature[] convertToSignatures(Certificate[][] certificateArray) throws CertificateEncodingException {
        Signature[] signatureArray = new Signature[certificateArray.length];
        for (int i = 0; i < certificateArray.length; ++i) {
            signatureArray[i] = new Signature(certificateArray[i]);
        }
        return signatureArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean copyNeeded(int n, Package package_, PackageUserState packageUserState, Bundle bundle, int n2) {
        boolean bl;
        return n2 != 0 || packageUserState.enabled != 0 && package_.applicationInfo.enabled != (bl = packageUserState.enabled == 1) || !packageUserState.installed || packageUserState.hidden || packageUserState.stopped || (n & 0x80) != 0 && (bundle != null || package_.mAppMetaData != null) || (n & 0x400) != 0 && package_.usesLibraryFiles != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final ActivityInfo generateActivityInfo(ActivityInfo activityInfo, int n, PackageUserState packageUserState, int n2) {
        if (activityInfo == null || !PackageParser.checkUseInstalledOrHidden(n, packageUserState)) {
            return null;
        }
        ActivityInfo activityInfo2 = new ActivityInfo(activityInfo);
        activityInfo2.applicationInfo = PackageParser.generateApplicationInfo(activityInfo2.applicationInfo, n, packageUserState, n2);
        return activityInfo2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final ActivityInfo generateActivityInfo(Activity activity, int n, PackageUserState packageUserState, int n2) {
        if (activity == null || !PackageParser.checkUseInstalledOrHidden(n, packageUserState)) {
            return null;
        }
        if (!PackageParser.copyNeeded(n, activity.owner, packageUserState, activity.metaData, n2)) {
            return activity.info;
        }
        ActivityInfo activityInfo = new ActivityInfo(activity.info);
        activityInfo.metaData = activity.metaData;
        activityInfo.applicationInfo = PackageParser.generateApplicationInfo(activity.owner, n, packageUserState, n2);
        return activityInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ApplicationInfo generateApplicationInfo(ApplicationInfo applicationInfo, int n, PackageUserState packageUserState, int n2) {
        if (applicationInfo == null || !PackageParser.checkUseInstalledOrHidden(n, packageUserState)) {
            return null;
        }
        ApplicationInfo applicationInfo2 = new ApplicationInfo(applicationInfo);
        if (n2 != 0) {
            applicationInfo2.uid = UserHandle.getUid(n2, applicationInfo2.uid);
            applicationInfo2.dataDir = PackageManager.getDataDirForUser(n2, applicationInfo2.packageName);
        }
        applicationInfo2.flags = packageUserState.stopped ? 0x200000 | applicationInfo2.flags : 0xFFDFFFFF & applicationInfo2.flags;
        PackageParser.updateApplicationInfo(applicationInfo2, n, packageUserState);
        return applicationInfo2;
    }

    public static ApplicationInfo generateApplicationInfo(Package package_, int n, PackageUserState packageUserState) {
        return PackageParser.generateApplicationInfo(package_, n, packageUserState, UserHandle.getCallingUserId());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ApplicationInfo generateApplicationInfo(Package package_, int n, PackageUserState packageUserState, int n2) {
        if (package_ == null || !PackageParser.checkUseInstalledOrHidden(n, packageUserState)) {
            return null;
        }
        if (!(PackageParser.copyNeeded(n, package_, packageUserState, null, n2) || (0x8000 & n) != 0 && packageUserState.enabled == 4)) {
            PackageParser.updateApplicationInfo(package_.applicationInfo, n, packageUserState);
            return package_.applicationInfo;
        }
        ApplicationInfo applicationInfo = new ApplicationInfo(package_.applicationInfo);
        if (n2 != 0) {
            applicationInfo.uid = UserHandle.getUid(n2, applicationInfo.uid);
            applicationInfo.dataDir = PackageManager.getDataDirForUser(n2, applicationInfo.packageName);
        }
        if ((n & 0x80) != 0) {
            applicationInfo.metaData = package_.mAppMetaData;
        }
        if ((n & 0x400) != 0) {
            applicationInfo.sharedLibraryFiles = package_.usesLibraryFiles;
        }
        applicationInfo.flags = packageUserState.stopped ? 0x200000 | applicationInfo.flags : 0xFFDFFFFF & applicationInfo.flags;
        PackageParser.updateApplicationInfo(applicationInfo, n, packageUserState);
        return applicationInfo;
    }

    public static final InstrumentationInfo generateInstrumentationInfo(Instrumentation instrumentation, int n) {
        if (instrumentation == null) {
            return null;
        }
        if ((n & 0x80) == 0) {
            return instrumentation.info;
        }
        InstrumentationInfo instrumentationInfo = new InstrumentationInfo(instrumentation.info);
        instrumentationInfo.metaData = instrumentation.metaData;
        return instrumentationInfo;
    }

    public static PackageInfo generatePackageInfo(Package package_, int[] nArray, int n, long l, long l2, HashSet<String> hashSet, PackageUserState packageUserState) {
        return PackageParser.generatePackageInfo(package_, nArray, n, l, l2, hashSet, packageUserState, UserHandle.getCallingUserId());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static PackageInfo generatePackageInfo(Package package_, int[] nArray, int n, long l, long l2, HashSet<String> hashSet, PackageUserState packageUserState, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (!PackageParser.checkUseInstalledOrHidden(n, packageUserState)) {
            return null;
        }
        PackageInfo packageInfo = new PackageInfo();
        packageInfo.packageName = package_.packageName;
        packageInfo.splitNames = package_.splitNames;
        packageInfo.versionCode = package_.mVersionCode;
        packageInfo.versionName = package_.mVersionName;
        packageInfo.sharedUserId = package_.mSharedUserId;
        packageInfo.sharedUserLabel = package_.mSharedUserLabel;
        packageInfo.applicationInfo = PackageParser.generateApplicationInfo(package_, n, packageUserState, n2);
        packageInfo.installLocation = package_.installLocation;
        packageInfo.coreApp = package_.coreApp;
        if ((1 & packageInfo.applicationInfo.flags) != 0 || (0x80 & packageInfo.applicationInfo.flags) != 0) {
            packageInfo.requiredForAllUsers = package_.mRequiredForAllUsers;
        }
        packageInfo.restrictedAccountType = package_.mRestrictedAccountType;
        packageInfo.requiredAccountType = package_.mRequiredAccountType;
        packageInfo.overlayTarget = package_.mOverlayTarget;
        packageInfo.isThemePack = package_.mIsThemePack;
        if (packageInfo.isThemePack) {
            packageInfo.themePack = package_.mThemePack;
        }
        packageInfo.firstInstallTime = l;
        packageInfo.lastUpdateTime = l2;
        if ((n & 0x100) != 0) {
            packageInfo.gids = nArray;
        }
        if ((n & 0x4000) != 0) {
            int n8;
            int n9;
            int n10 = package_.configPreferences != null ? package_.configPreferences.size() : 0;
            if (n10 > 0) {
                packageInfo.configPreferences = new ConfigurationInfo[n10];
                package_.configPreferences.toArray(packageInfo.configPreferences);
            }
            if ((n9 = package_.reqFeatures != null ? package_.reqFeatures.size() : 0) > 0) {
                packageInfo.reqFeatures = new FeatureInfo[n9];
                package_.reqFeatures.toArray(packageInfo.reqFeatures);
            }
            if ((n8 = package_.featureGroups != null ? package_.featureGroups.size() : 0) > 0) {
                packageInfo.featureGroups = new FeatureGroupInfo[n8];
                package_.featureGroups.toArray(packageInfo.featureGroups);
            }
        }
        if ((n & 1) != 0 && (n7 = package_.activities.size()) > 0) {
            if ((n & 0x200) != 0) {
                packageInfo.activities = new ActivityInfo[n7];
            } else {
                int n11 = 0;
                for (int i = 0; i < n7; ++i) {
                    if (!package_.activities.get((int)i).info.enabled) continue;
                    ++n11;
                }
                packageInfo.activities = new ActivityInfo[n11];
            }
            int n12 = 0;
            for (int i = 0; i < n7; ++i) {
                int n13;
                if (package_.activities.get((int)i).info.enabled || (n & 0x200) != 0) {
                    ActivityInfo[] activityInfoArray = packageInfo.activities;
                    n13 = n12 + 1;
                    activityInfoArray[n12] = PackageParser.generateActivityInfo(package_.activities.get(i), n, packageUserState, n2);
                } else {
                    n13 = n12;
                }
                n12 = n13;
            }
        }
        if ((n & 2) != 0 && (n6 = package_.receivers.size()) > 0) {
            if ((n & 0x200) != 0) {
                packageInfo.receivers = new ActivityInfo[n6];
            } else {
                int n14 = 0;
                for (int i = 0; i < n6; ++i) {
                    if (!package_.receivers.get((int)i).info.enabled) continue;
                    ++n14;
                }
                packageInfo.receivers = new ActivityInfo[n14];
            }
            int n15 = 0;
            for (int i = 0; i < n6; ++i) {
                int n16;
                if (package_.receivers.get((int)i).info.enabled || (n & 0x200) != 0) {
                    ActivityInfo[] activityInfoArray = packageInfo.receivers;
                    n16 = n15 + 1;
                    activityInfoArray[n15] = PackageParser.generateActivityInfo(package_.receivers.get(i), n, packageUserState, n2);
                } else {
                    n16 = n15;
                }
                n15 = n16;
            }
        }
        if ((n & 4) != 0 && (n5 = package_.services.size()) > 0) {
            if ((n & 0x200) != 0) {
                packageInfo.services = new ServiceInfo[n5];
            } else {
                int n17 = 0;
                for (int i = 0; i < n5; ++i) {
                    if (!package_.services.get((int)i).info.enabled) continue;
                    ++n17;
                }
                packageInfo.services = new ServiceInfo[n17];
            }
            int n18 = 0;
            for (int i = 0; i < n5; ++i) {
                int n19;
                if (package_.services.get((int)i).info.enabled || (n & 0x200) != 0) {
                    ServiceInfo[] serviceInfoArray = packageInfo.services;
                    n19 = n18 + 1;
                    serviceInfoArray[n18] = PackageParser.generateServiceInfo(package_.services.get(i), n, packageUserState, n2);
                } else {
                    n19 = n18;
                }
                n18 = n19;
            }
        }
        if ((n & 8) != 0 && (n4 = package_.providers.size()) > 0) {
            if ((n & 0x200) != 0) {
                packageInfo.providers = new ProviderInfo[n4];
            } else {
                int n20 = 0;
                for (int i = 0; i < n4; ++i) {
                    if (!package_.providers.get((int)i).info.enabled) continue;
                    ++n20;
                }
                packageInfo.providers = new ProviderInfo[n20];
            }
            int n21 = 0;
            for (int i = 0; i < n4; ++i) {
                int n22;
                if (package_.providers.get((int)i).info.enabled || (n & 0x200) != 0) {
                    ProviderInfo[] providerInfoArray = packageInfo.providers;
                    n22 = n21 + 1;
                    providerInfoArray[n21] = PackageParser.generateProviderInfo(package_.providers.get(i), n, packageUserState, n2);
                } else {
                    n22 = n21;
                }
                n21 = n22;
            }
        }
        if ((n & 0x10) != 0 && (n3 = package_.instrumentation.size()) > 0) {
            packageInfo.instrumentation = new InstrumentationInfo[n3];
            for (int i = 0; i < n3; ++i) {
                packageInfo.instrumentation[i] = PackageParser.generateInstrumentationInfo(package_.instrumentation.get(i), n);
            }
        }
        if ((n & 0x1000) != 0) {
            int n23;
            int n24 = package_.permissions.size();
            if (n24 > 0) {
                packageInfo.permissions = new PermissionInfo[n24];
                for (int i = 0; i < n24; ++i) {
                    packageInfo.permissions[i] = PackageParser.generatePermissionInfo(package_.permissions.get(i), n);
                }
            }
            if ((n23 = package_.requestedPermissions.size()) > 0) {
                packageInfo.requestedPermissions = new String[n23];
                packageInfo.requestedPermissionsFlags = new int[n23];
                for (int i = 0; i < n23; ++i) {
                    String string2;
                    packageInfo.requestedPermissions[i] = string2 = package_.requestedPermissions.get(i);
                    if (package_.requestedPermissionsRequired.get(i).booleanValue()) {
                        int[] nArray2 = packageInfo.requestedPermissionsFlags;
                        nArray2[i] = 1 | nArray2[i];
                    }
                    if (hashSet == null || !hashSet.contains(string2)) continue;
                    int[] nArray3 = packageInfo.requestedPermissionsFlags;
                    nArray3[i] = 2 | nArray3[i];
                }
            }
        }
        if ((n & 0x40) == 0) return packageInfo;
        int n25 = package_.mSignatures != null ? package_.mSignatures.length : 0;
        if (n25 <= 0) return packageInfo;
        packageInfo.signatures = new Signature[n25];
        System.arraycopy(package_.mSignatures, 0, packageInfo.signatures, 0, n25);
        return packageInfo;
    }

    public static final PermissionGroupInfo generatePermissionGroupInfo(PermissionGroup permissionGroup, int n) {
        if (permissionGroup == null) {
            return null;
        }
        if ((n & 0x80) == 0) {
            return permissionGroup.info;
        }
        PermissionGroupInfo permissionGroupInfo = new PermissionGroupInfo(permissionGroup.info);
        permissionGroupInfo.metaData = permissionGroup.metaData;
        return permissionGroupInfo;
    }

    public static final PermissionInfo generatePermissionInfo(Permission permission2, int n) {
        if (permission2 == null) {
            return null;
        }
        if ((n & 0x80) == 0) {
            return permission2.info;
        }
        PermissionInfo permissionInfo = new PermissionInfo(permission2.info);
        permissionInfo.metaData = permission2.metaData;
        return permissionInfo;
    }

    public static final ProviderInfo generateProviderInfo(Provider provider, int n, PackageUserState packageUserState, int n2) {
        if (provider == null) {
            return null;
        }
        if (!PackageParser.checkUseInstalledOrHidden(n, packageUserState)) {
            return null;
        }
        if (!(PackageParser.copyNeeded(n, provider.owner, packageUserState, provider.metaData, n2) || (n & 0x800) == 0 && provider.info.uriPermissionPatterns != null)) {
            return provider.info;
        }
        ProviderInfo providerInfo = new ProviderInfo(provider.info);
        providerInfo.metaData = provider.metaData;
        if ((n & 0x800) == 0) {
            providerInfo.uriPermissionPatterns = null;
        }
        providerInfo.applicationInfo = PackageParser.generateApplicationInfo(provider.owner, n, packageUserState, n2);
        return providerInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final ServiceInfo generateServiceInfo(Service service, int n, PackageUserState packageUserState, int n2) {
        if (service == null || !PackageParser.checkUseInstalledOrHidden(n, packageUserState)) {
            return null;
        }
        if (!PackageParser.copyNeeded(n, service.owner, packageUserState, service.metaData, n2)) {
            return service.info;
        }
        ServiceInfo serviceInfo = new ServiceInfo(service.info);
        serviceInfo.metaData = service.metaData;
        serviceInfo.applicationInfo = PackageParser.generateApplicationInfo(service.owner, n, packageUserState, n2);
        return serviceInfo;
    }

    public static final boolean isApkFile(File file) {
        return PackageParser.isApkPath(file.getName());
    }

    private static boolean isApkPath(String string2) {
        return string2.endsWith(".apk");
    }

    public static boolean isAvailable(PackageUserState packageUserState) {
        return PackageParser.checkUseInstalledOrHidden(0, packageUserState);
    }

    private static int loadApkIntoAssetManager(AssetManager assetManager, String string2, int n) throws PackageParserException {
        if ((n & 4) != 0 && !PackageParser.isApkPath(string2)) {
            throw new PackageParserException(-100, "Invalid package file: " + string2);
        }
        int n2 = assetManager.addAssetPath(string2);
        if (n2 == 0) {
            throw new PackageParserException(-101, "Failed adding asset path: " + string2);
        }
        return n2;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static Certificate[][] loadCertificates(StrictJarFile var0, ZipEntry var1_1) throws PackageParserException {
        var2_2 = null;
        try {
            var2_2 = var0.getInputStream(var1_1);
            PackageParser.readFullyIgnoringContents(var2_2);
            var9_3 = var0.getCertificateChains(var1_1);
        }
        catch (IOException var6_4) {
            var4_5 /* !! */  = var6_4;
lbl11:
            // 2 sources

            while (true) {
                try {
                    throw new PackageParserException(-102, "Failed reading " + var1_1.getName() + " in " + var0, var4_5 /* !! */ );
                }
                catch (Throwable var5_6) {
                    IoUtils.closeQuietly((AutoCloseable)var2_2);
                    throw var5_6;
                }
                break;
            }
        }
        catch (RuntimeException var3_7) {
            var4_5 /* !! */  = var3_7;
            ** continue;
        }
        IoUtils.closeQuietly((AutoCloseable)var2_2);
        return var9_3;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Activity parseActivity(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, String[] stringArray, boolean bl, boolean bl2) throws XmlPullParserException, IOException {
        int n2;
        boolean bl3;
        String string2;
        TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestActivity);
        if (this.mParseActivityArgs == null) {
            this.mParseActivityArgs = new ParseComponentArgs(package_, stringArray, 3, 1, 2, 23, 30, this.mSeparateProcesses, 7, 17, 5);
        }
        ParseComponentArgs parseComponentArgs = this.mParseActivityArgs;
        String string3 = bl ? "<receiver>" : "<activity>";
        parseComponentArgs.tag = string3;
        this.mParseActivityArgs.sa = typedArray;
        this.mParseActivityArgs.flags = n;
        Activity activity = new Activity(this.mParseActivityArgs, new ActivityInfo());
        if (stringArray[0] != null) {
            typedArray.recycle();
            return null;
        }
        boolean bl4 = typedArray.hasValue(6);
        if (bl4) {
            activity.info.exported = typedArray.getBoolean(6, false);
        }
        activity.info.theme = typedArray.getResourceId(0, 0);
        activity.info.uiOptions = typedArray.getInt(26, activity.info.applicationInfo.uiOptions);
        String string4 = typedArray.getNonConfigurationString(27, 1024);
        if (string4 != null) {
            String string5 = PackageParser.buildClassName(activity.info.packageName, string4, stringArray);
            if (stringArray[0] == null) {
                activity.info.parentActivityName = string5;
            } else {
                Log.e(TAG, "Activity " + activity.info.name + " specified invalid parentActivityName " + string4);
                stringArray[0] = null;
            }
        }
        if ((string2 = typedArray.getNonConfigurationString(4, 0)) == null) {
            activity.info.permission = package_.applicationInfo.permission;
        } else {
            ActivityInfo activityInfo = activity.info;
            String string6 = string2.length() > 0 ? string2.toString().intern() : null;
            activityInfo.permission = string6;
        }
        String string7 = typedArray.getNonConfigurationString(8, 1024);
        activity.info.taskAffinity = PackageParser.buildTaskAffinityName(package_.applicationInfo.packageName, package_.applicationInfo.taskAffinity, string7, stringArray);
        activity.info.flags = 0;
        if (typedArray.getBoolean(9, false)) {
            ActivityInfo activityInfo = activity.info;
            activityInfo.flags = 1 | activityInfo.flags;
        }
        if (typedArray.getBoolean(10, false)) {
            ActivityInfo activityInfo = activity.info;
            activityInfo.flags = 2 | activityInfo.flags;
        }
        if (typedArray.getBoolean(11, false)) {
            ActivityInfo activityInfo = activity.info;
            activityInfo.flags = 4 | activityInfo.flags;
        }
        if (typedArray.getBoolean(21, false)) {
            ActivityInfo activityInfo = activity.info;
            activityInfo.flags = 0x80 | activityInfo.flags;
        }
        if (typedArray.getBoolean(18, false)) {
            ActivityInfo activityInfo = activity.info;
            activityInfo.flags = 8 | activityInfo.flags;
        }
        if (typedArray.getBoolean(12, false)) {
            ActivityInfo activityInfo = activity.info;
            activityInfo.flags = 0x10 | activityInfo.flags;
        }
        if (typedArray.getBoolean(13, false)) {
            ActivityInfo activityInfo = activity.info;
            activityInfo.flags = 0x20 | activityInfo.flags;
        }
        if (typedArray.getBoolean(19, bl3 = (0x20 & package_.applicationInfo.flags) != 0)) {
            ActivityInfo activityInfo = activity.info;
            activityInfo.flags = 0x40 | activityInfo.flags;
        }
        if (typedArray.getBoolean(22, false)) {
            ActivityInfo activityInfo = activity.info;
            activityInfo.flags = 0x100 | activityInfo.flags;
        }
        if (typedArray.getBoolean(29, false)) {
            ActivityInfo activityInfo = activity.info;
            activityInfo.flags = 0x400 | activityInfo.flags;
        }
        if (typedArray.getBoolean(24, false)) {
            ActivityInfo activityInfo = activity.info;
            activityInfo.flags = 0x800 | activityInfo.flags;
        }
        if (!bl) {
            if (typedArray.getBoolean(25, bl2)) {
                ActivityInfo activityInfo = activity.info;
                activityInfo.flags = 0x200 | activityInfo.flags;
            }
            activity.info.launchMode = typedArray.getInt(14, 0);
            activity.info.documentLaunchMode = typedArray.getInt(33, 0);
            activity.info.maxRecents = typedArray.getInt(34, ActivityManager.getDefaultAppRecentsLimitStatic());
            activity.info.screenOrientation = typedArray.getInt(15, -1);
            activity.info.configChanges = typedArray.getInt(16, 0);
            activity.info.softInputMode = typedArray.getInt(20, 0);
            activity.info.persistableMode = typedArray.getInteger(32, 0);
            if (typedArray.getBoolean(31, false)) {
                ActivityInfo activityInfo = activity.info;
                activityInfo.flags = Integer.MIN_VALUE | activityInfo.flags;
            }
            if (typedArray.getBoolean(35, false)) {
                ActivityInfo activityInfo = activity.info;
                activityInfo.flags = 0x2000 | activityInfo.flags;
            }
            if (typedArray.getBoolean(36, false)) {
                ActivityInfo activityInfo = activity.info;
                activityInfo.flags = 0x1000 | activityInfo.flags;
            }
            if (typedArray.getBoolean(37, false)) {
                ActivityInfo activityInfo = activity.info;
                activityInfo.flags = 0x4000 | activityInfo.flags;
            }
        } else {
            activity.info.launchMode = 0;
            activity.info.configChanges = 0;
        }
        if (bl) {
            if (typedArray.getBoolean(28, false)) {
                ActivityInfo activityInfo = activity.info;
                activityInfo.flags = 0x40000000 | activityInfo.flags;
                if (activity.info.exported && (n & 0x80) == 0) {
                    Slog.w(TAG, "Activity exported request ignored due to singleUser: " + activity.className + " at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
                    activity.info.exported = false;
                    bl4 = true;
                }
            }
            if (typedArray.getBoolean(38, false)) {
                ActivityInfo activityInfo = activity.info;
                activityInfo.flags = 0x20000000 | activityInfo.flags;
            }
        }
        typedArray.recycle();
        if (bl && (0x10000000 & package_.applicationInfo.flags) != 0 && activity.info.processName == package_.packageName) {
            stringArray[0] = "Heavy-weight applications can not have receivers in main process";
        }
        if (stringArray[0] != null) {
            return null;
        }
        int n3 = xmlPullParser.getDepth();
        while ((n2 = xmlPullParser.next()) != 1 && (n2 != 3 || xmlPullParser.getDepth() > n3)) {
            if (n2 == 3 || n2 == 4) continue;
            if (xmlPullParser.getName().equals("intent-filter")) {
                ActivityIntentInfo activityIntentInfo = new ActivityIntentInfo(activity);
                if (!this.parseIntent(resources, xmlPullParser, attributeSet, true, activityIntentInfo, stringArray)) {
                    return null;
                }
                if (activityIntentInfo.countActions() == 0) {
                    Slog.w(TAG, "No actions in intent filter at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
                    continue;
                }
                activity.intents.add(activityIntentInfo);
                continue;
            }
            if (!bl && xmlPullParser.getName().equals("preferred")) {
                ActivityIntentInfo activityIntentInfo = new ActivityIntentInfo(activity);
                if (!this.parseIntent(resources, xmlPullParser, attributeSet, false, activityIntentInfo, stringArray)) {
                    return null;
                }
                if (activityIntentInfo.countActions() == 0) {
                    Slog.w(TAG, "No actions in preferred at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
                    continue;
                }
                if (package_.preferredActivityFilters == null) {
                    package_.preferredActivityFilters = new ArrayList();
                }
                package_.preferredActivityFilters.add(activityIntentInfo);
                continue;
            }
            if (xmlPullParser.getName().equals("meta-data")) {
                Bundle bundle;
                activity.metaData = bundle = this.parseMetaData(resources, xmlPullParser, attributeSet, activity.metaData, stringArray);
                if (bundle != null) continue;
                return null;
            }
            Slog.w(TAG, "Problem in package " + this.mArchiveSourcePath + ":");
            if (bl) {
                Slog.w(TAG, "Unknown element under <receiver>: " + xmlPullParser.getName() + " at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
            } else {
                Slog.w(TAG, "Unknown element under <activity>: " + xmlPullParser.getName() + " at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
            }
            XmlUtils.skipCurrentTag(xmlPullParser);
        }
        if (bl4) return activity;
        ActivityInfo activityInfo = activity.info;
        boolean bl5 = activity.intents.size() > 0;
        activityInfo.exported = bl5;
        return activity;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Activity parseActivityAlias(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, String[] stringArray) throws XmlPullParserException, IOException {
        int n2;
        String string2;
        String string3;
        Activity activity;
        String string4;
        TypedArray typedArray;
        block18: {
            Activity activity2;
            typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestActivityAlias);
            String string5 = typedArray.getNonConfigurationString(7, 1024);
            if (string5 == null) {
                stringArray[0] = "<activity-alias> does not specify android:targetActivity";
                typedArray.recycle();
                return null;
            }
            string4 = PackageParser.buildClassName(package_.applicationInfo.packageName, string5, stringArray);
            if (string4 == null) {
                typedArray.recycle();
                return null;
            }
            if (this.mParseActivityAliasArgs == null) {
                this.mParseActivityAliasArgs = new ParseComponentArgs(package_, stringArray, 2, 0, 1, 8, 10, this.mSeparateProcesses, 0, 6, 4);
                this.mParseActivityAliasArgs.tag = "<activity-alias>";
            }
            this.mParseActivityAliasArgs.sa = typedArray;
            this.mParseActivityAliasArgs.flags = n;
            int n3 = package_.activities.size();
            int n4 = 0;
            do {
                int n5 = ++n4;
                activity = null;
                if (n5 >= n3) break block18;
                activity2 = package_.activities.get(n4);
            } while (!string4.equals(activity2.info.name));
            activity = activity2;
        }
        if (activity == null) {
            stringArray[0] = "<activity-alias> target activity " + string4 + " not found in manifest";
            typedArray.recycle();
            return null;
        }
        ActivityInfo activityInfo = new ActivityInfo();
        activityInfo.targetActivity = string4;
        activityInfo.configChanges = activity.info.configChanges;
        activityInfo.flags = activity.info.flags;
        activityInfo.icon = activity.info.icon;
        activityInfo.logo = activity.info.logo;
        activityInfo.banner = activity.info.banner;
        activityInfo.labelRes = activity.info.labelRes;
        activityInfo.nonLocalizedLabel = activity.info.nonLocalizedLabel;
        activityInfo.launchMode = activity.info.launchMode;
        activityInfo.processName = activity.info.processName;
        if (activityInfo.descriptionRes == 0) {
            activityInfo.descriptionRes = activity.info.descriptionRes;
        }
        activityInfo.screenOrientation = activity.info.screenOrientation;
        activityInfo.taskAffinity = activity.info.taskAffinity;
        activityInfo.theme = activity.info.theme;
        activityInfo.softInputMode = activity.info.softInputMode;
        activityInfo.uiOptions = activity.info.uiOptions;
        activityInfo.parentActivityName = activity.info.parentActivityName;
        activityInfo.maxRecents = activity.info.maxRecents;
        Activity activity3 = new Activity(this.mParseActivityAliasArgs, activityInfo);
        if (stringArray[0] != null) {
            typedArray.recycle();
            return null;
        }
        boolean bl = typedArray.hasValue(5);
        if (bl) {
            activity3.info.exported = typedArray.getBoolean(5, false);
        }
        if ((string3 = typedArray.getNonConfigurationString(3, 0)) != null) {
            ActivityInfo activityInfo2 = activity3.info;
            String string6 = string3.length() > 0 ? string3.toString().intern() : null;
            activityInfo2.permission = string6;
        }
        if ((string2 = typedArray.getNonConfigurationString(9, 1024)) != null) {
            String string7 = PackageParser.buildClassName(activity3.info.packageName, string2, stringArray);
            if (stringArray[0] == null) {
                activity3.info.parentActivityName = string7;
            } else {
                Log.e(TAG, "Activity alias " + activity3.info.name + " specified invalid parentActivityName " + string2);
                stringArray[0] = null;
            }
        }
        typedArray.recycle();
        if (stringArray[0] != null) {
            return null;
        }
        int n6 = xmlPullParser.getDepth();
        while ((n2 = xmlPullParser.next()) != 1 && (n2 != 3 || xmlPullParser.getDepth() > n6)) {
            if (n2 == 3 || n2 == 4) continue;
            if (xmlPullParser.getName().equals("intent-filter")) {
                ActivityIntentInfo activityIntentInfo = new ActivityIntentInfo(activity3);
                if (!this.parseIntent(resources, xmlPullParser, attributeSet, true, activityIntentInfo, stringArray)) {
                    return null;
                }
                if (activityIntentInfo.countActions() == 0) {
                    Slog.w(TAG, "No actions in intent filter at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
                    continue;
                }
                activity3.intents.add(activityIntentInfo);
                continue;
            }
            if (xmlPullParser.getName().equals("meta-data")) {
                Bundle bundle;
                activity3.metaData = bundle = this.parseMetaData(resources, xmlPullParser, attributeSet, activity3.metaData, stringArray);
                if (bundle != null) continue;
                return null;
            }
            Slog.w(TAG, "Unknown element under <activity-alias>: " + xmlPullParser.getName() + " at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
            XmlUtils.skipCurrentTag(xmlPullParser);
        }
        if (bl) return activity3;
        ActivityInfo activityInfo3 = activity3.info;
        boolean bl2 = activity3.intents.size() > 0;
        activityInfo3.exported = bl2;
        return activity3;
    }

    private boolean parseAllMetaData(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, String string2, Component component, String[] stringArray) throws XmlPullParserException, IOException {
        int n;
        int n2 = xmlPullParser.getDepth();
        while ((n = xmlPullParser.next()) != 1 && (n != 3 || xmlPullParser.getDepth() > n2)) {
            if (n == 3 || n == 4) continue;
            if (xmlPullParser.getName().equals("meta-data")) {
                Bundle bundle;
                component.metaData = bundle = this.parseMetaData(resources, xmlPullParser, attributeSet, component.metaData, stringArray);
                if (bundle != null) continue;
                return false;
            }
            Slog.w(TAG, "Unknown element under " + string2 + ": " + xmlPullParser.getName() + " at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
            XmlUtils.skipCurrentTag(xmlPullParser);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ApkLite parseApkLite(File var0, int var1_1) throws PackageParserException {
        var2_2 = var0.getAbsolutePath();
        var3_3 = new AssetManager();
        try {
            var3_3.setConfiguration(0, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, Build.VERSION.RESOURCES_SDK_INT);
            var10_4 = var3_3.addAssetPath(var2_2);
            if (var10_4 == 0) {
                throw new PackageParserException(-100, "Failed to parse " + var2_2);
            }
            var11_15 = new DisplayMetrics();
            var11_15.setToDefaults();
            var12_16 = new Resources(var3_3, var11_15, null);
            var5_9 = var13_17 = var3_3.openXmlResourceParser(var10_4, "AndroidManifest.xml");
            if ((var1_1 & 256) == 0) ** GOTO lbl23
            ** GOTO lbl18
        }
        catch (XmlPullParserException var9_5) {
            var5_9 = null;
            ** GOTO lbl53
lbl18:
            // 1 sources

            try {
                block22: {
                    var16_18 = new Package(null);
                    PackageParser.collectCertificates(var16_18, var0, 0);
                    var14_19 = var16_18.mSignatures;
                    break block22;
lbl23:
                    // 1 sources

                    var14_19 = null;
                }
                var15_20 = PackageParser.parseApkLite(var2_2, var12_16, var5_9, var5_9, var1_1, var14_19);
            }
            catch (XmlPullParserException var9_8) {
                ** continue;
            }
            IoUtils.closeQuietly((AutoCloseable)var5_9);
            IoUtils.closeQuietly((AutoCloseable)var3_3);
            return var15_20;
            catch (IOException var4_21) {
                block21: {
                    var5_9 = null;
                    var3_3 = null;
                    break block21;
                    catch (RuntimeException var8_25) {
                        block20: {
                            var5_9 = null;
                            var3_3 = null;
                            break block20;
                            catch (Throwable var7_13) {
                                var3_3 = null;
                                var5_9 = null;
                                ** GOTO lbl-1000
                            }
                            catch (Throwable var7_14) {
                                var5_9 = null;
                                ** GOTO lbl-1000
                            }
                            catch (RuntimeException var8_27) {
                                var5_9 = null;
                                break block20;
                            }
                            catch (IOException var4_23) {
                                var5_9 = null;
                                break block21;
                            }
                            catch (XmlPullParserException var9_7) {
                                var3_3 = null;
                                var5_9 = null;
                            }
lbl53:
                            // 3 sources

                            while (true) {
                                var6_10 = var9_6;
lbl55:
                                // 3 sources

                                while (true) {
                                    try {
                                        throw new PackageParserException(-102, "Failed to parse " + var2_2, (Throwable)var6_10);
                                    }
                                    catch (Throwable var7_11) {}
                                    ** GOTO lbl-1000
                                    break;
                                }
                                break;
                            }
                            catch (RuntimeException var8_28) {}
                        }
                        var6_10 = var8_26;
                        ** GOTO lbl55
                    }
                    catch (IOException var4_24) {}
                }
                var6_10 = var4_22;
                ** continue;
            }
lbl-1000:
            // 3 sources

            {
                IoUtils.closeQuietly(var5_9);
                IoUtils.closeQuietly((AutoCloseable)var3_3);
                throw var7_12;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static ApkLite parseApkLite(String string2, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, Signature[] signatureArray) throws IOException, XmlPullParserException, PackageParserException {
        Pair<String, String> pair = PackageParser.parsePackageSplitNames(xmlPullParser, attributeSet, n);
        int n2 = -1;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n4 = 0;
        for (int i = 0; i < attributeSet.getAttributeCount(); ++i) {
            String string3 = attributeSet.getAttributeName(i);
            if (string3.equals("installLocation")) {
                n2 = attributeSet.getAttributeIntValue(i, -1);
                ++n4;
            } else if (string3.equals("versionCode")) {
                n3 = attributeSet.getAttributeIntValue(i, 0);
                ++n4;
            } else if (string3.equals("coreApp")) {
                bl = attributeSet.getAttributeBooleanValue(i, false);
                ++n4;
            }
            if (n4 >= 3) break;
        }
        int n5 = 1 + xmlPullParser.getDepth();
        ArrayList<VerifierInfo> arrayList = new ArrayList<VerifierInfo>();
        block1: while (true) {
            int n6;
            if ((n6 = xmlPullParser.next()) != 1 && (n6 != 3 || xmlPullParser.getDepth() >= n5)) {
                VerifierInfo verifierInfo;
                if (n6 == 3 || n6 == 4) continue;
                if (xmlPullParser.getDepth() == n5 && "package-verifier".equals(xmlPullParser.getName()) && (verifierInfo = PackageParser.parseVerifier(resources, xmlPullParser, attributeSet, n)) != null) {
                    arrayList.add(verifierInfo);
                }
                if (xmlPullParser.getDepth() != n5 || !"application".equals(xmlPullParser.getName())) continue;
            } else {
                return new ApkLite(string2, (String)pair.first, (String)pair.second, n3, n2, arrayList, signatureArray, bl, bl2);
            }
            int n7 = 0;
            while (true) {
                if (n7 >= attributeSet.getAttributeCount()) continue block1;
                if ("multiArch".equals(attributeSet.getAttributeName(n7))) {
                    bl2 = attributeSet.getAttributeBooleanValue(n7, false);
                    continue block1;
                }
                ++n7;
            }
            break;
        }
    }

    private boolean parseAsusBaseThemeOverlay(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Package package_, String[] stringArray) throws XmlPullParserException, IOException {
        int n;
        int n2 = xmlPullParser.getDepth();
        while ((n = xmlPullParser.next()) != 1 && (n != 3 || xmlPullParser.getDepth() > n2)) {
            if (!xmlPullParser.getName().equals("meta-data")) continue;
            Bundle bundle = this.parseMetaData(resources, xmlPullParser, attributeSet, null, stringArray);
            if (bundle == null) {
                return false;
            }
            package_.mAllowBaseThemeOverlay = bundle.getBoolean("allowBaseThemeOverlay", false);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Package parseBaseApk(Resources resources, XmlResourceParser xmlResourceParser, int n, String[] stringArray) throws XmlPullParserException, IOException {
        int n2;
        int n3;
        String string2;
        int n4;
        String string3;
        String string4;
        boolean bl = (n & 0x200) != 0;
        this.mParseInstrumentationArgs = null;
        this.mParseActivityArgs = null;
        this.mParseServiceArgs = null;
        this.mParseProviderArgs = null;
        try {
            Pair<String, String> pair = PackageParser.parsePackageSplitNames(xmlResourceParser, xmlResourceParser, n);
            string4 = (String)pair.first;
            string3 = (String)pair.second;
        }
        catch (PackageParserException packageParserException) {
            this.mParseError = -106;
            return null;
        }
        if (!TextUtils.isEmpty(string3)) {
            stringArray[0] = "Expected base APK, but found split " + string3;
            this.mParseError = -106;
            return null;
        }
        Package package_ = new Package(string4);
        boolean bl2 = false;
        TypedArray typedArray = resources.obtainAttributes(xmlResourceParser, R.styleable.AndroidManifest);
        ApplicationInfo applicationInfo = package_.applicationInfo;
        applicationInfo.versionCode = n4 = typedArray.getInteger(1, 0);
        package_.mVersionCode = n4;
        package_.mVersionName = typedArray.getNonConfigurationString(2, 0);
        if (package_.mVersionName != null) {
            package_.mVersionName = package_.mVersionName.intern();
        }
        if ((string2 = typedArray.getNonConfigurationString(0, 0)) != null && string2.length() > 0) {
            String string5 = PackageParser.validateName(string2, true);
            if (string5 != null && !"android".equals(string4)) {
                stringArray[0] = "<manifest> specifies bad sharedUserId name \"" + string2 + "\": " + string5;
                this.mParseError = -107;
                return null;
            }
            package_.mSharedUserId = string2.intern();
            package_.mSharedUserLabel = typedArray.getResourceId(3, 0);
        }
        package_.applicationInfo.installLocation = package_.installLocation = typedArray.getInteger(4, -1);
        package_.coreApp = xmlResourceParser.getAttributeBooleanValue(null, "coreApp", false);
        typedArray.recycle();
        if ((n & 0x10) != 0) {
            ApplicationInfo applicationInfo2 = package_.applicationInfo;
            applicationInfo2.flags = 0x20000000 | applicationInfo2.flags;
        }
        if ((n & 0x20) != 0) {
            ApplicationInfo applicationInfo3 = package_.applicationInfo;
            applicationInfo3.flags = 0x40000 | applicationInfo3.flags;
        }
        int n5 = 1;
        int n6 = 1;
        int n7 = 1;
        int n8 = 1;
        int n9 = 1;
        int n10 = 1;
        int n11 = xmlResourceParser.getDepth();
        while (true) {
            block89: {
                int n12;
                String string6;
                block91: {
                    boolean bl3;
                    String string7;
                    block83: {
                        String string8;
                        block90: {
                            int n13;
                            int n14;
                            ArrayList<FeatureInfo> arrayList;
                            FeatureGroupInfo featureGroupInfo;
                            block87: {
                                block85: {
                                    String string9;
                                    block88: {
                                        TypedValue typedValue;
                                        block86: {
                                            int n15;
                                            if ((n15 = xmlResourceParser.next()) == 1 || n15 == 3 && xmlResourceParser.getDepth() <= n11) break block85;
                                            if (n15 == 3 || n15 == 4) continue;
                                            string9 = xmlResourceParser.getName();
                                            if (string9.equals("application")) {
                                                if (bl2) {
                                                    Slog.w(TAG, "<manifest> has more than one <application>");
                                                    XmlUtils.skipCurrentTag(xmlResourceParser);
                                                    continue;
                                                }
                                                bl2 = true;
                                                if (this.parseBaseApplication(package_, resources, xmlResourceParser, xmlResourceParser, n, stringArray)) continue;
                                                return null;
                                            }
                                            if (string9.equals("overlay")) {
                                                package_.mTrustedOverlay = bl;
                                                TypedArray typedArray2 = resources.obtainAttributes(xmlResourceParser, R.styleable.AndroidManifestResourceOverlay);
                                                package_.mOverlayTarget = typedArray2.getString(1);
                                                package_.mOverlayPriority = typedArray2.getInt(0, -1);
                                                typedArray2.recycle();
                                                if (package_.mOverlayTarget == null) {
                                                    stringArray[0] = "<overlay> does not specify a target package";
                                                    this.mParseError = -108;
                                                    return null;
                                                }
                                                if (package_.mOverlayPriority != -1 && !bl) {
                                                    Slog.w(TAG, "overlay package " + string4 + " installed in " + "unreliable location, priority will be ignored");
                                                    package_.mOverlayPriority = -1;
                                                } else if (package_.mOverlayPriority == -1 && bl) {
                                                    stringArray[0] = "Trusted overlay requires a priority attribute";
                                                    this.mParseError = -108;
                                                    return null;
                                                }
                                                package_.applicationInfo.isThemeable = false;
                                                if ("com.asus.all.unbundle.apps".equals(package_.mOverlayTarget)) {
                                                    package_.mIsBaseThemeOverlay = true;
                                                }
                                                XmlUtils.skipCurrentTag(xmlResourceParser);
                                                continue;
                                            }
                                            if (xmlResourceParser.getName().equals("theme-pack")) {
                                                if (ThemePack.parseThemePack(package_, resources, xmlResourceParser, xmlResourceParser, stringArray)) continue;
                                                this.mParseError = -108;
                                                return null;
                                            }
                                            if (string9.equals("asus-basetheme-overlay")) {
                                                if (this.parseAsusBaseThemeOverlay(resources, xmlResourceParser, xmlResourceParser, package_, stringArray)) continue;
                                                this.mParseError = -108;
                                                return null;
                                            }
                                            if (string9.equals("key-sets")) {
                                                if (this.parseKeySets(package_, resources, xmlResourceParser, xmlResourceParser, stringArray)) continue;
                                                return null;
                                            }
                                            if (string9.equals("permission-group")) {
                                                if (this.parsePermissionGroup(package_, n, resources, xmlResourceParser, xmlResourceParser, stringArray) != null) continue;
                                                return null;
                                            }
                                            if (string9.equals("permission")) {
                                                if (this.parsePermission(package_, resources, xmlResourceParser, xmlResourceParser, stringArray) != null) continue;
                                                return null;
                                            }
                                            if (string9.equals("permission-tree")) {
                                                if (this.parsePermissionTree(package_, resources, xmlResourceParser, xmlResourceParser, stringArray) != null) continue;
                                                return null;
                                            }
                                            if (string9.equals("uses-permission")) {
                                                if (this.parseUsesPermission(package_, resources, xmlResourceParser, xmlResourceParser, stringArray)) continue;
                                                return null;
                                            }
                                            if (string9.equals("uses-configuration")) {
                                                ConfigurationInfo configurationInfo = new ConfigurationInfo();
                                                TypedArray typedArray3 = resources.obtainAttributes(xmlResourceParser, R.styleable.AndroidManifestUsesConfiguration);
                                                configurationInfo.reqTouchScreen = typedArray3.getInt(0, 0);
                                                configurationInfo.reqKeyboardType = typedArray3.getInt(1, 0);
                                                if (typedArray3.getBoolean(2, false)) {
                                                    configurationInfo.reqInputFeatures = 1 | configurationInfo.reqInputFeatures;
                                                }
                                                configurationInfo.reqNavigation = typedArray3.getInt(3, 0);
                                                if (typedArray3.getBoolean(4, false)) {
                                                    configurationInfo.reqInputFeatures = 2 | configurationInfo.reqInputFeatures;
                                                }
                                                typedArray3.recycle();
                                                package_.configPreferences = ArrayUtils.add(package_.configPreferences, configurationInfo);
                                                XmlUtils.skipCurrentTag(xmlResourceParser);
                                                continue;
                                            }
                                            if (string9.equals("uses-feature")) {
                                                FeatureInfo featureInfo = this.parseUsesFeature(resources, xmlResourceParser);
                                                package_.reqFeatures = ArrayUtils.add(package_.reqFeatures, featureInfo);
                                                if (featureInfo.name == null) {
                                                    ConfigurationInfo configurationInfo = new ConfigurationInfo();
                                                    configurationInfo.reqGlEsVersion = featureInfo.reqGlEsVersion;
                                                    package_.configPreferences = ArrayUtils.add(package_.configPreferences, configurationInfo);
                                                }
                                                XmlUtils.skipCurrentTag(xmlResourceParser);
                                                continue;
                                            }
                                            if (!string9.equals("feature-group")) break block86;
                                            featureGroupInfo = new FeatureGroupInfo();
                                            arrayList = null;
                                            n14 = xmlResourceParser.getDepth();
                                            break block87;
                                        }
                                        if (!string9.equals("uses-sdk")) break block88;
                                        if (SDK_VERSION <= 0) break block89;
                                        TypedArray typedArray4 = resources.obtainAttributes(xmlResourceParser, R.styleable.AndroidManifestUsesSdk);
                                        TypedValue typedValue2 = typedArray4.peekValue(0);
                                        string7 = null;
                                        int n16 = 0;
                                        string6 = null;
                                        n12 = 0;
                                        if (typedValue2 != null) {
                                            if (typedValue2.type == 3 && typedValue2.string != null) {
                                                string6 = string7 = typedValue2.string.toString();
                                            } else {
                                                n12 = n16 = typedValue2.data;
                                                string7 = null;
                                                string6 = null;
                                            }
                                        }
                                        if ((typedValue = typedArray4.peekValue(1)) != null) {
                                            if (typedValue.type == 3 && typedValue.string != null) {
                                                string6 = string7 = typedValue.string.toString();
                                            } else {
                                                n12 = typedValue.data;
                                            }
                                        }
                                        typedArray4.recycle();
                                        if (string7 != null) break block90;
                                        int n17 = SDK_VERSION;
                                        if (n16 > n17) {
                                            stringArray[0] = "Requires newer sdk version #" + n16 + " (current version is #" + SDK_VERSION + ")";
                                            this.mParseError = -12;
                                            return null;
                                        }
                                        break block91;
                                    }
                                    if (string9.equals("supports-screens")) {
                                        TypedArray typedArray5 = resources.obtainAttributes(xmlResourceParser, R.styleable.AndroidManifestSupportsScreens);
                                        package_.applicationInfo.requiresSmallestWidthDp = typedArray5.getInteger(6, 0);
                                        package_.applicationInfo.compatibleWidthLimitDp = typedArray5.getInteger(7, 0);
                                        package_.applicationInfo.largestWidthLimitDp = typedArray5.getInteger(8, 0);
                                        n5 = typedArray5.getInteger(1, n5);
                                        n6 = typedArray5.getInteger(2, n6);
                                        n7 = typedArray5.getInteger(3, n7);
                                        n8 = typedArray5.getInteger(5, n8);
                                        n9 = typedArray5.getInteger(4, n9);
                                        n10 = typedArray5.getInteger(0, n10);
                                        typedArray5.recycle();
                                        XmlUtils.skipCurrentTag(xmlResourceParser);
                                        continue;
                                    }
                                    if (string9.equals("protected-broadcast")) {
                                        TypedArray typedArray6 = resources.obtainAttributes(xmlResourceParser, R.styleable.AndroidManifestProtectedBroadcast);
                                        String string10 = typedArray6.getNonResourceString(0);
                                        typedArray6.recycle();
                                        if (string10 != null && (n & 1) != 0) {
                                            if (package_.protectedBroadcasts == null) {
                                                package_.protectedBroadcasts = new ArrayList();
                                            }
                                            if (!package_.protectedBroadcasts.contains(string10)) {
                                                package_.protectedBroadcasts.add(string10.intern());
                                            }
                                        }
                                        XmlUtils.skipCurrentTag(xmlResourceParser);
                                        continue;
                                    }
                                    if (string9.equals("instrumentation")) {
                                        if (this.parseInstrumentation(package_, resources, xmlResourceParser, xmlResourceParser, stringArray) != null) continue;
                                        return null;
                                    }
                                    if (string9.equals("original-package")) {
                                        TypedArray typedArray7 = resources.obtainAttributes(xmlResourceParser, R.styleable.AndroidManifestOriginalPackage);
                                        String string11 = typedArray7.getNonConfigurationString(0, 0);
                                        if (!package_.packageName.equals(string11)) {
                                            if (package_.mOriginalPackages == null) {
                                                package_.mOriginalPackages = new ArrayList();
                                                package_.mRealPackage = package_.packageName;
                                            }
                                            package_.mOriginalPackages.add(string11);
                                        }
                                        typedArray7.recycle();
                                        XmlUtils.skipCurrentTag(xmlResourceParser);
                                        continue;
                                    }
                                    if (string9.equals("adopt-permissions")) {
                                        TypedArray typedArray8 = resources.obtainAttributes(xmlResourceParser, R.styleable.AndroidManifestOriginalPackage);
                                        String string12 = typedArray8.getNonConfigurationString(0, 0);
                                        typedArray8.recycle();
                                        if (string12 != null) {
                                            if (package_.mAdoptPermissions == null) {
                                                package_.mAdoptPermissions = new ArrayList();
                                            }
                                            package_.mAdoptPermissions.add(string12);
                                        }
                                        XmlUtils.skipCurrentTag(xmlResourceParser);
                                        continue;
                                    }
                                    if (string9.equals("uses-gl-texture")) {
                                        XmlUtils.skipCurrentTag(xmlResourceParser);
                                        continue;
                                    }
                                    if (string9.equals("compatible-screens")) {
                                        XmlUtils.skipCurrentTag(xmlResourceParser);
                                        continue;
                                    }
                                    if (string9.equals("supports-input")) {
                                        XmlUtils.skipCurrentTag(xmlResourceParser);
                                        continue;
                                    }
                                    if (string9.equals("eat-comment")) {
                                        XmlUtils.skipCurrentTag(xmlResourceParser);
                                        continue;
                                    }
                                    Slog.w(TAG, "Unknown element under <manifest>: " + xmlResourceParser.getName() + " at " + this.mArchiveSourcePath + " " + xmlResourceParser.getPositionDescription());
                                    XmlUtils.skipCurrentTag(xmlResourceParser);
                                    continue;
                                }
                                if (!bl2 && package_.instrumentation.size() == 0) {
                                    stringArray[0] = "<manifest> does not contain an <application> or <instrumentation>";
                                    this.mParseError = -109;
                                }
                                if (package_.mOverlayTarget != null && package_.mAllowBaseThemeOverlay) {
                                    stringArray[0] = "<overlay> is conflict with <asus-basetheme-overlay>";
                                    this.mParseError = -108;
                                    return null;
                                }
                                break;
                            }
                            while ((n13 = xmlResourceParser.next()) != 1 && (n13 != 3 || xmlResourceParser.getDepth() > n14)) {
                                if (n13 == 3 || n13 == 4) continue;
                                String string13 = xmlResourceParser.getName();
                                if (string13.equals("uses-feature")) {
                                    FeatureInfo featureInfo = this.parseUsesFeature(resources, xmlResourceParser);
                                    featureInfo.flags = 1 | featureInfo.flags;
                                    arrayList = ArrayUtils.add(arrayList, featureInfo);
                                } else {
                                    Slog.w(TAG, "Unknown element under <feature-group>: " + string13 + " at " + this.mArchiveSourcePath + " " + xmlResourceParser.getPositionDescription());
                                }
                                XmlUtils.skipCurrentTag(xmlResourceParser);
                            }
                            if (arrayList != null) {
                                FeatureInfo[] featureInfoArray = featureGroupInfo.features = new FeatureInfo[arrayList.size()];
                                featureGroupInfo.features = arrayList.toArray(featureInfoArray);
                            }
                            package_.featureGroups = ArrayUtils.add(package_.featureGroups, featureGroupInfo);
                            continue;
                        }
                        String[] stringArray2 = SDK_CODENAMES;
                        int n18 = stringArray2.length;
                        int n19 = 0;
                        do {
                            int n20 = ++n19;
                            bl3 = false;
                            if (n20 >= n18) break block83;
                        } while (!string7.equals(string8 = stringArray2[n19]));
                        bl3 = true;
                    }
                    if (!bl3) {
                        stringArray[0] = SDK_CODENAMES.length > 0 ? "Requires development platform " + string7 + " (current platform is any of " + Arrays.toString(SDK_CODENAMES) + ")" : "Requires development platform " + string7 + " but this is a release platform.";
                        this.mParseError = -12;
                        return null;
                    }
                }
                if (string6 == null) {
                    package_.applicationInfo.targetSdkVersion = n12;
                } else {
                    boolean bl4;
                    block84: {
                        String string14;
                        String[] stringArray3 = SDK_CODENAMES;
                        int n21 = stringArray3.length;
                        int n22 = 0;
                        do {
                            int n23 = ++n22;
                            bl4 = false;
                            if (n23 >= n21) break block84;
                        } while (!string6.equals(string14 = stringArray3[n22]));
                        bl4 = true;
                    }
                    if (!bl4) {
                        stringArray[0] = SDK_CODENAMES.length > 0 ? "Requires development platform " + string6 + " (current platform is any of " + Arrays.toString(SDK_CODENAMES) + ")" : "Requires development platform " + string6 + " but this is a release platform.";
                        this.mParseError = -12;
                        return null;
                    }
                    package_.applicationInfo.targetSdkVersion = 10000;
                }
            }
            XmlUtils.skipCurrentTag(xmlResourceParser);
        }
        int n24 = NEW_PERMISSIONS.length;
        StringBuilder stringBuilder = null;
        int n25 = 0;
        while (true) {
            NewPermissionInfo newPermissionInfo;
            block93: {
                block92: {
                    if (n25 >= n24) break block92;
                    newPermissionInfo = NEW_PERMISSIONS[n25];
                    if (package_.applicationInfo.targetSdkVersion < newPermissionInfo.sdkVersion) break block93;
                }
                if (stringBuilder != null) {
                    Slog.i(TAG, stringBuilder.toString());
                }
                n3 = SPLIT_PERMISSIONS.length;
                break;
            }
            if (!package_.requestedPermissions.contains(newPermissionInfo.name)) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(128);
                    String string15 = package_.packageName;
                    stringBuilder.append(string15);
                    stringBuilder.append(": compat added ");
                } else {
                    stringBuilder.append(' ');
                }
                String string16 = newPermissionInfo.name;
                stringBuilder.append(string16);
                package_.requestedPermissions.add(newPermissionInfo.name);
                package_.requestedPermissionsRequired.add(Boolean.TRUE);
            }
            ++n25;
        }
        for (int i = 0; i < n3; ++i) {
            int n26;
            SplitPermissionInfo splitPermissionInfo = SPLIT_PERMISSIONS[i];
            if (package_.applicationInfo.targetSdkVersion >= splitPermissionInfo.targetSdk || !package_.requestedPermissions.contains(splitPermissionInfo.rootPerm)) continue;
            for (int j = 0; j < (n26 = splitPermissionInfo.newPerms.length); ++j) {
                String string17 = splitPermissionInfo.newPerms[j];
                if (package_.requestedPermissions.contains(string17)) continue;
                package_.requestedPermissions.add(string17);
                package_.requestedPermissionsRequired.add(Boolean.TRUE);
            }
        }
        if (n5 < 0 || n5 > 0 && package_.applicationInfo.targetSdkVersion >= 4) {
            ApplicationInfo applicationInfo4 = package_.applicationInfo;
            applicationInfo4.flags = 0x200 | applicationInfo4.flags;
        }
        if (n6 != 0) {
            ApplicationInfo applicationInfo5 = package_.applicationInfo;
            applicationInfo5.flags = 0x400 | applicationInfo5.flags;
        }
        if (n7 < 0 || n7 > 0 && package_.applicationInfo.targetSdkVersion >= 4) {
            ApplicationInfo applicationInfo6 = package_.applicationInfo;
            applicationInfo6.flags = 0x800 | applicationInfo6.flags;
        }
        if (n8 < 0 || n8 > 0 && package_.applicationInfo.targetSdkVersion >= 9) {
            ApplicationInfo applicationInfo7 = package_.applicationInfo;
            applicationInfo7.flags = 0x80000 | applicationInfo7.flags;
        }
        if (n9 < 0 || n9 > 0 && package_.applicationInfo.targetSdkVersion >= 4) {
            ApplicationInfo applicationInfo8 = package_.applicationInfo;
            applicationInfo8.flags = 0x1000 | applicationInfo8.flags;
        }
        if (n10 < 0 || n10 > 0 && package_.applicationInfo.targetSdkVersion >= 4) {
            ApplicationInfo applicationInfo9 = package_.applicationInfo;
            applicationInfo9.flags = 0x2000 | applicationInfo9.flags;
        }
        if (package_.applicationInfo.targetSdkVersion >= 18) return package_;
        int n27 = 0;
        while (n27 < (n2 = package_.requestedPermissionsRequired.size())) {
            ArrayList<Boolean> arrayList = package_.requestedPermissionsRequired;
            Boolean bl5 = Boolean.TRUE;
            arrayList.set(n27, bl5);
            ++n27;
        }
        return package_;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Package parseBaseApk(File var1_1, AssetManager var2_2, int var3_3) throws PackageParserException {
        var4_4 = var1_1.getAbsolutePath();
        this.mParseError = 1;
        this.mArchiveSourcePath = var1_1.getAbsolutePath();
        var5_5 = PackageParser.loadApkIntoAssetManager(var2_2, var4_4, var3_3);
        var6_6 = null;
        var7_7 = new Resources(var2_2, this.mMetrics, null);
        try {
            var2_2.setConfiguration(0, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, Build.VERSION.RESOURCES_SDK_INT);
            var6_6 = var2_2.openXmlResourceParser(var5_5, "AndroidManifest.xml");
            var11_8 = new String[1];
            var12_9 = this.parseBaseApk(var7_7, var6_6, var3_3, var11_8);
            if (var12_9 == null) {
                throw new PackageParserException(this.mParseError, var4_4 + " (at " + var6_6.getPositionDescription() + "): " + var11_8[0]);
            }
            var12_9.baseCodePath = var4_4;
            var12_9.mSignatures = null;
            IoUtils.closeQuietly((AutoCloseable)var6_6);
            return var12_9;
        }
        catch (PackageParserException var10_10) {}
        ** GOTO lbl-1000
        catch (Exception var8_18) {}
        finally {
            ** GOTO lbl-1000
        }
lbl-1000:
        // 1 sources

        {
            while (true) {
                throw var10_11;
                {
                    catch (Throwable var9_13) {}
                    ** GOTO lbl-1000
                    catch (Exception var8_16) {}
                    {
                        throw new PackageParserException(-102, "Failed to read manifest from " + var4_4, (Throwable)var8_17);
                    }
                    catch (PackageParserException var10_12) {
                        var6_6 = null;
                        continue;
                    }
lbl-1000:
                    // 2 sources

                    {
                        IoUtils.closeQuietly(var6_6);
                        throw var9_14;
                    }
                }
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseBaseApplication(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, String[] stringArray) throws XmlPullParserException, IOException {
        int n2;
        String string2;
        String string3;
        String string4;
        TypedValue typedValue;
        String string5;
        ApplicationInfo applicationInfo = package_.applicationInfo;
        String string6 = package_.applicationInfo.packageName;
        TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestApplication);
        String string7 = typedArray.getNonConfigurationString(3, 0);
        if (string7 != null) {
            applicationInfo.className = PackageParser.buildClassName(string6, string7, stringArray);
            if (applicationInfo.className == null) {
                typedArray.recycle();
                this.mParseError = -108;
                return false;
            }
        }
        if ((string5 = typedArray.getNonConfigurationString(4, 1024)) != null) {
            applicationInfo.manageSpaceActivityName = PackageParser.buildClassName(string6, string5, stringArray);
        }
        if (typedArray.getBoolean(17, true)) {
            applicationInfo.flags = 0x8000 | applicationInfo.flags;
            String string8 = typedArray.getNonConfigurationString(16, 1024);
            if (string8 != null) {
                applicationInfo.backupAgentName = PackageParser.buildClassName(string6, string8, stringArray);
                if (typedArray.getBoolean(18, true)) {
                    applicationInfo.flags = 0x10000 | applicationInfo.flags;
                }
                if (typedArray.getBoolean(21, false)) {
                    applicationInfo.flags = 0x20000 | applicationInfo.flags;
                }
                if (typedArray.getBoolean(32, false)) {
                    applicationInfo.flags = 0x4000000 | applicationInfo.flags;
                }
            }
        }
        if ((typedValue = typedArray.peekValue(1)) != null) {
            int n3;
            applicationInfo.labelRes = n3 = typedValue.resourceId;
            if (n3 == 0) {
                applicationInfo.nonLocalizedLabel = typedValue.coerceToString();
            }
        }
        applicationInfo.icon = typedArray.getResourceId(2, 0);
        applicationInfo.logo = typedArray.getResourceId(22, 0);
        applicationInfo.banner = typedArray.getResourceId(30, 0);
        applicationInfo.theme = typedArray.getResourceId(0, 0);
        applicationInfo.descriptionRes = typedArray.getResourceId(13, 0);
        if ((n & 1) != 0 && typedArray.getBoolean(8, false)) {
            applicationInfo.flags = 8 | applicationInfo.flags;
        }
        if (typedArray.getBoolean(27, false)) {
            package_.mRequiredForAllUsers = true;
        }
        if ((string4 = typedArray.getString(28)) != null && string4.length() > 0) {
            package_.mRestrictedAccountType = string4;
        }
        if ((string3 = typedArray.getString(29)) != null && string3.length() > 0) {
            package_.mRequiredAccountType = string3;
        }
        if (typedArray.getBoolean(10, false)) {
            applicationInfo.flags = 2 | applicationInfo.flags;
        }
        if (typedArray.getBoolean(20, false)) {
            applicationInfo.flags = 0x4000 | applicationInfo.flags;
        }
        boolean bl = package_.applicationInfo.targetSdkVersion >= 14;
        package_.baseHardwareAccelerated = typedArray.getBoolean(23, bl);
        if (typedArray.getBoolean(7, true)) {
            applicationInfo.flags = 4 | applicationInfo.flags;
        }
        if (typedArray.getBoolean(14, false)) {
            applicationInfo.flags = 0x20 | applicationInfo.flags;
        }
        if (typedArray.getBoolean(5, true)) {
            applicationInfo.flags = 0x40 | applicationInfo.flags;
        }
        if (typedArray.getBoolean(15, false)) {
            applicationInfo.flags = 0x100 | applicationInfo.flags;
        }
        if (typedArray.getBoolean(24, false)) {
            applicationInfo.flags = 0x100000 | applicationInfo.flags;
        }
        if (typedArray.getBoolean(26, false)) {
            applicationInfo.flags = 0x400000 | applicationInfo.flags;
        }
        if (typedArray.getBoolean(33, false)) {
            applicationInfo.flags = Integer.MIN_VALUE | applicationInfo.flags;
        }
        String string9 = (string2 = typedArray.getNonConfigurationString(6, 0)) != null && string2.length() > 0 ? string2.intern() : null;
        applicationInfo.permission = string9;
        String string10 = package_.applicationInfo.targetSdkVersion >= 8 ? typedArray.getNonConfigurationString(12, 1024) : typedArray.getNonResourceString(12);
        applicationInfo.taskAffinity = PackageParser.buildTaskAffinityName(applicationInfo.packageName, applicationInfo.packageName, string10, stringArray);
        if (stringArray[0] == null) {
            String string11 = package_.applicationInfo.targetSdkVersion >= 8 ? typedArray.getNonConfigurationString(11, 1024) : typedArray.getNonResourceString(11);
            applicationInfo.processName = PackageParser.buildProcessName(applicationInfo.packageName, null, string11, n, this.mSeparateProcesses, stringArray);
            applicationInfo.enabled = typedArray.getBoolean(9, true);
            if (typedArray.getBoolean(31, false)) {
                applicationInfo.flags = 0x2000000 | applicationInfo.flags;
            }
        }
        applicationInfo.uiOptions = typedArray.getInt(25, 0);
        typedArray.recycle();
        if (stringArray[0] != null) {
            this.mParseError = -108;
            return false;
        }
        int n4 = xmlPullParser.getDepth();
        while ((n2 = xmlPullParser.next()) != 1 && (n2 != 3 || xmlPullParser.getDepth() > n4)) {
            if (n2 == 3 || n2 == 4) continue;
            String string12 = xmlPullParser.getName();
            if (string12.equals("activity")) {
                Activity activity = this.parseActivity(package_, resources, xmlPullParser, attributeSet, n, stringArray, false, package_.baseHardwareAccelerated);
                if (activity == null) {
                    this.mParseError = -108;
                    return false;
                }
                package_.activities.add(activity);
                continue;
            }
            if (string12.equals("receiver")) {
                Activity activity = this.parseActivity(package_, resources, xmlPullParser, attributeSet, n, stringArray, true, false);
                if (activity == null) {
                    this.mParseError = -108;
                    return false;
                }
                package_.receivers.add(activity);
                continue;
            }
            if (string12.equals("service")) {
                Service service = this.parseService(package_, resources, xmlPullParser, attributeSet, n, stringArray);
                if (service == null) {
                    this.mParseError = -108;
                    return false;
                }
                package_.services.add(service);
                continue;
            }
            if (string12.equals("provider")) {
                Provider provider = this.parseProvider(package_, resources, xmlPullParser, attributeSet, n, stringArray);
                if (provider == null) {
                    this.mParseError = -108;
                    return false;
                }
                package_.providers.add(provider);
                continue;
            }
            if (string12.equals("activity-alias")) {
                Activity activity = this.parseActivityAlias(package_, resources, xmlPullParser, attributeSet, n, stringArray);
                if (activity == null) {
                    this.mParseError = -108;
                    return false;
                }
                package_.activities.add(activity);
                continue;
            }
            if (xmlPullParser.getName().equals("meta-data")) {
                Bundle bundle;
                package_.mAppMetaData = bundle = this.parseMetaData(resources, xmlPullParser, attributeSet, package_.mAppMetaData, stringArray);
                if (bundle != null) continue;
                this.mParseError = -108;
                return false;
            }
            if (string12.equals("library")) {
                String string13;
                TypedArray typedArray2 = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestLibrary);
                String string14 = typedArray2.getNonResourceString(0);
                typedArray2.recycle();
                if (string14 != null && !ArrayUtils.contains(package_.libraryNames, string13 = string14.intern())) {
                    package_.libraryNames = ArrayUtils.add(package_.libraryNames, string13);
                }
                XmlUtils.skipCurrentTag(xmlPullParser);
                continue;
            }
            if (string12.equals("uses-library")) {
                TypedArray typedArray3 = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestUsesLibrary);
                String string15 = typedArray3.getNonResourceString(0);
                boolean bl2 = typedArray3.getBoolean(1, true);
                typedArray3.recycle();
                if (string15 != null) {
                    String string16 = string15.intern();
                    if (bl2) {
                        package_.usesLibraries = ArrayUtils.add(package_.usesLibraries, string16);
                    } else {
                        package_.usesOptionalLibraries = ArrayUtils.add(package_.usesOptionalLibraries, string16);
                    }
                }
                XmlUtils.skipCurrentTag(xmlPullParser);
                continue;
            }
            if (string12.equals("uses-package")) {
                XmlUtils.skipCurrentTag(xmlPullParser);
                continue;
            }
            Slog.w(TAG, "Unknown element under <application>: " + string12 + " at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
            XmlUtils.skipCurrentTag(xmlPullParser);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Package parseClusterPackage(File file, int n) throws PackageParserException {
        PackageLite packageLite = PackageParser.parseClusterPackageLite(file, 0);
        if (this.mOnlyCoreApps && !packageLite.coreApp) {
            throw new PackageParserException(-108, "Not a coreApp: " + file);
        }
        AssetManager assetManager = new AssetManager();
        try {
            File file2;
            Package package_;
            PackageParser.loadApkIntoAssetManager(assetManager, packageLite.baseCodePath, n);
            if (!ArrayUtils.isEmpty(packageLite.splitCodePaths)) {
                String[] stringArray = packageLite.splitCodePaths;
                int n2 = stringArray.length;
                for (int i = 0; i < n2; ++i) {
                    PackageParser.loadApkIntoAssetManager(assetManager, stringArray[i], n);
                }
            }
            if ((package_ = this.parseBaseApk(file2 = new File(packageLite.baseCodePath), assetManager, n)) == null) {
                throw new PackageParserException(-100, "Failed to parse base APK: " + file2);
            }
            if (!ArrayUtils.isEmpty(packageLite.splitNames)) {
                int n3 = packageLite.splitNames.length;
                package_.splitNames = packageLite.splitNames;
                package_.splitCodePaths = packageLite.splitCodePaths;
                package_.splitFlags = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    this.parseSplitApk(package_, i, assetManager, n);
                }
            }
            package_.codePath = file.getAbsolutePath();
            return package_;
        }
        finally {
            IoUtils.closeQuietly((AutoCloseable)assetManager);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static PackageLite parseClusterPackageLite(File file, int n) throws PackageParserException {
        File[] fileArray = file.listFiles();
        if (ArrayUtils.isEmpty(fileArray)) {
            throw new PackageParserException(-100, "No packages found in split");
        }
        String string2 = null;
        int n2 = 0;
        ArrayMap<String, ApkLite> arrayMap = new ArrayMap<String, ApkLite>();
        for (File file2 : fileArray) {
            if (!PackageParser.isApkFile(file2)) continue;
            ApkLite apkLite = PackageParser.parseApkLite(file2, n);
            if (string2 == null) {
                string2 = apkLite.packageName;
                n2 = apkLite.versionCode;
            } else {
                if (!string2.equals(apkLite.packageName)) {
                    throw new PackageParserException(-101, "Inconsistent package " + apkLite.packageName + " in " + file2 + "; expected " + string2);
                }
                int n3 = apkLite.versionCode;
                if (n2 != n3) {
                    throw new PackageParserException(-101, "Inconsistent version " + apkLite.versionCode + " in " + file2 + "; expected " + n2);
                }
            }
            if (arrayMap.put(apkLite.splitName, apkLite) == null) continue;
            throw new PackageParserException(-101, "Split name " + apkLite.splitName + " defined more than once; most recent was " + file2);
        }
        ApkLite apkLite = (ApkLite)arrayMap.remove(null);
        if (apkLite == null) {
            throw new PackageParserException(-101, "Missing base APK in " + file);
        }
        int n4 = arrayMap.size();
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (n4 > 0) {
            String[] stringArray3 = new String[n4];
            stringArray = new String[n4];
            stringArray2 = arrayMap.keySet().toArray(stringArray3);
            Arrays.sort(stringArray2, sSplitNameComparator);
            for (int i = 0; i < n4; ++i) {
                stringArray[i] = ((ApkLite)arrayMap.get((Object)stringArray2[i])).codePath;
            }
        }
        String string3 = file.getAbsolutePath();
        return new PackageLite(string3, apkLite, stringArray2, stringArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Instrumentation parseInstrumentation(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, String[] stringArray) throws XmlPullParserException, IOException {
        TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestInstrumentation);
        if (this.mParseInstrumentationArgs == null) {
            this.mParseInstrumentationArgs = new ParsePackageItemArgs(package_, stringArray, 2, 0, 1, 6, 7);
            this.mParseInstrumentationArgs.tag = "<instrumentation>";
        }
        this.mParseInstrumentationArgs.sa = typedArray;
        Instrumentation instrumentation = new Instrumentation(this.mParseInstrumentationArgs, new InstrumentationInfo());
        if (stringArray[0] != null) {
            typedArray.recycle();
            this.mParseError = -108;
            return null;
        }
        String string2 = typedArray.getNonResourceString(3);
        InstrumentationInfo instrumentationInfo = instrumentation.info;
        String string3 = string2 != null ? string2.intern() : null;
        instrumentationInfo.targetPackage = string3;
        instrumentation.info.handleProfiling = typedArray.getBoolean(4, false);
        instrumentation.info.functionalTest = typedArray.getBoolean(5, false);
        typedArray.recycle();
        if (instrumentation.info.targetPackage == null) {
            stringArray[0] = "<instrumentation> does not specify targetPackage";
            this.mParseError = -108;
            return null;
        }
        if (!this.parseAllMetaData(resources, xmlPullParser, attributeSet, "<instrumentation>", instrumentation, stringArray)) {
            this.mParseError = -108;
            return null;
        }
        package_.instrumentation.add(instrumentation);
        return instrumentation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean parseIntent(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, boolean bl, IntentInfo intentInfo, String[] stringArray) throws XmlPullParserException, IOException {
        int n;
        TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestIntentFilter);
        intentInfo.setPriority(typedArray.getInt(2, 0));
        TypedValue typedValue = typedArray.peekValue(0);
        if (typedValue != null) {
            int n2;
            intentInfo.labelRes = n2 = typedValue.resourceId;
            if (n2 == 0) {
                intentInfo.nonLocalizedLabel = typedValue.coerceToString();
            }
        }
        intentInfo.icon = typedArray.getResourceId(1, 0);
        intentInfo.logo = typedArray.getResourceId(3, 0);
        intentInfo.banner = typedArray.getResourceId(4, 0);
        typedArray.recycle();
        int n3 = xmlPullParser.getDepth();
        while ((n = xmlPullParser.next()) != 1 && (n != 3 || xmlPullParser.getDepth() > n3)) {
            if (n == 3 || n == 4) continue;
            String string9 = xmlPullParser.getName();
            if (string9.equals("action")) {
                String string10 = attributeSet.getAttributeValue(ANDROID_RESOURCES, "name");
                if (string10 == null || string10 == "") {
                    stringArray[0] = "No value supplied for <android:name>";
                    return false;
                }
                XmlUtils.skipCurrentTag(xmlPullParser);
                intentInfo.addAction(string10);
                continue;
            }
            if (string9.equals("category")) {
                String string11 = attributeSet.getAttributeValue(ANDROID_RESOURCES, "name");
                if (string11 == null || string11 == "") {
                    stringArray[0] = "No value supplied for <android:name>";
                    return false;
                }
                XmlUtils.skipCurrentTag(xmlPullParser);
                intentInfo.addCategory(string11);
                continue;
            }
            if (string9.equals("data")) {
                String string2;
                String string3;
                String string4;
                String string5;
                String string6;
                String string7;
                String string8;
                TypedArray typedArray2 = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestData);
                String string12 = typedArray2.getNonConfigurationString(0, 0);
                if (string12 != null) {
                    try {
                        intentInfo.addDataType(string12);
                    }
                    catch (IntentFilter.MalformedMimeTypeException malformedMimeTypeException) {
                        stringArray[0] = malformedMimeTypeException.toString();
                        typedArray2.recycle();
                        return false;
                    }
                }
                if ((string8 = typedArray2.getNonConfigurationString(1, 0)) != null) {
                    intentInfo.addDataScheme(string8);
                }
                if ((string7 = typedArray2.getNonConfigurationString(7, 0)) != null) {
                    intentInfo.addDataSchemeSpecificPart(string7, 0);
                }
                if ((string6 = typedArray2.getNonConfigurationString(8, 0)) != null) {
                    intentInfo.addDataSchemeSpecificPart(string6, 1);
                }
                if ((string5 = typedArray2.getNonConfigurationString(9, 0)) != null) {
                    if (!bl) {
                        stringArray[0] = "sspPattern not allowed here; ssp must be literal";
                        return false;
                    }
                    intentInfo.addDataSchemeSpecificPart(string5, 2);
                }
                String string13 = typedArray2.getNonConfigurationString(2, 0);
                String string14 = typedArray2.getNonConfigurationString(3, 0);
                if (string13 != null) {
                    intentInfo.addDataAuthority(string13, string14);
                }
                if ((string4 = typedArray2.getNonConfigurationString(4, 0)) != null) {
                    intentInfo.addDataPath(string4, 0);
                }
                if ((string3 = typedArray2.getNonConfigurationString(5, 0)) != null) {
                    intentInfo.addDataPath(string3, 1);
                }
                if ((string2 = typedArray2.getNonConfigurationString(6, 0)) != null) {
                    if (!bl) {
                        stringArray[0] = "pathPattern not allowed here; path must be literal";
                        return false;
                    }
                    intentInfo.addDataPath(string2, 2);
                }
                typedArray2.recycle();
                XmlUtils.skipCurrentTag(xmlPullParser);
                continue;
            }
            Slog.w(TAG, "Unknown element under <intent-filter>: " + xmlPullParser.getName() + " at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
            XmlUtils.skipCurrentTag(xmlPullParser);
        }
        intentInfo.hasDefault = intentInfo.hasCategory("android.intent.category.DEFAULT");
        return true;
    }

    private boolean parseKeySets(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, String[] stringArray) throws XmlPullParserException, IOException {
        int n;
        int n2 = xmlPullParser.getDepth();
        int n3 = -1;
        String string2 = null;
        ArrayMap<String, PublicKey> arrayMap = new ArrayMap<String, PublicKey>();
        ArraySet<String> arraySet = new ArraySet<String>();
        ArrayMap arrayMap2 = new ArrayMap();
        ArraySet<String> arraySet2 = new ArraySet<String>();
        while ((n = xmlPullParser.next()) != 1 && (n != 3 || xmlPullParser.getDepth() > n2)) {
            String string3;
            block17: {
                String string4;
                TypedArray typedArray;
                block19: {
                    block18: {
                        if (n == 3) {
                            if (xmlPullParser.getDepth() != n3) continue;
                            n3 = -1;
                            string2 = null;
                            continue;
                        }
                        string3 = xmlPullParser.getName();
                        if (string3.equals("key-set")) {
                            if (string2 != null) {
                                Slog.w(TAG, "Improperly nested 'key-set' tag at " + xmlPullParser.getPositionDescription());
                                return false;
                            }
                            TypedArray typedArray2 = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestKeySet);
                            String string5 = typedArray2.getNonResourceString(0);
                            arrayMap2.put(string5, new ArraySet());
                            string2 = string5;
                            n3 = xmlPullParser.getDepth();
                            typedArray2.recycle();
                            continue;
                        }
                        if (!string3.equals("public-key")) break block17;
                        if (string2 == null) {
                            Slog.w(TAG, "Improperly nested 'public-key' tag at " + xmlPullParser.getPositionDescription());
                            return false;
                        }
                        typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestPublicKey);
                        string4 = typedArray.getNonResourceString(0);
                        String string6 = typedArray.getNonResourceString(1);
                        if (string6 == null && arrayMap.get(string4) == null) {
                            Slog.w(TAG, "'public-key' " + string4 + " must define a public-key value" + " on first use at " + xmlPullParser.getPositionDescription());
                            typedArray.recycle();
                            return false;
                        }
                        if (string6 == null) break block18;
                        PublicKey publicKey = PackageParser.parsePublicKey(string6);
                        if (publicKey == null) {
                            Slog.w(TAG, "No recognized valid key in 'public-key' tag at " + xmlPullParser.getPositionDescription() + " key-set " + string2 + " will not be added to the package's defined key-sets.");
                            typedArray.recycle();
                            arraySet2.add(string2);
                            XmlUtils.skipCurrentTag(xmlPullParser);
                            continue;
                        }
                        if (arrayMap.get(string4) != null && !((PublicKey)arrayMap.get(string4)).equals(publicKey)) break block19;
                        arrayMap.put(string4, publicKey);
                    }
                    ((ArraySet)arrayMap2.get(string2)).add(string4);
                    typedArray.recycle();
                    XmlUtils.skipCurrentTag(xmlPullParser);
                    continue;
                }
                Slog.w(TAG, "Value of 'public-key' " + string4 + " conflicts with previously defined value at " + xmlPullParser.getPositionDescription());
                typedArray.recycle();
                return false;
            }
            if (string3.equals("upgrade-key-set")) {
                TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestUpgradeKeySet);
                arraySet.add(typedArray.getNonResourceString(0));
                typedArray.recycle();
                XmlUtils.skipCurrentTag(xmlPullParser);
                continue;
            }
            Slog.w(TAG, "Unknown element under <key-sets>: " + xmlPullParser.getName() + " at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
            XmlUtils.skipCurrentTag(xmlPullParser);
        }
        if (arrayMap.keySet().removeAll(arrayMap2.keySet())) {
            Slog.w(TAG, "Package" + package_.packageName + " AndroidManifext.xml " + "'key-set' and 'public-key' names must be distinct.");
            return false;
        }
        package_.mKeySetMapping = new ArrayMap();
        for (Map.Entry entry : arrayMap2.entrySet()) {
            String string7 = (String)entry.getKey();
            if (((ArraySet)entry.getValue()).size() == 0) {
                Slog.w(TAG, "Package" + package_.packageName + " AndroidManifext.xml " + "'key-set' " + string7 + " has no valid associated 'public-key'." + " Not including in package's defined key-sets.");
                continue;
            }
            if (arraySet2.contains(string7)) {
                Slog.w(TAG, "Package" + package_.packageName + " AndroidManifext.xml " + "'key-set' " + string7 + " contained improper 'public-key'" + " tags. Not including in package's defined key-sets.");
                continue;
            }
            package_.mKeySetMapping.put(string7, new ArraySet());
            for (String string8 : (ArraySet)entry.getValue()) {
                package_.mKeySetMapping.get(string7).add((PublicKey)arrayMap.get(string8));
            }
        }
        if (package_.mKeySetMapping.keySet().containsAll(arraySet)) {
            package_.mUpgradeKeySets = arraySet;
            return true;
        }
        Slog.w(TAG, "Package" + package_.packageName + " AndroidManifext.xml " + "does not define all 'upgrade-key-set's .");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Bundle parseMetaData(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Bundle bundle, String[] stringArray) throws XmlPullParserException, IOException {
        TypedArray typedArray;
        block7: {
            block9: {
                TypedValue typedValue;
                String string2;
                block11: {
                    block10: {
                        block8: {
                            String string3;
                            typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestMetaData);
                            if (bundle == null) {
                                bundle = new Bundle();
                            }
                            if ((string3 = typedArray.getNonConfigurationString(0, 0)) == null) {
                                stringArray[0] = "<meta-data> requires an android:name attribute";
                                typedArray.recycle();
                                return null;
                            }
                            string2 = string3.intern();
                            TypedValue typedValue2 = typedArray.peekValue(2);
                            if (typedValue2 == null || typedValue2.resourceId == 0) break block8;
                            bundle.putInt(string2, typedValue2.resourceId);
                            break block7;
                        }
                        typedValue = typedArray.peekValue(1);
                        if (typedValue == null) break block9;
                        if (typedValue.type != 3) break block10;
                        CharSequence charSequence = typedValue.coerceToString();
                        String string4 = null;
                        if (charSequence != null) {
                            string4 = charSequence.toString().intern();
                        }
                        bundle.putString(string2, string4);
                        break block7;
                    }
                    if (typedValue.type != 18) break block11;
                    boolean bl = typedValue.data != 0;
                    bundle.putBoolean(string2, bl);
                    break block7;
                }
                if (typedValue.type >= 16 && typedValue.type <= 31) {
                    bundle.putInt(string2, typedValue.data);
                    break block7;
                } else if (typedValue.type == 4) {
                    bundle.putFloat(string2, typedValue.getFloat());
                    break block7;
                } else {
                    Slog.w(TAG, "<meta-data> only supports string, integer, float, color, boolean, and resource reference types: " + xmlPullParser.getName() + " at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
                }
                break block7;
            }
            stringArray[0] = "<meta-data> requires an android:value or android:resource attribute";
            bundle = null;
        }
        typedArray.recycle();
        XmlUtils.skipCurrentTag(xmlPullParser);
        return bundle;
    }

    private static PackageLite parseMonolithicPackageLite(File file, int n) throws PackageParserException {
        ApkLite apkLite = PackageParser.parseApkLite(file, n);
        return new PackageLite(file.getAbsolutePath(), apkLite, null, null);
    }

    private boolean parsePackageItemInfo(Package package_, PackageItemInfo packageItemInfo, String[] stringArray, String string2, TypedArray typedArray, int n, int n2, int n3, int n4, int n5) {
        TypedValue typedValue;
        int n6;
        int n7;
        String string3 = typedArray.getNonConfigurationString(n, 0);
        if (string3 == null) {
            stringArray[0] = string2 + " does not specify android:name";
            return false;
        }
        packageItemInfo.name = PackageParser.buildClassName(package_.applicationInfo.packageName, string3, stringArray);
        if (packageItemInfo.name == null) {
            return false;
        }
        int n8 = typedArray.getResourceId(n3, 0);
        if (n8 != 0) {
            packageItemInfo.icon = n8;
            packageItemInfo.nonLocalizedLabel = null;
        }
        if ((n7 = typedArray.getResourceId(n4, 0)) != 0) {
            packageItemInfo.logo = n7;
        }
        if ((n6 = typedArray.getResourceId(n5, 0)) != 0) {
            packageItemInfo.banner = n6;
        }
        if ((typedValue = typedArray.peekValue(n2)) != null) {
            int n9;
            packageItemInfo.labelRes = n9 = typedValue.resourceId;
            if (n9 == 0) {
                packageItemInfo.nonLocalizedLabel = typedValue.coerceToString();
            }
        }
        packageItemInfo.packageName = package_.packageName;
        return true;
    }

    public static PackageLite parsePackageLite(File file, int n) throws PackageParserException {
        if (file.isDirectory()) {
            return PackageParser.parseClusterPackageLite(file, n);
        }
        return PackageParser.parseMonolithicPackageLite(file, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Pair<String, String> parsePackageSplitNames(XmlPullParser xmlPullParser, AttributeSet attributeSet, int n) throws IOException, XmlPullParserException, PackageParserException {
        String string2;
        int n2;
        while ((n2 = xmlPullParser.next()) != 2 && n2 != 1) {
        }
        if (n2 != 2) {
            throw new PackageParserException(-108, "No start tag found");
        }
        if (!xmlPullParser.getName().equals("manifest")) {
            throw new PackageParserException(-108, "No <manifest> tag");
        }
        String string3 = attributeSet.getAttributeValue(null, "package");
        if (!"android".equals(string3) && (string2 = PackageParser.validateName(string3, true)) != null) {
            throw new PackageParserException(-106, "Invalid manifest package: " + string2);
        }
        String string4 = attributeSet.getAttributeValue(null, "split");
        if (string4 != null) {
            if (string4.length() == 0) {
                string4 = null;
            } else {
                String string5 = PackageParser.validateName(string4, false);
                if (string5 != null) {
                    throw new PackageParserException(-106, "Invalid manifest split: " + string5);
                }
            }
        }
        String string6 = string3.intern();
        if (string4 != null) {
            string4 = string4.intern();
        }
        return Pair.create(string6, string4);
    }

    private Permission parsePermission(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, String[] stringArray) throws XmlPullParserException, IOException {
        Permission permission2 = new Permission(package_);
        TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestPermission);
        if (!this.parsePackageItemInfo(package_, permission2.info, stringArray, "<permission>", typedArray, 2, 0, 1, 6, 8)) {
            typedArray.recycle();
            this.mParseError = -108;
            return null;
        }
        permission2.info.group = typedArray.getNonResourceString(4);
        if (permission2.info.group != null) {
            permission2.info.group = permission2.info.group.intern();
        }
        permission2.info.descriptionRes = typedArray.getResourceId(5, 0);
        permission2.info.protectionLevel = typedArray.getInt(3, 0);
        permission2.info.flags = typedArray.getInt(7, 0);
        typedArray.recycle();
        if (permission2.info.protectionLevel == -1) {
            stringArray[0] = "<permission> does not specify protectionLevel";
            this.mParseError = -108;
            return null;
        }
        permission2.info.protectionLevel = PermissionInfo.fixProtectionLevel(permission2.info.protectionLevel);
        if ((0xF0 & permission2.info.protectionLevel) != 0 && (0xF & permission2.info.protectionLevel) != 2) {
            stringArray[0] = "<permission>  protectionLevel specifies a flag but is not based on signature type";
            this.mParseError = -108;
            return null;
        }
        if (!this.parseAllMetaData(resources, xmlPullParser, attributeSet, "<permission>", permission2, stringArray)) {
            this.mParseError = -108;
            return null;
        }
        package_.permissions.add(permission2);
        return permission2;
    }

    private PermissionGroup parsePermissionGroup(Package package_, int n, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, String[] stringArray) throws XmlPullParserException, IOException {
        PermissionGroup permissionGroup = new PermissionGroup(package_);
        TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestPermissionGroup);
        if (!this.parsePackageItemInfo(package_, permissionGroup.info, stringArray, "<permission-group>", typedArray, 2, 0, 1, 5, 7)) {
            typedArray.recycle();
            this.mParseError = -108;
            return null;
        }
        permissionGroup.info.descriptionRes = typedArray.getResourceId(4, 0);
        permissionGroup.info.flags = typedArray.getInt(6, 0);
        permissionGroup.info.priority = typedArray.getInt(3, 0);
        if (permissionGroup.info.priority > 0 && (n & 1) == 0) {
            permissionGroup.info.priority = 0;
        }
        typedArray.recycle();
        if (!this.parseAllMetaData(resources, xmlPullParser, attributeSet, "<permission-group>", permissionGroup, stringArray)) {
            this.mParseError = -108;
            return null;
        }
        package_.permissionGroups.add(permissionGroup);
        return permissionGroup;
    }

    private Permission parsePermissionTree(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, String[] stringArray) throws XmlPullParserException, IOException {
        Permission permission2 = new Permission(package_);
        TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestPermissionTree);
        if (!this.parsePackageItemInfo(package_, permission2.info, stringArray, "<permission-tree>", typedArray, 2, 0, 1, 3, 4)) {
            typedArray.recycle();
            this.mParseError = -108;
            return null;
        }
        typedArray.recycle();
        int n = permission2.info.name.indexOf(46);
        if (n > 0) {
            n = permission2.info.name.indexOf(46, n + 1);
        }
        if (n < 0) {
            stringArray[0] = "<permission-tree> name has less than three segments: " + permission2.info.name;
            this.mParseError = -108;
            return null;
        }
        permission2.info.descriptionRes = 0;
        permission2.info.protectionLevel = 0;
        permission2.tree = true;
        if (!this.parseAllMetaData(resources, xmlPullParser, attributeSet, "<permission-tree>", permission2, stringArray)) {
            this.mParseError = -108;
            return null;
        }
        package_.permissions.add(permission2);
        return permission2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Provider parseProvider(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, String[] stringArray) throws XmlPullParserException, IOException {
        String string2;
        TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestProvider);
        if (this.mParseProviderArgs == null) {
            this.mParseProviderArgs = new ParseComponentArgs(package_, stringArray, 2, 0, 1, 15, 17, this.mSeparateProcesses, 8, 14, 6);
            this.mParseProviderArgs.tag = "<provider>";
        }
        this.mParseProviderArgs.sa = typedArray;
        this.mParseProviderArgs.flags = n;
        Provider provider = new Provider(this.mParseProviderArgs, new ProviderInfo());
        if (stringArray[0] != null) {
            typedArray.recycle();
            return null;
        }
        int n2 = package_.applicationInfo.targetSdkVersion;
        boolean bl = false;
        if (n2 < 17) {
            bl = true;
        }
        provider.info.exported = typedArray.getBoolean(7, bl);
        String string3 = typedArray.getNonConfigurationString(10, 0);
        provider.info.isSyncable = typedArray.getBoolean(11, false);
        String string4 = typedArray.getNonConfigurationString(3, 0);
        String string5 = typedArray.getNonConfigurationString(4, 0);
        if (string5 == null) {
            string5 = string4;
        }
        if (string5 == null) {
            provider.info.readPermission = package_.applicationInfo.permission;
        } else {
            ProviderInfo providerInfo = provider.info;
            String string6 = string5.length() > 0 ? string5.toString().intern() : null;
            providerInfo.readPermission = string6;
        }
        if ((string2 = typedArray.getNonConfigurationString(5, 0)) == null) {
            string2 = string4;
        }
        if (string2 == null) {
            provider.info.writePermission = package_.applicationInfo.permission;
        } else {
            ProviderInfo providerInfo = provider.info;
            String string7 = string2.length() > 0 ? string2.toString().intern() : null;
            providerInfo.writePermission = string7;
        }
        provider.info.grantUriPermissions = typedArray.getBoolean(13, false);
        provider.info.multiprocess = typedArray.getBoolean(9, false);
        provider.info.initOrder = typedArray.getInt(12, 0);
        provider.info.flags = 0;
        if (typedArray.getBoolean(16, false)) {
            ProviderInfo providerInfo = provider.info;
            providerInfo.flags = 0x40000000 | providerInfo.flags;
            if (provider.info.exported && (n & 0x80) == 0) {
                Slog.w(TAG, "Provider exported request ignored due to singleUser: " + provider.className + " at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
                provider.info.exported = false;
            }
        }
        typedArray.recycle();
        if ((0x10000000 & package_.applicationInfo.flags) != 0 && provider.info.processName == package_.packageName) {
            stringArray[0] = "Heavy-weight applications can not have providers in main process";
            return null;
        }
        if (string3 == null) {
            stringArray[0] = "<provider> does not include authorities attribute";
            return null;
        }
        provider.info.authority = string3.intern();
        if (this.parseProviderTags(resources, xmlPullParser, attributeSet, provider, stringArray)) return provider;
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseProviderTags(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Provider provider, String[] stringArray) throws XmlPullParserException, IOException {
        int n;
        int n2 = xmlPullParser.getDepth();
        while ((n = xmlPullParser.next()) != 1 && (n != 3 || xmlPullParser.getDepth() > n2)) {
            if (n == 3 || n == 4) continue;
            if (xmlPullParser.getName().equals("intent-filter")) {
                ProviderIntentInfo providerIntentInfo = new ProviderIntentInfo(provider);
                if (!this.parseIntent(resources, xmlPullParser, attributeSet, true, providerIntentInfo, stringArray)) {
                    return false;
                }
                provider.intents.add(providerIntentInfo);
                continue;
            }
            if (xmlPullParser.getName().equals("meta-data")) {
                Bundle bundle;
                provider.metaData = bundle = this.parseMetaData(resources, xmlPullParser, attributeSet, provider.metaData, stringArray);
                if (bundle != null) continue;
                return false;
            }
            if (xmlPullParser.getName().equals("grant-uri-permission")) {
                String string2;
                String string3;
                TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestGrantUriPermission);
                String string4 = typedArray.getNonConfigurationString(0, 0);
                PatternMatcher patternMatcher = null;
                if (string4 != null) {
                    patternMatcher = new PatternMatcher(string4, 0);
                }
                if ((string3 = typedArray.getNonConfigurationString(1, 0)) != null) {
                    patternMatcher = new PatternMatcher(string3, 1);
                }
                if ((string2 = typedArray.getNonConfigurationString(2, 0)) != null) {
                    patternMatcher = new PatternMatcher(string2, 2);
                }
                typedArray.recycle();
                if (patternMatcher != null) {
                    if (provider.info.uriPermissionPatterns == null) {
                        provider.info.uriPermissionPatterns = new PatternMatcher[1];
                        provider.info.uriPermissionPatterns[0] = patternMatcher;
                    } else {
                        int n3 = provider.info.uriPermissionPatterns.length;
                        PatternMatcher[] patternMatcherArray = new PatternMatcher[n3 + 1];
                        System.arraycopy(provider.info.uriPermissionPatterns, 0, patternMatcherArray, 0, n3);
                        patternMatcherArray[n3] = patternMatcher;
                        provider.info.uriPermissionPatterns = patternMatcherArray;
                    }
                    provider.info.grantUriPermissions = true;
                    XmlUtils.skipCurrentTag(xmlPullParser);
                    continue;
                }
                Slog.w(TAG, "Unknown element under <path-permission>: " + xmlPullParser.getName() + " at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
                XmlUtils.skipCurrentTag(xmlPullParser);
                continue;
            }
            if (xmlPullParser.getName().equals("path-permission")) {
                String string5;
                String string6;
                String string7;
                TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestPathPermission);
                String string8 = typedArray.getNonConfigurationString(0, 0);
                String string9 = typedArray.getNonConfigurationString(1, 0);
                if (string9 == null) {
                    string9 = string8;
                }
                if ((string7 = typedArray.getNonConfigurationString(2, 0)) == null) {
                    string7 = string8;
                }
                boolean bl = false;
                if (string9 != null) {
                    string9 = string9.intern();
                    bl = true;
                }
                if (string7 != null) {
                    string7 = string7.intern();
                    bl = true;
                }
                if (!bl) {
                    Slog.w(TAG, "No readPermission or writePermssion for <path-permission>: " + xmlPullParser.getName() + " at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
                    XmlUtils.skipCurrentTag(xmlPullParser);
                    continue;
                }
                String string10 = typedArray.getNonConfigurationString(3, 0);
                PathPermission pathPermission = null;
                if (string10 != null) {
                    pathPermission = new PathPermission(string10, 0, string9, string7);
                }
                if ((string6 = typedArray.getNonConfigurationString(4, 0)) != null) {
                    pathPermission = new PathPermission(string6, 1, string9, string7);
                }
                if ((string5 = typedArray.getNonConfigurationString(5, 0)) != null) {
                    pathPermission = new PathPermission(string5, 2, string9, string7);
                }
                typedArray.recycle();
                if (pathPermission != null) {
                    if (provider.info.pathPermissions == null) {
                        provider.info.pathPermissions = new PathPermission[1];
                        provider.info.pathPermissions[0] = pathPermission;
                    } else {
                        int n4 = provider.info.pathPermissions.length;
                        PathPermission[] pathPermissionArray = new PathPermission[n4 + 1];
                        System.arraycopy(provider.info.pathPermissions, 0, pathPermissionArray, 0, n4);
                        pathPermissionArray[n4] = pathPermission;
                        provider.info.pathPermissions = pathPermissionArray;
                    }
                    XmlUtils.skipCurrentTag(xmlPullParser);
                    continue;
                }
                Slog.w(TAG, "No path, pathPrefix, or pathPattern for <path-permission>: " + xmlPullParser.getName() + " at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
                XmlUtils.skipCurrentTag(xmlPullParser);
                continue;
            }
            Slog.w(TAG, "Unknown element under <provider>: " + xmlPullParser.getName() + " at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
            XmlUtils.skipCurrentTag(xmlPullParser);
        }
        return true;
    }

    public static final PublicKey parsePublicKey(String string2) {
        X509EncodedKeySpec x509EncodedKeySpec;
        if (string2 == null) {
            Slog.i(TAG, "Could not parse null public key");
            return null;
        }
        try {
            x509EncodedKeySpec = new X509EncodedKeySpec(Base64.decode(string2, 0));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Slog.i(TAG, "Could not parse verifier public key; invalid Base64");
            return null;
        }
        try {
            PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(x509EncodedKeySpec);
            return publicKey;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.wtf(TAG, "Could not parse public key because RSA isn't included in build");
            return null;
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            try {
                PublicKey publicKey = KeyFactory.getInstance("DSA").generatePublic(x509EncodedKeySpec);
                return publicKey;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Log.wtf(TAG, "Could not parse public key because DSA isn't included in build");
                return null;
            }
            catch (InvalidKeySpecException invalidKeySpecException2) {
                return null;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Service parseService(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, String[] stringArray) throws XmlPullParserException, IOException {
        int n2;
        String string2;
        TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestService);
        if (this.mParseServiceArgs == null) {
            this.mParseServiceArgs = new ParseComponentArgs(package_, stringArray, 2, 0, 1, 8, 12, this.mSeparateProcesses, 6, 7, 4);
            this.mParseServiceArgs.tag = "<service>";
        }
        this.mParseServiceArgs.sa = typedArray;
        this.mParseServiceArgs.flags = n;
        Service service = new Service(this.mParseServiceArgs, new ServiceInfo());
        if (stringArray[0] != null) {
            typedArray.recycle();
            return null;
        }
        boolean bl = typedArray.hasValue(5);
        if (bl) {
            service.info.exported = typedArray.getBoolean(5, false);
        }
        if ((string2 = typedArray.getNonConfigurationString(3, 0)) == null) {
            service.info.permission = package_.applicationInfo.permission;
        } else {
            ServiceInfo serviceInfo = service.info;
            String string3 = string2.length() > 0 ? string2.toString().intern() : null;
            serviceInfo.permission = string3;
        }
        service.info.flags = 0;
        if (typedArray.getBoolean(9, false)) {
            ServiceInfo serviceInfo = service.info;
            serviceInfo.flags = 1 | serviceInfo.flags;
        }
        if (typedArray.getBoolean(10, false)) {
            ServiceInfo serviceInfo = service.info;
            serviceInfo.flags = 2 | serviceInfo.flags;
        }
        if (typedArray.getBoolean(11, false)) {
            ServiceInfo serviceInfo = service.info;
            serviceInfo.flags = 0x40000000 | serviceInfo.flags;
            if (service.info.exported && (n & 0x80) == 0) {
                Slog.w(TAG, "Service exported request ignored due to singleUser: " + service.className + " at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
                service.info.exported = false;
                bl = true;
            }
        }
        typedArray.recycle();
        if ((0x10000000 & package_.applicationInfo.flags) != 0 && service.info.processName == package_.packageName) {
            stringArray[0] = "Heavy-weight applications can not have services in main process";
            return null;
        }
        int n3 = xmlPullParser.getDepth();
        while ((n2 = xmlPullParser.next()) != 1 && (n2 != 3 || xmlPullParser.getDepth() > n3)) {
            if (n2 == 3 || n2 == 4) continue;
            if (xmlPullParser.getName().equals("intent-filter")) {
                ServiceIntentInfo serviceIntentInfo = new ServiceIntentInfo(service);
                if (!this.parseIntent(resources, xmlPullParser, attributeSet, true, serviceIntentInfo, stringArray)) {
                    return null;
                }
                service.intents.add(serviceIntentInfo);
                continue;
            }
            if (xmlPullParser.getName().equals("meta-data")) {
                Bundle bundle;
                service.metaData = bundle = this.parseMetaData(resources, xmlPullParser, attributeSet, service.metaData, stringArray);
                if (bundle != null) continue;
                return null;
            }
            Slog.w(TAG, "Unknown element under <service>: " + xmlPullParser.getName() + " at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
            XmlUtils.skipCurrentTag(xmlPullParser);
        }
        if (bl) return service;
        ServiceInfo serviceInfo = service.info;
        boolean bl2 = service.intents.size() > 0;
        serviceInfo.exported = bl2;
        return service;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Package parseSplitApk(Package package_, Resources resources, XmlResourceParser xmlResourceParser, int n, int n2, String[] stringArray) throws XmlPullParserException, IOException, PackageParserException {
        int n3;
        PackageParser.parsePackageSplitNames(xmlResourceParser, xmlResourceParser, n);
        this.mParseInstrumentationArgs = null;
        this.mParseActivityArgs = null;
        this.mParseServiceArgs = null;
        this.mParseProviderArgs = null;
        boolean bl = false;
        int n4 = xmlResourceParser.getDepth();
        while ((n3 = xmlResourceParser.next()) != 1 && (n3 != 3 || xmlResourceParser.getDepth() > n4)) {
            if (n3 == 3 || n3 == 4) continue;
            if (xmlResourceParser.getName().equals("application")) {
                if (bl) {
                    Slog.w(TAG, "<manifest> has more than one <application>");
                    XmlUtils.skipCurrentTag(xmlResourceParser);
                    continue;
                }
                bl = true;
                if (this.parseSplitApplication(package_, resources, xmlResourceParser, xmlResourceParser, n, n2, stringArray)) continue;
                return null;
            }
            Slog.w(TAG, "Unknown element under <manifest>: " + xmlResourceParser.getName() + " at " + this.mArchiveSourcePath + " " + xmlResourceParser.getPositionDescription());
            XmlUtils.skipCurrentTag(xmlResourceParser);
        }
        if (bl) return package_;
        stringArray[0] = "<manifest> does not contain an <application>";
        this.mParseError = -109;
        return package_;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseSplitApk(Package var1_1, int var2_2, AssetManager var3_3, int var4_4) throws PackageParserException {
        block16: {
            var5_5 = var1_1.splitCodePaths[var2_2];
            new File(var5_5);
            this.mParseError = 1;
            this.mArchiveSourcePath = var5_5;
            var7_6 = PackageParser.loadApkIntoAssetManager(var3_3, var5_5, var4_4);
            var8_7 = new Resources(var3_3, this.mMetrics, null);
            var3_3.setConfiguration(0, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, Build.VERSION.RESOURCES_SDK_INT);
            var10_9 = var13_8 = var3_3.openXmlResourceParser(var7_6, "AndroidManifest.xml");
            try {
                var14_10 = new String[1];
                if (this.parseSplitApk(var1_1, var8_7, var10_9, var4_4, var2_2, var14_10) == null) {
                    throw new PackageParserException(this.mParseError, var5_5 + " (at " + var10_9.getPositionDescription() + "): " + var14_10[0]);
                }
                break block16;
            }
            catch (PackageParserException var9_11) {}
            ** GOTO lbl-1000
        }
        IoUtils.closeQuietly((AutoCloseable)var10_9);
        return;
        catch (Exception var12_20) {
            block17: {
                var10_9 = null;
                break block17;
                catch (Throwable var11_17) {
                    var10_9 = null;
                    ** GOTO lbl-1000
                }
                catch (Throwable var11_18) {
                    var10_9 = null;
                    ** GOTO lbl-1000
                }
                catch (Throwable var11_19) {
                    ** GOTO lbl-1000
                }
                catch (Exception var12_22) {
                    var10_9 = null;
                    break block17;
                }
                catch (Exception var12_23) {}
            }
            throw new PackageParserException(-102, "Failed to read manifest from " + var5_5, (Throwable)var12_21);
            {
                catch (Throwable var11_15) lbl-1000:
                // 4 sources

                {
                    IoUtils.closeQuietly(var10_9);
                    throw var11_16;
                }
            }
            catch (PackageParserException var9_13) {
                var10_9 = null;
                ** GOTO lbl-1000
            }
            catch (PackageParserException var9_14) {
                var10_9 = null;
            }
lbl-1000:
            // 3 sources

            {
                throw var9_12;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseSplitApplication(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, int n2, String[] stringArray) throws XmlPullParserException, IOException {
        int n3;
        if (resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestApplication).getBoolean(7, true)) {
            int[] nArray = package_.splitFlags;
            nArray[n2] = 4 | nArray[n2];
        }
        int n4 = xmlPullParser.getDepth();
        while ((n3 = xmlPullParser.next()) != 1 && (n3 != 3 || xmlPullParser.getDepth() > n4)) {
            if (n3 == 3 || n3 == 4) continue;
            String string2 = xmlPullParser.getName();
            if (string2.equals("activity")) {
                Activity activity = this.parseActivity(package_, resources, xmlPullParser, attributeSet, n, stringArray, false, package_.baseHardwareAccelerated);
                if (activity == null) {
                    this.mParseError = -108;
                    return false;
                }
                package_.activities.add(activity);
                continue;
            }
            if (string2.equals("receiver")) {
                Activity activity = this.parseActivity(package_, resources, xmlPullParser, attributeSet, n, stringArray, true, false);
                if (activity == null) {
                    this.mParseError = -108;
                    return false;
                }
                package_.receivers.add(activity);
                continue;
            }
            if (string2.equals("service")) {
                Service service = this.parseService(package_, resources, xmlPullParser, attributeSet, n, stringArray);
                if (service == null) {
                    this.mParseError = -108;
                    return false;
                }
                package_.services.add(service);
                continue;
            }
            if (string2.equals("provider")) {
                Provider provider = this.parseProvider(package_, resources, xmlPullParser, attributeSet, n, stringArray);
                if (provider == null) {
                    this.mParseError = -108;
                    return false;
                }
                package_.providers.add(provider);
                continue;
            }
            if (string2.equals("activity-alias")) {
                Activity activity = this.parseActivityAlias(package_, resources, xmlPullParser, attributeSet, n, stringArray);
                if (activity == null) {
                    this.mParseError = -108;
                    return false;
                }
                package_.activities.add(activity);
                continue;
            }
            if (xmlPullParser.getName().equals("meta-data")) {
                Bundle bundle;
                package_.mAppMetaData = bundle = this.parseMetaData(resources, xmlPullParser, attributeSet, package_.mAppMetaData, stringArray);
                if (bundle != null) continue;
                this.mParseError = -108;
                return false;
            }
            if (string2.equals("uses-library")) {
                TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestUsesLibrary);
                String string3 = typedArray.getNonResourceString(0);
                boolean bl = typedArray.getBoolean(1, true);
                typedArray.recycle();
                if (string3 != null) {
                    String string4 = string3.intern();
                    if (bl) {
                        package_.usesLibraries = ArrayUtils.add(package_.usesLibraries, string4);
                        package_.usesOptionalLibraries = ArrayUtils.remove(package_.usesOptionalLibraries, string4);
                    } else if (!ArrayUtils.contains(package_.usesLibraries, string4)) {
                        package_.usesOptionalLibraries = ArrayUtils.add(package_.usesOptionalLibraries, string4);
                    }
                }
                XmlUtils.skipCurrentTag(xmlPullParser);
                continue;
            }
            if (string2.equals("uses-package")) {
                XmlUtils.skipCurrentTag(xmlPullParser);
                continue;
            }
            Slog.w(TAG, "Unknown element under <application>: " + string2 + " at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
            XmlUtils.skipCurrentTag(xmlPullParser);
        }
        return true;
    }

    private FeatureInfo parseUsesFeature(Resources resources, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        FeatureInfo featureInfo = new FeatureInfo();
        TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestUsesFeature);
        featureInfo.name = typedArray.getNonResourceString(0);
        if (featureInfo.name == null) {
            featureInfo.reqGlEsVersion = typedArray.getInt(1, 0);
        }
        if (typedArray.getBoolean(2, true)) {
            featureInfo.flags = 1 | featureInfo.flags;
        }
        typedArray.recycle();
        return featureInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseUsesPermission(Package package_, Resources resources, XmlResourceParser xmlResourceParser, AttributeSet attributeSet, String[] stringArray) throws XmlPullParserException, IOException {
        TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestUsesPermission);
        String string2 = typedArray.getNonResourceString(0);
        TypedValue typedValue = typedArray.peekValue(1);
        int n = 0;
        if (typedValue != null) {
            int n2 = typedValue.type;
            n = 0;
            if (n2 >= 16) {
                int n3 = typedValue.type;
                n = 0;
                if (n3 <= 31) {
                    n = typedValue.data;
                }
            }
        }
        typedArray.recycle();
        if ((n == 0 || n >= Build.VERSION.RESOURCES_SDK_INT) && string2 != null) {
            int n4 = package_.requestedPermissions.indexOf(string2);
            if (n4 == -1) {
                package_.requestedPermissions.add(string2.intern());
                ArrayList<Boolean> arrayList = package_.requestedPermissionsRequired;
                Boolean bl = Boolean.TRUE;
                arrayList.add(bl);
            } else if (!package_.requestedPermissionsRequired.get(n4).booleanValue()) {
                stringArray[0] = "conflicting <uses-permission> entries";
                this.mParseError = -108;
                return false;
            }
        }
        XmlUtils.skipCurrentTag(xmlResourceParser);
        return true;
    }

    private static VerifierInfo parseVerifier(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, int n) {
        TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestPackageVerifier);
        String string2 = typedArray.getNonResourceString(0);
        String string3 = typedArray.getNonResourceString(1);
        typedArray.recycle();
        if (string2 == null || string2.length() == 0) {
            Slog.i(TAG, "verifier package name was null; skipping");
            return null;
        }
        PublicKey publicKey = PackageParser.parsePublicKey(string3);
        if (publicKey == null) {
            Slog.i(TAG, "Unable to parse verifier public key for " + string2);
            return null;
        }
        return new VerifierInfo(string2, publicKey);
    }

    public static long readFullyIgnoringContents(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = sBuffer.getAndSet(null);
        if (byArray == null) {
            byArray = new byte[4096];
        }
        int n2 = 0;
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            n2 += n;
        }
        sBuffer.set(byArray);
        return n2;
    }

    public static void setCompatibilityModeEnabled(boolean bl) {
        sCompatibilityModeEnabled = bl;
    }

    public static Signature stringToSignature(String string2) {
        int n = string2.length();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)string2.charAt(i);
        }
        return new Signature(byArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void updateApplicationInfo(ApplicationInfo applicationInfo, int n, PackageUserState packageUserState) {
        int n2 = 1;
        if (!sCompatibilityModeEnabled) {
            applicationInfo.disableCompatibilityMode();
        }
        applicationInfo.flags = packageUserState.installed ? 0x800000 | applicationInfo.flags : 0xFF7FFFFF & applicationInfo.flags;
        applicationInfo.flags = packageUserState.hidden ? 0x8000000 | applicationInfo.flags : 0xF7FFFFFF & applicationInfo.flags;
        if (packageUserState.enabled == n2) {
            applicationInfo.enabled = n2;
        } else if (packageUserState.enabled == 4) {
            if ((0x8000 & n) == 0) {
                n2 = 0;
            }
            applicationInfo.enabled = n2;
        } else if (packageUserState.enabled == 2 || packageUserState.enabled == 3) {
            applicationInfo.enabled = false;
        }
        applicationInfo.enabledSetting = packageUserState.enabled;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String validateName(String string2, boolean bl) {
        int n = string2.length();
        boolean bl2 = false;
        boolean bl3 = true;
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                bl3 = false;
                continue;
            }
            if (!bl3 && (c >= '0' && c <= '9' || c == '_')) continue;
            if (c != '.') {
                return "bad character '" + c + "'";
            }
            bl2 = true;
            bl3 = true;
        }
        if (!bl2 && bl) {
            return "must have at least one '.' separator";
        }
        return null;
    }

    public void collectCertificates(Package package_, int n) throws PackageParserException {
        package_.mCertificates = null;
        package_.mSignatures = null;
        package_.mSigningKeys = null;
        PackageParser.collectCertificates(package_, new File(package_.baseCodePath), n);
        if (!ArrayUtils.isEmpty(package_.splitCodePaths)) {
            String[] stringArray = package_.splitCodePaths;
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                PackageParser.collectCertificates(package_, new File(stringArray[i]), n);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void collectManifestDigest(Package package_) throws PackageParserException {
        StrictJarFile strictJarFile;
        block9: {
            ZipEntry zipEntry;
            package_.manifestDigest = null;
            strictJarFile = new StrictJarFile(package_.baseCodePath);
            try {
                zipEntry = strictJarFile.findEntry(ANDROID_MANIFEST_FILENAME);
                if (zipEntry == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    strictJarFile.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new PackageParserException(-108, "Failed to collect manifest digest");
                }
                catch (RuntimeException runtimeException) {
                    throw new PackageParserException(-108, "Failed to collect manifest digest");
                }
            }
            package_.manifestDigest = ManifestDigest.fromInputStream(strictJarFile.getInputStream(zipEntry));
        }
        strictJarFile.close();
    }

    @Deprecated
    public Package parseMonolithicPackage(File file, int n) throws PackageParserException {
        if (this.mOnlyCoreApps && !PackageParser.parseMonolithicPackageLite((File)file, (int)n).coreApp) {
            throw new PackageParserException(-108, "Not a coreApp: " + file);
        }
        AssetManager assetManager = new AssetManager();
        try {
            Package package_ = this.parseBaseApk(file, assetManager, n);
            package_.codePath = file.getAbsolutePath();
            return package_;
        }
        finally {
            IoUtils.closeQuietly((AutoCloseable)assetManager);
        }
    }

    public Package parsePackage(File file, int n) throws PackageParserException {
        if (file.isDirectory()) {
            return this.parseClusterPackage(file, n);
        }
        return this.parseMonolithicPackage(file, n);
    }

    public void setDisplayMetrics(DisplayMetrics displayMetrics) {
        this.mMetrics = displayMetrics;
    }

    public void setOnlyCoreApps(boolean bl) {
        this.mOnlyCoreApps = bl;
    }

    public void setSeparateProcesses(String[] stringArray) {
        this.mSeparateProcesses = stringArray;
    }

    public static final class Activity
    extends Component<ActivityIntentInfo> {
        public final ActivityInfo info;

        public Activity(ParseComponentArgs parseComponentArgs, ActivityInfo activityInfo) {
            super(parseComponentArgs, activityInfo);
            this.info = activityInfo;
            this.info.applicationInfo = parseComponentArgs.owner.applicationInfo;
        }

        @Override
        public void setPackageName(String string2) {
            super.setPackageName(string2);
            this.info.packageName = string2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("Activity{");
            stringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
            stringBuilder.append(' ');
            this.appendComponentShortName(stringBuilder);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    public static final class ActivityIntentInfo
    extends IntentInfo {
        public final Activity activity;

        public ActivityIntentInfo(Activity activity) {
            this.activity = activity;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("ActivityIntentInfo{");
            stringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
            stringBuilder.append(' ');
            this.activity.appendComponentShortName(stringBuilder);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    public static class ApkLite {
        public final String codePath;
        public final boolean coreApp;
        public final int installLocation;
        public final boolean multiArch;
        public final String packageName;
        public final Signature[] signatures;
        public final String splitName;
        public final VerifierInfo[] verifiers;
        public final int versionCode;

        public ApkLite(String string2, String string3, String string4, int n, int n2, List<VerifierInfo> list, Signature[] signatureArray, boolean bl, boolean bl2) {
            this.codePath = string2;
            this.packageName = string3;
            this.splitName = string4;
            this.versionCode = n;
            this.installLocation = n2;
            this.verifiers = list.toArray(new VerifierInfo[list.size()]);
            this.signatures = signatureArray;
            this.coreApp = bl;
            this.multiArch = bl2;
        }
    }

    public static class Component<II extends IntentInfo> {
        public final String className;
        ComponentName componentName;
        String componentShortName;
        public final ArrayList<II> intents;
        public Bundle metaData;
        public final Package owner;

        public Component(Component<II> component) {
            this.owner = component.owner;
            this.intents = component.intents;
            this.className = component.className;
            this.componentName = component.componentName;
            this.componentShortName = component.componentShortName;
        }

        public Component(Package package_) {
            this.owner = package_;
            this.intents = null;
            this.className = null;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Component(ParseComponentArgs parseComponentArgs, ComponentInfo componentInfo) {
            this((ParsePackageItemArgs)parseComponentArgs, (PackageItemInfo)componentInfo);
            if (parseComponentArgs.outError[0] != null) {
                return;
            }
            if (parseComponentArgs.processRes != 0) {
                String string2 = this.owner.applicationInfo.targetSdkVersion >= 8 ? parseComponentArgs.sa.getNonConfigurationString(parseComponentArgs.processRes, 1024) : parseComponentArgs.sa.getNonResourceString(parseComponentArgs.processRes);
                componentInfo.processName = PackageParser.buildProcessName(this.owner.applicationInfo.packageName, this.owner.applicationInfo.processName, string2, parseComponentArgs.flags, parseComponentArgs.sepProcesses, parseComponentArgs.outError);
            }
            if (parseComponentArgs.descriptionRes != 0) {
                componentInfo.descriptionRes = parseComponentArgs.sa.getResourceId(parseComponentArgs.descriptionRes, 0);
            }
            componentInfo.enabled = parseComponentArgs.sa.getBoolean(parseComponentArgs.enabledRes, true);
        }

        public Component(ParsePackageItemArgs parsePackageItemArgs, PackageItemInfo packageItemInfo) {
            TypedValue typedValue;
            int n;
            int n2;
            this.owner = parsePackageItemArgs.owner;
            this.intents = new ArrayList(0);
            String string2 = parsePackageItemArgs.sa.getNonConfigurationString(parsePackageItemArgs.nameRes, 0);
            if (string2 == null) {
                this.className = null;
                parsePackageItemArgs.outError[0] = parsePackageItemArgs.tag + " does not specify android:name";
                return;
            }
            packageItemInfo.name = PackageParser.buildClassName(this.owner.applicationInfo.packageName, string2, parsePackageItemArgs.outError);
            if (packageItemInfo.name == null) {
                this.className = null;
                parsePackageItemArgs.outError[0] = parsePackageItemArgs.tag + " does not have valid android:name";
                return;
            }
            this.className = packageItemInfo.name;
            int n3 = parsePackageItemArgs.sa.getResourceId(parsePackageItemArgs.iconRes, 0);
            if (n3 != 0) {
                packageItemInfo.icon = n3;
                packageItemInfo.nonLocalizedLabel = null;
            }
            if ((n2 = parsePackageItemArgs.sa.getResourceId(parsePackageItemArgs.logoRes, 0)) != 0) {
                packageItemInfo.logo = n2;
            }
            if ((n = parsePackageItemArgs.sa.getResourceId(parsePackageItemArgs.bannerRes, 0)) != 0) {
                packageItemInfo.banner = n;
            }
            if ((typedValue = parsePackageItemArgs.sa.peekValue(parsePackageItemArgs.labelRes)) != null) {
                int n4;
                packageItemInfo.labelRes = n4 = typedValue.resourceId;
                if (n4 == 0) {
                    packageItemInfo.nonLocalizedLabel = typedValue.coerceToString();
                }
            }
            packageItemInfo.packageName = this.owner.packageName;
        }

        public void appendComponentShortName(StringBuilder stringBuilder) {
            ComponentName.appendShortString(stringBuilder, this.owner.applicationInfo.packageName, this.className);
        }

        public ComponentName getComponentName() {
            if (this.componentName != null) {
                return this.componentName;
            }
            if (this.className != null) {
                this.componentName = new ComponentName(this.owner.applicationInfo.packageName, this.className);
            }
            return this.componentName;
        }

        public void printComponentShortName(PrintWriter printWriter) {
            ComponentName.printShortString(printWriter, this.owner.applicationInfo.packageName, this.className);
        }

        public void setPackageName(String string2) {
            this.componentName = null;
            this.componentShortName = null;
        }
    }

    public static final class Instrumentation
    extends Component {
        public final InstrumentationInfo info;

        public Instrumentation(ParsePackageItemArgs parsePackageItemArgs, InstrumentationInfo instrumentationInfo) {
            super(parsePackageItemArgs, instrumentationInfo);
            this.info = instrumentationInfo;
        }

        @Override
        public void setPackageName(String string2) {
            super.setPackageName(string2);
            this.info.packageName = string2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("Instrumentation{");
            stringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
            stringBuilder.append(' ');
            this.appendComponentShortName(stringBuilder);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    public static class IntentInfo
    extends IntentFilter {
        public int banner;
        public boolean hasDefault;
        public int icon;
        public int labelRes;
        public int logo;
        public CharSequence nonLocalizedLabel;
        public int preferred;
    }

    public static class LRTComparator
    implements Comparator<Package> {
        @Override
        public int compare(Package package_, Package package_2) {
            if (package_.mLastPackageUsageTimeInMills < package_2.mLastPackageUsageTimeInMills) {
                return -1;
            }
            if (package_.mLastPackageUsageTimeInMills > package_2.mLastPackageUsageTimeInMills) {
                return 1;
            }
            return 0;
        }
    }

    public static class NewPermissionInfo {
        public final int fileVersion;
        public final String name;
        public final int sdkVersion;

        public NewPermissionInfo(String string2, int n, int n2) {
            this.name = string2;
            this.sdkVersion = n;
            this.fileVersion = n2;
        }
    }

    public static final class Package {
        public static final String ASUS_BASETHEME_VIRTUAL_PACKAGE = "com.asus.all.unbundle.apps";
        public final ArrayList<Activity> activities;
        public final ApplicationInfo applicationInfo = new ApplicationInfo();
        public String baseCodePath;
        public boolean baseHardwareAccelerated;
        public String codePath;
        public ArrayList<ConfigurationInfo> configPreferences = null;
        public boolean coreApp;
        public String cpuAbiOverride;
        public ArrayList<FeatureGroupInfo> featureGroups = null;
        public int installLocation;
        public final ArrayList<Instrumentation> instrumentation;
        public ArrayList<String> libraryNames = null;
        public ArrayList<String> mAdoptPermissions = null;
        public boolean mAllowBaseThemeOverlay;
        public Bundle mAppMetaData = null;
        public Certificate[][] mCertificates;
        public String mDexOptFlag;
        public final ArraySet<String> mDexOptPerformed;
        public long mDexOptTime;
        public Object mExtras;
        public boolean mIsBaseThemeOverlay;
        public boolean mIsThemePack = false;
        public ArrayMap<String, ArraySet<PublicKey>> mKeySetMapping;
        public long mLastPackageUsageTimeInMills;
        public boolean mOperationPending;
        public ArrayList<String> mOriginalPackages = null;
        public int mOverlayPriority;
        public String mOverlayTarget;
        public int mPreferredOrder = 0;
        public String mRealPackage = null;
        public String mRequiredAccountType;
        public boolean mRequiredForAllUsers;
        public String mRestrictedAccountType;
        public String mSharedUserId;
        public int mSharedUserLabel;
        public Signature[] mSignatures;
        public ArraySet<PublicKey> mSigningKeys;
        public ThemePack mThemePack = null;
        public boolean mTrustedOverlay;
        public ArraySet<String> mUpgradeKeySets;
        public int mVersionCode;
        public String mVersionName;
        public ManifestDigest manifestDigest;
        public String packageName;
        public final ArrayList<PermissionGroup> permissionGroups;
        public final ArrayList<Permission> permissions = new ArrayList(0);
        public ArrayList<ActivityIntentInfo> preferredActivityFilters = null;
        public ArrayList<String> protectedBroadcasts;
        public final ArrayList<Provider> providers;
        public final ArrayList<Activity> receivers;
        public ArrayList<FeatureInfo> reqFeatures = null;
        public final ArrayList<String> requestedPermissions;
        public final ArrayList<Boolean> requestedPermissionsRequired;
        public final ArrayList<Service> services;
        public String[] splitCodePaths;
        public int[] splitFlags;
        public String[] splitNames;
        public ArrayList<String> usesLibraries = null;
        public String[] usesLibraryFiles = null;
        public ArrayList<String> usesOptionalLibraries = null;

        public Package(String string2) {
            this.permissionGroups = new ArrayList(0);
            this.activities = new ArrayList(0);
            this.receivers = new ArrayList(0);
            this.providers = new ArrayList(0);
            this.services = new ArrayList(0);
            this.instrumentation = new ArrayList(0);
            this.requestedPermissions = new ArrayList();
            this.requestedPermissionsRequired = new ArrayList();
            this.mDexOptPerformed = new ArraySet(4);
            this.packageName = string2;
            this.applicationInfo.packageName = string2;
            this.applicationInfo.uid = -1;
        }

        public List<String> getAllCodePaths() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.baseCodePath);
            if (!ArrayUtils.isEmpty(this.splitCodePaths)) {
                Collections.addAll(arrayList, this.splitCodePaths);
            }
            return arrayList;
        }

        public List<String> getAllCodePathsExcludingResourceOnly() {
            ArrayList<String> arrayList = new ArrayList<String>();
            if ((4 & this.applicationInfo.flags) != 0) {
                arrayList.add(this.baseCodePath);
            }
            if (!ArrayUtils.isEmpty(this.splitCodePaths)) {
                for (int i = 0; i < this.splitCodePaths.length; ++i) {
                    if ((4 & this.splitFlags[i]) == 0) continue;
                    arrayList.add(this.splitCodePaths[i]);
                }
            }
            return arrayList;
        }

        public boolean hasComponentClassName(String string2) {
            for (int i = -1 + this.activities.size(); i >= 0; --i) {
                if (!string2.equals(this.activities.get((int)i).className)) continue;
                return true;
            }
            for (int i = -1 + this.receivers.size(); i >= 0; --i) {
                if (!string2.equals(this.receivers.get((int)i).className)) continue;
                return true;
            }
            for (int i = -1 + this.providers.size(); i >= 0; --i) {
                if (!string2.equals(this.providers.get((int)i).className)) continue;
                return true;
            }
            for (int i = -1 + this.services.size(); i >= 0; --i) {
                if (!string2.equals(this.services.get((int)i).className)) continue;
                return true;
            }
            for (int i = -1 + this.instrumentation.size(); i >= 0; --i) {
                if (!string2.equals(this.instrumentation.get((int)i).className)) continue;
                return true;
            }
            return false;
        }

        public void setPackageName(String string2) {
            this.packageName = string2;
            this.applicationInfo.packageName = string2;
            for (int i = -1 + this.permissions.size(); i >= 0; --i) {
                this.permissions.get(i).setPackageName(string2);
            }
            for (int i = -1 + this.permissionGroups.size(); i >= 0; --i) {
                this.permissionGroups.get(i).setPackageName(string2);
            }
            for (int i = -1 + this.activities.size(); i >= 0; --i) {
                this.activities.get(i).setPackageName(string2);
            }
            for (int i = -1 + this.receivers.size(); i >= 0; --i) {
                this.receivers.get(i).setPackageName(string2);
            }
            for (int i = -1 + this.providers.size(); i >= 0; --i) {
                this.providers.get(i).setPackageName(string2);
            }
            for (int i = -1 + this.services.size(); i >= 0; --i) {
                this.services.get(i).setPackageName(string2);
            }
            for (int i = -1 + this.instrumentation.size(); i >= 0; --i) {
                this.instrumentation.get(i).setPackageName(string2);
            }
        }

        public String toString() {
            return "Package{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.packageName + "}";
        }
    }

    public static class PackageLite {
        public final String baseCodePath;
        public final String codePath;
        public final boolean coreApp;
        public final int installLocation;
        public final boolean multiArch;
        public final String packageName;
        public final String[] splitCodePaths;
        public final String[] splitNames;
        public final VerifierInfo[] verifiers;
        public final int versionCode;

        public PackageLite(String string2, ApkLite apkLite, String[] stringArray, String[] stringArray2) {
            this.packageName = apkLite.packageName;
            this.versionCode = apkLite.versionCode;
            this.installLocation = apkLite.installLocation;
            this.verifiers = apkLite.verifiers;
            this.splitNames = stringArray;
            this.codePath = string2;
            this.baseCodePath = apkLite.codePath;
            this.splitCodePaths = stringArray2;
            this.coreApp = apkLite.coreApp;
            this.multiArch = apkLite.multiArch;
        }

        public List<String> getAllCodePaths() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.baseCodePath);
            if (!ArrayUtils.isEmpty(this.splitCodePaths)) {
                Collections.addAll(arrayList, this.splitCodePaths);
            }
            return arrayList;
        }
    }

    public static class PackageParserException
    extends Exception {
        public final int error;

        public PackageParserException(int n, String string2) {
            super(string2);
            this.error = n;
        }

        public PackageParserException(int n, String string2, Throwable throwable) {
            super(string2, throwable);
            this.error = n;
        }
    }

    static class ParseComponentArgs
    extends ParsePackageItemArgs {
        final int descriptionRes;
        final int enabledRes;
        int flags;
        final int processRes;
        final String[] sepProcesses;

        ParseComponentArgs(Package package_, String[] stringArray, int n, int n2, int n3, int n4, int n5, String[] stringArray2, int n6, int n7, int n8) {
            super(package_, stringArray, n, n2, n3, n4, n5);
            this.sepProcesses = stringArray2;
            this.processRes = n6;
            this.descriptionRes = n7;
            this.enabledRes = n8;
        }
    }

    static class ParsePackageItemArgs {
        final int bannerRes;
        final int iconRes;
        final int labelRes;
        final int logoRes;
        final int nameRes;
        final String[] outError;
        final Package owner;
        TypedArray sa;
        String tag;

        ParsePackageItemArgs(Package package_, String[] stringArray, int n, int n2, int n3, int n4, int n5) {
            this.owner = package_;
            this.outError = stringArray;
            this.nameRes = n;
            this.labelRes = n2;
            this.iconRes = n3;
            this.logoRes = n4;
            this.bannerRes = n5;
        }
    }

    public static final class Permission
    extends Component<IntentInfo> {
        public PermissionGroup group;
        public final PermissionInfo info;
        public boolean tree;

        public Permission(Package package_) {
            super(package_);
            this.info = new PermissionInfo();
        }

        public Permission(Package package_, PermissionInfo permissionInfo) {
            super(package_);
            this.info = permissionInfo;
        }

        @Override
        public void setPackageName(String string2) {
            super.setPackageName(string2);
            this.info.packageName = string2;
        }

        public String toString() {
            return "Permission{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.info.name + "}";
        }
    }

    public static final class PermissionGroup
    extends Component<IntentInfo> {
        public final PermissionGroupInfo info;

        public PermissionGroup(Package package_) {
            super(package_);
            this.info = new PermissionGroupInfo();
        }

        public PermissionGroup(Package package_, PermissionGroupInfo permissionGroupInfo) {
            super(package_);
            this.info = permissionGroupInfo;
        }

        @Override
        public void setPackageName(String string2) {
            super.setPackageName(string2);
            this.info.packageName = string2;
        }

        public String toString() {
            return "PermissionGroup{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.info.name + "}";
        }
    }

    public static final class Provider
    extends Component<ProviderIntentInfo> {
        public final ProviderInfo info;
        public boolean syncable;

        public Provider(ParseComponentArgs parseComponentArgs, ProviderInfo providerInfo) {
            super(parseComponentArgs, providerInfo);
            this.info = providerInfo;
            this.info.applicationInfo = parseComponentArgs.owner.applicationInfo;
            this.syncable = false;
        }

        public Provider(Provider provider) {
            super(provider);
            this.info = provider.info;
            this.syncable = provider.syncable;
        }

        @Override
        public void setPackageName(String string2) {
            super.setPackageName(string2);
            this.info.packageName = string2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("Provider{");
            stringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
            stringBuilder.append(' ');
            this.appendComponentShortName(stringBuilder);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    public static final class ProviderIntentInfo
    extends IntentInfo {
        public final Provider provider;

        public ProviderIntentInfo(Provider provider) {
            this.provider = provider;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("ProviderIntentInfo{");
            stringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
            stringBuilder.append(' ');
            this.provider.appendComponentShortName(stringBuilder);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    public static final class Service
    extends Component<ServiceIntentInfo> {
        public final ServiceInfo info;

        public Service(ParseComponentArgs parseComponentArgs, ServiceInfo serviceInfo) {
            super(parseComponentArgs, serviceInfo);
            this.info = serviceInfo;
            this.info.applicationInfo = parseComponentArgs.owner.applicationInfo;
        }

        @Override
        public void setPackageName(String string2) {
            super.setPackageName(string2);
            this.info.packageName = string2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("Service{");
            stringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
            stringBuilder.append(' ');
            this.appendComponentShortName(stringBuilder);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    public static final class ServiceIntentInfo
    extends IntentInfo {
        public final Service service;

        public ServiceIntentInfo(Service service) {
            this.service = service;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("ServiceIntentInfo{");
            stringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
            stringBuilder.append(' ');
            this.service.appendComponentShortName(stringBuilder);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    private static class SplitNameComparator
    implements Comparator<String> {
        private SplitNameComparator() {
        }

        @Override
        public int compare(String string2, String string3) {
            if (string2 == null) {
                return -1;
            }
            if (string3 == null) {
                return 1;
            }
            return string2.compareTo(string3);
        }
    }

    public static class SplitPermissionInfo {
        public final String[] newPerms;
        public final String rootPerm;
        public final int targetSdk;

        public SplitPermissionInfo(String string2, String[] stringArray, int n) {
            this.rootPerm = string2;
            this.newPerms = stringArray;
            this.targetSdk = n;
        }
    }
}

