/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.ThemePack;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public final class Configuration
implements Parcelable,
Comparable<Configuration> {
    public static final Parcelable.Creator<Configuration> CREATOR;
    private static final boolean DEBUG = false;
    public static final int DENSITY_DPI_ANY = 65534;
    public static final int DENSITY_DPI_NONE = 65535;
    public static final int DENSITY_DPI_UNDEFINED = 0;
    public static final Configuration EMPTY;
    public static final int HARDKEYBOARDHIDDEN_NO = 1;
    public static final int HARDKEYBOARDHIDDEN_UNDEFINED = 0;
    public static final int HARDKEYBOARDHIDDEN_YES = 2;
    public static final int KEYBOARDHIDDEN_NO = 1;
    public static final int KEYBOARDHIDDEN_SOFT = 3;
    public static final int KEYBOARDHIDDEN_UNDEFINED = 0;
    public static final int KEYBOARDHIDDEN_YES = 2;
    public static final int KEYBOARD_12KEY = 3;
    public static final int KEYBOARD_NOKEYS = 1;
    public static final int KEYBOARD_QWERTY = 2;
    public static final int KEYBOARD_UNDEFINED = 0;
    public static final int MNC_ZERO = 65535;
    private static final String MonoTAG = "Monotype";
    public static final int NATIVE_CONFIG_DENSITY = 256;
    public static final int NATIVE_CONFIG_FLIPFONT = 32768;
    public static final int NATIVE_CONFIG_KEYBOARD = 16;
    public static final int NATIVE_CONFIG_KEYBOARD_HIDDEN = 32;
    public static final int NATIVE_CONFIG_LAYOUTDIR = 16384;
    public static final int NATIVE_CONFIG_LOCALE = 4;
    public static final int NATIVE_CONFIG_MCC = 1;
    public static final int NATIVE_CONFIG_MNC = 2;
    public static final int NATIVE_CONFIG_NAVIGATION = 64;
    public static final int NATIVE_CONFIG_ORIENTATION = 128;
    public static final int NATIVE_CONFIG_SCREEN_LAYOUT = 2048;
    public static final int NATIVE_CONFIG_SCREEN_SIZE = 512;
    public static final int NATIVE_CONFIG_SMALLEST_SCREEN_SIZE = 8192;
    public static final int NATIVE_CONFIG_TOUCHSCREEN = 8;
    public static final int NATIVE_CONFIG_UI_MODE = 4096;
    public static final int NATIVE_CONFIG_VERSION = 1024;
    public static final int NAVIGATIONHIDDEN_NO = 1;
    public static final int NAVIGATIONHIDDEN_UNDEFINED = 0;
    public static final int NAVIGATIONHIDDEN_YES = 2;
    public static final int NAVIGATION_DPAD = 2;
    public static final int NAVIGATION_NONAV = 1;
    public static final int NAVIGATION_TRACKBALL = 3;
    public static final int NAVIGATION_UNDEFINED = 0;
    public static final int NAVIGATION_WHEEL = 4;
    public static final int ORIENTATION_LANDSCAPE = 2;
    public static final int ORIENTATION_PORTRAIT = 1;
    @Deprecated
    public static final int ORIENTATION_SQUARE = 3;
    public static final int ORIENTATION_UNDEFINED = 0;
    public static final int SCREENLAYOUT_COMPAT_NEEDED = 0x10000000;
    public static final int SCREENLAYOUT_LAYOUTDIR_LTR = 64;
    public static final int SCREENLAYOUT_LAYOUTDIR_MASK = 192;
    public static final int SCREENLAYOUT_LAYOUTDIR_RTL = 128;
    public static final int SCREENLAYOUT_LAYOUTDIR_SHIFT = 6;
    public static final int SCREENLAYOUT_LAYOUTDIR_UNDEFINED = 0;
    public static final int SCREENLAYOUT_LONG_MASK = 48;
    public static final int SCREENLAYOUT_LONG_NO = 16;
    public static final int SCREENLAYOUT_LONG_UNDEFINED = 0;
    public static final int SCREENLAYOUT_LONG_YES = 32;
    public static final int SCREENLAYOUT_SIZE_LARGE = 3;
    public static final int SCREENLAYOUT_SIZE_MASK = 15;
    public static final int SCREENLAYOUT_SIZE_NORMAL = 2;
    public static final int SCREENLAYOUT_SIZE_SMALL = 1;
    public static final int SCREENLAYOUT_SIZE_UNDEFINED = 0;
    public static final int SCREENLAYOUT_SIZE_XLARGE = 4;
    public static final int SCREENLAYOUT_UNDEFINED = 0;
    public static final int SCREEN_HEIGHT_DP_UNDEFINED = 0;
    public static final int SCREEN_WIDTH_DP_UNDEFINED = 0;
    public static final int SMALLEST_SCREEN_WIDTH_DP_UNDEFINED = 0;
    public static final int TOUCHSCREEN_FINGER = 3;
    public static final int TOUCHSCREEN_NOTOUCH = 1;
    @Deprecated
    public static final int TOUCHSCREEN_STYLUS = 2;
    public static final int TOUCHSCREEN_UNDEFINED = 0;
    public static final int UI_MODE_NIGHT_MASK = 48;
    public static final int UI_MODE_NIGHT_NO = 16;
    public static final int UI_MODE_NIGHT_UNDEFINED = 0;
    public static final int UI_MODE_NIGHT_YES = 32;
    public static final int UI_MODE_TYPE_APPLIANCE = 5;
    public static final int UI_MODE_TYPE_CAR = 3;
    public static final int UI_MODE_TYPE_DESK = 2;
    public static final int UI_MODE_TYPE_MASK = 15;
    public static final int UI_MODE_TYPE_NORMAL = 1;
    public static final int UI_MODE_TYPE_TELEVISION = 4;
    public static final int UI_MODE_TYPE_UNDEFINED = 0;
    public static final int UI_MODE_TYPE_WATCH = 6;
    private static final String XML_ATTR_DENSITY = "density";
    private static final String XML_ATTR_FONT_SCALE = "fs";
    private static final String XML_ATTR_HARD_KEYBOARD_HIDDEN = "hardKeyHid";
    private static final String XML_ATTR_KEYBOARD = "key";
    private static final String XML_ATTR_KEYBOARD_HIDDEN = "keyHid";
    private static final String XML_ATTR_LOCALE = "locale";
    private static final String XML_ATTR_MCC = "mcc";
    private static final String XML_ATTR_MNC = "mnc";
    private static final String XML_ATTR_NAVIGATION = "nav";
    private static final String XML_ATTR_NAVIGATION_HIDDEN = "navHid";
    private static final String XML_ATTR_ORIENTATION = "ori";
    private static final String XML_ATTR_SCREEN_HEIGHT = "height";
    private static final String XML_ATTR_SCREEN_LAYOUT = "scrLay";
    private static final String XML_ATTR_SCREEN_WIDTH = "width";
    private static final String XML_ATTR_SMALLEST_WIDTH = "sw";
    private static final String XML_ATTR_TOUCHSCREEN = "touch";
    private static final String XML_ATTR_UI_MODE = "ui";
    public int FlipFont;
    public int compatScreenHeightDp;
    public int compatScreenWidthDp;
    public int compatSmallestScreenWidthDp;
    public int densityDpi;
    public float fontScale;
    public int hardKeyboardHidden;
    public int keyboard;
    public int keyboardHidden;
    public Locale locale;
    public int mcc;
    public int mnc;
    public int navigation;
    public int navigationHidden;
    public int orientation;
    public int screenHeightDp;
    public int screenLayout;
    public int screenWidthDp;
    public int seq;
    public int smallestScreenWidthDp;
    public ThemePack themePack;
    public int touchscreen;
    public int uiMode;
    public boolean userSetLocale;

    static {
        EMPTY = new Configuration();
        CREATOR = new Parcelable.Creator<Configuration>(){

            @Override
            public Configuration createFromParcel(Parcel parcel) {
                return new Configuration(parcel);
            }

            public Configuration[] newArray(int n) {
                return new Configuration[n];
            }
        };
    }

    public Configuration() {
        this.setToDefaults();
    }

    public Configuration(Configuration configuration) {
        this.setTo(configuration);
    }

    private Configuration(Parcel parcel) {
        this.readFromParcel(parcel);
    }

    public static Configuration generateDelta(Configuration configuration, Configuration configuration2) {
        Configuration configuration3 = new Configuration();
        if (configuration.fontScale != configuration2.fontScale) {
            configuration3.fontScale = configuration2.fontScale;
        }
        if (configuration.mcc != configuration2.mcc) {
            configuration3.mcc = configuration2.mcc;
        }
        if (configuration.mnc != configuration2.mnc) {
            configuration3.mnc = configuration2.mnc;
        }
        if (configuration.locale == null && configuration2.locale != null || configuration.locale != null && !configuration.locale.equals(configuration2.locale)) {
            configuration3.locale = configuration2.locale;
        }
        if (configuration.touchscreen != configuration2.touchscreen) {
            configuration3.touchscreen = configuration2.touchscreen;
        }
        if (configuration.keyboard != configuration2.keyboard) {
            configuration3.keyboard = configuration2.keyboard;
        }
        if (configuration.keyboardHidden != configuration2.keyboardHidden) {
            configuration3.keyboardHidden = configuration2.keyboardHidden;
        }
        if (configuration.navigation != configuration2.navigation) {
            configuration3.navigation = configuration2.navigation;
        }
        if (configuration.navigationHidden != configuration2.navigationHidden) {
            configuration3.navigationHidden = configuration2.navigationHidden;
        }
        if (configuration.orientation != configuration2.orientation) {
            configuration3.orientation = configuration2.orientation;
        }
        if ((0xF & configuration.screenLayout) != (0xF & configuration2.screenLayout)) {
            configuration3.screenLayout |= 0xF & configuration2.screenLayout;
        }
        if ((0xC0 & configuration.screenLayout) != (0xC0 & configuration2.screenLayout)) {
            configuration3.screenLayout |= 0xC0 & configuration2.screenLayout;
        }
        if ((0x30 & configuration.screenLayout) != (0x30 & configuration2.screenLayout)) {
            configuration3.screenLayout |= 0x30 & configuration2.screenLayout;
        }
        if ((0xF & configuration.uiMode) != (0xF & configuration2.uiMode)) {
            configuration3.uiMode |= 0xF & configuration2.uiMode;
        }
        if ((0x30 & configuration.uiMode) != (0x30 & configuration2.uiMode)) {
            configuration3.uiMode |= 0x30 & configuration2.uiMode;
        }
        if (configuration.screenWidthDp != configuration2.screenWidthDp) {
            configuration3.screenWidthDp = configuration2.screenWidthDp;
        }
        if (configuration.screenHeightDp != configuration2.screenHeightDp) {
            configuration3.screenHeightDp = configuration2.screenHeightDp;
        }
        if (configuration.smallestScreenWidthDp != configuration2.smallestScreenWidthDp) {
            configuration3.smallestScreenWidthDp = configuration2.smallestScreenWidthDp;
        }
        if (configuration.densityDpi != configuration2.densityDpi) {
            configuration3.densityDpi = configuration2.densityDpi;
        }
        return configuration3;
    }

    private static int getScreenLayoutNoDirection(int n) {
        return n & 0xFFFFFF3F;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String localeToResourceQualifier(Locale locale) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = locale.getLanguage().length() != 0;
        boolean bl2 = locale.getCountry().length() != 0;
        boolean bl3 = locale.getScript().length() != 0;
        boolean bl4 = locale.getVariant().length() != 0;
        if (bl) {
            stringBuilder.append(locale.getLanguage());
            if (bl2) {
                stringBuilder.append("-r").append(locale.getCountry());
                if (bl3) {
                    stringBuilder.append("-s").append(locale.getScript());
                    if (bl4) {
                        stringBuilder.append("-v").append(locale.getVariant());
                    }
                }
            }
        }
        return stringBuilder.toString();
    }

    public static boolean needNewResources(int n, int n2) {
        return (n & (0x8000 | (0x20000000 | (0x40000000 | n2)))) != 0;
    }

    public static void readXmlAttrs(XmlPullParser xmlPullParser, Configuration configuration) throws XmlPullParserException, IOException {
        configuration.fontScale = Float.intBitsToFloat(XmlUtils.readIntAttribute(xmlPullParser, XML_ATTR_FONT_SCALE, 0));
        configuration.mcc = XmlUtils.readIntAttribute(xmlPullParser, XML_ATTR_MCC, 0);
        configuration.mnc = XmlUtils.readIntAttribute(xmlPullParser, XML_ATTR_MNC, 0);
        String string2 = XmlUtils.readStringAttribute(xmlPullParser, XML_ATTR_LOCALE);
        if (string2 != null) {
            configuration.locale = Locale.forLanguageTag(string2);
        }
        configuration.touchscreen = XmlUtils.readIntAttribute(xmlPullParser, XML_ATTR_TOUCHSCREEN, 0);
        configuration.keyboard = XmlUtils.readIntAttribute(xmlPullParser, XML_ATTR_KEYBOARD, 0);
        configuration.keyboardHidden = XmlUtils.readIntAttribute(xmlPullParser, XML_ATTR_KEYBOARD_HIDDEN, 0);
        configuration.hardKeyboardHidden = XmlUtils.readIntAttribute(xmlPullParser, XML_ATTR_HARD_KEYBOARD_HIDDEN, 0);
        configuration.navigation = XmlUtils.readIntAttribute(xmlPullParser, XML_ATTR_NAVIGATION, 0);
        configuration.navigationHidden = XmlUtils.readIntAttribute(xmlPullParser, XML_ATTR_NAVIGATION_HIDDEN, 0);
        configuration.orientation = XmlUtils.readIntAttribute(xmlPullParser, XML_ATTR_ORIENTATION, 0);
        configuration.screenLayout = XmlUtils.readIntAttribute(xmlPullParser, XML_ATTR_SCREEN_LAYOUT, 0);
        configuration.uiMode = XmlUtils.readIntAttribute(xmlPullParser, XML_ATTR_UI_MODE, 0);
        configuration.screenWidthDp = XmlUtils.readIntAttribute(xmlPullParser, XML_ATTR_SCREEN_WIDTH, 0);
        configuration.screenHeightDp = XmlUtils.readIntAttribute(xmlPullParser, XML_ATTR_SCREEN_HEIGHT, 0);
        configuration.smallestScreenWidthDp = XmlUtils.readIntAttribute(xmlPullParser, XML_ATTR_SMALLEST_WIDTH, 0);
        configuration.densityDpi = XmlUtils.readIntAttribute(xmlPullParser, XML_ATTR_DENSITY, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int reduceScreenLayout(int n, int n2, int n3) {
        boolean bl;
        boolean bl2;
        int n4;
        if (n2 < 470) {
            n4 = 1;
            bl2 = false;
            bl = false;
        } else {
            n4 = n2 >= 960 && n3 >= 720 ? 4 : (n2 >= 640 && n3 >= 480 ? 3 : 2);
            bl = n3 > 321 || n2 > 570;
            bl2 = n2 * 3 / 5 >= n3 - 1;
        }
        if (!bl2) {
            n = 0x10 | n & 0xFFFFFFCF;
        }
        if (bl) {
            n |= 0x10000000;
        }
        if (n4 >= (n & 0xF)) return n;
        return n4 | n & 0xFFFFFFF0;
    }

    public static int resetScreenLayout(int n) {
        return 0x24 | 0xEFFFFFC0 & n;
    }

    /*
     * Handled duff style switch with additional control
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public static String resourceQualifierString(Configuration var0) {
        block76: {
            block75: {
                block74: {
                    block73: {
                        block72: {
                            var1_1 = new ArrayList<String>();
                            if (var0.mcc != 0) {
                                var1_1.add(var0.mcc + "mcc");
                                if (var0.mnc != 0) {
                                    var1_1.add(var0.mnc + "mnc");
                                }
                            }
                            if (!var0.locale.getLanguage().isEmpty()) {
                                var1_1.add(Configuration.localeToResourceQualifier(var0.locale));
                            }
                            switch (192 & var0.screenLayout) {
                                case 64: {
                                    var1_1.add("ldltr");
                                }
                                default: {
                                    break;
                                }
                                case 128: {
                                    var1_1.add("ldrtl");
                                }
                            }
                            if (var0.smallestScreenWidthDp != 0) {
                                var1_1.add("sw" + var0.smallestScreenWidthDp + "dp");
                            }
                            if (var0.screenWidthDp != 0) {
                                var1_1.add("w" + var0.screenWidthDp + "dp");
                            }
                            if (var0.screenHeightDp != 0) {
                                var1_1.add("h" + var0.screenHeightDp + "dp");
                            }
                            switch (15 & var0.screenLayout) {
                                case 1: {
                                    var1_1.add("small");
                                    ** break;
                                }
                                case 2: {
                                    var1_1.add("normal");
                                    ** break;
                                }
                                case 3: {
                                    var1_1.add("large");
                                }
lbl41:
                                // 4 sources

                                default: {
                                    break block72;
                                }
                                case 4: 
                            }
                            var1_1.add("xlarge");
                        }
                        switch (48 & var0.screenLayout) {
                            case 32: {
                                var1_1.add("long");
                            }
                            default: {
                                break;
                            }
                            case 16: {
                                var1_1.add("notlong");
                            }
                        }
                        switch (var0.orientation) {
                            case 2: {
                                var1_1.add("land");
                            }
                            default: {
                                break;
                            }
                            case 1: {
                                var1_1.add("port");
                            }
                        }
                        switch (15 & var0.uiMode) {
                            case 5: {
                                var1_1.add("appliance");
                                ** break;
                            }
                            case 2: {
                                var1_1.add("desk");
                                ** break;
                            }
                            case 4: {
                                var1_1.add("television");
                                ** break;
                            }
                            case 3: {
                                var1_1.add("car");
                            }
lbl81:
                            // 5 sources

                            default: {
                                break block73;
                            }
                            case 6: 
                        }
                        var1_1.add("watch");
                    }
                    switch (48 & var0.uiMode) {
                        case 32: {
                            var1_1.add("night");
                        }
                        default: {
                            break;
                        }
                        case 16: {
                            var1_1.add("notnight");
                        }
                    }
                    cfr_temp_0 = -2147483648;
                    block65: do {
                        switch (cfr_temp_0 == -2147483648 ? var0.densityDpi : cfr_temp_0) {
                            default: {
                                ** GOTO lbl144
                            }
                            case 120: {
                                var1_1.add("ldpi");
                                cfr_temp_0 = 0;
                                continue block65;
                            }
                            case 160: {
                                var1_1.add("mdpi");
                                cfr_temp_0 = 0;
                                continue block65;
                            }
                            case 213: {
                                var1_1.add("tvdpi");
                                cfr_temp_0 = 0;
                                continue block65;
                            }
                            case 240: {
                                var1_1.add("hdpi");
                                cfr_temp_0 = 0;
                                continue block65;
                            }
                            case 320: {
                                var1_1.add("xhdpi");
                                cfr_temp_0 = 0;
                                continue block65;
                            }
                            case 480: {
                                var1_1.add("xxhdpi");
                                cfr_temp_0 = 0;
                                continue block65;
                            }
                            case 640: {
                                var1_1.add("xxxhdpi");
                                cfr_temp_0 = 0;
                                continue block65;
                            }
                            case 65534: {
                                var1_1.add("anydpi");
                                cfr_temp_0 = 0;
                                continue block65;
                            }
                            case 65535: {
                                var1_1.add("nodpi");
lbl144:
                                // 2 sources

                                var1_1.add(var0.densityDpi + "dpi");
                            }
                            case 0: 
                        }
                        break;
                    } while (true);
                    switch (var0.touchscreen) {
                        case 1: {
                            var1_1.add("notouch");
                        }
                        default: {
                            break;
                        }
                        case 3: {
                            var1_1.add("finger");
                        }
                    }
                    switch (var0.keyboardHidden) {
                        case 1: {
                            var1_1.add("keysexposed");
                            ** break;
                        }
                        case 2: {
                            var1_1.add("keyshidden");
                        }
lbl166:
                        // 3 sources

                        default: {
                            break block74;
                        }
                        case 3: 
                    }
                    var1_1.add("keyssoft");
                }
                switch (var0.keyboard) {
                    case 1: {
                        var1_1.add("nokeys");
                        ** break;
                    }
                    case 2: {
                        var1_1.add("qwerty");
                    }
lbl180:
                    // 3 sources

                    default: {
                        break block75;
                    }
                    case 3: 
                }
                var1_1.add("12key");
            }
            switch (var0.navigationHidden) {
                case 1: {
                    var1_1.add("navexposed");
                }
                default: {
                    break;
                }
                case 2: {
                    var1_1.add("navhidden");
                }
            }
            switch (var0.navigation) {
                case 1: {
                    var1_1.add("nonav");
                    ** break;
                }
                case 2: {
                    var1_1.add("dpad");
                    ** break;
                }
                case 3: {
                    var1_1.add("trackball");
                }
lbl207:
                // 4 sources

                default: {
                    break block76;
                }
                case 4: 
            }
            var1_1.add("wheel");
        }
        var1_1.add("v" + Build.VERSION.RESOURCES_SDK_INT);
        return TextUtils.join((CharSequence)"-", var1_1);
    }

    public static void writeXmlAttrs(XmlSerializer xmlSerializer, Configuration configuration) throws IOException {
        XmlUtils.writeIntAttribute(xmlSerializer, XML_ATTR_FONT_SCALE, Float.floatToIntBits(configuration.fontScale));
        if (configuration.mcc != 0) {
            XmlUtils.writeIntAttribute(xmlSerializer, XML_ATTR_MCC, configuration.mcc);
        }
        if (configuration.mnc != 0) {
            XmlUtils.writeIntAttribute(xmlSerializer, XML_ATTR_MNC, configuration.mnc);
        }
        if (configuration.locale != null) {
            XmlUtils.writeStringAttribute(xmlSerializer, XML_ATTR_LOCALE, configuration.locale.toLanguageTag());
        }
        if (configuration.touchscreen != 0) {
            XmlUtils.writeIntAttribute(xmlSerializer, XML_ATTR_TOUCHSCREEN, configuration.touchscreen);
        }
        if (configuration.keyboard != 0) {
            XmlUtils.writeIntAttribute(xmlSerializer, XML_ATTR_KEYBOARD, configuration.keyboard);
        }
        if (configuration.keyboardHidden != 0) {
            XmlUtils.writeIntAttribute(xmlSerializer, XML_ATTR_KEYBOARD_HIDDEN, configuration.keyboardHidden);
        }
        if (configuration.hardKeyboardHidden != 0) {
            XmlUtils.writeIntAttribute(xmlSerializer, XML_ATTR_HARD_KEYBOARD_HIDDEN, configuration.hardKeyboardHidden);
        }
        if (configuration.navigation != 0) {
            XmlUtils.writeIntAttribute(xmlSerializer, XML_ATTR_NAVIGATION, configuration.navigation);
        }
        if (configuration.navigationHidden != 0) {
            XmlUtils.writeIntAttribute(xmlSerializer, XML_ATTR_NAVIGATION_HIDDEN, configuration.navigationHidden);
        }
        if (configuration.orientation != 0) {
            XmlUtils.writeIntAttribute(xmlSerializer, XML_ATTR_ORIENTATION, configuration.orientation);
        }
        if (configuration.screenLayout != 0) {
            XmlUtils.writeIntAttribute(xmlSerializer, XML_ATTR_SCREEN_LAYOUT, configuration.screenLayout);
        }
        if (configuration.uiMode != 0) {
            XmlUtils.writeIntAttribute(xmlSerializer, XML_ATTR_UI_MODE, configuration.uiMode);
        }
        if (configuration.screenWidthDp != 0) {
            XmlUtils.writeIntAttribute(xmlSerializer, XML_ATTR_SCREEN_WIDTH, configuration.screenWidthDp);
        }
        if (configuration.screenHeightDp != 0) {
            XmlUtils.writeIntAttribute(xmlSerializer, XML_ATTR_SCREEN_HEIGHT, configuration.screenHeightDp);
        }
        if (configuration.smallestScreenWidthDp != 0) {
            XmlUtils.writeIntAttribute(xmlSerializer, XML_ATTR_SMALLEST_WIDTH, configuration.smallestScreenWidthDp);
        }
        if (configuration.densityDpi != 0) {
            XmlUtils.writeIntAttribute(xmlSerializer, XML_ATTR_DENSITY, configuration.densityDpi);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(Configuration configuration) {
        float f;
        float f2;
        float f3 = this.fontScale;
        float f4 = configuration.fontScale;
        if (f3 < f4) {
            return -1;
        }
        if (f3 > f4) {
            return 1;
        }
        int n = this.mcc - configuration.mcc;
        if (n != 0) return n;
        n = this.mnc - configuration.mnc;
        if (n != 0) return n;
        if (this.locale == null) {
            if (configuration.locale != null) {
                return 1;
            }
        } else {
            if (configuration.locale == null) {
                return -1;
            }
            n = this.locale.getLanguage().compareTo(configuration.locale.getLanguage());
            if (n != 0) return n;
            n = this.locale.getCountry().compareTo(configuration.locale.getCountry());
            if (n != 0) return n;
            n = this.locale.getVariant().compareTo(configuration.locale.getVariant());
            if (n != 0) return n;
        }
        if ((n = this.touchscreen - configuration.touchscreen) != 0) return n;
        n = this.keyboard - configuration.keyboard;
        if (n != 0) return n;
        n = this.keyboardHidden - configuration.keyboardHidden;
        if (n != 0) return n;
        n = this.hardKeyboardHidden - configuration.hardKeyboardHidden;
        if (n != 0) return n;
        n = this.navigation - configuration.navigation;
        if (n != 0) return n;
        n = this.navigationHidden - configuration.navigationHidden;
        if (n != 0) return n;
        n = this.orientation - configuration.orientation;
        if (n != 0) return n;
        n = this.screenLayout - configuration.screenLayout;
        if (n != 0) return n;
        n = this.uiMode - configuration.uiMode;
        if (n != 0) return n;
        n = this.screenWidthDp - configuration.screenWidthDp;
        if (n != 0) return n;
        n = this.screenHeightDp - configuration.screenHeightDp;
        if (n != 0) return n;
        n = this.smallestScreenWidthDp - configuration.smallestScreenWidthDp;
        if (n != 0) return n;
        n = this.densityDpi - configuration.densityDpi;
        if (this.themePack == null) {
            if (configuration.themePack != null) {
                return 1;
            }
        } else {
            n = this.themePack.compareTo(configuration.themePack);
        }
        if ((f2 = (float)this.FlipFont) < (f = (float)configuration.FlipFont)) {
            return -1;
        }
        if (!(f2 > f)) return n;
        return 1;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int diff(Configuration configuration) {
        int n;
        float f = configuration.fontScale - 0.0f;
        float f2 = f == 0.0f ? 0 : (f > 0.0f ? 1 : -1);
        int n2 = 0;
        if (f2 > 0) {
            float f3 = this.fontScale - configuration.fontScale;
            float f4 = f3 == 0.0f ? 0 : (f3 > 0.0f ? 1 : -1);
            n2 = 0;
            if (f4 != false) {
                n2 = 0 | 0x40000000;
            }
        }
        if (configuration.mcc != 0 && this.mcc != configuration.mcc) {
            n2 |= 1;
        }
        if (configuration.mnc != 0 && this.mnc != configuration.mnc) {
            n2 |= 2;
        }
        if (!(configuration.locale == null || this.locale != null && this.locale.equals(configuration.locale))) {
            n2 = 0x2000 | (n2 | 4);
        }
        if ((n = 0xC0 & configuration.screenLayout) != 0 && n != (0xC0 & this.screenLayout)) {
            n2 |= 0x2000;
        }
        if (configuration.touchscreen != 0 && this.touchscreen != configuration.touchscreen) {
            n2 |= 8;
        }
        if (configuration.keyboard != 0 && this.keyboard != configuration.keyboard) {
            n2 |= 0x10;
        }
        if (configuration.keyboardHidden != 0 && this.keyboardHidden != configuration.keyboardHidden) {
            n2 |= 0x20;
        }
        if (configuration.hardKeyboardHidden != 0 && this.hardKeyboardHidden != configuration.hardKeyboardHidden) {
            n2 |= 0x20;
        }
        if (configuration.navigation != 0 && this.navigation != configuration.navigation) {
            n2 |= 0x40;
        }
        if (configuration.navigationHidden != 0 && this.navigationHidden != configuration.navigationHidden) {
            n2 |= 0x20;
        }
        if (configuration.orientation != 0 && this.orientation != configuration.orientation) {
            n2 |= 0x80;
        }
        if (Configuration.getScreenLayoutNoDirection(configuration.screenLayout) != 0 && Configuration.getScreenLayoutNoDirection(this.screenLayout) != Configuration.getScreenLayoutNoDirection(configuration.screenLayout)) {
            n2 |= 0x100;
        }
        if (configuration.uiMode != 0 && this.uiMode != configuration.uiMode) {
            n2 |= 0x200;
        }
        if (configuration.screenWidthDp != 0 && this.screenWidthDp != configuration.screenWidthDp) {
            n2 |= 0x400;
        }
        if (configuration.screenHeightDp != 0 && this.screenHeightDp != configuration.screenHeightDp) {
            n2 |= 0x400;
        }
        if (configuration.smallestScreenWidthDp != 0 && this.smallestScreenWidthDp != configuration.smallestScreenWidthDp) {
            n2 |= 0x800;
        }
        if (configuration.densityDpi != 0 && this.densityDpi != configuration.densityDpi) {
            n2 |= 0x1000;
        }
        if (!(configuration.themePack == null || this.themePack != null && this.themePack.equals(configuration.themePack))) {
            n2 |= 0x8000;
        }
        if (configuration.FlipFont > 0 && this.FlipFont != configuration.FlipFont) {
            n2 |= 0x20000000;
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Configuration configuration) {
        boolean bl = true;
        if (configuration == null) {
            return false;
        }
        if (configuration == this) return bl;
        if (this.compareTo(configuration) == 0) return bl;
        return false;
    }

    public boolean equals(Object object) {
        try {
            boolean bl = this.equals((Configuration)object);
            return bl;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int getLayoutDirection() {
        if ((0xC0 & this.screenLayout) == 128) {
            return 1;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int hashCode() {
        int n = 31 * (31 * (31 * (527 + Float.floatToIntBits(this.fontScale)) + this.mcc) + this.mnc);
        int n2 = this.locale != null ? this.locale.hashCode() : 0;
        int n3 = 31 * (31 * (31 * (31 * (31 * (31 * (31 * (31 * (31 * (31 * (31 * (31 * (31 * (31 * (n + n2) + this.touchscreen) + this.keyboard) + this.keyboardHidden) + this.hardKeyboardHidden) + this.navigation) + this.navigationHidden) + this.orientation) + this.screenLayout) + this.uiMode) + this.screenWidthDp) + this.screenHeightDp) + this.smallestScreenWidthDp) + this.densityDpi);
        ThemePack themePack = this.themePack;
        int n4 = 0;
        if (themePack != null) {
            n4 = this.themePack.hashCode();
        }
        return 31 * (n3 + n4) + this.FlipFont;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isLayoutSizeAtLeast(int n) {
        int n2 = 0xF & this.screenLayout;
        return n2 != 0 && n2 >= n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOtherSeqNewer(Configuration configuration) {
        boolean bl = true;
        if (configuration == null) {
            return false;
        }
        if (configuration.seq == 0) return bl;
        if (this.seq == 0) return bl;
        int n = configuration.seq - this.seq;
        if (n > 65536) {
            return false;
        }
        if (n > 0) return bl;
        return false;
    }

    @Deprecated
    public void makeDefault() {
        this.setToDefaults();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void readFromParcel(Parcel parcel) {
        int n = 1;
        this.fontScale = parcel.readFloat();
        this.mcc = parcel.readInt();
        this.mnc = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.locale = new Locale(parcel.readString(), parcel.readString(), parcel.readString());
        }
        if (parcel.readInt() != n) {
            n = 0;
        }
        this.userSetLocale = n;
        this.touchscreen = parcel.readInt();
        this.keyboard = parcel.readInt();
        this.keyboardHidden = parcel.readInt();
        this.hardKeyboardHidden = parcel.readInt();
        this.navigation = parcel.readInt();
        this.navigationHidden = parcel.readInt();
        this.orientation = parcel.readInt();
        this.screenLayout = parcel.readInt();
        this.uiMode = parcel.readInt();
        this.screenWidthDp = parcel.readInt();
        this.screenHeightDp = parcel.readInt();
        this.smallestScreenWidthDp = parcel.readInt();
        this.densityDpi = parcel.readInt();
        this.compatScreenWidthDp = parcel.readInt();
        this.compatScreenHeightDp = parcel.readInt();
        this.compatSmallestScreenWidthDp = parcel.readInt();
        this.seq = parcel.readInt();
        this.themePack = (ThemePack)parcel.readParcelable(ThemePack.class.getClassLoader());
        this.FlipFont = parcel.readInt();
    }

    public void setLayoutDirection(Locale locale) {
        int n = 1 + TextUtils.getLayoutDirectionFromLocale(locale);
        this.screenLayout = 0xFFFFFF3F & this.screenLayout | n << 6;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.userSetLocale = true;
        this.setLayoutDirection(this.locale);
    }

    public void setTo(Configuration configuration) {
        this.fontScale = configuration.fontScale;
        this.mcc = configuration.mcc;
        this.mnc = configuration.mnc;
        if (configuration.locale != null) {
            this.locale = (Locale)configuration.locale.clone();
        }
        this.userSetLocale = configuration.userSetLocale;
        this.touchscreen = configuration.touchscreen;
        this.keyboard = configuration.keyboard;
        this.keyboardHidden = configuration.keyboardHidden;
        this.hardKeyboardHidden = configuration.hardKeyboardHidden;
        this.navigation = configuration.navigation;
        this.navigationHidden = configuration.navigationHidden;
        this.orientation = configuration.orientation;
        this.screenLayout = configuration.screenLayout;
        this.uiMode = configuration.uiMode;
        this.screenWidthDp = configuration.screenWidthDp;
        this.screenHeightDp = configuration.screenHeightDp;
        this.smallestScreenWidthDp = configuration.smallestScreenWidthDp;
        this.densityDpi = configuration.densityDpi;
        this.compatScreenWidthDp = configuration.compatScreenWidthDp;
        this.compatScreenHeightDp = configuration.compatScreenHeightDp;
        this.compatSmallestScreenWidthDp = configuration.compatSmallestScreenWidthDp;
        this.seq = configuration.seq;
        if (configuration.themePack != null) {
            this.themePack = (ThemePack)configuration.themePack.clone();
        }
        this.FlipFont = configuration.FlipFont;
    }

    public void setToDefaults() {
        this.fontScale = 1.0f;
        this.mnc = 0;
        this.mcc = 0;
        this.locale = null;
        this.userSetLocale = false;
        this.touchscreen = 0;
        this.keyboard = 0;
        this.keyboardHidden = 0;
        this.hardKeyboardHidden = 0;
        this.navigation = 0;
        this.navigationHidden = 0;
        this.orientation = 0;
        this.screenLayout = 0;
        this.uiMode = 0;
        this.compatScreenWidthDp = 0;
        this.screenWidthDp = 0;
        this.compatScreenHeightDp = 0;
        this.screenHeightDp = 0;
        this.compatSmallestScreenWidthDp = 0;
        this.smallestScreenWidthDp = 0;
        this.densityDpi = 0;
        this.seq = 0;
        this.FlipFont = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("{");
        stringBuilder.append(this.FlipFont);
        stringBuilder.append(" ");
        stringBuilder.append(this.fontScale);
        stringBuilder.append(" ");
        if (this.mcc != 0) {
            stringBuilder.append(this.mcc);
            stringBuilder.append(XML_ATTR_MCC);
        } else {
            stringBuilder.append("?mcc");
        }
        if (this.mnc != 0) {
            stringBuilder.append(this.mnc);
            stringBuilder.append(XML_ATTR_MNC);
        } else {
            stringBuilder.append("?mnc");
        }
        if (this.locale != null) {
            stringBuilder.append(" ");
            stringBuilder.append(this.locale);
        } else {
            stringBuilder.append(" ?locale");
        }
        int n = 0xC0 & this.screenLayout;
        switch (n) {
            default: {
                stringBuilder.append(" layoutDir=");
                stringBuilder.append(n >> 6);
                break;
            }
            case 0: {
                stringBuilder.append(" ?layoutDir");
                break;
            }
            case 64: {
                stringBuilder.append(" ldltr");
                break;
            }
            case 128: {
                stringBuilder.append(" ldrtl");
            }
        }
        if (this.smallestScreenWidthDp != 0) {
            stringBuilder.append(" sw");
            stringBuilder.append(this.smallestScreenWidthDp);
            stringBuilder.append("dp");
        } else {
            stringBuilder.append(" ?swdp");
        }
        if (this.screenWidthDp != 0) {
            stringBuilder.append(" w");
            stringBuilder.append(this.screenWidthDp);
            stringBuilder.append("dp");
        } else {
            stringBuilder.append(" ?wdp");
        }
        if (this.screenHeightDp != 0) {
            stringBuilder.append(" h");
            stringBuilder.append(this.screenHeightDp);
            stringBuilder.append("dp");
        } else {
            stringBuilder.append(" ?hdp");
        }
        if (this.densityDpi != 0) {
            stringBuilder.append(" ");
            stringBuilder.append(this.densityDpi);
            stringBuilder.append("dpi");
        } else {
            stringBuilder.append(" ?density");
        }
        switch (0xF & this.screenLayout) {
            default: {
                stringBuilder.append(" layoutSize=");
                stringBuilder.append(0xF & this.screenLayout);
                break;
            }
            case 0: {
                stringBuilder.append(" ?lsize");
                break;
            }
            case 1: {
                stringBuilder.append(" smll");
                break;
            }
            case 2: {
                stringBuilder.append(" nrml");
                break;
            }
            case 3: {
                stringBuilder.append(" lrg");
                break;
            }
            case 4: {
                stringBuilder.append(" xlrg");
            }
        }
        switch (0x30 & this.screenLayout) {
            default: {
                stringBuilder.append(" layoutLong=");
                stringBuilder.append(0x30 & this.screenLayout);
                break;
            }
            case 0: {
                stringBuilder.append(" ?long");
            }
            case 16: {
                break;
            }
            case 32: {
                stringBuilder.append(" long");
            }
        }
        switch (this.orientation) {
            default: {
                stringBuilder.append(" orien=");
                stringBuilder.append(this.orientation);
                break;
            }
            case 0: {
                stringBuilder.append(" ?orien");
                break;
            }
            case 2: {
                stringBuilder.append(" land");
                break;
            }
            case 1: {
                stringBuilder.append(" port");
            }
        }
        switch (0xF & this.uiMode) {
            default: {
                stringBuilder.append(" uimode=");
                stringBuilder.append(0xF & this.uiMode);
                break;
            }
            case 0: {
                stringBuilder.append(" ?uimode");
                break;
            }
            case 2: {
                stringBuilder.append(" desk");
                break;
            }
            case 3: {
                stringBuilder.append(" car");
                break;
            }
            case 4: {
                stringBuilder.append(" television");
                break;
            }
            case 5: {
                stringBuilder.append(" appliance");
            }
            case 1: {
                break;
            }
            case 6: {
                stringBuilder.append(" watch");
            }
        }
        switch (0x30 & this.uiMode) {
            default: {
                stringBuilder.append(" night=");
                stringBuilder.append(0x30 & this.uiMode);
                break;
            }
            case 0: {
                stringBuilder.append(" ?night");
            }
            case 16: {
                break;
            }
            case 32: {
                stringBuilder.append(" night");
            }
        }
        switch (this.touchscreen) {
            default: {
                stringBuilder.append(" touch=");
                stringBuilder.append(this.touchscreen);
                break;
            }
            case 0: {
                stringBuilder.append(" ?touch");
                break;
            }
            case 1: {
                stringBuilder.append(" -touch");
                break;
            }
            case 2: {
                stringBuilder.append(" stylus");
                break;
            }
            case 3: {
                stringBuilder.append(" finger");
            }
        }
        switch (this.keyboard) {
            default: {
                stringBuilder.append(" keys=");
                stringBuilder.append(this.keyboard);
                break;
            }
            case 0: {
                stringBuilder.append(" ?keyb");
                break;
            }
            case 1: {
                stringBuilder.append(" -keyb");
                break;
            }
            case 2: {
                stringBuilder.append(" qwerty");
                break;
            }
            case 3: {
                stringBuilder.append(" 12key");
            }
        }
        switch (this.keyboardHidden) {
            default: {
                stringBuilder.append("/");
                stringBuilder.append(this.keyboardHidden);
                break;
            }
            case 0: {
                stringBuilder.append("/?");
                break;
            }
            case 1: {
                stringBuilder.append("/v");
                break;
            }
            case 2: {
                stringBuilder.append("/h");
                break;
            }
            case 3: {
                stringBuilder.append("/s");
            }
        }
        switch (this.hardKeyboardHidden) {
            default: {
                stringBuilder.append("/");
                stringBuilder.append(this.hardKeyboardHidden);
                break;
            }
            case 0: {
                stringBuilder.append("/?");
                break;
            }
            case 1: {
                stringBuilder.append("/v");
                break;
            }
            case 2: {
                stringBuilder.append("/h");
            }
        }
        switch (this.navigation) {
            default: {
                stringBuilder.append(" nav=");
                stringBuilder.append(this.navigation);
                break;
            }
            case 0: {
                stringBuilder.append(" ?nav");
                break;
            }
            case 1: {
                stringBuilder.append(" -nav");
                break;
            }
            case 2: {
                stringBuilder.append(" dpad");
                break;
            }
            case 3: {
                stringBuilder.append(" tball");
                break;
            }
            case 4: {
                stringBuilder.append(" wheel");
            }
        }
        switch (this.navigationHidden) {
            default: {
                stringBuilder.append("/");
                stringBuilder.append(this.navigationHidden);
                break;
            }
            case 0: {
                stringBuilder.append("/?");
                break;
            }
            case 1: {
                stringBuilder.append("/v");
                break;
            }
            case 2: {
                stringBuilder.append("/h");
            }
        }
        if (this.seq != 0) {
            stringBuilder.append(" s.");
            stringBuilder.append(this.seq);
        }
        stringBuilder.append(" themePack=");
        stringBuilder.append(this.themePack);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public int updateFrom(Configuration configuration) {
        int n;
        float f = configuration.fontScale - 0.0f;
        float f2 = f == 0.0f ? 0 : (f > 0.0f ? 1 : -1);
        int n2 = 0;
        if (f2 > 0) {
            float f3 = this.fontScale - configuration.fontScale;
            float f4 = f3 == 0.0f ? 0 : (f3 > 0.0f ? 1 : -1);
            n2 = 0;
            if (f4 != false) {
                n2 = 0 | 0x40000000;
                this.fontScale = configuration.fontScale;
            }
        }
        if (configuration.mcc != 0 && this.mcc != configuration.mcc) {
            n2 |= 1;
            this.mcc = configuration.mcc;
        }
        if (configuration.mnc != 0 && this.mnc != configuration.mnc) {
            n2 |= 2;
            this.mnc = configuration.mnc;
        }
        if (!(configuration.locale == null || this.locale != null && this.locale.equals(configuration.locale))) {
            int n3 = n2 | 4;
            Locale locale = configuration.locale != null ? (Locale)configuration.locale.clone() : null;
            this.locale = locale;
            n2 = n3 | 0x2000;
            this.setLayoutDirection(this.locale);
        }
        if ((n = 0xC0 & configuration.screenLayout) != 0 && n != (0xC0 & this.screenLayout)) {
            this.screenLayout = n | 0xFFFFFF3F & this.screenLayout;
            n2 |= 0x2000;
        }
        if (configuration.userSetLocale && (!this.userSetLocale || (n2 & 4) != 0)) {
            n2 |= 4;
            this.userSetLocale = true;
        }
        if (configuration.touchscreen != 0 && this.touchscreen != configuration.touchscreen) {
            n2 |= 8;
            this.touchscreen = configuration.touchscreen;
        }
        if (configuration.keyboard != 0 && this.keyboard != configuration.keyboard) {
            n2 |= 0x10;
            this.keyboard = configuration.keyboard;
        }
        if (configuration.keyboardHidden != 0 && this.keyboardHidden != configuration.keyboardHidden) {
            n2 |= 0x20;
            this.keyboardHidden = configuration.keyboardHidden;
        }
        if (configuration.hardKeyboardHidden != 0 && this.hardKeyboardHidden != configuration.hardKeyboardHidden) {
            n2 |= 0x20;
            this.hardKeyboardHidden = configuration.hardKeyboardHidden;
        }
        if (configuration.navigation != 0 && this.navigation != configuration.navigation) {
            n2 |= 0x40;
            this.navigation = configuration.navigation;
        }
        if (configuration.navigationHidden != 0 && this.navigationHidden != configuration.navigationHidden) {
            n2 |= 0x20;
            this.navigationHidden = configuration.navigationHidden;
        }
        if (configuration.orientation != 0 && this.orientation != configuration.orientation) {
            n2 |= 0x80;
            this.orientation = configuration.orientation;
        }
        if (Configuration.getScreenLayoutNoDirection(configuration.screenLayout) != 0 && Configuration.getScreenLayoutNoDirection(this.screenLayout) != Configuration.getScreenLayoutNoDirection(configuration.screenLayout)) {
            n2 |= 0x100;
            this.screenLayout = (0xC0 & configuration.screenLayout) == 0 ? 0xC0 & this.screenLayout | configuration.screenLayout : configuration.screenLayout;
        }
        if (configuration.uiMode != 0 && this.uiMode != configuration.uiMode) {
            n2 |= 0x200;
            if ((0xF & configuration.uiMode) != 0) {
                this.uiMode = 0xFFFFFFF0 & this.uiMode | 0xF & configuration.uiMode;
            }
            if ((0x30 & configuration.uiMode) != 0) {
                this.uiMode = 0xFFFFFFCF & this.uiMode | 0x30 & configuration.uiMode;
            }
        }
        if (configuration.screenWidthDp != 0 && this.screenWidthDp != configuration.screenWidthDp) {
            n2 |= 0x400;
            this.screenWidthDp = configuration.screenWidthDp;
        }
        if (configuration.screenHeightDp != 0 && this.screenHeightDp != configuration.screenHeightDp) {
            n2 |= 0x400;
            this.screenHeightDp = configuration.screenHeightDp;
        }
        if (configuration.smallestScreenWidthDp != 0 && this.smallestScreenWidthDp != configuration.smallestScreenWidthDp) {
            n2 |= 0x800;
            this.smallestScreenWidthDp = configuration.smallestScreenWidthDp;
        }
        if (configuration.densityDpi != 0 && this.densityDpi != configuration.densityDpi) {
            n2 |= 0x1000;
            this.densityDpi = configuration.densityDpi;
        }
        if (configuration.compatScreenWidthDp != 0) {
            this.compatScreenWidthDp = configuration.compatScreenWidthDp;
        }
        if (configuration.compatScreenHeightDp != 0) {
            this.compatScreenHeightDp = configuration.compatScreenHeightDp;
        }
        if (configuration.compatSmallestScreenWidthDp != 0) {
            this.compatSmallestScreenWidthDp = configuration.compatSmallestScreenWidthDp;
        }
        if (configuration.seq != 0) {
            this.seq = configuration.seq;
        }
        if (!(configuration.themePack == null || this.themePack != null && this.themePack.equals(configuration.themePack))) {
            n2 |= 0x8000;
            this.themePack = (ThemePack)configuration.themePack.clone();
        }
        if (configuration.FlipFont > 0 && this.FlipFont != configuration.FlipFont) {
            n2 |= 0x20000000;
            this.FlipFont = configuration.FlipFont;
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeFloat(this.fontScale);
        parcel.writeInt(this.mcc);
        parcel.writeInt(this.mnc);
        if (this.locale == null) {
            parcel.writeInt(0);
        } else {
            parcel.writeInt(1);
            parcel.writeString(this.locale.getLanguage());
            parcel.writeString(this.locale.getCountry());
            parcel.writeString(this.locale.getVariant());
        }
        if (this.userSetLocale) {
            parcel.writeInt(1);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.touchscreen);
        parcel.writeInt(this.keyboard);
        parcel.writeInt(this.keyboardHidden);
        parcel.writeInt(this.hardKeyboardHidden);
        parcel.writeInt(this.navigation);
        parcel.writeInt(this.navigationHidden);
        parcel.writeInt(this.orientation);
        parcel.writeInt(this.screenLayout);
        parcel.writeInt(this.uiMode);
        parcel.writeInt(this.screenWidthDp);
        parcel.writeInt(this.screenHeightDp);
        parcel.writeInt(this.smallestScreenWidthDp);
        parcel.writeInt(this.densityDpi);
        parcel.writeInt(this.compatScreenWidthDp);
        parcel.writeInt(this.compatScreenHeightDp);
        parcel.writeInt(this.compatSmallestScreenWidthDp);
        parcel.writeInt(this.seq);
        parcel.writeParcelable(this.themePack, n);
        parcel.writeInt(this.FlipFont);
    }
}

