/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.content.ContentValues;
import android.content.Context;
import android.content.OperationApplicationException;
import android.database.AbstractWindowedCursor;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.SQLException;
import android.database.sqlite.SQLiteAbortException;
import android.database.sqlite.SQLiteConstraintException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseCorruptException;
import android.database.sqlite.SQLiteDiskIOException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteFullException;
import android.database.sqlite.SQLiteProgram;
import android.database.sqlite.SQLiteStatement;
import android.os.OperationCanceledException;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.util.Log;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.text.Collator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;

public class DatabaseUtils {
    private static final boolean DEBUG = false;
    public static final int STATEMENT_ABORT = 6;
    public static final int STATEMENT_ATTACH = 3;
    public static final int STATEMENT_BEGIN = 4;
    public static final int STATEMENT_COMMIT = 5;
    public static final int STATEMENT_DDL = 8;
    public static final int STATEMENT_OTHER = 99;
    public static final int STATEMENT_PRAGMA = 7;
    public static final int STATEMENT_SELECT = 1;
    public static final int STATEMENT_UNPREPARED = 9;
    public static final int STATEMENT_UPDATE = 2;
    private static final String TAG = "DatabaseUtils";
    private static Collator mColl = null;

    public static void appendEscapedSQLString(StringBuilder stringBuilder, String string2) {
        stringBuilder.append('\'');
        if (string2.indexOf(39) != -1) {
            int n = string2.length();
            for (int i = 0; i < n; ++i) {
                char c = string2.charAt(i);
                if (c == '\'') {
                    stringBuilder.append('\'');
                }
                stringBuilder.append(c);
            }
        } else {
            stringBuilder.append(string2);
        }
        stringBuilder.append('\'');
    }

    public static String[] appendSelectionArgs(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray.length == 0) {
            return stringArray2;
        }
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    public static final void appendValueToSql(StringBuilder stringBuilder, Object object) {
        if (object == null) {
            stringBuilder.append("NULL");
            return;
        }
        if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                stringBuilder.append('1');
                return;
            }
            stringBuilder.append('0');
            return;
        }
        DatabaseUtils.appendEscapedSQLString(stringBuilder, object.toString());
    }

    public static void bindObjectToProgram(SQLiteProgram sQLiteProgram, int n, Object object) {
        if (object == null) {
            sQLiteProgram.bindNull(n);
            return;
        }
        if (object instanceof Double || object instanceof Float) {
            sQLiteProgram.bindDouble(n, ((Number)object).doubleValue());
            return;
        }
        if (object instanceof Number) {
            sQLiteProgram.bindLong(n, ((Number)object).longValue());
            return;
        }
        if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                sQLiteProgram.bindLong(n, 1L);
                return;
            }
            sQLiteProgram.bindLong(n, 0L);
            return;
        }
        if (object instanceof byte[]) {
            sQLiteProgram.bindBlob(n, (byte[])object);
            return;
        }
        sQLiteProgram.bindString(n, object.toString());
    }

    public static ParcelFileDescriptor blobFileDescriptorForQuery(SQLiteDatabase sQLiteDatabase, String string2, String[] stringArray) {
        SQLiteStatement sQLiteStatement = sQLiteDatabase.compileStatement(string2);
        try {
            ParcelFileDescriptor parcelFileDescriptor = DatabaseUtils.blobFileDescriptorForQuery(sQLiteStatement, stringArray);
            return parcelFileDescriptor;
        }
        finally {
            sQLiteStatement.close();
        }
    }

    public static ParcelFileDescriptor blobFileDescriptorForQuery(SQLiteStatement sQLiteStatement, String[] stringArray) {
        sQLiteStatement.bindAllArgsAsStrings(stringArray);
        return sQLiteStatement.simpleQueryForBlobFileDescriptor();
    }

    public static String concatenateWhere(String string2, String string3) {
        if (TextUtils.isEmpty(string2)) {
            return string3;
        }
        if (TextUtils.isEmpty(string3)) {
            return string2;
        }
        return "(" + string2 + ") AND (" + string3 + ")";
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void createDbFromSqlStatements(Context context, String string2, int n, String string3) {
        SQLiteDatabase sQLiteDatabase = context.openOrCreateDatabase(string2, 0, null);
        String[] stringArray = TextUtils.split(string3, ";\n");
        int n2 = stringArray.length;
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                sQLiteDatabase.setVersion(n);
                sQLiteDatabase.close();
                return;
            }
            String string4 = stringArray[n3];
            if (!TextUtils.isEmpty(string4)) {
                sQLiteDatabase.execSQL(string4);
            }
            ++n3;
        }
    }

    public static void cursorDoubleToContentValues(Cursor cursor, String string2, ContentValues contentValues, String string3) {
        int n = cursor.getColumnIndex(string2);
        if (!cursor.isNull(n)) {
            contentValues.put(string3, cursor.getDouble(n));
            return;
        }
        contentValues.put(string3, (Double)null);
    }

    public static void cursorDoubleToContentValuesIfPresent(Cursor cursor, ContentValues contentValues, String string2) {
        int n = cursor.getColumnIndex(string2);
        if (n != -1 && !cursor.isNull(n)) {
            contentValues.put(string2, cursor.getDouble(n));
        }
    }

    public static void cursorDoubleToCursorValues(Cursor cursor, String string2, ContentValues contentValues) {
        DatabaseUtils.cursorDoubleToContentValues(cursor, string2, contentValues, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void cursorFillWindow(Cursor cursor, int n, CursorWindow cursorWindow) {
        if (n < 0 || n >= cursor.getCount()) {
            return;
        }
        int n2 = cursor.getPosition();
        int n3 = cursor.getColumnCount();
        cursorWindow.clear();
        cursorWindow.setStartPosition(n);
        cursorWindow.setNumColumns(n3);
        if (cursor.moveToPosition(n)) {
            while (cursorWindow.allocRow()) {
                for (int i = 0; i < n3; ++i) {
                    boolean bl;
                    switch (cursor.getType(i)) {
                        default: {
                            String string2 = cursor.getString(i);
                            bl = string2 != null ? cursorWindow.putString(string2, n, i) : cursorWindow.putNull(n, i);
                        }
                        case 0: {
                            bl = cursorWindow.putNull(n, i);
                            break;
                        }
                        case 1: {
                            bl = cursorWindow.putLong(cursor.getLong(i), n, i);
                            break;
                        }
                        case 2: {
                            bl = cursorWindow.putDouble(cursor.getDouble(i), n, i);
                            break;
                        }
                        case 4: {
                            byte[] byArray = cursor.getBlob(i);
                            if (byArray != null) {
                                bl = cursorWindow.putBlob(byArray, n, i);
                                break;
                            }
                            bl = cursorWindow.putNull(n, i);
                            break;
                        }
                    }
                    if (bl) continue;
                    cursorWindow.freeLastRow();
                    break;
                }
                ++n;
                if (cursor.moveToNext()) continue;
            }
        }
        cursor.moveToPosition(n2);
    }

    public static void cursorFloatToContentValuesIfPresent(Cursor cursor, ContentValues contentValues, String string2) {
        int n = cursor.getColumnIndex(string2);
        if (n != -1 && !cursor.isNull(n)) {
            contentValues.put(string2, Float.valueOf(cursor.getFloat(n)));
        }
    }

    public static void cursorIntToContentValues(Cursor cursor, String string2, ContentValues contentValues) {
        DatabaseUtils.cursorIntToContentValues(cursor, string2, contentValues, string2);
    }

    public static void cursorIntToContentValues(Cursor cursor, String string2, ContentValues contentValues, String string3) {
        int n = cursor.getColumnIndex(string2);
        if (!cursor.isNull(n)) {
            contentValues.put(string3, cursor.getInt(n));
            return;
        }
        contentValues.put(string3, (Integer)null);
    }

    public static void cursorIntToContentValuesIfPresent(Cursor cursor, ContentValues contentValues, String string2) {
        int n = cursor.getColumnIndex(string2);
        if (n != -1 && !cursor.isNull(n)) {
            contentValues.put(string2, cursor.getInt(n));
        }
    }

    public static void cursorLongToContentValues(Cursor cursor, String string2, ContentValues contentValues) {
        DatabaseUtils.cursorLongToContentValues(cursor, string2, contentValues, string2);
    }

    public static void cursorLongToContentValues(Cursor cursor, String string2, ContentValues contentValues, String string3) {
        int n = cursor.getColumnIndex(string2);
        if (!cursor.isNull(n)) {
            contentValues.put(string3, cursor.getLong(n));
            return;
        }
        contentValues.put(string3, (Long)null);
    }

    public static void cursorLongToContentValuesIfPresent(Cursor cursor, ContentValues contentValues, String string2) {
        int n = cursor.getColumnIndex(string2);
        if (n != -1 && !cursor.isNull(n)) {
            contentValues.put(string2, cursor.getLong(n));
        }
    }

    public static int cursorPickFillWindowStartPosition(int n, int n2) {
        return Math.max(n - n2 / 3, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void cursorRowToContentValues(Cursor cursor, ContentValues contentValues) {
        AbstractWindowedCursor abstractWindowedCursor = cursor instanceof AbstractWindowedCursor ? (AbstractWindowedCursor)cursor : null;
        String[] stringArray = cursor.getColumnNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (abstractWindowedCursor != null && abstractWindowedCursor.isBlob(n2)) {
                contentValues.put(stringArray[n2], cursor.getBlob(n2));
            } else {
                contentValues.put(stringArray[n2], cursor.getString(n2));
            }
            ++n2;
        }
        return;
    }

    public static void cursorShortToContentValuesIfPresent(Cursor cursor, ContentValues contentValues, String string2) {
        int n = cursor.getColumnIndex(string2);
        if (n != -1 && !cursor.isNull(n)) {
            contentValues.put(string2, cursor.getShort(n));
        }
    }

    public static void cursorStringToContentValues(Cursor cursor, String string2, ContentValues contentValues) {
        DatabaseUtils.cursorStringToContentValues(cursor, string2, contentValues, string2);
    }

    public static void cursorStringToContentValues(Cursor cursor, String string2, ContentValues contentValues, String string3) {
        contentValues.put(string3, cursor.getString(cursor.getColumnIndexOrThrow(string2)));
    }

    public static void cursorStringToContentValuesIfPresent(Cursor cursor, ContentValues contentValues, String string2) {
        int n = cursor.getColumnIndex(string2);
        if (n != -1 && !cursor.isNull(n)) {
            contentValues.put(string2, cursor.getString(n));
        }
    }

    public static void cursorStringToInsertHelper(Cursor cursor, String string2, InsertHelper insertHelper, int n) {
        insertHelper.bind(n, cursor.getString(cursor.getColumnIndexOrThrow(string2)));
    }

    public static void dumpCurrentRow(Cursor cursor) {
        DatabaseUtils.dumpCurrentRow(cursor, System.out);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void dumpCurrentRow(Cursor cursor, PrintStream printStream) {
        String[] stringArray = cursor.getColumnNames();
        printStream.println("" + cursor.getPosition() + " {");
        int n = stringArray.length;
        int n2 = 0;
        while (true) {
            String string2;
            if (n2 >= n) {
                printStream.println("}");
                return;
            }
            try {
                String string3;
                string2 = string3 = cursor.getString(n2);
            }
            catch (SQLiteException sQLiteException) {
                string2 = "<unprintable>";
            }
            printStream.println("   " + stringArray[n2] + '=' + string2);
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void dumpCurrentRow(Cursor cursor, StringBuilder stringBuilder) {
        String[] stringArray = cursor.getColumnNames();
        stringBuilder.append("" + cursor.getPosition() + " {\n");
        int n = stringArray.length;
        int n2 = 0;
        while (true) {
            String string2;
            if (n2 >= n) {
                stringBuilder.append("}\n");
                return;
            }
            try {
                String string3;
                string2 = string3 = cursor.getString(n2);
            }
            catch (SQLiteException sQLiteException) {
                string2 = "<unprintable>";
            }
            stringBuilder.append("   " + stringArray[n2] + '=' + string2 + "\n");
            ++n2;
        }
    }

    public static String dumpCurrentRowToString(Cursor cursor) {
        StringBuilder stringBuilder = new StringBuilder();
        DatabaseUtils.dumpCurrentRow(cursor, stringBuilder);
        return stringBuilder.toString();
    }

    public static void dumpCursor(Cursor cursor) {
        DatabaseUtils.dumpCursor(cursor, System.out);
    }

    public static void dumpCursor(Cursor cursor, PrintStream printStream) {
        printStream.println(">>>>> Dumping cursor " + cursor);
        if (cursor != null) {
            int n = cursor.getPosition();
            cursor.moveToPosition(-1);
            while (cursor.moveToNext()) {
                DatabaseUtils.dumpCurrentRow(cursor, printStream);
            }
            cursor.moveToPosition(n);
        }
        printStream.println("<<<<<");
    }

    public static void dumpCursor(Cursor cursor, StringBuilder stringBuilder) {
        stringBuilder.append(">>>>> Dumping cursor " + cursor + "\n");
        if (cursor != null) {
            int n = cursor.getPosition();
            cursor.moveToPosition(-1);
            while (cursor.moveToNext()) {
                DatabaseUtils.dumpCurrentRow(cursor, stringBuilder);
            }
            cursor.moveToPosition(n);
        }
        stringBuilder.append("<<<<<\n");
    }

    public static String dumpCursorToString(Cursor cursor) {
        StringBuilder stringBuilder = new StringBuilder();
        DatabaseUtils.dumpCursor(cursor, stringBuilder);
        return stringBuilder.toString();
    }

    public static int findRowIdColumnIndex(String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals("_id")) continue;
            return i;
        }
        return -1;
    }

    public static String getCollationKey(String string2) {
        byte[] byArray = DatabaseUtils.getCollationKeyInBytes(string2);
        try {
            String string3 = new String(byArray, 0, DatabaseUtils.getKeyLen(byArray), "ISO8859_1");
            return string3;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static byte[] getCollationKeyInBytes(String string2) {
        if (mColl == null) {
            mColl = Collator.getInstance();
            mColl.setStrength(0);
        }
        return mColl.getCollationKey(string2).toByteArray();
    }

    public static String getHexCollationKey(String string2) {
        byte[] byArray = DatabaseUtils.getCollationKeyInBytes(string2);
        return new String(Hex.encodeHex((byte[])byArray), 0, 2 * DatabaseUtils.getKeyLen(byArray));
    }

    private static int getKeyLen(byte[] byArray) {
        if (byArray[-1 + byArray.length] != 0) {
            return byArray.length;
        }
        return -1 + byArray.length;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getSqlStatementType(String string2) {
        block13: {
            block12: {
                String string3 = string2.trim();
                if (string3.length() < 3) break block12;
                String string4 = string3.substring(0, 3).toUpperCase(Locale.ROOT);
                if (string4.equals("SEL")) {
                    return 1;
                }
                if (string4.equals("INS") || string4.equals("UPD") || string4.equals("REP") || string4.equals("DEL")) {
                    return 2;
                }
                if (string4.equals("ATT")) {
                    return 3;
                }
                if (string4.equals("COM")) {
                    return 5;
                }
                if (string4.equals("END")) {
                    return 5;
                }
                if (string4.equals("ROL")) {
                    return 6;
                }
                if (string4.equals("BEG")) {
                    return 4;
                }
                if (string4.equals("PRA")) {
                    return 7;
                }
                if (string4.equals("CRE") || string4.equals("DRO") || string4.equals("ALT")) {
                    return 8;
                }
                if (string4.equals("ANA") || string4.equals("DET")) break block13;
            }
            return 99;
        }
        return 9;
    }

    public static int getTypeOfObject(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof byte[]) {
            return 4;
        }
        if (object instanceof Float || object instanceof Double) {
            return 2;
        }
        if (object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte) {
            return 1;
        }
        return 3;
    }

    public static long longForQuery(SQLiteDatabase sQLiteDatabase, String string2, String[] stringArray) {
        SQLiteStatement sQLiteStatement = sQLiteDatabase.compileStatement(string2);
        try {
            long l = DatabaseUtils.longForQuery(sQLiteStatement, stringArray);
            return l;
        }
        finally {
            sQLiteStatement.close();
        }
    }

    public static long longForQuery(SQLiteStatement sQLiteStatement, String[] stringArray) {
        sQLiteStatement.bindAllArgsAsStrings(stringArray);
        return sQLiteStatement.simpleQueryForLong();
    }

    public static boolean queryIsEmpty(SQLiteDatabase sQLiteDatabase, String string2) {
        return DatabaseUtils.longForQuery(sQLiteDatabase, "select exists(select 1 from " + string2 + ")", null) == 0L;
    }

    public static long queryNumEntries(SQLiteDatabase sQLiteDatabase, String string2) {
        return DatabaseUtils.queryNumEntries(sQLiteDatabase, string2, null, null);
    }

    public static long queryNumEntries(SQLiteDatabase sQLiteDatabase, String string2, String string3) {
        return DatabaseUtils.queryNumEntries(sQLiteDatabase, string2, string3, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long queryNumEntries(SQLiteDatabase sQLiteDatabase, String string2, String string3, String[] stringArray) {
        String string4;
        if (!TextUtils.isEmpty(string3)) {
            string4 = " where " + string3;
            return DatabaseUtils.longForQuery(sQLiteDatabase, "select count(*) from " + string2 + string4, stringArray);
        }
        string4 = "";
        return DatabaseUtils.longForQuery(sQLiteDatabase, "select count(*) from " + string2 + string4, stringArray);
    }

    public static final void readExceptionFromParcel(Parcel parcel) {
        int n = parcel.readExceptionCode();
        if (n == 0) {
            return;
        }
        DatabaseUtils.readExceptionFromParcel(parcel, parcel.readString(), n);
    }

    private static final void readExceptionFromParcel(Parcel parcel, String string2, int n) {
        switch (n) {
            default: {
                parcel.readException(n, string2);
                return;
            }
            case 2: {
                throw new IllegalArgumentException(string2);
            }
            case 3: {
                throw new UnsupportedOperationException(string2);
            }
            case 4: {
                throw new SQLiteAbortException(string2);
            }
            case 5: {
                throw new SQLiteConstraintException(string2);
            }
            case 6: {
                throw new SQLiteDatabaseCorruptException(string2);
            }
            case 7: {
                throw new SQLiteFullException(string2);
            }
            case 8: {
                throw new SQLiteDiskIOException(string2);
            }
            case 9: {
                throw new SQLiteException(string2);
            }
            case 11: 
        }
        throw new OperationCanceledException(string2);
    }

    public static void readExceptionWithFileNotFoundExceptionFromParcel(Parcel parcel) throws FileNotFoundException {
        int n = parcel.readExceptionCode();
        if (n == 0) {
            return;
        }
        String string2 = parcel.readString();
        if (n == 1) {
            throw new FileNotFoundException(string2);
        }
        DatabaseUtils.readExceptionFromParcel(parcel, string2, n);
    }

    public static void readExceptionWithOperationApplicationExceptionFromParcel(Parcel parcel) throws OperationApplicationException {
        int n = parcel.readExceptionCode();
        if (n == 0) {
            return;
        }
        String string2 = parcel.readString();
        if (n == 10) {
            throw new OperationApplicationException(string2);
        }
        DatabaseUtils.readExceptionFromParcel(parcel, string2, n);
    }

    public static String sqlEscapeString(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        DatabaseUtils.appendEscapedSQLString(stringBuilder, string2);
        return stringBuilder.toString();
    }

    public static String stringForQuery(SQLiteDatabase sQLiteDatabase, String string2, String[] stringArray) {
        SQLiteStatement sQLiteStatement = sQLiteDatabase.compileStatement(string2);
        try {
            String string3 = DatabaseUtils.stringForQuery(sQLiteStatement, stringArray);
            return string3;
        }
        finally {
            sQLiteStatement.close();
        }
    }

    public static String stringForQuery(SQLiteStatement sQLiteStatement, String[] stringArray) {
        sQLiteStatement.bindAllArgsAsStrings(stringArray);
        return sQLiteStatement.simpleQueryForString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final void writeExceptionToParcel(Parcel parcel, Exception exception) {
        int n;
        boolean bl = true;
        if (exception instanceof FileNotFoundException) {
            n = 1;
            bl = false;
        } else if (exception instanceof IllegalArgumentException) {
            n = 2;
        } else if (exception instanceof UnsupportedOperationException) {
            n = 3;
        } else if (exception instanceof SQLiteAbortException) {
            n = 4;
        } else if (exception instanceof SQLiteConstraintException) {
            n = 5;
        } else if (exception instanceof SQLiteDatabaseCorruptException) {
            n = 6;
        } else if (exception instanceof SQLiteFullException) {
            n = 7;
        } else if (exception instanceof SQLiteDiskIOException) {
            n = 8;
        } else if (exception instanceof SQLiteException) {
            n = 9;
        } else if (exception instanceof OperationApplicationException) {
            n = 10;
        } else {
            if (!(exception instanceof OperationCanceledException)) {
                parcel.writeException(exception);
                Log.e(TAG, "Writing exception to parcel", exception);
                return;
            }
            n = 11;
            bl = false;
        }
        parcel.writeInt(n);
        parcel.writeString(exception.getMessage());
        if (bl) {
            Log.e(TAG, "Writing exception to parcel", exception);
        }
    }

    @Deprecated
    public static class InsertHelper {
        public static final int TABLE_INFO_PRAGMA_COLUMNNAME_INDEX = 1;
        public static final int TABLE_INFO_PRAGMA_DEFAULT_INDEX = 4;
        private HashMap<String, Integer> mColumns;
        private final SQLiteDatabase mDb;
        private String mInsertSQL = null;
        private SQLiteStatement mInsertStatement = null;
        private SQLiteStatement mPreparedStatement = null;
        private SQLiteStatement mReplaceStatement = null;
        private final String mTableName;

        public InsertHelper(SQLiteDatabase sQLiteDatabase, String string2) {
            this.mDb = sQLiteDatabase;
            this.mTableName = string2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void buildSQL() throws SQLException {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("INSERT INTO ");
            stringBuilder.append(this.mTableName);
            stringBuilder.append(" (");
            StringBuilder stringBuilder2 = new StringBuilder(128);
            stringBuilder2.append("VALUES (");
            int n = 1;
            Cursor cursor = null;
            try {
                cursor = this.mDb.rawQuery("PRAGMA table_info(" + this.mTableName + ")", null);
                this.mColumns = new HashMap(cursor.getCount());
                while (cursor.moveToNext()) {
                    String string2 = cursor.getString(1);
                    String string3 = cursor.getString(4);
                    this.mColumns.put(string2, n);
                    stringBuilder.append("'");
                    stringBuilder.append(string2);
                    stringBuilder.append("'");
                    if (string3 == null) {
                        stringBuilder2.append("?");
                    } else {
                        stringBuilder2.append("COALESCE(?, ");
                        stringBuilder2.append(string3);
                        stringBuilder2.append(")");
                    }
                    String string4 = n == cursor.getCount() ? ") " : ", ";
                    stringBuilder.append(string4);
                    String string5 = n == cursor.getCount() ? ");" : ", ";
                    stringBuilder2.append(string5);
                    ++n;
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            stringBuilder.append(stringBuilder2);
            this.mInsertSQL = stringBuilder.toString();
        }

        private SQLiteStatement getStatement(boolean bl) throws SQLException {
            if (bl) {
                if (this.mReplaceStatement == null) {
                    if (this.mInsertSQL == null) {
                        this.buildSQL();
                    }
                    String string2 = "INSERT OR REPLACE" + this.mInsertSQL.substring(6);
                    this.mReplaceStatement = this.mDb.compileStatement(string2);
                }
                return this.mReplaceStatement;
            }
            if (this.mInsertStatement == null) {
                if (this.mInsertSQL == null) {
                    this.buildSQL();
                }
                this.mInsertStatement = this.mDb.compileStatement(this.mInsertSQL);
            }
            return this.mInsertStatement;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private long insertInternal(ContentValues contentValues, boolean bl) {
            this.mDb.beginTransactionNonExclusive();
            try {
                SQLiteStatement sQLiteStatement;
                try {
                    sQLiteStatement = this.getStatement(bl);
                    sQLiteStatement.clearBindings();
                    for (Map.Entry<String, Object> entry : contentValues.valueSet()) {
                        DatabaseUtils.bindObjectToProgram(sQLiteStatement, this.getColumnIndex(entry.getKey()), entry.getValue());
                    }
                }
                catch (SQLException sQLException) {
                    Log.e(DatabaseUtils.TAG, "Error inserting " + contentValues + " into table  " + this.mTableName, sQLException);
                    return -1L;
                }
                long l = sQLiteStatement.executeInsert();
                this.mDb.setTransactionSuccessful();
                return l;
            }
            finally {
                this.mDb.endTransaction();
            }
        }

        public void bind(int n, double d) {
            this.mPreparedStatement.bindDouble(n, d);
        }

        public void bind(int n, float f) {
            this.mPreparedStatement.bindDouble(n, f);
        }

        public void bind(int n, int n2) {
            this.mPreparedStatement.bindLong(n, n2);
        }

        public void bind(int n, long l) {
            this.mPreparedStatement.bindLong(n, l);
        }

        public void bind(int n, String string2) {
            if (string2 == null) {
                this.mPreparedStatement.bindNull(n);
                return;
            }
            this.mPreparedStatement.bindString(n, string2);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void bind(int n, boolean bl) {
            SQLiteStatement sQLiteStatement = this.mPreparedStatement;
            long l = bl ? 1L : 0L;
            sQLiteStatement.bindLong(n, l);
        }

        public void bind(int n, byte[] byArray) {
            if (byArray == null) {
                this.mPreparedStatement.bindNull(n);
                return;
            }
            this.mPreparedStatement.bindBlob(n, byArray);
        }

        public void bindNull(int n) {
            this.mPreparedStatement.bindNull(n);
        }

        public void close() {
            if (this.mInsertStatement != null) {
                this.mInsertStatement.close();
                this.mInsertStatement = null;
            }
            if (this.mReplaceStatement != null) {
                this.mReplaceStatement.close();
                this.mReplaceStatement = null;
            }
            this.mInsertSQL = null;
            this.mColumns = null;
        }

        public long execute() {
            if (this.mPreparedStatement == null) {
                throw new IllegalStateException("you must prepare this inserter before calling execute");
            }
            try {
                long l = this.mPreparedStatement.executeInsert();
                return l;
            }
            catch (SQLException sQLException) {
                Log.e(DatabaseUtils.TAG, "Error executing InsertHelper with table " + this.mTableName, sQLException);
                return -1L;
            }
            finally {
                this.mPreparedStatement = null;
            }
        }

        public int getColumnIndex(String string2) {
            this.getStatement(false);
            Integer n = this.mColumns.get(string2);
            if (n == null) {
                throw new IllegalArgumentException("column '" + string2 + "' is invalid");
            }
            return n;
        }

        public long insert(ContentValues contentValues) {
            return this.insertInternal(contentValues, false);
        }

        public void prepareForInsert() {
            this.mPreparedStatement = this.getStatement(false);
            this.mPreparedStatement.clearBindings();
        }

        public void prepareForReplace() {
            this.mPreparedStatement = this.getStatement(true);
            this.mPreparedStatement.clearBindings();
        }

        public long replace(ContentValues contentValues) {
            return this.insertInternal(contentValues, true);
        }
    }
}

