/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import java.util.ArrayList;

public abstract class Observable<T> {
    protected final ArrayList<T> mObservers = new ArrayList();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerObserver(T t) {
        if (t == null) {
            throw new IllegalArgumentException("The observer is null.");
        }
        ArrayList<T> arrayList = this.mObservers;
        synchronized (arrayList) {
            if (this.mObservers.contains(t)) {
                throw new IllegalStateException("Observer " + t + " is already registered.");
            }
            this.mObservers.add(t);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterAll() {
        ArrayList<T> arrayList = this.mObservers;
        synchronized (arrayList) {
            this.mObservers.clear();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterObserver(T t) {
        if (t == null) {
            throw new IllegalArgumentException("The observer is null.");
        }
        ArrayList<T> arrayList = this.mObservers;
        synchronized (arrayList) {
            int n = this.mObservers.indexOf(t);
            if (n == -1) {
                throw new IllegalStateException("Observer " + t + " was not registered.");
            }
            this.mObservers.remove(n);
            return;
        }
    }
}

