/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.os.CancellationSignal;
import android.text.TextUtils;
import android.util.Log;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class SQLiteQueryBuilder {
    private static final String TAG = "SQLiteQueryBuilder";
    private static final Pattern sLimitPattern = Pattern.compile("\\s*\\d+\\s*(,\\s*\\d+\\s*)?");
    private boolean mDistinct = false;
    private SQLiteDatabase.CursorFactory mFactory = null;
    private Map<String, String> mProjectionMap = null;
    private boolean mStrict;
    private String mTables = "";
    private StringBuilder mWhereClause = null;

    private static void appendClause(StringBuilder stringBuilder, String string2, String string3) {
        if (!TextUtils.isEmpty(string3)) {
            stringBuilder.append(string2);
            stringBuilder.append(string3);
        }
    }

    public static void appendColumns(StringBuilder stringBuilder, String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            if (string2 == null) continue;
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string2);
        }
        stringBuilder.append(' ');
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String buildQueryString(boolean bl, String string2, String[] stringArray, String string3, String string4, String string5, String string6, String string7) {
        if (TextUtils.isEmpty(string4) && !TextUtils.isEmpty(string5)) {
            throw new IllegalArgumentException("HAVING clauses are only permitted when using a groupBy clause");
        }
        if (!TextUtils.isEmpty(string7) && !sLimitPattern.matcher(string7).matches()) {
            throw new IllegalArgumentException("invalid LIMIT clauses:" + string7);
        }
        StringBuilder stringBuilder = new StringBuilder(120);
        stringBuilder.append("SELECT ");
        if (bl) {
            stringBuilder.append("DISTINCT ");
        }
        if (stringArray != null && stringArray.length != 0) {
            SQLiteQueryBuilder.appendColumns(stringBuilder, stringArray);
        } else {
            stringBuilder.append("* ");
        }
        stringBuilder.append("FROM ");
        stringBuilder.append(string2);
        SQLiteQueryBuilder.appendClause(stringBuilder, " WHERE ", string3);
        SQLiteQueryBuilder.appendClause(stringBuilder, " GROUP BY ", string4);
        SQLiteQueryBuilder.appendClause(stringBuilder, " HAVING ", string5);
        SQLiteQueryBuilder.appendClause(stringBuilder, " ORDER BY ", string6);
        SQLiteQueryBuilder.appendClause(stringBuilder, " LIMIT ", string7);
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private String[] computeProjection(String[] stringArray) {
        String[] stringArray2;
        if (stringArray == null || stringArray.length <= 0) {
            if (this.mProjectionMap == null) {
                return null;
            }
            Set<Map.Entry<String, String>> set = this.mProjectionMap.entrySet();
            stringArray2 = new String[set.size()];
            Iterator<Map.Entry<String, String>> iterator = set.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                if (entry.getKey().equals("_count")) continue;
                int n2 = n + 1;
                stringArray2[n] = entry.getValue();
                n = n2;
            }
            return stringArray2;
        }
        if (this.mProjectionMap == null) return stringArray;
        stringArray2 = new String[stringArray.length];
        int n = stringArray.length;
        int n3 = 0;
        while (n3 < n) {
            String string2 = stringArray[n3];
            String string3 = this.mProjectionMap.get(string2);
            if (string3 != null) {
                stringArray2[n3] = string3;
            } else {
                if (this.mStrict) throw new IllegalArgumentException("Invalid column " + stringArray[n3]);
                if (!string2.contains(" AS ")) {
                    if (!string2.contains(" as ")) throw new IllegalArgumentException("Invalid column " + stringArray[n3]);
                }
                stringArray2[n3] = string2;
            }
            ++n3;
        }
        return stringArray2;
    }

    private void validateQuerySql(SQLiteDatabase sQLiteDatabase, String string2, CancellationSignal cancellationSignal) {
        sQLiteDatabase.getThreadSession().prepare(string2, sQLiteDatabase.getThreadDefaultConnectionFlags(true), cancellationSignal, null);
    }

    public void appendWhere(CharSequence charSequence) {
        if (this.mWhereClause == null) {
            this.mWhereClause = new StringBuilder(16 + charSequence.length());
        }
        if (this.mWhereClause.length() == 0) {
            this.mWhereClause.append('(');
        }
        this.mWhereClause.append(charSequence);
    }

    public void appendWhereEscapeString(String string2) {
        if (this.mWhereClause == null) {
            this.mWhereClause = new StringBuilder(16 + string2.length());
        }
        if (this.mWhereClause.length() == 0) {
            this.mWhereClause.append('(');
        }
        DatabaseUtils.appendEscapedSQLString(this.mWhereClause, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String buildQuery(String[] stringArray, String string2, String string3, String string4, String string5, String string6) {
        String[] stringArray2 = this.computeProjection(stringArray);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = this.mWhereClause != null && this.mWhereClause.length() > 0;
        if (bl) {
            stringBuilder.append(this.mWhereClause.toString());
            stringBuilder.append(')');
        }
        if (string2 != null && string2.length() > 0) {
            if (bl) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append('(');
            stringBuilder.append(string2);
            stringBuilder.append(')');
        }
        return SQLiteQueryBuilder.buildQueryString(this.mDistinct, this.mTables, stringArray2, stringBuilder.toString(), string3, string4, string5, string6);
    }

    @Deprecated
    public String buildQuery(String[] stringArray, String string2, String[] stringArray2, String string3, String string4, String string5, String string6) {
        return this.buildQuery(stringArray, string2, string3, string4, string5, string6);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String buildUnionQuery(String[] stringArray, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(128);
        int n = stringArray.length;
        String string4 = this.mDistinct ? " UNION " : " UNION ALL ";
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                SQLiteQueryBuilder.appendClause(stringBuilder, " ORDER BY ", string2);
                SQLiteQueryBuilder.appendClause(stringBuilder, " LIMIT ", string3);
                return stringBuilder.toString();
            }
            if (n2 > 0) {
                stringBuilder.append(string4);
            }
            stringBuilder.append(stringArray[n2]);
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public String buildUnionSubQuery(String string2, String[] stringArray, Set<String> set, int n, String string3, String string4, String string5, String string6) {
        int n2 = stringArray.length;
        String[] stringArray2 = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            String string7 = stringArray[n3];
            stringArray2[n3] = string7.equals(string2) ? "'" + string3 + "' AS " + string2 : (n3 <= n || set.contains(string7) ? string7 : "NULL AS " + string7);
            ++n3;
        }
        return this.buildQuery(stringArray2, string4, string5, string6, null, null);
    }

    @Deprecated
    public String buildUnionSubQuery(String string2, String[] stringArray, Set<String> set, int n, String string3, String string4, String[] stringArray2, String string5, String string6) {
        return this.buildUnionSubQuery(string2, stringArray, set, n, string3, string4, string5, string6);
    }

    public String getTables() {
        return this.mTables;
    }

    public Cursor query(SQLiteDatabase sQLiteDatabase, String[] stringArray, String string2, String[] stringArray2, String string3, String string4, String string5) {
        return this.query(sQLiteDatabase, stringArray, string2, stringArray2, string3, string4, string5, null, null);
    }

    public Cursor query(SQLiteDatabase sQLiteDatabase, String[] stringArray, String string2, String[] stringArray2, String string3, String string4, String string5, String string6) {
        return this.query(sQLiteDatabase, stringArray, string2, stringArray2, string3, string4, string5, string6, null);
    }

    public Cursor query(SQLiteDatabase sQLiteDatabase, String[] stringArray, String string2, String[] stringArray2, String string3, String string4, String string5, String string6, CancellationSignal cancellationSignal) {
        if (this.mTables == null) {
            return null;
        }
        if (this.mStrict && string2 != null && string2.length() > 0) {
            this.validateQuerySql(sQLiteDatabase, this.buildQuery(stringArray, "(" + string2 + ")", string3, string4, string5, string6), cancellationSignal);
        }
        String string7 = this.buildQuery(stringArray, string2, string3, string4, string5, string6);
        if (Log.isLoggable(TAG, 3)) {
            Log.d(TAG, "Performing query: " + string7);
        }
        return sQLiteDatabase.rawQueryWithFactory(this.mFactory, string7, stringArray2, SQLiteDatabase.findEditTable(this.mTables), cancellationSignal);
    }

    public void setCursorFactory(SQLiteDatabase.CursorFactory cursorFactory) {
        this.mFactory = cursorFactory;
    }

    public void setDistinct(boolean bl) {
        this.mDistinct = bl;
    }

    public void setProjectionMap(Map<String, String> map) {
        this.mProjectionMap = map;
    }

    public void setStrict(boolean bl) {
        this.mStrict = bl;
    }

    public void setTables(String string2) {
        this.mTables = string2;
    }
}

