/*
 * Decompiled with CFR 0.152.
 */
package android.ddm;

import android.opengl.GLUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewDebug;
import android.view.WindowManagerGlobal;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;

public class DdmHandleViewDebug
extends ChunkHandler {
    public static final int CHUNK_VUGL = 0;
    private static final int CHUNK_VULW = 0;
    private static final int CHUNK_VUOP = 0;
    private static final int CHUNK_VURT = 0;
    private static final int ERR_EXCEPTION = -3;
    private static final int ERR_INVALID_OP = -1;
    private static final int ERR_INVALID_PARAM = -2;
    private static final String TAG = "DdmViewDebug";
    private static final int VUOP_CAPTURE_VIEW = 1;
    private static final int VUOP_DUMP_DISPLAYLIST = 2;
    private static final int VUOP_INVOKE_VIEW_METHOD = 4;
    private static final int VUOP_PROFILE_VIEW = 3;
    private static final int VUOP_SET_LAYOUT_PARAMETER = 5;
    private static final int VURT_CAPTURE_LAYERS = 2;
    private static final int VURT_DUMP_HIERARCHY = 1;
    private static final int VURT_DUMP_THEME = 3;
    private static final DdmHandleViewDebug sInstance;

    static {
        CHUNK_VUGL = DdmHandleViewDebug.type((String)"VUGL");
        CHUNK_VULW = DdmHandleViewDebug.type((String)"VULW");
        CHUNK_VURT = DdmHandleViewDebug.type((String)"VURT");
        CHUNK_VUOP = DdmHandleViewDebug.type((String)"VUOP");
        sInstance = new DdmHandleViewDebug();
    }

    private DdmHandleViewDebug() {
    }

    private Chunk captureLayers(View view) {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            ViewDebug.captureLayers(view, dataOutputStream);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            Chunk chunk = DdmHandleViewDebug.createFailChunk((int)1, (String)("Unexpected error while obtaining view hierarchy: " + iOException.getMessage()));
            return chunk;
        }
        finally {
            dataOutputStream.close();
        }
        return new Chunk(CHUNK_VURT, byArray, 0, byArray.length);
    }

    private Chunk captureView(View view, View view2) {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        try {
            ViewDebug.capture(view, (OutputStream)byteArrayOutputStream, view2);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return DdmHandleViewDebug.createFailChunk((int)1, (String)("Unexpected error while capturing view: " + iOException.getMessage()));
        }
        return new Chunk(CHUNK_VUOP, byArray, 0, byArray.length);
    }

    private Chunk dumpDisplayLists(final View view, final View view2) {
        view.post(new Runnable(){

            @Override
            public void run() {
                ViewDebug.outputDisplayList(view, view2);
            }
        });
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Chunk dumpHierarchy(View view, ByteBuffer byteBuffer) {
        boolean bl = byteBuffer.getInt() > 0;
        boolean bl2 = byteBuffer.getInt() > 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        try {
            ViewDebug.dump(view, bl, bl2, byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return new Chunk(CHUNK_VURT, byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            return DdmHandleViewDebug.createFailChunk((int)1, (String)("Unexpected error while obtaining view hierarchy: " + iOException.getMessage()));
        }
    }

    private Chunk dumpTheme(View view) {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        try {
            ViewDebug.dumpTheme(view, byteArrayOutputStream);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return DdmHandleViewDebug.createFailChunk((int)1, (String)("Unexpected error while dumping the theme: " + iOException.getMessage()));
        }
        return new Chunk(CHUNK_VURT, byArray, 0, byArray.length);
    }

    private View getRootView(ByteBuffer byteBuffer) {
        try {
            String string2 = DdmHandleViewDebug.getString((ByteBuffer)byteBuffer, (int)byteBuffer.getInt());
            View view = WindowManagerGlobal.getInstance().getRootView(string2);
            return view;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            return null;
        }
    }

    private View getTargetView(View view, ByteBuffer byteBuffer) {
        String string2;
        try {
            string2 = DdmHandleViewDebug.getString((ByteBuffer)byteBuffer, (int)byteBuffer.getInt());
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            return null;
        }
        return ViewDebug.findView(view, string2);
    }

    private Chunk handleOpenGlTrace(Chunk chunk) {
        GLUtils.setTracingLevel(DdmHandleViewDebug.wrapChunk((Chunk)chunk).getInt());
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private Chunk invokeViewMethod(View var1_1, View var2_2, ByteBuffer var3_3) {
        var4_4 = DdmHandleViewDebug.getString((ByteBuffer)var3_3, (int)var3_3.getInt());
        if (!var3_3.hasRemaining()) {
            var5_5 = new Class[]{};
            var6_6 = new Object[]{};
            while (true) {
                var9_7 = var2_2.getClass().getMethod(var4_4, var5_5);
                ViewDebug.invokeViewMethod(var2_2, var9_7, var6_6);
                return null;
                break;
            }
        }
        var14_8 = var3_3.getInt();
        var5_5 = new Class[var14_8];
        var6_6 = new Object[var14_8];
        var15_9 = 0;
        block15: while (true) {
            if (var15_9 >= var14_8) ** continue;
            var16_10 = var3_3.getChar();
            switch (var16_10) {
                default: {
                    Log.e("DdmViewDebug", "arg " + var15_9 + ", unrecognized type: " + var16_10);
                    return DdmHandleViewDebug.createFailChunk((int)-2, (String)("Unsupported parameter type (" + var16_10 + ") to invoke view method."));
                }
                case 'Z': {
                    var5_5[var15_9] = Boolean.TYPE;
                    if (var3_3.get() == 0) {
                        var17_11 = false;
lbl28:
                        // 2 sources

                        while (true) {
                            var6_6[var15_9] = var17_11;
lbl30:
                            // 8 sources

                            while (true) {
                                ++var15_9;
                                continue block15;
                                break;
                            }
                            break;
                        }
                    }
                    var17_11 = true;
                    ** continue;
                }
                case 'B': {
                    var5_5[var15_9] = Byte.TYPE;
                    var6_6[var15_9] = var3_3.get();
                    ** GOTO lbl30
                }
                case 'C': {
                    var5_5[var15_9] = Character.TYPE;
                    var6_6[var15_9] = Character.valueOf(var3_3.getChar());
                    ** GOTO lbl30
                }
                case 'S': {
                    var5_5[var15_9] = Short.TYPE;
                    var6_6[var15_9] = var3_3.getShort();
                    ** GOTO lbl30
                }
                case 'I': {
                    var5_5[var15_9] = Integer.TYPE;
                    var6_6[var15_9] = var3_3.getInt();
                    ** GOTO lbl30
                }
                case 'J': {
                    var5_5[var15_9] = Long.TYPE;
                    var6_6[var15_9] = var3_3.getLong();
                    ** GOTO lbl30
                }
                case 'F': {
                    var5_5[var15_9] = Float.TYPE;
                    var6_6[var15_9] = Float.valueOf(var3_3.getFloat());
                    ** GOTO lbl30
                }
                case 'D': 
            }
            break;
        }
        var5_5[var15_9] = Double.TYPE;
        var6_6[var15_9] = var3_3.getDouble();
        ** while (true)
        catch (NoSuchMethodException var7_12) {
            Log.e("DdmViewDebug", "No such method: " + var7_12.getMessage());
            return DdmHandleViewDebug.createFailChunk((int)-2, (String)("No such method: " + var7_12.getMessage()));
        }
        catch (Exception var10_13) {
            Log.e("DdmViewDebug", "Exception while invoking method: " + var10_13.getCause().getMessage());
            var12_14 = var10_13.getCause().getMessage();
            if (var12_14 == null) {
                var12_14 = var10_13.getCause().toString();
            }
            return DdmHandleViewDebug.createFailChunk((int)-3, (String)var12_14);
        }
    }

    private Chunk listWindows() {
        String[] stringArray = WindowManagerGlobal.getInstance().getViewRootNames();
        int n = 4;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string2 = stringArray[i];
            n = n + 4 + 2 * string2.length();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.order(ChunkHandler.CHUNK_ORDER);
        byteBuffer.putInt(stringArray.length);
        for (String string3 : stringArray) {
            byteBuffer.putInt(string3.length());
            DdmHandleViewDebug.putString((ByteBuffer)byteBuffer, (String)string3);
        }
        return new Chunk(CHUNK_VULW, byteBuffer);
    }

    private Chunk profileView(View view, View view2) {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(32768);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(byteArrayOutputStream), 32768);
        try {
            ViewDebug.profileViewAndChildren(view2, bufferedWriter);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            Chunk chunk = DdmHandleViewDebug.createFailChunk((int)1, (String)("Unexpected error while profiling view: " + iOException.getMessage()));
            return chunk;
        }
        finally {
            bufferedWriter.close();
        }
        return new Chunk(CHUNK_VUOP, byArray, 0, byArray.length);
    }

    public static void register() {
        DdmServer.registerHandler((int)CHUNK_VUGL, (ChunkHandler)sInstance);
        DdmServer.registerHandler((int)CHUNK_VULW, (ChunkHandler)sInstance);
        DdmServer.registerHandler((int)CHUNK_VURT, (ChunkHandler)sInstance);
        DdmServer.registerHandler((int)CHUNK_VUOP, (ChunkHandler)sInstance);
    }

    private Chunk setLayoutParameter(View view, View view2, ByteBuffer byteBuffer) {
        String string2 = DdmHandleViewDebug.getString((ByteBuffer)byteBuffer, (int)byteBuffer.getInt());
        int n = byteBuffer.getInt();
        try {
            ViewDebug.setLayoutParameter(view2, string2, n);
            return null;
        }
        catch (Exception exception) {
            Log.e(TAG, "Exception setting layout parameter: " + exception);
            return DdmHandleViewDebug.createFailChunk((int)-3, (String)("Error accessing field " + string2 + ":" + exception.getMessage()));
        }
    }

    public void connected() {
    }

    public void disconnected() {
    }

    public Chunk handleChunk(Chunk chunk) {
        int n = chunk.type;
        if (n == CHUNK_VUGL) {
            return this.handleOpenGlTrace(chunk);
        }
        if (n == CHUNK_VULW) {
            return this.listWindows();
        }
        ByteBuffer byteBuffer = DdmHandleViewDebug.wrapChunk((Chunk)chunk);
        int n2 = byteBuffer.getInt();
        View view = this.getRootView(byteBuffer);
        if (view == null) {
            return DdmHandleViewDebug.createFailChunk((int)-2, (String)"Invalid View Root");
        }
        if (n == CHUNK_VURT) {
            if (n2 == 1) {
                return this.dumpHierarchy(view, byteBuffer);
            }
            if (n2 == 2) {
                return this.captureLayers(view);
            }
            if (n2 == 3) {
                return this.dumpTheme(view);
            }
            return DdmHandleViewDebug.createFailChunk((int)-1, (String)("Unknown view root operation: " + n2));
        }
        View view2 = this.getTargetView(view, byteBuffer);
        if (view2 == null) {
            return DdmHandleViewDebug.createFailChunk((int)-2, (String)"Invalid target view");
        }
        if (n == CHUNK_VUOP) {
            switch (n2) {
                default: {
                    return DdmHandleViewDebug.createFailChunk((int)-1, (String)("Unknown view operation: " + n2));
                }
                case 1: {
                    return this.captureView(view, view2);
                }
                case 2: {
                    return this.dumpDisplayLists(view, view2);
                }
                case 3: {
                    return this.profileView(view, view2);
                }
                case 4: {
                    return this.invokeViewMethod(view, view2, byteBuffer);
                }
                case 5: 
            }
            return this.setLayoutParameter(view, view2, byteBuffer);
        }
        throw new RuntimeException("Unknown packet " + ChunkHandler.name((int)n));
    }
}

