/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.content.Context;
import android.filterfw.core.GLEnvironment;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;

public class FilterSurfaceView
extends SurfaceView
implements SurfaceHolder.Callback {
    private static int STATE_ALLOCATED = 0;
    private static int STATE_CREATED = 1;
    private static int STATE_INITIALIZED = 2;
    private int mFormat;
    private GLEnvironment mGLEnv;
    private int mHeight;
    private SurfaceHolder.Callback mListener;
    private int mState = STATE_ALLOCATED;
    private int mSurfaceId = -1;
    private int mWidth;

    public FilterSurfaceView(Context context) {
        super(context);
        this.getHolder().addCallback(this);
    }

    public FilterSurfaceView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.getHolder().addCallback(this);
    }

    private void registerSurface() {
        this.mSurfaceId = this.mGLEnv.registerSurface(this.getHolder().getSurface());
        if (this.mSurfaceId < 0) {
            throw new RuntimeException("Could not register Surface: " + this.getHolder().getSurface() + " in FilterSurfaceView!");
        }
    }

    private void unregisterSurface() {
        if (this.mGLEnv != null && this.mSurfaceId > 0) {
            this.mGLEnv.unregisterSurfaceId(this.mSurfaceId);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void bindToListener(SurfaceHolder.Callback callback, GLEnvironment gLEnvironment) {
        synchronized (this) {
            if (callback == null) {
                throw new NullPointerException("Attempting to bind null filter to SurfaceView!");
            }
            if (this.mListener != null && this.mListener != callback) {
                throw new RuntimeException("Attempting to bind filter " + callback + " to SurfaceView with another open " + "filter " + this.mListener + " attached already!");
            }
            this.mListener = callback;
            if (this.mGLEnv != null && this.mGLEnv != gLEnvironment) {
                this.mGLEnv.unregisterSurfaceId(this.mSurfaceId);
            }
            this.mGLEnv = gLEnvironment;
            if (this.mState >= STATE_CREATED) {
                this.registerSurface();
                this.mListener.surfaceCreated(this.getHolder());
                if (this.mState == STATE_INITIALIZED) {
                    this.mListener.surfaceChanged(this.getHolder(), this.mFormat, this.mWidth, this.mHeight);
                }
            }
            return;
        }
    }

    public GLEnvironment getGLEnv() {
        synchronized (this) {
            GLEnvironment gLEnvironment = this.mGLEnv;
            return gLEnvironment;
        }
    }

    public int getSurfaceId() {
        synchronized (this) {
            int n = this.mSurfaceId;
            return n;
        }
    }

    @Override
    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        synchronized (this) {
            this.mFormat = n;
            this.mWidth = n2;
            this.mHeight = n3;
            this.mState = STATE_INITIALIZED;
            if (this.mListener != null) {
                this.mListener.surfaceChanged(surfaceHolder, n, n2, n3);
            }
            return;
        }
    }

    @Override
    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        synchronized (this) {
            this.mState = STATE_CREATED;
            if (this.mGLEnv != null) {
                this.registerSurface();
            }
            if (this.mListener != null) {
                this.mListener.surfaceCreated(surfaceHolder);
            }
            return;
        }
    }

    @Override
    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        synchronized (this) {
            this.mState = STATE_ALLOCATED;
            if (this.mListener != null) {
                this.mListener.surfaceDestroyed(surfaceHolder);
            }
            this.unregisterSurface();
            return;
        }
    }

    public void unbind() {
        synchronized (this) {
            this.mListener = null;
            return;
        }
    }
}

