/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterGraph;
import android.filterfw.core.RoundRobinScheduler;
import android.util.Log;
import java.util.HashMap;

public class OneShotScheduler
extends RoundRobinScheduler {
    private static final String TAG = "OneShotScheduler";
    private final boolean mLogVerbose;
    private HashMap<String, Integer> scheduled = new HashMap();

    public OneShotScheduler(FilterGraph filterGraph) {
        super(filterGraph);
        this.mLogVerbose = Log.isLoggable(TAG, 2);
    }

    @Override
    public void reset() {
        super.reset();
        this.scheduled.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Filter scheduleNextNode() {
        Filter filter = null;
        while (true) {
            Filter filter2;
            if ((filter2 = super.scheduleNextNode()) == null) {
                if (!this.mLogVerbose) return null;
                Log.v(TAG, "No filters available to run.");
                return null;
            }
            if (!this.scheduled.containsKey(filter2.getName())) {
                if (filter2.getNumberOfConnectedInputs() == 0) {
                    this.scheduled.put(filter2.getName(), 1);
                }
                if (!this.mLogVerbose) return filter2;
                Log.v(TAG, "Scheduling filter \"" + filter2.getName() + "\" of type " + filter2.getFilterClassName());
                return filter2;
            }
            if (filter == filter2) {
                if (!this.mLogVerbose) return null;
                Log.v(TAG, "One pass through graph completed.");
                return null;
            }
            if (filter != null) continue;
            filter = filter2;
        }
    }
}

