/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.FrameManager;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.format.ObjectFormat;
import android.graphics.Bitmap;
import java.nio.ByteBuffer;

public class SimpleFrame
extends Frame {
    private Object mObject;

    SimpleFrame(FrameFormat frameFormat, FrameManager frameManager) {
        super(frameFormat, frameManager);
        this.initWithFormat(frameFormat);
        this.setReusable(false);
    }

    private void initWithFormat(FrameFormat frameFormat) {
        int n = frameFormat.getLength();
        switch (frameFormat.getBaseType()) {
            default: {
                this.mObject = null;
                return;
            }
            case 2: {
                this.mObject = new byte[n];
                return;
            }
            case 3: {
                this.mObject = new short[n];
                return;
            }
            case 4: {
                this.mObject = new int[n];
                return;
            }
            case 5: {
                this.mObject = new float[n];
                return;
            }
            case 6: 
        }
        this.mObject = new double[n];
    }

    private void setFormatObjectClass(Class clazz) {
        MutableFrameFormat mutableFrameFormat = this.getFormat().mutableCopy();
        mutableFrameFormat.setObjectClass(clazz);
        this.setFormat(mutableFrameFormat);
    }

    static SimpleFrame wrapObject(Object object, FrameManager frameManager) {
        SimpleFrame simpleFrame = new SimpleFrame(ObjectFormat.fromObject(object, 1), frameManager);
        simpleFrame.setObjectValue(object);
        return simpleFrame;
    }

    @Override
    public Bitmap getBitmap() {
        if (this.mObject instanceof Bitmap) {
            return (Bitmap)this.mObject;
        }
        return null;
    }

    @Override
    public ByteBuffer getData() {
        if (this.mObject instanceof ByteBuffer) {
            return (ByteBuffer)this.mObject;
        }
        return null;
    }

    @Override
    public float[] getFloats() {
        if (this.mObject instanceof float[]) {
            return (float[])this.mObject;
        }
        return null;
    }

    @Override
    public int[] getInts() {
        if (this.mObject instanceof int[]) {
            return (int[])this.mObject;
        }
        return null;
    }

    @Override
    public Object getObjectValue() {
        return this.mObject;
    }

    @Override
    protected boolean hasNativeAllocation() {
        return false;
    }

    @Override
    protected void releaseNativeAllocation() {
    }

    @Override
    public void setBitmap(Bitmap bitmap) {
        this.assertFrameMutable();
        this.setGenericObjectValue(bitmap);
    }

    @Override
    public void setData(ByteBuffer byteBuffer, int n, int n2) {
        this.assertFrameMutable();
        this.setGenericObjectValue(ByteBuffer.wrap(byteBuffer.array(), n, n2));
    }

    @Override
    public void setFloats(float[] fArray) {
        this.assertFrameMutable();
        this.setGenericObjectValue(fArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void setGenericObjectValue(Object object) {
        FrameFormat frameFormat = this.getFormat();
        if (frameFormat.getObjectClass() == null) {
            this.setFormatObjectClass(object.getClass());
        } else if (!frameFormat.getObjectClass().isAssignableFrom(object.getClass())) {
            throw new RuntimeException("Attempting to set object value of type '" + object.getClass() + "' on " + "SimpleFrame of type '" + frameFormat.getObjectClass() + "'!");
        }
        this.mObject = object;
    }

    @Override
    public void setInts(int[] nArray) {
        this.assertFrameMutable();
        this.setGenericObjectValue(nArray);
    }

    public String toString() {
        return "SimpleFrame (" + this.getFormat() + ")";
    }
}

