/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.format;

import android.filterfw.core.MutableFrameFormat;
import android.graphics.Bitmap;

public class ImageFormat {
    public static final int COLORSPACE_GRAY = 1;
    public static final String COLORSPACE_KEY = "colorspace";
    public static final int COLORSPACE_RGB = 2;
    public static final int COLORSPACE_RGBA = 3;
    public static final int COLORSPACE_YUV = 4;

    public static int bytesPerSampleForColorspace(int n) {
        int n2 = 3;
        switch (n) {
            default: {
                throw new RuntimeException("Unknown colorspace id " + n + "!");
            }
            case 1: {
                n2 = 1;
            }
            case 2: 
            case 4: {
                return n2;
            }
            case 3: 
        }
        return 4;
    }

    public static MutableFrameFormat create(int n) {
        return ImageFormat.create(0, 0, n, ImageFormat.bytesPerSampleForColorspace(n), 0);
    }

    public static MutableFrameFormat create(int n, int n2) {
        return ImageFormat.create(0, 0, n, ImageFormat.bytesPerSampleForColorspace(n), n2);
    }

    public static MutableFrameFormat create(int n, int n2, int n3, int n4) {
        return ImageFormat.create(n, n2, n3, ImageFormat.bytesPerSampleForColorspace(n3), n4);
    }

    public static MutableFrameFormat create(int n, int n2, int n3, int n4, int n5) {
        MutableFrameFormat mutableFrameFormat = new MutableFrameFormat(2, n5);
        mutableFrameFormat.setDimensions(n, n2);
        mutableFrameFormat.setBytesPerSample(n4);
        mutableFrameFormat.setMetaValue(COLORSPACE_KEY, n3);
        if (n5 == 1) {
            mutableFrameFormat.setObjectClass(Bitmap.class);
        }
        return mutableFrameFormat;
    }
}

