/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.io;

import android.content.Context;
import android.filterfw.core.FilterGraph;
import android.filterfw.core.KeyValueMap;
import android.filterfw.io.GraphIOException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;

public abstract class GraphReader {
    protected KeyValueMap mReferences = new KeyValueMap();

    public void addReference(String string2, Object object) {
        this.mReferences.put(string2, object);
    }

    public void addReferencesByKeysAndValues(Object ... objectArray) {
        this.mReferences.setKeyValues(objectArray);
    }

    public void addReferencesByMap(KeyValueMap keyValueMap) {
        this.mReferences.putAll(keyValueMap);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FilterGraph readGraphResource(Context context, int n) throws GraphIOException {
        InputStreamReader inputStreamReader = new InputStreamReader(context.getResources().openRawResource(n));
        StringWriter stringWriter = new StringWriter();
        char[] cArray = new char[1024];
        try {
            int n2;
            while ((n2 = inputStreamReader.read(cArray, 0, 1024)) > 0) {
                stringWriter.write(cArray, 0, n2);
            }
            return this.readGraphString(stringWriter.toString());
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not read specified resource file!");
        }
    }

    public abstract FilterGraph readGraphString(String var1) throws GraphIOException;

    public abstract KeyValueMap readKeyValueAssignments(String var1) throws GraphIOException;
}

