/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.base;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.GenerateFieldPort;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class OutputStreamTarget
extends Filter {
    @GenerateFieldPort(name="stream")
    private OutputStream mOutputStream;

    public OutputStreamTarget(String string2) {
        super(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void process(FilterContext filterContext) {
        Frame frame = this.pullInput("data");
        ByteBuffer byteBuffer = frame.getFormat().getObjectClass() == String.class ? ByteBuffer.wrap(((String)frame.getObjectValue()).getBytes()) : frame.getData();
        try {
            this.mOutputStream.write(byteBuffer.array(), 0, byteBuffer.limit());
            this.mOutputStream.flush();
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException("OutputStreamTarget: Could not write to stream: " + iOException.getMessage() + "!");
        }
    }

    @Override
    public void setupPorts() {
        this.addInputPort("data");
    }
}

