/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.Program;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;

public class ImageSlicer
extends Filter {
    private int mInputHeight;
    private int mInputWidth;
    private Frame mOriginalFrame;
    private int mOutputHeight;
    private int mOutputWidth;
    @GenerateFieldPort(name="padSize")
    private int mPadSize;
    private Program mProgram;
    private int mSliceHeight;
    private int mSliceIndex = 0;
    private int mSliceWidth;
    @GenerateFieldPort(name="xSlices")
    private int mXSlices;
    @GenerateFieldPort(name="ySlices")
    private int mYSlices;

    public ImageSlicer(String string2) {
        super(string2);
    }

    private void calcOutputFormatForInput(Frame frame) {
        this.mInputWidth = frame.getFormat().getWidth();
        this.mInputHeight = frame.getFormat().getHeight();
        this.mSliceWidth = (-1 + (this.mInputWidth + this.mXSlices)) / this.mXSlices;
        this.mSliceHeight = (-1 + (this.mInputHeight + this.mYSlices)) / this.mYSlices;
        this.mOutputWidth = this.mSliceWidth + 2 * this.mPadSize;
        this.mOutputHeight = this.mSliceHeight + 2 * this.mPadSize;
    }

    @Override
    public FrameFormat getOutputFormat(String string2, FrameFormat frameFormat) {
        return frameFormat;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void process(FilterContext filterContext) {
        if (this.mSliceIndex == 0) {
            this.mOriginalFrame = this.pullInput("image");
            this.calcOutputFormatForInput(this.mOriginalFrame);
        }
        MutableFrameFormat mutableFrameFormat = this.mOriginalFrame.getFormat().mutableCopy();
        mutableFrameFormat.setDimensions(this.mOutputWidth, this.mOutputHeight);
        Frame frame = filterContext.getFrameManager().newFrame(mutableFrameFormat);
        if (this.mProgram == null) {
            this.mProgram = ShaderProgram.createIdentity(filterContext);
        }
        int n = this.mSliceIndex % this.mXSlices;
        int n2 = this.mSliceIndex / this.mXSlices;
        float f = (float)(n * this.mSliceWidth - this.mPadSize) / (float)this.mInputWidth;
        float f2 = (float)(n2 * this.mSliceHeight - this.mPadSize) / (float)this.mInputHeight;
        ((ShaderProgram)this.mProgram).setSourceRect(f, f2, (float)this.mOutputWidth / (float)this.mInputWidth, (float)this.mOutputHeight / (float)this.mInputHeight);
        this.mProgram.process(this.mOriginalFrame, frame);
        this.mSliceIndex = 1 + this.mSliceIndex;
        if (this.mSliceIndex == this.mXSlices * this.mYSlices) {
            this.mSliceIndex = 0;
            this.mOriginalFrame.release();
            this.setWaitsOnInputPort("image", true);
        } else {
            this.mOriginalFrame.retain();
            this.setWaitsOnInputPort("image", false);
        }
        this.pushOutput("image", frame);
        frame.release();
    }

    @Override
    public void setupPorts() {
        this.addMaskedInputPort("image", ImageFormat.create(3, 3));
        this.addOutputBasedOnInput("image", "image");
    }
}

