/*
 * Decompiled with CFR 0.152.
 */
package android.gesture;

import android.gesture.Gesture;
import android.gesture.GestureUtils;
import android.gesture.Instance;
import android.gesture.InstanceLearner;
import android.gesture.Learner;
import android.gesture.Prediction;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class GestureStore {
    private static final short FILE_FORMAT_VERSION = 1;
    public static final int ORIENTATION_INVARIANT = 1;
    public static final int ORIENTATION_SENSITIVE = 2;
    static final int ORIENTATION_SENSITIVE_4 = 4;
    static final int ORIENTATION_SENSITIVE_8 = 8;
    private static final boolean PROFILE_LOADING_SAVING = false;
    public static final int SEQUENCE_INVARIANT = 1;
    public static final int SEQUENCE_SENSITIVE = 2;
    private boolean mChanged = false;
    private Learner mClassifier;
    private final HashMap<String, ArrayList<Gesture>> mNamedGestures = new HashMap();
    private int mOrientationStyle = 2;
    private int mSequenceType = 2;

    public GestureStore() {
        this.mClassifier = new InstanceLearner();
    }

    private void readFormatV1(DataInputStream dataInputStream) throws IOException {
        Learner learner = this.mClassifier;
        HashMap<String, ArrayList<Gesture>> hashMap = this.mNamedGestures;
        hashMap.clear();
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            String string2 = dataInputStream.readUTF();
            int n2 = dataInputStream.readInt();
            ArrayList<Gesture> arrayList = new ArrayList<Gesture>(n2);
            for (int j = 0; j < n2; ++j) {
                Gesture gesture = Gesture.deserialize(dataInputStream);
                arrayList.add(gesture);
                learner.addInstance(Instance.createInstance(this.mSequenceType, this.mOrientationStyle, gesture, string2));
            }
            hashMap.put(string2, arrayList);
        }
    }

    public void addGesture(String string2, Gesture gesture) {
        if (string2 == null || string2.length() == 0) {
            return;
        }
        ArrayList<Gesture> arrayList = this.mNamedGestures.get(string2);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.mNamedGestures.put(string2, arrayList);
        }
        arrayList.add(gesture);
        this.mClassifier.addInstance(Instance.createInstance(this.mSequenceType, this.mOrientationStyle, gesture, string2));
        this.mChanged = true;
    }

    public Set<String> getGestureEntries() {
        return this.mNamedGestures.keySet();
    }

    public ArrayList<Gesture> getGestures(String string2) {
        ArrayList<Gesture> arrayList = this.mNamedGestures.get(string2);
        if (arrayList != null) {
            return new ArrayList<Gesture>(arrayList);
        }
        return null;
    }

    Learner getLearner() {
        return this.mClassifier;
    }

    public int getOrientationStyle() {
        return this.mOrientationStyle;
    }

    public int getSequenceType() {
        return this.mSequenceType;
    }

    public boolean hasChanged() {
        return this.mChanged;
    }

    public void load(InputStream inputStream) throws IOException {
        this.load(inputStream, false);
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(InputStream inputStream, boolean bl) throws IOException {
        short s;
        if (!(inputStream instanceof BufferedInputStream)) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 32768);
            inputStream = bufferedInputStream;
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            s = dataInputStream.readShort();
        }
        catch (Throwable throwable) {
            void var3_7;
            DataInputStream dataInputStream2;
            block12: {
                dataInputStream2 = dataInputStream;
                break block12;
                catch (Throwable throwable2) {
                    dataInputStream2 = null;
                }
            }
            if (bl) {
                GestureUtils.closeStream(dataInputStream2);
            }
            throw var3_7;
        }
        switch (s) {
            default: {
                break;
            }
            case 1: {
                this.readFormatV1(dataInputStream);
            }
        }
        if (bl) {
            GestureUtils.closeStream(dataInputStream);
        }
        return;
    }

    public ArrayList<Prediction> recognize(Gesture gesture) {
        Instance instance = Instance.createInstance(this.mSequenceType, this.mOrientationStyle, gesture, null);
        return this.mClassifier.classify(this.mSequenceType, this.mOrientationStyle, instance.vector);
    }

    public void removeEntry(String string2) {
        this.mNamedGestures.remove(string2);
        this.mClassifier.removeInstances(string2);
        this.mChanged = true;
    }

    public void removeGesture(String string2, Gesture gesture) {
        ArrayList<Gesture> arrayList = this.mNamedGestures.get(string2);
        if (arrayList == null) {
            return;
        }
        arrayList.remove(gesture);
        if (arrayList.isEmpty()) {
            this.mNamedGestures.remove(string2);
        }
        this.mClassifier.removeInstance(gesture.getID());
        this.mChanged = true;
    }

    public void save(OutputStream outputStream) throws IOException {
        this.save(outputStream, false);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(OutputStream outputStream, boolean bl) throws IOException {
        DataOutputStream dataOutputStream;
        block10: {
            dataOutputStream = null;
            HashMap<String, ArrayList<Gesture>> hashMap = this.mNamedGestures;
            if (!(outputStream instanceof BufferedOutputStream)) {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, 32768);
                outputStream = bufferedOutputStream;
            }
            DataOutputStream dataOutputStream2 = new DataOutputStream(outputStream);
            try {
                dataOutputStream2.writeShort(1);
                dataOutputStream2.writeInt(hashMap.size());
                for (Map.Entry<String, ArrayList<Gesture>> entry : hashMap.entrySet()) {
                    String string2 = entry.getKey();
                    ArrayList<Gesture> arrayList = entry.getValue();
                    int n = arrayList.size();
                    dataOutputStream2.writeUTF(string2);
                    dataOutputStream2.writeInt(n);
                    for (int i = 0; i < n; ++i) {
                        arrayList.get(i).serialize(dataOutputStream2);
                    }
                }
                dataOutputStream2.flush();
                this.mChanged = false;
                if (!bl) break block10;
            }
            catch (Throwable throwable) {
                dataOutputStream = dataOutputStream2;
            }
            GestureUtils.closeStream(dataOutputStream2);
        }
        return;
        catch (Throwable throwable) {}
        {
            void var4_14;
            if (bl) {
                GestureUtils.closeStream(dataOutputStream);
            }
            throw var4_14;
        }
    }

    public void setOrientationStyle(int n) {
        this.mOrientationStyle = n;
    }

    public void setSequenceType(int n) {
        this.mSequenceType = n;
    }
}

