/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

public class Atlas {
    public static final int FLAG_ADD_PADDING = 2;
    public static final int FLAG_ALLOW_ROTATIONS = 1;
    public static final int FLAG_DEFAULTS = 2;
    private final Policy mPolicy;

    public Atlas(Type type, int n, int n2) {
        this(type, n, n2, 2);
    }

    public Atlas(Type type, int n, int n2, int n3) {
        this.mPolicy = Atlas.findPolicy(type, n, n2, n3);
    }

    private static Policy findPolicy(Type type, int n, int n2, int n3) {
        switch (1.$SwitchMap$android$graphics$Atlas$Type[type.ordinal()]) {
            default: {
                return null;
            }
            case 1: {
                return new SlicePolicy(n, n2, n3, new SlicePolicy.MinAreaSplitDecision());
            }
            case 2: {
                return new SlicePolicy(n, n2, n3, new SlicePolicy.MaxAreaSplitDecision());
            }
            case 3: {
                return new SlicePolicy(n, n2, n3, new SlicePolicy.ShorterFreeAxisSplitDecision());
            }
            case 4: 
        }
        return new SlicePolicy(n, n2, n3, new SlicePolicy.LongerFreeAxisSplitDecision());
    }

    public Entry pack(int n, int n2) {
        return this.pack(n, n2, null);
    }

    public Entry pack(int n, int n2, Entry entry) {
        if (entry == null) {
            entry = new Entry();
        }
        return this.mPolicy.pack(n, n2, entry);
    }

    public static class Entry {
        public boolean rotated;
        public int x;
        public int y;
    }

    private static abstract class Policy {
        private Policy() {
        }

        abstract Entry pack(int var1, int var2, Entry var3);
    }

    private static class SlicePolicy
    extends Policy {
        private final boolean mAllowRotation;
        private final int mPadding;
        private final Cell mRoot;
        private final SplitDecision mSplitDecision;

        /*
         * Enabled aggressive block sorting
         */
        SlicePolicy(int n, int n2, int n3, SplitDecision splitDecision) {
            int n4;
            boolean bl = true;
            this.mRoot = new Cell();
            boolean bl2 = (n3 & 1) != 0 ? bl : false;
            this.mAllowRotation = bl2;
            if ((n3 & 2) == 0) {
                bl = false;
            }
            this.mPadding = bl ? 1 : 0;
            Cell cell = new Cell();
            cell.y = n4 = this.mPadding;
            cell.x = n4;
            cell.width = n - 2 * this.mPadding;
            cell.height = n2 - 2 * this.mPadding;
            this.mRoot.next = cell;
            this.mSplitDecision = splitDecision;
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean insert(Cell cell, Cell cell2, int n, int n2, Entry entry) {
            boolean bl;
            block10: {
                block9: {
                    if (cell.width < n) break block9;
                    int n3 = cell.height;
                    bl = false;
                    if (n3 >= n2) break block10;
                }
                if (!this.mAllowRotation || cell.width < n2 || cell.height < n) {
                    return false;
                }
                int n4 = n;
                n = n2;
                n2 = n4;
                bl = true;
            }
            int n5 = cell.width - n;
            int n6 = cell.height - n2;
            Cell cell3 = new Cell();
            Cell cell4 = new Cell();
            cell3.x = n + cell.x + this.mPadding;
            cell3.y = cell.y;
            cell3.width = n5 - this.mPadding;
            cell4.x = cell.x;
            cell4.y = n2 + cell.y + this.mPadding;
            cell4.height = n6 - this.mPadding;
            if (this.mSplitDecision.splitHorizontal(n5, n6, n, n2)) {
                cell3.height = n2;
                cell4.width = cell.width;
            } else {
                cell3.height = cell.height;
                cell4.width = n;
                Cell cell5 = cell3;
                cell3 = cell4;
                cell4 = cell5;
            }
            if (cell3.width > 0 && cell3.height > 0) {
                cell2.next = cell3;
                cell2 = cell3;
            }
            if (cell4.width > 0 && cell4.height > 0) {
                cell2.next = cell4;
                cell4.next = cell.next;
            } else {
                cell2.next = cell.next;
            }
            cell.next = null;
            entry.x = cell.x;
            entry.y = cell.y;
            entry.rotated = bl;
            return true;
        }

        @Override
        Entry pack(int n, int n2, Entry entry) {
            Cell cell = this.mRoot.next;
            Cell cell2 = this.mRoot;
            while (cell != null) {
                if (this.insert(cell, cell2, n, n2, entry)) {
                    return entry;
                }
                cell2 = cell;
                cell = cell.next;
            }
            return null;
        }

        private static class Cell {
            int height;
            Cell next;
            int width;
            int x;
            int y;

            private Cell() {
            }

            public String toString() {
                Object[] objectArray = new Object[]{this.x, this.y, this.width, this.height};
                return String.format("cell[x=%d y=%d width=%d height=%d", objectArray);
            }
        }

        private static class LongerFreeAxisSplitDecision
        implements SplitDecision {
            private LongerFreeAxisSplitDecision() {
            }

            @Override
            public boolean splitHorizontal(int n, int n2, int n3, int n4) {
                return n > n2;
            }
        }

        private static class MaxAreaSplitDecision
        implements SplitDecision {
            private MaxAreaSplitDecision() {
            }

            @Override
            public boolean splitHorizontal(int n, int n2, int n3, int n4) {
                return n3 * n2 <= n * n4;
            }
        }

        private static class MinAreaSplitDecision
        implements SplitDecision {
            private MinAreaSplitDecision() {
            }

            @Override
            public boolean splitHorizontal(int n, int n2, int n3, int n4) {
                return n3 * n2 > n * n4;
            }
        }

        private static class ShorterFreeAxisSplitDecision
        implements SplitDecision {
            private ShorterFreeAxisSplitDecision() {
            }

            @Override
            public boolean splitHorizontal(int n, int n2, int n3, int n4) {
                return n <= n2;
            }
        }

        private static interface SplitDecision {
            public boolean splitHorizontal(int var1, int var2, int var3, int var4);
        }
    }

    public static final class Type
    extends Enum<Type> {
        private static final /* synthetic */ Type[] $VALUES;
        public static final /* enum */ Type SliceLongAxis;
        public static final /* enum */ Type SliceMaxArea;
        public static final /* enum */ Type SliceMinArea;
        public static final /* enum */ Type SliceShortAxis;

        static {
            SliceMinArea = new Type();
            SliceMaxArea = new Type();
            SliceShortAxis = new Type();
            SliceLongAxis = new Type();
            Type[] typeArray = new Type[]{SliceMinArea, SliceMaxArea, SliceShortAxis, SliceLongAxis};
            $VALUES = typeArray;
        }

        public static Type valueOf(String string2) {
            return Enum.valueOf(Type.class, string2);
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }
    }
}

