/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class BitmapRegionDecoder {
    private long mNativeBitmapRegionDecoder;
    private final Object mNativeLock = new Object();
    private boolean mRecycled;

    private BitmapRegionDecoder(long l) {
        this.mNativeBitmapRegionDecoder = l;
        this.mRecycled = false;
    }

    private void checkRecycled(String string2) {
        if (this.mRecycled) {
            throw new IllegalStateException(string2);
        }
    }

    private static native void nativeClean(long var0);

    private static native Bitmap nativeDecodeRegion(long var0, int var2, int var3, int var4, int var5, BitmapFactory.Options var6);

    private static native int nativeGetHeight(long var0);

    private static native int nativeGetWidth(long var0);

    private static native BitmapRegionDecoder nativeNewInstance(long var0, boolean var2);

    private static native BitmapRegionDecoder nativeNewInstance(FileDescriptor var0, boolean var1);

    private static native BitmapRegionDecoder nativeNewInstance(InputStream var0, byte[] var1, boolean var2);

    private static native BitmapRegionDecoder nativeNewInstance(byte[] var0, int var1, int var2, boolean var3);

    public static BitmapRegionDecoder newInstance(FileDescriptor fileDescriptor, boolean bl) throws IOException {
        return BitmapRegionDecoder.nativeNewInstance(fileDescriptor, bl);
    }

    public static BitmapRegionDecoder newInstance(InputStream inputStream, boolean bl) throws IOException {
        if (inputStream instanceof AssetManager.AssetInputStream) {
            return BitmapRegionDecoder.nativeNewInstance(((AssetManager.AssetInputStream)inputStream).getNativeAsset(), bl);
        }
        return BitmapRegionDecoder.nativeNewInstance(inputStream, new byte[16384], bl);
    }

    /*
     * Unable to fully structure code
     */
    public static BitmapRegionDecoder newInstance(String var0, boolean var1_1) throws IOException {
        block11: {
            var2_2 = null;
            var3_3 = new FileInputStream(var0);
            var6_4 = BitmapRegionDecoder.newInstance(var3_3, var1_1);
            if (var3_3 == null) break block11;
            try {
                var3_3.close();
            }
            catch (IOException var7_8) {
                return var6_4;
            }
        }
        return var6_4;
        catch (Throwable var4_5) lbl-1000:
        // 2 sources

        {
            while (true) {
                if (var2_2 != null) {
                    var2_2.close();
                }
lbl16:
                // 4 sources

                throw var4_6;
            }
        }
        {
            catch (IOException var5_9) {
                ** continue;
            }
        }
        catch (Throwable var4_7) {
            var2_2 = var3_3;
            ** continue;
        }
    }

    public static BitmapRegionDecoder newInstance(byte[] byArray, int n, int n2, boolean bl) throws IOException {
        if ((n | n2) < 0 || byArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return BitmapRegionDecoder.nativeNewInstance(byArray, n, n2, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Bitmap decodeRegion(Rect rect, BitmapFactory.Options options) {
        Object object = this.mNativeLock;
        synchronized (object) {
            this.checkRecycled("decodeRegion called on recycled region decoder");
            if (rect.right <= 0) throw new IllegalArgumentException("rectangle is outside the image");
            if (rect.bottom <= 0) throw new IllegalArgumentException("rectangle is outside the image");
            if (rect.left >= this.getWidth()) throw new IllegalArgumentException("rectangle is outside the image");
            if (rect.top >= this.getHeight()) throw new IllegalArgumentException("rectangle is outside the image");
            return BitmapRegionDecoder.nativeDecodeRegion(this.mNativeBitmapRegionDecoder, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, options);
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.recycle();
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getHeight() {
        Object object = this.mNativeLock;
        synchronized (object) {
            this.checkRecycled("getHeight called on recycled region decoder");
            return BitmapRegionDecoder.nativeGetHeight(this.mNativeBitmapRegionDecoder);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getWidth() {
        Object object = this.mNativeLock;
        synchronized (object) {
            this.checkRecycled("getWidth called on recycled region decoder");
            return BitmapRegionDecoder.nativeGetWidth(this.mNativeBitmapRegionDecoder);
        }
    }

    public final boolean isRecycled() {
        return this.mRecycled;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void recycle() {
        Object object = this.mNativeLock;
        synchronized (object) {
            if (!this.mRecycled) {
                BitmapRegionDecoder.nativeClean(this.mNativeBitmapRegionDecoder);
                this.mRecycled = true;
            }
            return;
        }
    }
}

