/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;

public class NinePatch {
    private final Bitmap mBitmap;
    public final long mNativeChunk;
    private Paint mPaint;
    private String mSrcName;

    public NinePatch(Bitmap bitmap, byte[] byArray) {
        this(bitmap, byArray, null);
    }

    public NinePatch(Bitmap bitmap, byte[] byArray, String string2) {
        this.mBitmap = bitmap;
        this.mSrcName = string2;
        this.mNativeChunk = NinePatch.validateNinePatchChunk(this.mBitmap.ni(), byArray);
    }

    public NinePatch(NinePatch ninePatch) {
        this.mBitmap = ninePatch.mBitmap;
        this.mSrcName = ninePatch.mSrcName;
        if (ninePatch.mPaint != null) {
            this.mPaint = new Paint(ninePatch.mPaint);
        }
        this.mNativeChunk = ninePatch.mNativeChunk;
    }

    public static native boolean isNinePatchChunk(byte[] var0);

    private static native void nativeDraw(long var0, Rect var2, long var3, long var5, long var7, int var9, int var10);

    private static native void nativeDraw(long var0, RectF var2, long var3, long var5, long var7, int var9, int var10);

    private static native void nativeFinalize(long var0);

    private static native long nativeGetTransparentRegion(long var0, long var2, Rect var4);

    private static native long validateNinePatchChunk(long var0, byte[] var2);

    public void draw(Canvas canvas, Rect rect) {
        canvas.drawPatch(this, rect, this.mPaint);
    }

    public void draw(Canvas canvas, Rect rect, Paint paint) {
        canvas.drawPatch(this, rect, paint);
    }

    public void draw(Canvas canvas, RectF rectF) {
        canvas.drawPatch(this, rectF, this.mPaint);
    }

    /*
     * Enabled aggressive block sorting
     */
    void drawSoftware(Canvas canvas, Rect rect, Paint paint) {
        long l = canvas.getNativeCanvasWrapper();
        long l2 = this.mBitmap.ni();
        long l3 = this.mNativeChunk;
        long l4 = paint != null ? paint.mNativePaint : 0L;
        NinePatch.nativeDraw(l, rect, l2, l3, l4, canvas.mDensity, this.mBitmap.mDensity);
    }

    /*
     * Enabled aggressive block sorting
     */
    void drawSoftware(Canvas canvas, RectF rectF, Paint paint) {
        long l = canvas.getNativeCanvasWrapper();
        long l2 = this.mBitmap.ni();
        long l3 = this.mNativeChunk;
        long l4 = paint != null ? paint.mNativePaint : 0L;
        NinePatch.nativeDraw(l, rectF, l2, l3, l4, canvas.mDensity, this.mBitmap.mDensity);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mNativeChunk != 0L) {
                NinePatch.nativeFinalize(this.mNativeChunk);
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    public int getDensity() {
        return this.mBitmap.mDensity;
    }

    public int getHeight() {
        return this.mBitmap.getHeight();
    }

    public String getName() {
        return this.mSrcName;
    }

    public Paint getPaint() {
        return this.mPaint;
    }

    public final Region getTransparentRegion(Rect rect) {
        long l = NinePatch.nativeGetTransparentRegion(this.mBitmap.ni(), this.mNativeChunk, rect);
        if (l != 0L) {
            return new Region(l);
        }
        return null;
    }

    public int getWidth() {
        return this.mBitmap.getWidth();
    }

    public final boolean hasAlpha() {
        return this.mBitmap.hasAlpha();
    }

    public void setPaint(Paint paint) {
        this.mPaint = paint;
    }

    public static class InsetStruct {
        public final Rect opticalRect;
        public final float outlineAlpha;
        public final float outlineRadius;
        public final Rect outlineRect;

        InsetStruct(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, float f, int n9, float f2) {
            this.opticalRect = new Rect(n, n2, n3, n4);
            this.outlineRect = new Rect(n5, n6, n7, n8);
            if (f2 != 1.0f) {
                this.opticalRect.scale(f2);
                this.outlineRect.scaleRoundIn(f2);
            }
            this.outlineRadius = f * f2;
            this.outlineAlpha = (float)n9 / 255.0f;
        }
    }
}

