/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import java.io.InputStream;
import java.io.OutputStream;

public class Picture {
    private static final int WORKING_STREAM_STORAGE = 16384;
    private final long mNativePicture;
    private Canvas mRecordingCanvas;

    public Picture() {
        this(Picture.nativeConstructor(0L));
    }

    private Picture(long l) {
        if (l == 0L) {
            throw new RuntimeException();
        }
        this.mNativePicture = l;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Picture(Picture picture) {
        long l = picture != null ? picture.mNativePicture : 0L;
        this(Picture.nativeConstructor(l));
    }

    @Deprecated
    public static Picture createFromStream(InputStream inputStream) {
        return new Picture(Picture.nativeCreateFromStream(inputStream, new byte[16384]));
    }

    private static native long nativeBeginRecording(long var0, int var2, int var3);

    private static native long nativeConstructor(long var0);

    private static native long nativeCreateFromStream(InputStream var0, byte[] var1);

    private static native void nativeDestructor(long var0);

    private static native void nativeDraw(long var0, long var2);

    private static native void nativeEndRecording(long var0);

    private static native int nativeGetHeight(long var0);

    private static native int nativeGetWidth(long var0);

    private static native boolean nativeWriteToStream(long var0, OutputStream var2, byte[] var3);

    public Canvas beginRecording(int n, int n2) {
        this.mRecordingCanvas = new RecordingCanvas(this, Picture.nativeBeginRecording(this.mNativePicture, n, n2));
        return this.mRecordingCanvas;
    }

    public void draw(Canvas canvas) {
        if (canvas.isHardwareAccelerated()) {
            throw new IllegalArgumentException("Picture playback is only supported on software canvas.");
        }
        if (this.mRecordingCanvas != null) {
            this.endRecording();
        }
        Picture.nativeDraw(canvas.getNativeCanvasWrapper(), this.mNativePicture);
    }

    public void endRecording() {
        if (this.mRecordingCanvas != null) {
            this.mRecordingCanvas = null;
            Picture.nativeEndRecording(this.mNativePicture);
        }
    }

    protected void finalize() throws Throwable {
        try {
            Picture.nativeDestructor(this.mNativePicture);
            return;
        }
        finally {
            super.finalize();
        }
    }

    public int getHeight() {
        return Picture.nativeGetHeight(this.mNativePicture);
    }

    public int getWidth() {
        return Picture.nativeGetWidth(this.mNativePicture);
    }

    @Deprecated
    public void writeToStream(OutputStream outputStream) {
        if (outputStream == null) {
            throw new NullPointerException();
        }
        if (!Picture.nativeWriteToStream(this.mNativePicture, outputStream, new byte[16384])) {
            throw new RuntimeException();
        }
    }

    private static class RecordingCanvas
    extends Canvas {
        private final Picture mPicture;

        public RecordingCanvas(Picture picture, long l) {
            super(l);
            this.mPicture = picture;
        }

        @Override
        public void drawPicture(Picture picture) {
            if (this.mPicture == picture) {
                throw new RuntimeException("Cannot draw a picture into its recording canvas");
            }
            super.drawPicture(picture);
        }

        @Override
        public void setBitmap(Bitmap bitmap) {
            throw new RuntimeException("Cannot call setBitmap on a picture canvas");
        }
    }
}

