/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Point;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.FloatMath;

public class PointF
implements Parcelable {
    public static final Parcelable.Creator<PointF> CREATOR = new Parcelable.Creator<PointF>(){

        @Override
        public PointF createFromParcel(Parcel parcel) {
            PointF pointF = new PointF();
            pointF.readFromParcel(parcel);
            return pointF;
        }

        public PointF[] newArray(int n) {
            return new PointF[n];
        }
    };
    public float x;
    public float y;

    public PointF() {
    }

    public PointF(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public PointF(Point point) {
        this.x = point.x;
        this.y = point.y;
    }

    public static float length(float f, float f2) {
        return FloatMath.sqrt(f * f + f2 * f2);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public final boolean equals(float f, float f2) {
        return this.x == f && this.y == f2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block6: {
            block5: {
                if (this == object) break block5;
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                PointF pointF = (PointF)object;
                if (Float.compare(pointF.x, this.x) != 0) {
                    return false;
                }
                if (Float.compare(pointF.y, this.y) != 0) break block6;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int hashCode() {
        int n = this.x != 0.0f ? Float.floatToIntBits(this.x) : 0;
        int n2 = n * 31;
        float f = this.y - 0.0f;
        float f2 = f == 0.0f ? 0 : (f > 0.0f ? 1 : -1);
        int n3 = 0;
        if (f2 != false) {
            n3 = Float.floatToIntBits(this.y);
        }
        return n2 + n3;
    }

    public final float length() {
        return PointF.length(this.x, this.y);
    }

    public final void negate() {
        this.x = -this.x;
        this.y = -this.y;
    }

    public final void offset(float f, float f2) {
        this.x = f + this.x;
        this.y = f2 + this.y;
    }

    public void readFromParcel(Parcel parcel) {
        this.x = parcel.readFloat();
        this.y = parcel.readFloat();
    }

    public final void set(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public final void set(PointF pointF) {
        this.x = pointF.x;
        this.y = pointF.y;
    }

    public String toString() {
        return "PointF(" + this.x + ", " + this.y + ")";
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeFloat(this.x);
        parcel.writeFloat(this.y);
    }
}

