/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Shader;

public class SweepGradient
extends Shader {
    private static final int TYPE_COLORS_AND_POSITIONS = 1;
    private static final int TYPE_COLOR_START_AND_COLOR_END = 2;
    private int mColor0;
    private int mColor1;
    private int[] mColors;
    private float mCx;
    private float mCy;
    private float[] mPositions;
    private int mType;

    public SweepGradient(float f, float f2, int n, int n2) {
        this.mType = 2;
        this.mCx = f;
        this.mCy = f2;
        this.mColor0 = n;
        this.mColor1 = n2;
        this.init(SweepGradient.nativeCreate2(f, f2, n, n2));
    }

    public SweepGradient(float f, float f2, int[] nArray, float[] fArray) {
        if (nArray.length < 2) {
            throw new IllegalArgumentException("needs >= 2 number of colors");
        }
        if (fArray != null && nArray.length != fArray.length) {
            throw new IllegalArgumentException("color and position arrays must be of equal length");
        }
        this.mType = 1;
        this.mCx = f;
        this.mCy = f2;
        this.mColors = nArray;
        this.mPositions = fArray;
        this.init(SweepGradient.nativeCreate1(f, f2, nArray, fArray));
    }

    private static native long nativeCreate1(float var0, float var1, int[] var2, float[] var3);

    private static native long nativeCreate2(float var0, float var1, int var2, int var3);

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected Shader copy() {
        SweepGradient sweepGradient;
        switch (this.mType) {
            default: {
                throw new IllegalArgumentException("SweepGradient should be created with either colors and positions or start color and end color");
            }
            case 1: {
                float f = this.mCx;
                float f2 = this.mCy;
                int[] nArray = (int[])this.mColors.clone();
                float[] fArray = this.mPositions != null ? (float[])this.mPositions.clone() : null;
                sweepGradient = new SweepGradient(f, f2, nArray, fArray);
                break;
            }
            case 2: {
                sweepGradient = new SweepGradient(this.mCx, this.mCy, this.mColor0, this.mColor1);
            }
        }
        this.copyLocalMatrix(sweepGradient);
        return sweepGradient;
    }
}

