/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.app.ActivityThread;
import android.app.Application;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.media.IAudioService;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RenderScript;
import android.renderscript.Type;
import android.text.TextUtils;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.asus.cta.CtaChecker;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

@Deprecated
public class Camera {
    public static final String ACTION_NEW_PICTURE = "android.hardware.action.NEW_PICTURE";
    public static final String ACTION_NEW_VIDEO = "android.hardware.action.NEW_VIDEO";
    public static final int CAMERA_ERROR_SERVER_DIED = 100;
    public static final int CAMERA_ERROR_UNKNOWN = 1;
    private static final int CAMERA_FACE_DETECTION_HW = 0;
    private static final int CAMERA_FACE_DETECTION_SW = 1;
    public static final int CAMERA_HAL_API_VERSION_1_0 = 256;
    private static final int CAMERA_HAL_API_VERSION_NORMAL_CONNECT = -2;
    private static final int CAMERA_HAL_API_VERSION_UNSPECIFIED = -1;
    private static final int CAMERA_MSG_COMPRESSED_IMAGE = 256;
    private static final int CAMERA_MSG_ERROR = 1;
    private static final int CAMERA_MSG_FOCUS = 4;
    private static final int CAMERA_MSG_FOCUS_MOVE = 2048;
    private static final int CAMERA_MSG_POSTVIEW_FRAME = 64;
    private static final int CAMERA_MSG_PREVIEW_FRAME = 16;
    private static final int CAMERA_MSG_PREVIEW_METADATA = 1024;
    private static final int CAMERA_MSG_RAW_IMAGE = 128;
    private static final int CAMERA_MSG_RAW_IMAGE_NOTIFY = 512;
    private static final int CAMERA_MSG_SHUTTER = 2;
    private static final int CAMERA_MSG_VIDEO_FRAME = 32;
    private static final int CAMERA_MSG_ZOOM = 8;
    private static final int EACCESS = -13;
    private static final int EBUSY = -16;
    private static final int EINVAL = -22;
    private static final int ENODEV = -19;
    private static final int ENOSYS = -38;
    private static final int EOPNOTSUPP = -95;
    private static final int EUSERS = -87;
    private static final int NO_ERROR = 0;
    private static final String TAG = "Camera";
    private AutoFocusCallback mAutoFocusCallback;
    private final Object mAutoFocusCallbackLock = new Object();
    private AutoFocusMoveCallback mAutoFocusMoveCallback;
    private ErrorCallback mErrorCallback;
    private EventHandler mEventHandler;
    private boolean mFaceDetectionRunning = false;
    private FaceDetectionListener mFaceListener;
    private PictureCallback mJpegCallback;
    private long mNativeContext;
    private boolean mOneShot;
    private PictureCallback mPostviewCallback;
    private PreviewCallback mPreviewCallback;
    private PictureCallback mRawImageCallback;
    private ShutterCallback mShutterCallback;
    private boolean mUsingPreviewAllocation;
    private boolean mWithBuffer;
    private OnZoomChangeListener mZoomListener;

    Camera() {
    }

    Camera(int n) {
        int n2 = this.cameraInitNormal(n);
        if (Camera.checkInitErrors(n2)) {
            switch (n2) {
                default: {
                    throw new RuntimeException("Unknown camera error");
                }
                case -13: {
                    throw new RuntimeException("Fail to connect to camera service");
                }
                case -19: 
            }
            throw new RuntimeException("Camera initialization failed");
        }
    }

    private Camera(int n, int n2) {
        int n3 = this.cameraInitVersion(n, n2);
        if (Camera.checkInitErrors(n3)) {
            switch (n3) {
                default: {
                    throw new RuntimeException("Unknown camera error");
                }
                case -13: {
                    throw new RuntimeException("Fail to connect to camera service");
                }
                case -19: {
                    throw new RuntimeException("Camera initialization failed");
                }
                case -38: {
                    throw new RuntimeException("Camera initialization failed because some methods are not implemented");
                }
                case -95: {
                    throw new RuntimeException("Camera initialization failed because the hal version is not supported by this device");
                }
                case -22: {
                    throw new RuntimeException("Camera initialization failed because the input arugments are invalid");
                }
                case -16: {
                    throw new RuntimeException("Camera initialization failed because the camera device was already opened");
                }
                case -87: 
            }
            throw new RuntimeException("Camera initialization failed because the max number of camera devices were already opened");
        }
    }

    private static void CheckCTAPermission() {
        Log.d(TAG, "[CTA] Camera CheckCTAPermission entered ");
        Application application = ActivityThread.currentApplication();
        if (application != null) {
            CtaChecker ctaChecker = new CtaChecker(application);
            ctaChecker.setCheckWindowType(2003);
            if (!ctaChecker.checkPermission(13, ActivityThread.currentPackageName())) {
                throw new RuntimeException("Camera open failed, User reject to open camera");
            }
        }
    }

    private final native void _addCallbackBuffer(byte[] var1, int var2);

    private final native boolean _enableShutterSound(boolean var1);

    private static native void _getCameraInfo(int var0, CameraInfo var1);

    private final native void _startFaceDetection(int var1);

    private final native void _stopFaceDetection();

    private final native void _stopPreview();

    static /* synthetic */ PreviewCallback access$302(Camera camera, PreviewCallback previewCallback) {
        camera.mPreviewCallback = previewCallback;
        return previewCallback;
    }

    private final void addCallbackBuffer(byte[] byArray, int n) {
        if (n != 16 && n != 128) {
            throw new IllegalArgumentException("Unsupported message type: " + n);
        }
        this._addCallbackBuffer(byArray, n);
    }

    private int cameraInitNormal(int n) {
        return this.cameraInitVersion(n, -2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int cameraInitVersion(int n, int n2) {
        Looper looper;
        this.mShutterCallback = null;
        this.mRawImageCallback = null;
        this.mJpegCallback = null;
        this.mPreviewCallback = null;
        this.mPostviewCallback = null;
        this.mUsingPreviewAllocation = false;
        this.mZoomListener = null;
        Looper looper2 = Looper.myLooper();
        this.mEventHandler = looper2 != null ? new EventHandler(this, looper2) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
        String string2 = ActivityThread.currentPackageName();
        return this.native_setup(new WeakReference<Camera>(this), n, n2, string2);
    }

    public static boolean checkInitErrors(int n) {
        return n != 0;
    }

    private native void enableFocusMoveCallback(int var1);

    public static void getCameraInfo(int n, CameraInfo cameraInfo) {
        Camera._getCameraInfo(n, cameraInfo);
        IAudioService iAudioService = IAudioService.Stub.asInterface(ServiceManager.getService("audio"));
        try {
            if (iAudioService.isCameraSoundForced()) {
                cameraInfo.canDisableShutterSound = false;
            }
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Audio service is unavailable for queries");
            return;
        }
    }

    public static Parameters getEmptyParameters() {
        Camera camera = new Camera();
        camera.getClass();
        return camera.new Parameters();
    }

    public static native int getNumberOfCameras();

    public static Parameters getParametersCopy(Parameters parameters) {
        if (parameters == null) {
            throw new NullPointerException("parameters must not be null");
        }
        Camera camera = parameters.getOuter();
        camera.getClass();
        Parameters parameters2 = camera.new Parameters();
        parameters2.copyFrom(parameters);
        return parameters2;
    }

    private final native void native_autoFocus();

    private final native void native_cancelAutoFocus();

    private final native String native_getParameters();

    private final native void native_release();

    private final native void native_setParameters(String var1);

    private final native int native_setup(Object var1, int var2, int var3, String var4);

    private final native void native_takePicture(int var1);

    public static Camera open() {
        Log.d(TAG, "[CTA] Camera open()");
        int n = Camera.getNumberOfCameras();
        CameraInfo cameraInfo = new CameraInfo();
        for (int i = 0; i < n; ++i) {
            Camera.getCameraInfo(i, cameraInfo);
            if (cameraInfo.facing != 0) continue;
            Camera.CheckCTAPermission();
            return new Camera(i);
        }
        return null;
    }

    public static Camera open(int n) {
        Log.d(TAG, "[CTA] Camera open(int cameraId)");
        Camera.CheckCTAPermission();
        return new Camera(n);
    }

    public static Camera openLegacy(int n, int n2) {
        Log.d(TAG, "[CTA] Camera openLegacy(int cameraId, int halVersion)");
        if (n2 < 256) {
            throw new IllegalArgumentException("Invalid HAL version " + n2);
        }
        Camera.CheckCTAPermission();
        return new Camera(n, n2);
    }

    public static Camera openUninitialized() {
        Log.d(TAG, "[CTA] Camera openUninitialized()");
        Camera.CheckCTAPermission();
        return new Camera();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
        Camera camera = (Camera)((WeakReference)object).get();
        if (camera == null || camera.mEventHandler == null) {
            return;
        }
        Message message = camera.mEventHandler.obtainMessage(n, n2, n3, object2);
        camera.mEventHandler.sendMessage(message);
    }

    private final native void setHasPreviewCallback(boolean var1, boolean var2);

    private final native void setPreviewCallbackSurface(Surface var1);

    public final void addCallbackBuffer(byte[] byArray) {
        this._addCallbackBuffer(byArray, 16);
    }

    public final void addRawImageCallbackBuffer(byte[] byArray) {
        this.addCallbackBuffer(byArray, 128);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void autoFocus(AutoFocusCallback autoFocusCallback) {
        Object object = this.mAutoFocusCallbackLock;
        synchronized (object) {
            this.mAutoFocusCallback = autoFocusCallback;
        }
        this.native_autoFocus();
    }

    public int cameraInitUnspecified(int n) {
        return this.cameraInitVersion(n, -1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void cancelAutoFocus() {
        Object object = this.mAutoFocusCallbackLock;
        synchronized (object) {
            this.mAutoFocusCallback = null;
        }
        this.native_cancelAutoFocus();
        this.mEventHandler.removeMessages(4);
    }

    public final Allocation createPreviewAllocation(RenderScript renderScript, int n) throws RSIllegalArgumentException {
        Size size = this.getParameters().getPreviewSize();
        Type.Builder builder = new Type.Builder(renderScript, Element.createPixel(renderScript, Element.DataType.UNSIGNED_8, Element.DataKind.PIXEL_YUV));
        builder.setYuvFormat(842094169);
        builder.setX(size.width);
        builder.setY(size.height);
        return Allocation.createTyped(renderScript, builder.create(), n | 0x20);
    }

    public final boolean disableShutterSound() {
        return this._enableShutterSound(false);
    }

    public final boolean enableShutterSound(boolean bl) {
        if (!bl) {
            IAudioService iAudioService = IAudioService.Stub.asInterface(ServiceManager.getService("audio"));
            try {
                boolean bl2 = iAudioService.isCameraSoundForced();
                if (bl2) {
                    return false;
                }
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Audio service is unavailable for queries");
            }
        }
        return this._enableShutterSound(bl);
    }

    protected void finalize() {
        this.release();
    }

    public Parameters getParameters() {
        Parameters parameters = new Parameters();
        parameters.unflatten(this.native_getParameters());
        return parameters;
    }

    public final native void lock();

    public final native boolean previewEnabled();

    public final native void reconnect() throws IOException;

    public final void release() {
        this.native_release();
        this.mFaceDetectionRunning = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setAutoFocusMoveCallback(AutoFocusMoveCallback autoFocusMoveCallback) {
        this.mAutoFocusMoveCallback = autoFocusMoveCallback;
        int n = this.mAutoFocusMoveCallback != null ? 1 : 0;
        this.enableFocusMoveCallback(n);
    }

    public final native void setDisplayOrientation(int var1);

    public final void setErrorCallback(ErrorCallback errorCallback) {
        this.mErrorCallback = errorCallback;
    }

    public final void setFaceDetectionListener(FaceDetectionListener faceDetectionListener) {
        this.mFaceListener = faceDetectionListener;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void setOneShotPreviewCallback(PreviewCallback previewCallback) {
        boolean bl = true;
        this.mPreviewCallback = previewCallback;
        this.mOneShot = bl;
        this.mWithBuffer = false;
        if (previewCallback != null) {
            this.mUsingPreviewAllocation = false;
        }
        if (previewCallback == null) {
            bl = false;
        }
        this.setHasPreviewCallback(bl, false);
    }

    public void setParameters(Parameters parameters) {
        if (this.mUsingPreviewAllocation) {
            Size size = parameters.getPreviewSize();
            Size size2 = this.getParameters().getPreviewSize();
            if (size.width != size2.width || size.height != size2.height) {
                throw new IllegalStateException("Cannot change preview size while a preview allocation is configured.");
            }
        }
        this.native_setParameters(parameters.flatten());
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void setPreviewCallback(PreviewCallback previewCallback) {
        this.mPreviewCallback = previewCallback;
        this.mOneShot = false;
        this.mWithBuffer = false;
        if (previewCallback != null) {
            this.mUsingPreviewAllocation = false;
        }
        boolean bl = previewCallback != null;
        this.setHasPreviewCallback(bl, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void setPreviewCallbackAllocation(Allocation allocation) throws IOException {
        Surface surface;
        if (allocation != null) {
            Size size = this.getParameters().getPreviewSize();
            if (size.width != allocation.getType().getX() || size.height != allocation.getType().getY()) {
                throw new IllegalArgumentException("Allocation dimensions don't match preview dimensions: Allocation is " + allocation.getType().getX() + ", " + allocation.getType().getY() + ". Preview is " + size.width + ", " + size.height);
            }
            if ((0x20 & allocation.getUsage()) == 0) {
                throw new IllegalArgumentException("Allocation usage does not include USAGE_IO_INPUT");
            }
            if (allocation.getType().getElement().getDataKind() != Element.DataKind.PIXEL_YUV) {
                throw new IllegalArgumentException("Allocation is not of a YUV type");
            }
            surface = allocation.getSurface();
            this.mUsingPreviewAllocation = true;
        } else {
            this.mUsingPreviewAllocation = false;
            surface = null;
        }
        this.setPreviewCallbackSurface(surface);
    }

    public final void setPreviewCallbackWithBuffer(PreviewCallback previewCallback) {
        this.mPreviewCallback = previewCallback;
        this.mOneShot = false;
        this.mWithBuffer = true;
        if (previewCallback != null) {
            this.mUsingPreviewAllocation = false;
        }
        boolean bl = false;
        if (previewCallback != null) {
            bl = true;
        }
        this.setHasPreviewCallback(bl, true);
    }

    public final void setPreviewDisplay(SurfaceHolder surfaceHolder) throws IOException {
        if (surfaceHolder != null) {
            this.setPreviewSurface(surfaceHolder.getSurface());
            return;
        }
        this.setPreviewSurface(null);
    }

    public final native void setPreviewSurface(Surface var1) throws IOException;

    public final native void setPreviewTexture(SurfaceTexture var1) throws IOException;

    public final void setZoomChangeListener(OnZoomChangeListener onZoomChangeListener) {
        this.mZoomListener = onZoomChangeListener;
    }

    public final void startFaceDetection() {
        if (this.mFaceDetectionRunning) {
            throw new RuntimeException("Face detection is already running");
        }
        this._startFaceDetection(0);
        this.mFaceDetectionRunning = true;
    }

    public final native void startPreview();

    public final native void startSmoothZoom(int var1);

    public final void stopFaceDetection() {
        this._stopFaceDetection();
        this.mFaceDetectionRunning = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void stopPreview() {
        this._stopPreview();
        this.mFaceDetectionRunning = false;
        this.mShutterCallback = null;
        this.mRawImageCallback = null;
        this.mPostviewCallback = null;
        this.mJpegCallback = null;
        Object object = this.mAutoFocusCallbackLock;
        synchronized (object) {
            this.mAutoFocusCallback = null;
        }
        this.mAutoFocusMoveCallback = null;
    }

    public final native void stopSmoothZoom();

    public final void takePicture(ShutterCallback shutterCallback, PictureCallback pictureCallback, PictureCallback pictureCallback2) {
        this.takePicture(shutterCallback, pictureCallback, null, pictureCallback2);
    }

    public final void takePicture(ShutterCallback shutterCallback, PictureCallback pictureCallback, PictureCallback pictureCallback2, PictureCallback pictureCallback3) {
        this.mShutterCallback = shutterCallback;
        this.mRawImageCallback = pictureCallback;
        this.mPostviewCallback = pictureCallback2;
        this.mJpegCallback = pictureCallback3;
        ShutterCallback shutterCallback2 = this.mShutterCallback;
        int n = 0;
        if (shutterCallback2 != null) {
            n = 0 | 2;
        }
        if (this.mRawImageCallback != null) {
            n |= 0x80;
        }
        if (this.mPostviewCallback != null) {
            n |= 0x40;
        }
        if (this.mJpegCallback != null) {
            n |= 0x100;
        }
        this.native_takePicture(n);
        this.mFaceDetectionRunning = false;
    }

    public final native void unlock();

    @Deprecated
    public static class Area {
        public Rect rect;
        public int weight;

        public Area(Rect rect, int n) {
            this.rect = rect;
            this.weight = n;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block7: {
                block4: {
                    Area area;
                    block6: {
                        block5: {
                            if (!(object instanceof Area)) break block4;
                            area = (Area)object;
                            if (this.rect != null) break block5;
                            if (area.rect != null) break block4;
                            break block6;
                        }
                        if (!this.rect.equals(area.rect)) {
                            return false;
                        }
                    }
                    if (this.weight == area.weight) break block7;
                }
                return false;
            }
            return true;
        }
    }

    @Deprecated
    public static interface AutoFocusCallback {
        public void onAutoFocus(boolean var1, Camera var2);
    }

    @Deprecated
    public static interface AutoFocusMoveCallback {
        public void onAutoFocusMoving(boolean var1, Camera var2);
    }

    @Deprecated
    public static class CameraInfo {
        public static final int CAMERA_FACING_BACK = 0;
        public static final int CAMERA_FACING_FRONT = 1;
        public boolean canDisableShutterSound;
        public int facing;
        public int orientation;
    }

    @Deprecated
    public static interface ErrorCallback {
        public void onError(int var1, Camera var2);
    }

    private class EventHandler
    extends Handler {
        private final Camera mCamera;

        public EventHandler(Camera camera2, Looper looper) {
            super(looper);
            this.mCamera = camera2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleMessage(Message message) {
            boolean bl = true;
            switch (message.what) {
                default: {
                    Log.e(Camera.TAG, "Unknown message type " + message.what);
                    return;
                }
                case 2: {
                    if (Camera.this.mShutterCallback == null) return;
                    Camera.this.mShutterCallback.onShutter();
                    return;
                }
                case 128: {
                    if (Camera.this.mRawImageCallback == null) return;
                    Camera.this.mRawImageCallback.onPictureTaken((byte[])message.obj, this.mCamera);
                    return;
                }
                case 256: {
                    if (Camera.this.mJpegCallback == null) return;
                    Camera.this.mJpegCallback.onPictureTaken((byte[])message.obj, this.mCamera);
                    return;
                }
                case 16: {
                    PreviewCallback previewCallback = Camera.this.mPreviewCallback;
                    if (previewCallback == null) return;
                    if (Camera.this.mOneShot) {
                        Camera.access$302(Camera.this, null);
                    } else if (!Camera.this.mWithBuffer) {
                        Camera.this.setHasPreviewCallback(bl, false);
                    }
                    previewCallback.onPreviewFrame((byte[])message.obj, this.mCamera);
                    return;
                }
                case 64: {
                    if (Camera.this.mPostviewCallback == null) return;
                    Camera.this.mPostviewCallback.onPictureTaken((byte[])message.obj, this.mCamera);
                    return;
                }
                case 4: {
                    AutoFocusCallback autoFocusCallback;
                    Object object = Camera.this.mAutoFocusCallbackLock;
                    synchronized (object) {
                        autoFocusCallback = Camera.this.mAutoFocusCallback;
                    }
                    if (autoFocusCallback == null) return;
                    int n = message.arg1;
                    boolean bl2 = false;
                    if (n != 0) {
                        bl2 = bl;
                    }
                    autoFocusCallback.onAutoFocus(bl2, this.mCamera);
                    return;
                }
                case 8: {
                    if (Camera.this.mZoomListener == null) return;
                    OnZoomChangeListener onZoomChangeListener = Camera.this.mZoomListener;
                    int n = message.arg1;
                    if (message.arg2 == 0) {
                        bl = false;
                    }
                    onZoomChangeListener.onZoomChange(n, bl, this.mCamera);
                    return;
                }
                case 1024: {
                    if (Camera.this.mFaceListener == null) return;
                    Camera.this.mFaceListener.onFaceDetection((Face[])message.obj, this.mCamera);
                    return;
                }
                case 1: {
                    Log.e(Camera.TAG, "Error " + message.arg1);
                    if (Camera.this.mErrorCallback == null) return;
                    Camera.this.mErrorCallback.onError(message.arg1, this.mCamera);
                    return;
                }
                case 2048: {
                    if (Camera.this.mAutoFocusMoveCallback == null) return;
                    AutoFocusMoveCallback autoFocusMoveCallback = Camera.this.mAutoFocusMoveCallback;
                    int n = message.arg1;
                    boolean bl3 = false;
                    if (n != 0) {
                        bl3 = bl;
                    }
                    autoFocusMoveCallback.onAutoFocusMoving(bl3, this.mCamera);
                    return;
                }
            }
        }
    }

    @Deprecated
    public static class Face {
        public int id = -1;
        public Point leftEye = null;
        public Point mouth = null;
        public Rect rect;
        public Point rightEye = null;
        public int score;
    }

    @Deprecated
    public static interface FaceDetectionListener {
        public void onFaceDetection(Face[] var1, Camera var2);
    }

    @Deprecated
    public static interface OnZoomChangeListener {
        public void onZoomChange(int var1, boolean var2, Camera var3);
    }

    @Deprecated
    public class Parameters {
        public static final String ANTIBANDING_50HZ = "50hz";
        public static final String ANTIBANDING_60HZ = "60hz";
        public static final String ANTIBANDING_AUTO = "auto";
        public static final String ANTIBANDING_OFF = "off";
        public static final String EFFECT_AQUA = "aqua";
        public static final String EFFECT_BLACKBOARD = "blackboard";
        public static final String EFFECT_MONO = "mono";
        public static final String EFFECT_NEGATIVE = "negative";
        public static final String EFFECT_NONE = "none";
        public static final String EFFECT_POSTERIZE = "posterize";
        public static final String EFFECT_SEPIA = "sepia";
        public static final String EFFECT_SOLARIZE = "solarize";
        public static final String EFFECT_WHITEBOARD = "whiteboard";
        private static final String FALSE = "false";
        public static final String FLASH_MODE_AUTO = "auto";
        public static final String FLASH_MODE_OFF = "off";
        public static final String FLASH_MODE_ON = "on";
        public static final String FLASH_MODE_RED_EYE = "red-eye";
        public static final String FLASH_MODE_TORCH = "torch";
        public static final int FOCUS_DISTANCE_FAR_INDEX = 2;
        public static final int FOCUS_DISTANCE_NEAR_INDEX = 0;
        public static final int FOCUS_DISTANCE_OPTIMAL_INDEX = 1;
        public static final String FOCUS_MODE_AUTO = "auto";
        public static final String FOCUS_MODE_CONTINUOUS_PICTURE = "continuous-picture";
        public static final String FOCUS_MODE_CONTINUOUS_VIDEO = "continuous-video";
        public static final String FOCUS_MODE_EDOF = "edof";
        public static final String FOCUS_MODE_FIXED = "fixed";
        public static final String FOCUS_MODE_INFINITY = "infinity";
        public static final String FOCUS_MODE_MACRO = "macro";
        private static final String KEY_ANTIBANDING = "antibanding";
        private static final String KEY_AUTO_EXPOSURE_LOCK = "auto-exposure-lock";
        private static final String KEY_AUTO_EXPOSURE_LOCK_SUPPORTED = "auto-exposure-lock-supported";
        private static final String KEY_AUTO_WHITEBALANCE_LOCK = "auto-whitebalance-lock";
        private static final String KEY_AUTO_WHITEBALANCE_LOCK_SUPPORTED = "auto-whitebalance-lock-supported";
        private static final String KEY_EFFECT = "effect";
        private static final String KEY_EXPOSURE_COMPENSATION = "exposure-compensation";
        private static final String KEY_EXPOSURE_COMPENSATION_STEP = "exposure-compensation-step";
        private static final String KEY_FLASH_MODE = "flash-mode";
        private static final String KEY_FOCAL_LENGTH = "focal-length";
        private static final String KEY_FOCUS_AREAS = "focus-areas";
        private static final String KEY_FOCUS_DISTANCES = "focus-distances";
        private static final String KEY_FOCUS_MODE = "focus-mode";
        private static final String KEY_GPS_ALTITUDE = "gps-altitude";
        private static final String KEY_GPS_LATITUDE = "gps-latitude";
        private static final String KEY_GPS_LONGITUDE = "gps-longitude";
        private static final String KEY_GPS_PROCESSING_METHOD = "gps-processing-method";
        private static final String KEY_GPS_TIMESTAMP = "gps-timestamp";
        private static final String KEY_HORIZONTAL_VIEW_ANGLE = "horizontal-view-angle";
        private static final String KEY_JPEG_QUALITY = "jpeg-quality";
        private static final String KEY_JPEG_THUMBNAIL_HEIGHT = "jpeg-thumbnail-height";
        private static final String KEY_JPEG_THUMBNAIL_QUALITY = "jpeg-thumbnail-quality";
        private static final String KEY_JPEG_THUMBNAIL_SIZE = "jpeg-thumbnail-size";
        private static final String KEY_JPEG_THUMBNAIL_WIDTH = "jpeg-thumbnail-width";
        private static final String KEY_MAX_EXPOSURE_COMPENSATION = "max-exposure-compensation";
        private static final String KEY_MAX_NUM_DETECTED_FACES_HW = "max-num-detected-faces-hw";
        private static final String KEY_MAX_NUM_DETECTED_FACES_SW = "max-num-detected-faces-sw";
        private static final String KEY_MAX_NUM_FOCUS_AREAS = "max-num-focus-areas";
        private static final String KEY_MAX_NUM_METERING_AREAS = "max-num-metering-areas";
        private static final String KEY_MAX_ZOOM = "max-zoom";
        private static final String KEY_METERING_AREAS = "metering-areas";
        private static final String KEY_MIN_EXPOSURE_COMPENSATION = "min-exposure-compensation";
        private static final String KEY_PICTURE_FORMAT = "picture-format";
        private static final String KEY_PICTURE_SIZE = "picture-size";
        private static final String KEY_PREFERRED_PREVIEW_SIZE_FOR_VIDEO = "preferred-preview-size-for-video";
        private static final String KEY_PREVIEW_FORMAT = "preview-format";
        private static final String KEY_PREVIEW_FPS_RANGE = "preview-fps-range";
        private static final String KEY_PREVIEW_FRAME_RATE = "preview-frame-rate";
        private static final String KEY_PREVIEW_SIZE = "preview-size";
        private static final String KEY_RECORDING_HINT = "recording-hint";
        private static final String KEY_ROTATION = "rotation";
        private static final String KEY_SCENE_MODE = "scene-mode";
        private static final String KEY_SMOOTH_ZOOM_SUPPORTED = "smooth-zoom-supported";
        private static final String KEY_VERTICAL_VIEW_ANGLE = "vertical-view-angle";
        private static final String KEY_VIDEO_SIZE = "video-size";
        private static final String KEY_VIDEO_SNAPSHOT_SUPPORTED = "video-snapshot-supported";
        private static final String KEY_VIDEO_STABILIZATION = "video-stabilization";
        private static final String KEY_VIDEO_STABILIZATION_SUPPORTED = "video-stabilization-supported";
        private static final String KEY_WHITE_BALANCE = "whitebalance";
        private static final String KEY_ZOOM = "zoom";
        private static final String KEY_ZOOM_RATIOS = "zoom-ratios";
        private static final String KEY_ZOOM_SUPPORTED = "zoom-supported";
        private static final String PIXEL_FORMAT_BAYER_RGGB = "bayer-rggb";
        private static final String PIXEL_FORMAT_JPEG = "jpeg";
        private static final String PIXEL_FORMAT_RGB565 = "rgb565";
        private static final String PIXEL_FORMAT_YUV420P = "yuv420p";
        private static final String PIXEL_FORMAT_YUV420SP = "yuv420sp";
        private static final String PIXEL_FORMAT_YUV422I = "yuv422i-yuyv";
        private static final String PIXEL_FORMAT_YUV422SP = "yuv422sp";
        public static final int PREVIEW_FPS_MAX_INDEX = 1;
        public static final int PREVIEW_FPS_MIN_INDEX = 0;
        public static final String SCENE_MODE_ACTION = "action";
        public static final String SCENE_MODE_AUTO = "auto";
        public static final String SCENE_MODE_BARCODE = "barcode";
        public static final String SCENE_MODE_BEACH = "beach";
        public static final String SCENE_MODE_CANDLELIGHT = "candlelight";
        public static final String SCENE_MODE_FIREWORKS = "fireworks";
        public static final String SCENE_MODE_HDR = "hdr";
        public static final String SCENE_MODE_LANDSCAPE = "landscape";
        public static final String SCENE_MODE_NIGHT = "night";
        public static final String SCENE_MODE_NIGHT_PORTRAIT = "night-portrait";
        public static final String SCENE_MODE_PARTY = "party";
        public static final String SCENE_MODE_PORTRAIT = "portrait";
        public static final String SCENE_MODE_SNOW = "snow";
        public static final String SCENE_MODE_SPORTS = "sports";
        public static final String SCENE_MODE_STEADYPHOTO = "steadyphoto";
        public static final String SCENE_MODE_SUNSET = "sunset";
        public static final String SCENE_MODE_THEATRE = "theatre";
        private static final String SUPPORTED_VALUES_SUFFIX = "-values";
        private static final String TRUE = "true";
        public static final String WHITE_BALANCE_AUTO = "auto";
        public static final String WHITE_BALANCE_CLOUDY_DAYLIGHT = "cloudy-daylight";
        public static final String WHITE_BALANCE_DAYLIGHT = "daylight";
        public static final String WHITE_BALANCE_FLUORESCENT = "fluorescent";
        public static final String WHITE_BALANCE_INCANDESCENT = "incandescent";
        public static final String WHITE_BALANCE_SHADE = "shade";
        public static final String WHITE_BALANCE_TWILIGHT = "twilight";
        public static final String WHITE_BALANCE_WARM_FLUORESCENT = "warm-fluorescent";
        private final LinkedHashMap<String, String> mMap = new LinkedHashMap(64);

        private Parameters() {
        }

        private String cameraFormatForPixelFormat(int n) {
            switch (n) {
                default: {
                    return null;
                }
                case 16: {
                    return PIXEL_FORMAT_YUV422SP;
                }
                case 17: {
                    return PIXEL_FORMAT_YUV420SP;
                }
                case 20: {
                    return PIXEL_FORMAT_YUV422I;
                }
                case 842094169: {
                    return PIXEL_FORMAT_YUV420P;
                }
                case 4: {
                    return PIXEL_FORMAT_RGB565;
                }
                case 256: 
            }
            return PIXEL_FORMAT_JPEG;
        }

        private float getFloat(String string2, float f) {
            try {
                float f2 = Float.parseFloat(this.mMap.get(string2));
                return f2;
            }
            catch (NumberFormatException numberFormatException) {
                return f;
            }
        }

        private int getInt(String string2, int n) {
            try {
                int n2 = Integer.parseInt(this.mMap.get(string2));
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
        }

        private Camera getOuter() {
            return Camera.this;
        }

        /*
         * Enabled aggressive block sorting
         */
        private int pixelFormatForCameraFormat(String string2) {
            block9: {
                block8: {
                    if (string2 == null) break block8;
                    if (string2.equals(PIXEL_FORMAT_YUV422SP)) {
                        return 16;
                    }
                    if (string2.equals(PIXEL_FORMAT_YUV420SP)) {
                        return 17;
                    }
                    if (string2.equals(PIXEL_FORMAT_YUV422I)) {
                        return 20;
                    }
                    if (string2.equals(PIXEL_FORMAT_YUV420P)) {
                        return 842094169;
                    }
                    if (string2.equals(PIXEL_FORMAT_RGB565)) {
                        return 4;
                    }
                    if (string2.equals(PIXEL_FORMAT_JPEG)) break block9;
                }
                return 0;
            }
            return 256;
        }

        private void put(String string2, String string3) {
            this.mMap.remove(string2);
            this.mMap.put(string2, string3);
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean same(String string2, String string3) {
            return string2 == null && string3 == null || string2 != null && string2.equals(string3);
        }

        private void set(String string2, List<Area> list) {
            if (list == null) {
                this.set(string2, "(0,0,0,0,0)");
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < list.size(); ++i) {
                Area area = list.get(i);
                Rect rect = area.rect;
                stringBuilder.append('(');
                stringBuilder.append(rect.left);
                stringBuilder.append(',');
                stringBuilder.append(rect.top);
                stringBuilder.append(',');
                stringBuilder.append(rect.right);
                stringBuilder.append(',');
                stringBuilder.append(rect.bottom);
                stringBuilder.append(',');
                stringBuilder.append(area.weight);
                stringBuilder.append(')');
                if (i == -1 + list.size()) continue;
                stringBuilder.append(',');
            }
            this.set(string2, stringBuilder.toString());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private ArrayList<String> split(String string2) {
            if (string2 == null) {
                return null;
            }
            TextUtils.SimpleStringSplitter simpleStringSplitter = new TextUtils.SimpleStringSplitter(',');
            simpleStringSplitter.setString(string2);
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = simpleStringSplitter.iterator();
            while (iterator.hasNext()) {
                arrayList.add((String)iterator.next());
            }
            return arrayList;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private ArrayList<Area> splitArea(String string2) {
            int n;
            if (string2 == null || string2.charAt(0) != '(' || string2.charAt(-1 + string2.length()) != ')') {
                Log.e(Camera.TAG, "Invalid area string=" + string2);
                return null;
            }
            ArrayList<Area> arrayList = new ArrayList<Area>();
            int n2 = 1;
            int[] nArray = new int[5];
            do {
                if ((n = string2.indexOf("),(", n2)) == -1) {
                    n = -1 + string2.length();
                }
                this.splitInt(string2.substring(n2, n), nArray);
                arrayList.add(new Area(new Rect(nArray[0], nArray[1], nArray[2], nArray[3]), nArray[4]));
                n2 = n + 3;
            } while (n != -1 + string2.length());
            if (arrayList.size() == 0) {
                return null;
            }
            if (arrayList.size() != 1) return arrayList;
            Area area = (Area)arrayList.get(0);
            Rect rect = area.rect;
            if (rect.left != 0) return arrayList;
            if (rect.top != 0) return arrayList;
            if (rect.right != 0) return arrayList;
            if (rect.bottom != 0) return arrayList;
            if (area.weight != 0) return arrayList;
            return null;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void splitFloat(String string2, float[] fArray) {
            if (string2 != null) {
                TextUtils.SimpleStringSplitter simpleStringSplitter = new TextUtils.SimpleStringSplitter(',');
                simpleStringSplitter.setString(string2);
                int n = 0;
                for (String string3 : simpleStringSplitter) {
                    int n2 = n + 1;
                    fArray[n] = Float.parseFloat(string3);
                    n = n2;
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private ArrayList<Integer> splitInt(String string2) {
            if (string2 == null) {
                return null;
            }
            TextUtils.SimpleStringSplitter simpleStringSplitter = new TextUtils.SimpleStringSplitter(',');
            simpleStringSplitter.setString(string2);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            Iterator iterator = simpleStringSplitter.iterator();
            while (iterator.hasNext()) {
                arrayList.add(Integer.parseInt((String)iterator.next()));
            }
            if (arrayList.size() != 0) return arrayList;
            return null;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void splitInt(String string2, int[] nArray) {
            if (string2 != null) {
                TextUtils.SimpleStringSplitter simpleStringSplitter = new TextUtils.SimpleStringSplitter(',');
                simpleStringSplitter.setString(string2);
                int n = 0;
                for (String string3 : simpleStringSplitter) {
                    int n2 = n + 1;
                    nArray[n] = Integer.parseInt(string3);
                    n = n2;
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private ArrayList<int[]> splitRange(String string2) {
            int n;
            if (string2 == null || string2.charAt(0) != '(' || string2.charAt(-1 + string2.length()) != ')') {
                Log.e(Camera.TAG, "Invalid range list string=" + string2);
                return null;
            }
            ArrayList<int[]> arrayList = new ArrayList<int[]>();
            int n2 = 1;
            do {
                int[] nArray = new int[2];
                n = string2.indexOf("),(", n2);
                if (n == -1) {
                    n = -1 + string2.length();
                }
                this.splitInt(string2.substring(n2, n), nArray);
                arrayList.add(nArray);
                n2 = n + 3;
            } while (n != -1 + string2.length());
            if (arrayList.size() != 0) return arrayList;
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private ArrayList<Size> splitSize(String string2) {
            if (string2 == null) {
                return null;
            }
            TextUtils.SimpleStringSplitter simpleStringSplitter = new TextUtils.SimpleStringSplitter(',');
            simpleStringSplitter.setString(string2);
            ArrayList<Size> arrayList = new ArrayList<Size>();
            Iterator iterator = simpleStringSplitter.iterator();
            while (iterator.hasNext()) {
                Size size = this.strToSize((String)iterator.next());
                if (size == null) continue;
                arrayList.add(size);
            }
            if (arrayList.size() != 0) return arrayList;
            return null;
        }

        private Size strToSize(String string2) {
            if (string2 == null) {
                return null;
            }
            int n = string2.indexOf(120);
            if (n != -1) {
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                return new Size(Integer.parseInt(string3), Integer.parseInt(string4));
            }
            Log.e(Camera.TAG, "Invalid size parameter string=" + string2);
            return null;
        }

        public void copyFrom(Parameters parameters) {
            if (parameters == null) {
                throw new NullPointerException("other must not be null");
            }
            this.mMap.putAll(parameters.mMap);
        }

        @Deprecated
        public void dump() {
            Log.e(Camera.TAG, "dump: size=" + this.mMap.size());
            for (String string2 : this.mMap.keySet()) {
                Log.e(Camera.TAG, "dump: " + string2 + "=" + this.mMap.get(string2));
            }
        }

        public String flatten() {
            StringBuilder stringBuilder = new StringBuilder(128);
            for (String string2 : this.mMap.keySet()) {
                stringBuilder.append(string2);
                stringBuilder.append("=");
                stringBuilder.append(this.mMap.get(string2));
                stringBuilder.append(";");
            }
            stringBuilder.deleteCharAt(-1 + stringBuilder.length());
            return stringBuilder.toString();
        }

        public String get(String string2) {
            return this.mMap.get(string2);
        }

        public String getAntibanding() {
            return this.get(KEY_ANTIBANDING);
        }

        public boolean getAutoExposureLock() {
            return TRUE.equals(this.get(KEY_AUTO_EXPOSURE_LOCK));
        }

        public boolean getAutoWhiteBalanceLock() {
            return TRUE.equals(this.get(KEY_AUTO_WHITEBALANCE_LOCK));
        }

        public String getColorEffect() {
            return this.get(KEY_EFFECT);
        }

        public int getExposureCompensation() {
            return this.getInt(KEY_EXPOSURE_COMPENSATION, 0);
        }

        public float getExposureCompensationStep() {
            return this.getFloat(KEY_EXPOSURE_COMPENSATION_STEP, 0.0f);
        }

        public String getFlashMode() {
            return this.get(KEY_FLASH_MODE);
        }

        public float getFocalLength() {
            return Float.parseFloat(this.get(KEY_FOCAL_LENGTH));
        }

        public List<Area> getFocusAreas() {
            return this.splitArea(this.get(KEY_FOCUS_AREAS));
        }

        public void getFocusDistances(float[] fArray) {
            if (fArray == null || fArray.length != 3) {
                throw new IllegalArgumentException("output must be a float array with three elements.");
            }
            this.splitFloat(this.get(KEY_FOCUS_DISTANCES), fArray);
        }

        public String getFocusMode() {
            return this.get(KEY_FOCUS_MODE);
        }

        public float getHorizontalViewAngle() {
            return Float.parseFloat(this.get(KEY_HORIZONTAL_VIEW_ANGLE));
        }

        public int getInt(String string2) {
            return Integer.parseInt(this.mMap.get(string2));
        }

        public int getJpegQuality() {
            return this.getInt(KEY_JPEG_QUALITY);
        }

        public int getJpegThumbnailQuality() {
            return this.getInt(KEY_JPEG_THUMBNAIL_QUALITY);
        }

        public Size getJpegThumbnailSize() {
            return new Size(this.getInt(KEY_JPEG_THUMBNAIL_WIDTH), this.getInt(KEY_JPEG_THUMBNAIL_HEIGHT));
        }

        public int getMaxExposureCompensation() {
            return this.getInt(KEY_MAX_EXPOSURE_COMPENSATION, 0);
        }

        public int getMaxNumDetectedFaces() {
            return this.getInt(KEY_MAX_NUM_DETECTED_FACES_HW, 0);
        }

        public int getMaxNumFocusAreas() {
            return this.getInt(KEY_MAX_NUM_FOCUS_AREAS, 0);
        }

        public int getMaxNumMeteringAreas() {
            return this.getInt(KEY_MAX_NUM_METERING_AREAS, 0);
        }

        public int getMaxZoom() {
            return this.getInt(KEY_MAX_ZOOM, 0);
        }

        public List<Area> getMeteringAreas() {
            return this.splitArea(this.get(KEY_METERING_AREAS));
        }

        public int getMinExposureCompensation() {
            return this.getInt(KEY_MIN_EXPOSURE_COMPENSATION, 0);
        }

        public int getPictureFormat() {
            return this.pixelFormatForCameraFormat(this.get(KEY_PICTURE_FORMAT));
        }

        public Size getPictureSize() {
            return this.strToSize(this.get(KEY_PICTURE_SIZE));
        }

        public Size getPreferredPreviewSizeForVideo() {
            return this.strToSize(this.get(KEY_PREFERRED_PREVIEW_SIZE_FOR_VIDEO));
        }

        public int getPreviewFormat() {
            return this.pixelFormatForCameraFormat(this.get(KEY_PREVIEW_FORMAT));
        }

        public void getPreviewFpsRange(int[] nArray) {
            if (nArray == null || nArray.length != 2) {
                throw new IllegalArgumentException("range must be an array with two elements.");
            }
            this.splitInt(this.get(KEY_PREVIEW_FPS_RANGE), nArray);
        }

        @Deprecated
        public int getPreviewFrameRate() {
            return this.getInt(KEY_PREVIEW_FRAME_RATE);
        }

        public Size getPreviewSize() {
            return this.strToSize(this.get(KEY_PREVIEW_SIZE));
        }

        public String getSceneMode() {
            return this.get(KEY_SCENE_MODE);
        }

        public List<String> getSupportedAntibanding() {
            return this.split(this.get("antibanding-values"));
        }

        public List<String> getSupportedColorEffects() {
            return this.split(this.get("effect-values"));
        }

        public List<String> getSupportedFlashModes() {
            return this.split(this.get("flash-mode-values"));
        }

        public List<String> getSupportedFocusModes() {
            return this.split(this.get("focus-mode-values"));
        }

        public List<Size> getSupportedJpegThumbnailSizes() {
            return this.splitSize(this.get("jpeg-thumbnail-size-values"));
        }

        public List<Integer> getSupportedPictureFormats() {
            String string2 = this.get("picture-format-values");
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            Iterator<String> iterator = this.split(string2).iterator();
            while (iterator.hasNext()) {
                int n = this.pixelFormatForCameraFormat(iterator.next());
                if (n == 0) continue;
                arrayList.add(n);
            }
            return arrayList;
        }

        public List<Size> getSupportedPictureSizes() {
            return this.splitSize(this.get("picture-size-values"));
        }

        public List<Integer> getSupportedPreviewFormats() {
            String string2 = this.get("preview-format-values");
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            Iterator<String> iterator = this.split(string2).iterator();
            while (iterator.hasNext()) {
                int n = this.pixelFormatForCameraFormat(iterator.next());
                if (n == 0) continue;
                arrayList.add(n);
            }
            return arrayList;
        }

        public List<int[]> getSupportedPreviewFpsRange() {
            return this.splitRange(this.get("preview-fps-range-values"));
        }

        @Deprecated
        public List<Integer> getSupportedPreviewFrameRates() {
            return this.splitInt(this.get("preview-frame-rate-values"));
        }

        public List<Size> getSupportedPreviewSizes() {
            return this.splitSize(this.get("preview-size-values"));
        }

        public List<String> getSupportedSceneModes() {
            return this.split(this.get("scene-mode-values"));
        }

        public List<Size> getSupportedVideoSizes() {
            return this.splitSize(this.get("video-size-values"));
        }

        public List<String> getSupportedWhiteBalance() {
            return this.split(this.get("whitebalance-values"));
        }

        public float getVerticalViewAngle() {
            return Float.parseFloat(this.get(KEY_VERTICAL_VIEW_ANGLE));
        }

        public boolean getVideoStabilization() {
            return TRUE.equals(this.get(KEY_VIDEO_STABILIZATION));
        }

        public String getWhiteBalance() {
            return this.get(KEY_WHITE_BALANCE);
        }

        public int getZoom() {
            return this.getInt(KEY_ZOOM, 0);
        }

        public List<Integer> getZoomRatios() {
            return this.splitInt(this.get(KEY_ZOOM_RATIOS));
        }

        public boolean isAutoExposureLockSupported() {
            return TRUE.equals(this.get(KEY_AUTO_EXPOSURE_LOCK_SUPPORTED));
        }

        public boolean isAutoWhiteBalanceLockSupported() {
            return TRUE.equals(this.get(KEY_AUTO_WHITEBALANCE_LOCK_SUPPORTED));
        }

        public boolean isSmoothZoomSupported() {
            return TRUE.equals(this.get(KEY_SMOOTH_ZOOM_SUPPORTED));
        }

        public boolean isVideoSnapshotSupported() {
            return TRUE.equals(this.get(KEY_VIDEO_SNAPSHOT_SUPPORTED));
        }

        public boolean isVideoStabilizationSupported() {
            return TRUE.equals(this.get(KEY_VIDEO_STABILIZATION_SUPPORTED));
        }

        public boolean isZoomSupported() {
            return TRUE.equals(this.get(KEY_ZOOM_SUPPORTED));
        }

        public void remove(String string2) {
            this.mMap.remove(string2);
        }

        public void removeGpsData() {
            this.remove(KEY_GPS_LATITUDE);
            this.remove(KEY_GPS_LONGITUDE);
            this.remove(KEY_GPS_ALTITUDE);
            this.remove(KEY_GPS_TIMESTAMP);
            this.remove(KEY_GPS_PROCESSING_METHOD);
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean same(Parameters parameters) {
            return this == parameters || parameters != null && this.mMap.equals(parameters.mMap);
        }

        public void set(String string2, int n) {
            this.put(string2, Integer.toString(n));
        }

        public void set(String string2, String string3) {
            if (string2.indexOf(61) != -1 || string2.indexOf(59) != -1 || string2.indexOf(0) != -1) {
                Log.e(Camera.TAG, "Key \"" + string2 + "\" contains invalid character (= or ; or \\0)");
                return;
            }
            if (string3.indexOf(61) != -1 || string3.indexOf(59) != -1 || string3.indexOf(0) != -1) {
                Log.e(Camera.TAG, "Value \"" + string3 + "\" contains invalid character (= or ; or \\0)");
                return;
            }
            this.put(string2, string3);
        }

        public void setAntibanding(String string2) {
            this.set(KEY_ANTIBANDING, string2);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setAutoExposureLock(boolean bl) {
            String string2 = bl ? TRUE : FALSE;
            this.set(KEY_AUTO_EXPOSURE_LOCK, string2);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setAutoWhiteBalanceLock(boolean bl) {
            String string2 = bl ? TRUE : FALSE;
            this.set(KEY_AUTO_WHITEBALANCE_LOCK, string2);
        }

        public void setColorEffect(String string2) {
            this.set(KEY_EFFECT, string2);
        }

        public void setExposureCompensation(int n) {
            this.set(KEY_EXPOSURE_COMPENSATION, n);
        }

        public void setFlashMode(String string2) {
            this.set(KEY_FLASH_MODE, string2);
        }

        public void setFocusAreas(List<Area> list) {
            this.set(KEY_FOCUS_AREAS, list);
        }

        public void setFocusMode(String string2) {
            this.set(KEY_FOCUS_MODE, string2);
        }

        public void setGpsAltitude(double d) {
            this.set(KEY_GPS_ALTITUDE, Double.toString(d));
        }

        public void setGpsLatitude(double d) {
            this.set(KEY_GPS_LATITUDE, Double.toString(d));
        }

        public void setGpsLongitude(double d) {
            this.set(KEY_GPS_LONGITUDE, Double.toString(d));
        }

        public void setGpsProcessingMethod(String string2) {
            this.set(KEY_GPS_PROCESSING_METHOD, string2);
        }

        public void setGpsTimestamp(long l) {
            this.set(KEY_GPS_TIMESTAMP, Long.toString(l));
        }

        public void setJpegQuality(int n) {
            this.set(KEY_JPEG_QUALITY, n);
        }

        public void setJpegThumbnailQuality(int n) {
            this.set(KEY_JPEG_THUMBNAIL_QUALITY, n);
        }

        public void setJpegThumbnailSize(int n, int n2) {
            this.set(KEY_JPEG_THUMBNAIL_WIDTH, n);
            this.set(KEY_JPEG_THUMBNAIL_HEIGHT, n2);
        }

        public void setMeteringAreas(List<Area> list) {
            this.set(KEY_METERING_AREAS, list);
        }

        public void setPictureFormat(int n) {
            String string2 = this.cameraFormatForPixelFormat(n);
            if (string2 == null) {
                throw new IllegalArgumentException("Invalid pixel_format=" + n);
            }
            this.set(KEY_PICTURE_FORMAT, string2);
        }

        public void setPictureSize(int n, int n2) {
            this.set(KEY_PICTURE_SIZE, Integer.toString(n) + "x" + Integer.toString(n2));
        }

        public void setPreviewFormat(int n) {
            String string2 = this.cameraFormatForPixelFormat(n);
            if (string2 == null) {
                throw new IllegalArgumentException("Invalid pixel_format=" + n);
            }
            this.set(KEY_PREVIEW_FORMAT, string2);
        }

        public void setPreviewFpsRange(int n, int n2) {
            this.set(KEY_PREVIEW_FPS_RANGE, "" + n + "," + n2);
        }

        @Deprecated
        public void setPreviewFrameRate(int n) {
            this.set(KEY_PREVIEW_FRAME_RATE, n);
        }

        public void setPreviewSize(int n, int n2) {
            this.set(KEY_PREVIEW_SIZE, Integer.toString(n) + "x" + Integer.toString(n2));
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setRecordingHint(boolean bl) {
            String string2 = bl ? TRUE : FALSE;
            this.set(KEY_RECORDING_HINT, string2);
        }

        public void setRotation(int n) {
            if (n == 0 || n == 90 || n == 180 || n == 270) {
                this.set(KEY_ROTATION, Integer.toString(n));
                return;
            }
            throw new IllegalArgumentException("Invalid rotation=" + n);
        }

        public void setSceneMode(String string2) {
            this.set(KEY_SCENE_MODE, string2);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setVideoStabilization(boolean bl) {
            String string2 = bl ? TRUE : FALSE;
            this.set(KEY_VIDEO_STABILIZATION, string2);
        }

        public void setWhiteBalance(String string2) {
            if (this.same(string2, this.get(KEY_WHITE_BALANCE))) {
                return;
            }
            this.set(KEY_WHITE_BALANCE, string2);
            this.set(KEY_AUTO_WHITEBALANCE_LOCK, FALSE);
        }

        public void setZoom(int n) {
            this.set(KEY_ZOOM, n);
        }

        public void unflatten(String string2) {
            this.mMap.clear();
            TextUtils.SimpleStringSplitter simpleStringSplitter = new TextUtils.SimpleStringSplitter(';');
            simpleStringSplitter.setString(string2);
            for (String string3 : simpleStringSplitter) {
                int n = string3.indexOf(61);
                if (n == -1) continue;
                String string4 = string3.substring(0, n);
                String string5 = string3.substring(n + 1);
                this.mMap.put(string4, string5);
            }
        }
    }

    @Deprecated
    public static interface PictureCallback {
        public void onPictureTaken(byte[] var1, Camera var2);
    }

    @Deprecated
    public static interface PreviewCallback {
        public void onPreviewFrame(byte[] var1, Camera var2);
    }

    @Deprecated
    public static interface ShutterCallback {
        public void onShutter();
    }

    @Deprecated
    public class Size {
        public int height;
        public int width;

        public Size(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (!(object instanceof Size)) break block2;
                    Size size = (Size)object;
                    if (this.width == size.width && this.height == size.height) break block3;
                }
                return false;
            }
            return true;
        }

        public int hashCode() {
            return 32713 * this.width + this.height;
        }
    }
}

