/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.Camera;
import android.hardware.camera2.params.Face;
import android.hardware.camera2.params.MeteringRectangle;
import android.hardware.camera2.utils.ListUtils;
import android.hardware.camera2.utils.ParamsUtils;
import android.hardware.camera2.utils.SizeAreaComparator;
import android.util.Log;
import android.util.Size;
import android.util.SizeF;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class ParameterUtils {
    public static final Camera.Area CAMERA_AREA_DEFAULT;
    public static final Rect NORMALIZED_RECTANGLE_DEFAULT;
    public static final int NORMALIZED_RECTANGLE_MAX = 1000;
    public static final int NORMALIZED_RECTANGLE_MIN = -1000;
    public static final Rect RECTANGLE_EMPTY;
    private static final String TAG = "ParameterUtils";
    private static final boolean VERBOSE = false;
    private static final int ZOOM_RATIO_MULTIPLIER = 100;

    static {
        NORMALIZED_RECTANGLE_DEFAULT = new Rect(-1000, -1000, 1000, 1000);
        CAMERA_AREA_DEFAULT = new Camera.Area(new Rect(NORMALIZED_RECTANGLE_DEFAULT), 1);
        RECTANGLE_EMPTY = new Rect(0, 0, 0, 0);
        VERBOSE = Log.isLoggable(TAG, 2);
    }

    private ParameterUtils() {
        throw new AssertionError();
    }

    public static boolean containsSize(List<Camera.Size> list, int n, int n2) {
        Preconditions.checkNotNull(list, "sizeList must not be null");
        for (Camera.Size size : list) {
            if (size.height != n2 || size.width != n) continue;
            return true;
        }
        return false;
    }

    public static WeightedRectangle convertCameraAreaToActiveArrayRectangle(Rect rect, ZoomData zoomData, Camera.Area area) {
        return ParameterUtils.convertCameraAreaToActiveArrayRectangle(rect, zoomData, area, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static WeightedRectangle convertCameraAreaToActiveArrayRectangle(Rect rect, ZoomData zoomData, Camera.Area area, boolean bl) {
        Rect rect2 = zoomData.previewCrop;
        Rect rect3 = zoomData.reportedCrop;
        float f = 1.0f * (float)rect2.width() / 2000.0f;
        float f2 = 1.0f * (float)rect2.height() / 2000.0f;
        Matrix matrix = new Matrix();
        matrix.setTranslate(1000.0f, 1000.0f);
        matrix.postScale(f, f2);
        matrix.postTranslate(rect2.left, rect2.top);
        Rect rect4 = bl ? rect2 : rect3;
        Rect rect5 = ParamsUtils.mapRect(matrix, area.rect);
        if (!rect5.intersect(rect4)) {
            rect5.set(RECTANGLE_EMPTY);
        }
        if (area.weight < 0) {
            Log.w(TAG, "convertCameraAreaToMeteringRectangle - rectangle " + ParameterUtils.stringFromArea(area) + " has too small weight, clip to 0");
        }
        return new WeightedRectangle(rect5, area.weight);
    }

    private static Point convertCameraPointToActiveArrayPoint(Rect rect, ZoomData zoomData, Point point, boolean bl) {
        WeightedRectangle weightedRectangle = ParameterUtils.convertCameraAreaToActiveArrayRectangle(rect, zoomData, new Camera.Area(new Rect(point.x, point.y, point.x, point.y), 1), bl);
        return new Point(weightedRectangle.rect.left, weightedRectangle.rect.top);
    }

    public static Face convertFaceFromLegacy(Camera.Face face, Rect rect, ZoomData zoomData) {
        Preconditions.checkNotNull(face, "face must not be null");
        WeightedRectangle weightedRectangle = ParameterUtils.convertCameraAreaToActiveArrayRectangle(rect, zoomData, new Camera.Area(face.rect, 1));
        Point point = face.leftEye;
        Point point2 = face.rightEye;
        Point point3 = face.mouth;
        if (point != null && point2 != null && point3 != null) {
            Point point4 = ParameterUtils.convertCameraPointToActiveArrayPoint(rect, zoomData, point, true);
            Point point5 = ParameterUtils.convertCameraPointToActiveArrayPoint(rect, zoomData, point4, true);
            Point point6 = ParameterUtils.convertCameraPointToActiveArrayPoint(rect, zoomData, point4, true);
            return weightedRectangle.toFace(face.id, point4, point5, point6);
        }
        return weightedRectangle.toFace();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static MeteringData convertMeteringRectangleToLegacy(Rect rect, MeteringRectangle meteringRectangle, ZoomData zoomData) {
        Rect rect2;
        Camera.Area area;
        Rect rect3 = zoomData.previewCrop;
        float f = 2000.0f / (float)rect3.width();
        float f2 = 2000.0f / (float)rect3.height();
        Matrix matrix = new Matrix();
        matrix.setTranslate(-rect3.left, -rect3.top);
        matrix.postScale(f, f2);
        matrix.postTranslate(-1000.0f, -1000.0f);
        Rect rect4 = ParamsUtils.mapRect(matrix, meteringRectangle.getRect());
        Rect rect5 = new Rect(rect4);
        if (!rect5.intersect(NORMALIZED_RECTANGLE_DEFAULT)) {
            Log.w(TAG, "convertMeteringRectangleToLegacy - metering rectangle too small, no metering will be done");
            rect5.set(RECTANGLE_EMPTY);
            area = new Camera.Area(RECTANGLE_EMPTY, 0);
        } else {
            area = new Camera.Area(rect5, meteringRectangle.getMeteringWeight());
        }
        if (!(rect2 = meteringRectangle.getRect()).intersect(rect3)) {
            rect2.set(RECTANGLE_EMPTY);
        }
        Rect rect6 = ParameterUtils.convertCameraAreaToActiveArrayRectangle((Rect)rect, (ZoomData)zoomData, (Camera.Area)new Camera.Area((Rect)rect4, (int)meteringRectangle.getMeteringWeight()), (boolean)false).rect;
        if (VERBOSE) {
            Object[] objectArray = new Object[]{rect, meteringRectangle, rect3, ParameterUtils.stringFromArea(area), rect2, rect6, rect4};
            Log.v(TAG, String.format("convertMeteringRectangleToLegacy - activeArray = %s, meteringRect = %s, previewCrop = %s, meteringArea = %s, previewMetering = %s, reportedMetering = %s, normalizedRegionUnbounded = %s", objectArray));
        }
        return new MeteringData(area, rect2, rect6);
    }

    public static ZoomData convertScalerCropRegion(Rect rect, Rect rect2, Size size, Camera.Parameters parameters) {
        Rect rect3 = new Rect(0, 0, rect.width(), rect.height());
        Rect rect4 = rect2;
        if (rect4 == null) {
            rect4 = rect3;
        }
        if (VERBOSE) {
            Log.v(TAG, "convertScalerCropRegion - user crop region was " + rect4);
        }
        Rect rect5 = new Rect();
        Rect rect6 = new Rect();
        int n = ParameterUtils.getClosestAvailableZoomCrop(parameters, rect3, size, rect4, rect5, rect6);
        if (VERBOSE) {
            Log.v(TAG, "convertScalerCropRegion - zoom calculated to: zoomIndex = " + n + ", reported crop region = " + rect5 + ", preview crop region = " + rect6);
        }
        return new ZoomData(n, rect6, rect5);
    }

    public static Size convertSize(Camera.Size size) {
        Preconditions.checkNotNull(size, "size must not be null");
        return new Size(size.width, size.height);
    }

    public static List<Size> convertSizeList(List<Camera.Size> list) {
        Preconditions.checkNotNull(list, "sizeList must not be null");
        ArrayList<Size> arrayList = new ArrayList<Size>(list.size());
        for (Camera.Size size : list) {
            arrayList.add(new Size(size.width, size.height));
        }
        return arrayList;
    }

    public static Size[] convertSizeListToArray(List<Camera.Size> list) {
        Preconditions.checkNotNull(list, "sizeList must not be null");
        Size[] sizeArray = new Size[list.size()];
        int n = 0;
        for (Camera.Size size : list) {
            int n2 = n + 1;
            sizeArray[n] = new Size(size.width, size.height);
            n = n2;
        }
        return sizeArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<Rect> getAvailableCropRectangles(Camera.Parameters parameters, Rect rect, Size size) {
        Preconditions.checkNotNull(parameters, "params must not be null");
        Preconditions.checkNotNull(rect, "activeArray must not be null");
        Preconditions.checkNotNull(size, "streamSize must not be null");
        Rect rect2 = ParameterUtils.getPreviewCropRectangleUnzoomed(rect, size);
        if (!parameters.isZoomSupported()) {
            return new ArrayList<Rect>(Arrays.asList(rect2));
        }
        ArrayList<Rect> arrayList = new ArrayList(1 + parameters.getMaxZoom());
        Matrix matrix = new Matrix();
        RectF rectF = new RectF();
        Iterator<Integer> iterator = parameters.getZoomRatios().iterator();
        while (iterator.hasNext()) {
            float f = 100.0f / (float)iterator.next().intValue();
            ParamsUtils.convertRectF(rect2, rectF);
            matrix.setScale(f, f, rect.exactCenterX(), rect.exactCenterY());
            matrix.mapRect(rectF);
            arrayList.add(ParamsUtils.createRect(rectF));
        }
        return arrayList;
    }

    public static List<Rect> getAvailablePreviewZoomCropRectangles(Camera.Parameters parameters, Rect rect, Size size) {
        Preconditions.checkNotNull(parameters, "params must not be null");
        Preconditions.checkNotNull(rect, "activeArray must not be null");
        Preconditions.checkNotNull(size, "previewSize must not be null");
        return ParameterUtils.getAvailableCropRectangles(parameters, rect, size);
    }

    public static List<Rect> getAvailableZoomCropRectangles(Camera.Parameters parameters, Rect rect) {
        Preconditions.checkNotNull(parameters, "params must not be null");
        Preconditions.checkNotNull(rect, "activeArray must not be null");
        return ParameterUtils.getAvailableCropRectangles(parameters, rect, ParamsUtils.createSize(rect));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getClosestAvailableZoomCrop(Camera.Parameters parameters, Rect rect, Size size, Rect rect2, Rect rect3, Rect rect4) {
        Preconditions.checkNotNull(parameters, "params must not be null");
        Preconditions.checkNotNull(rect, "activeArray must not be null");
        Preconditions.checkNotNull(size, "streamSize must not be null");
        Preconditions.checkNotNull(rect3, "reportedCropRegion must not be null");
        Preconditions.checkNotNull(rect4, "previewCropRegion must not be null");
        Rect rect5 = new Rect(rect2);
        if (!rect5.intersect(rect)) {
            Log.w(TAG, "getClosestAvailableZoomCrop - Crop region out of range; setting to active array size");
            rect5.set(rect);
        }
        Rect rect6 = ParameterUtils.getPreviewCropRectangleUnzoomed(rect, size);
        Rect rect7 = ParameterUtils.shrinkToSameAspectRatioCentered(rect6, rect5);
        if (VERBOSE) {
            Log.v(TAG, "getClosestAvailableZoomCrop - actualCrop = " + rect5);
            Log.v(TAG, "getClosestAvailableZoomCrop - previewCrop = " + rect6);
            Log.v(TAG, "getClosestAvailableZoomCrop - cropRegionAsPreview = " + rect7);
        }
        Rect rect8 = null;
        Rect rect9 = null;
        int n = -1;
        List<Rect> list = ParameterUtils.getAvailableZoomCropRectangles(parameters, rect);
        List<Rect> list2 = ParameterUtils.getAvailablePreviewZoomCropRectangles(parameters, rect, size);
        if (VERBOSE) {
            Log.v(TAG, "getClosestAvailableZoomCrop - availableReportedCropRegions = " + ListUtils.listToString(list));
            Log.v(TAG, "getClosestAvailableZoomCrop - availablePreviewCropRegions = " + ListUtils.listToString(list2));
        }
        if (list.size() != list2.size()) {
            throw new AssertionError((Object)"available reported/preview crop region size mismatch");
        }
        int n2 = 0;
        while (n2 < list.size()) {
            Rect rect10 = list2.get(n2);
            Rect rect11 = list.get(n2);
            boolean bl = n == -1 ? true : rect10.width() >= rect7.width() && rect10.height() >= rect7.height();
            if (!bl) break;
            rect9 = rect10;
            rect8 = rect11;
            n = n2++;
        }
        if (n == -1) {
            throw new AssertionError((Object)"Should've found at least one valid zoom index");
        }
        rect3.set(rect8);
        rect4.set(rect9);
        return n;
    }

    public static Size getLargestSupportedJpegSizeByArea(Camera.Parameters parameters) {
        Preconditions.checkNotNull(parameters, "params must not be null");
        return SizeAreaComparator.findLargestByArea(ParameterUtils.convertSizeList(parameters.getSupportedPictureSizes()));
    }

    public static float getMaxZoomRatio(Camera.Parameters parameters) {
        if (!parameters.isZoomSupported()) {
            return 1.0f;
        }
        List<Integer> list = parameters.getZoomRatios();
        return 1.0f * (float)list.get(-1 + list.size()).intValue() / 100.0f;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Rect getPreviewCropRectangleUnzoomed(Rect rect, Size size) {
        float f;
        float f2;
        if (size.getWidth() > rect.width()) {
            throw new IllegalArgumentException("previewSize must not be wider than activeArray");
        }
        if (size.getHeight() > rect.height()) {
            throw new IllegalArgumentException("previewSize must not be taller than activeArray");
        }
        float f3 = 1.0f * (float)rect.width() / (float)rect.height();
        float f4 = 1.0f * (float)size.getWidth() / (float)size.getHeight();
        if (f4 < f3) {
            f2 = rect.height();
            f = f2 * f4;
        } else {
            f = rect.width();
            f2 = f / f4;
        }
        Matrix matrix = new Matrix();
        RectF rectF = new RectF(0.0f, 0.0f, f, f2);
        matrix.setTranslate(rect.exactCenterX(), rect.exactCenterY());
        matrix.postTranslate(-rectF.centerX(), -rectF.centerY());
        matrix.mapRect(rectF);
        return ParamsUtils.createRect(rectF);
    }

    private static SizeF getZoomRatio(Size size, Size size2) {
        Preconditions.checkNotNull(size, "activeArraySize must not be null");
        Preconditions.checkNotNull(size2, "cropSize must not be null");
        Preconditions.checkArgumentPositive(size2.getWidth(), "cropSize.width must be positive");
        Preconditions.checkArgumentPositive(size2.getHeight(), "cropSize.height must be positive");
        return new SizeF(1.0f * (float)size.getWidth() / (float)size2.getWidth(), 1.0f * (float)size.getHeight() / (float)size2.getHeight());
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Rect shrinkToSameAspectRatioCentered(Rect rect, Rect rect2) {
        float f;
        float f2;
        float f3 = 1.0f * (float)rect.width() / (float)rect.height();
        float f4 = 1.0f * (float)rect2.width() / (float)rect2.height();
        if (f4 < f3) {
            f2 = rect.height();
            f = f2 * f4;
        } else {
            f = rect.width();
            f2 = f / f4;
        }
        Matrix matrix = new Matrix();
        RectF rectF = new RectF(rect2);
        matrix.setScale(f / (float)rect.width(), f2 / (float)rect.height(), rect2.exactCenterX(), rect2.exactCenterY());
        matrix.mapRect(rectF);
        return ParamsUtils.createRect(rectF);
    }

    public static String stringFromArea(Camera.Area area) {
        if (area == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Rect rect = area.rect;
        stringBuilder.setLength(0);
        stringBuilder.append("([");
        stringBuilder.append(rect.left);
        stringBuilder.append(',');
        stringBuilder.append(rect.top);
        stringBuilder.append("][");
        stringBuilder.append(rect.right);
        stringBuilder.append(',');
        stringBuilder.append(rect.bottom);
        stringBuilder.append(']');
        stringBuilder.append(',');
        stringBuilder.append(area.weight);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String stringFromAreaList(List<Camera.Area> list) {
        StringBuilder stringBuilder = new StringBuilder();
        if (list == null) {
            return null;
        }
        int n = 0;
        Iterator<Camera.Area> iterator = list.iterator();
        while (iterator.hasNext()) {
            Camera.Area area = iterator.next();
            if (area == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append(ParameterUtils.stringFromArea(area));
            }
            if (n != -1 + list.size()) {
                stringBuilder.append(", ");
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    public static class MeteringData {
        public final Camera.Area meteringArea;
        public final Rect previewMetering;
        public final Rect reportedMetering;

        public MeteringData(Camera.Area area, Rect rect, Rect rect2) {
            this.meteringArea = area;
            this.previewMetering = rect;
            this.reportedMetering = rect2;
        }
    }

    public static class WeightedRectangle {
        public final Rect rect;
        public final int weight;

        public WeightedRectangle(Rect rect, int n) {
            this.rect = Preconditions.checkNotNull(rect, "rect must not be null");
            this.weight = n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static int clip(int n, int n2, int n3, Rect rect, String string2) {
            if (n < n2) {
                Log.w(ParameterUtils.TAG, "toMetering - Rectangle " + rect + " " + string2 + " too small, clip to " + n2);
                return n2;
            }
            if (n <= n3) return n;
            Log.w(ParameterUtils.TAG, "toMetering - Rectangle " + rect + " " + string2 + " too small, clip to " + n3);
            return n3;
        }

        private static int clipLower(int n, int n2, Rect rect, String string2) {
            return WeightedRectangle.clip(n, n2, Integer.MAX_VALUE, rect, string2);
        }

        public Face toFace() {
            int n = WeightedRectangle.clip(this.weight, 1, 100, this.rect, "score");
            return new Face(this.rect, n);
        }

        public Face toFace(int n, Point point, Point point2, Point point3) {
            int n2 = WeightedRectangle.clipLower(n, 0, this.rect, "id");
            int n3 = WeightedRectangle.clip(this.weight, 1, 100, this.rect, "score");
            return new Face(this.rect, n3, n2, point, point2, point3);
        }

        public MeteringRectangle toMetering() {
            int n = WeightedRectangle.clip(this.weight, 0, 1000, this.rect, "weight");
            return new MeteringRectangle(WeightedRectangle.clipLower(this.rect.left, 0, this.rect, "left"), WeightedRectangle.clipLower(this.rect.top, 0, this.rect, "top"), WeightedRectangle.clipLower(this.rect.width(), 0, this.rect, "width"), WeightedRectangle.clipLower(this.rect.height(), 0, this.rect, "height"), n);
        }
    }

    public static class ZoomData {
        public final Rect previewCrop;
        public final Rect reportedCrop;
        public final int zoomIndex;

        public ZoomData(int n, Rect rect, Rect rect2) {
            this.zoomIndex = n;
            this.previewCrop = rect;
            this.reportedCrop = rect2;
        }
    }
}

