/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal.impl;

import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.params.ColorSpaceTransform;
import android.hardware.camera2.utils.TypeReference;
import java.nio.ByteBuffer;

public class MarshalQueryableColorSpaceTransform
implements MarshalQueryable<ColorSpaceTransform> {
    private static final int ELEMENTS_INT32 = 18;
    private static final int SIZE = 72;

    @Override
    public Marshaler<ColorSpaceTransform> createMarshaler(TypeReference<ColorSpaceTransform> typeReference, int n) {
        return new MarshalerColorSpaceTransform(typeReference, n);
    }

    @Override
    public boolean isTypeMappingSupported(TypeReference<ColorSpaceTransform> typeReference, int n) {
        return n == 5 && ColorSpaceTransform.class.equals((Object)typeReference.getType());
    }

    private class MarshalerColorSpaceTransform
    extends Marshaler<ColorSpaceTransform> {
        protected MarshalerColorSpaceTransform(TypeReference<ColorSpaceTransform> typeReference, int n) {
            super(MarshalQueryableColorSpaceTransform.this, typeReference, n);
        }

        @Override
        public int getNativeSize() {
            return 72;
        }

        @Override
        public void marshal(ColorSpaceTransform colorSpaceTransform, ByteBuffer byteBuffer) {
            int[] nArray = new int[18];
            colorSpaceTransform.copyElements(nArray, 0);
            for (int i = 0; i < 18; ++i) {
                byteBuffer.putInt(nArray[i]);
            }
        }

        @Override
        public ColorSpaceTransform unmarshal(ByteBuffer byteBuffer) {
            int[] nArray = new int[18];
            for (int i = 0; i < 18; ++i) {
                nArray[i] = byteBuffer.getInt();
            }
            return new ColorSpaceTransform(nArray);
        }
    }
}

