/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal.impl;

import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.MarshalRegistry;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.utils.TypeReference;
import android.util.Range;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.nio.ByteBuffer;

public class MarshalQueryableRange<T extends Comparable<? super T>>
implements MarshalQueryable<Range<T>> {
    private static final int RANGE_COUNT = 2;

    @Override
    public Marshaler<Range<T>> createMarshaler(TypeReference<Range<T>> typeReference, int n) {
        return new MarshalerRange(typeReference, n);
    }

    @Override
    public boolean isTypeMappingSupported(TypeReference<Range<T>> typeReference, int n) {
        return Range.class.equals(typeReference.getRawType());
    }

    private class MarshalerRange
    extends Marshaler<Range<T>> {
        private final Class<? super Range<T>> mClass;
        private final Constructor<Range<T>> mConstructor;
        private final Marshaler<T> mNestedTypeMarshaler;

        protected MarshalerRange(TypeReference<Range<T>> typeReference, int n) {
            ParameterizedType parameterizedType;
            super(MarshalQueryableRange.this, typeReference, n);
            this.mClass = typeReference.getRawType();
            try {
                parameterizedType = (ParameterizedType)typeReference.getType();
            }
            catch (ClassCastException classCastException) {
                throw new AssertionError("Raw use of Range is not supported", classCastException);
            }
            this.mNestedTypeMarshaler = MarshalRegistry.getMarshaler(TypeReference.createSpecializedTypeReference(parameterizedType.getActualTypeArguments()[0]), this.mNativeType);
            try {
                this.mConstructor = this.mClass.getConstructor(Comparable.class, Comparable.class);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new AssertionError((Object)noSuchMethodException);
            }
        }

        @Override
        public int calculateMarshalSize(Range<T> range) {
            int n = this.getNativeSize();
            if (n != NATIVE_SIZE_DYNAMIC) {
                return n;
            }
            return this.mNestedTypeMarshaler.calculateMarshalSize(range.getLower()) + this.mNestedTypeMarshaler.calculateMarshalSize(range.getUpper());
        }

        @Override
        public int getNativeSize() {
            int n = this.mNestedTypeMarshaler.getNativeSize();
            if (n != NATIVE_SIZE_DYNAMIC) {
                return n * 2;
            }
            return NATIVE_SIZE_DYNAMIC;
        }

        @Override
        public void marshal(Range<T> range, ByteBuffer byteBuffer) {
            this.mNestedTypeMarshaler.marshal(range.getLower(), byteBuffer);
            this.mNestedTypeMarshaler.marshal(range.getUpper(), byteBuffer);
        }

        @Override
        public Range<T> unmarshal(ByteBuffer byteBuffer) {
            Comparable comparable = (Comparable)this.mNestedTypeMarshaler.unmarshal(byteBuffer);
            Comparable comparable2 = (Comparable)this.mNestedTypeMarshaler.unmarshal(byteBuffer);
            try {
                Range range = this.mConstructor.newInstance(comparable, comparable2);
                return range;
            }
            catch (InstantiationException instantiationException) {
                throw new AssertionError((Object)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new AssertionError((Object)illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new AssertionError((Object)invocationTargetException);
            }
        }
    }
}

