/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.hardware.camera2.params.StreamConfigurationMap;
import android.hardware.camera2.utils.HashCodeHelpers;
import com.android.internal.util.Preconditions;
import java.util.Arrays;

public final class ReprocessFormatsMap {
    private final int[] mEntry;
    private final int mInputCount;

    public ReprocessFormatsMap(int[] nArray) {
        Preconditions.checkNotNull(nArray, "entry must not be null");
        int n = 0;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < nArray.length) {
            int n4 = StreamConfigurationMap.checkArgumentFormatInternal(nArray[n3]);
            int n5 = n2 - 1;
            int n6 = n3 + 1;
            if (n5 < 1) {
                Object[] objectArray = new Object[]{n4};
                throw new IllegalArgumentException(String.format("Input %x had no output format length listed", objectArray));
            }
            int n7 = nArray[n6];
            n2 = n5 - 1;
            n3 = n6 + 1;
            for (int i = 0; i < n7; ++i) {
                StreamConfigurationMap.checkArgumentFormatInternal(nArray[n3 + i]);
            }
            if (n7 > 0) {
                if (n2 < n7) {
                    Object[] objectArray = new Object[]{n4, n2, n7};
                    throw new IllegalArgumentException(String.format("Input %x had too few output formats listed (actual: %d, expected: %d)", objectArray));
                }
                n3 += n7;
                n2 -= n7;
            }
            ++n;
        }
        this.mEntry = nArray;
        this.mInputCount = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (object == null) break block4;
                if (this == object) {
                    return true;
                }
                if (object instanceof ReprocessFormatsMap) break block5;
            }
            return false;
        }
        ReprocessFormatsMap reprocessFormatsMap = (ReprocessFormatsMap)object;
        return Arrays.equals(this.mEntry, reprocessFormatsMap.mEntry);
    }

    public int[] getInputs() {
        int[] nArray = new int[this.mInputCount];
        int n = this.mEntry.length;
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.mEntry.length) {
            int n4 = this.mEntry[n2];
            int n5 = n - 1;
            int n6 = n2 + 1;
            if (n5 < 1) {
                Object[] objectArray = new Object[]{n4};
                throw new AssertionError((Object)String.format("Input %x had no output format length listed", objectArray));
            }
            int n7 = this.mEntry[n6];
            n = n5 - 1;
            n2 = n6 + 1;
            if (n7 > 0) {
                if (n < n7) {
                    Object[] objectArray = new Object[]{n4, n, n7};
                    throw new AssertionError((Object)String.format("Input %x had too few output formats listed (actual: %d, expected: %d)", objectArray));
                }
                n2 += n7;
                n -= n7;
            }
            nArray[n3] = n4;
            ++n3;
        }
        return StreamConfigurationMap.imageFormatToPublic(nArray);
    }

    public int[] getOutputs(int n) {
        int n2 = this.mEntry.length;
        int n3 = 0;
        while (n3 < this.mEntry.length) {
            int n4 = this.mEntry[n3];
            int n5 = n2 - 1;
            int n6 = n3 + 1;
            if (n5 < 1) {
                Object[] objectArray = new Object[]{n};
                throw new AssertionError((Object)String.format("Input %x had no output format length listed", objectArray));
            }
            int n7 = this.mEntry[n6];
            int n8 = n5 - 1;
            int n9 = n6 + 1;
            if (n7 > 0 && n8 < n7) {
                Object[] objectArray = new Object[]{n, n8, n7};
                throw new AssertionError((Object)String.format("Input %x had too few output formats listed (actual: %d, expected: %d)", objectArray));
            }
            if (n4 == n) {
                int[] nArray = new int[n7];
                for (int i = 0; i < n7; ++i) {
                    nArray[i] = this.mEntry[n9 + i];
                }
                return StreamConfigurationMap.imageFormatToPublic(nArray);
            }
            n3 = n9 + n7;
            n2 = n8 - n7;
        }
        Object[] objectArray = new Object[]{n};
        throw new IllegalArgumentException(String.format("Input format %x was not one in #getInputs", objectArray));
    }

    public int hashCode() {
        return HashCodeHelpers.hashCode(this.mEntry);
    }
}

