/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import com.android.internal.util.Preconditions;

public final class RggbChannelVector {
    public static final int BLUE = 3;
    public static final int COUNT = 4;
    public static final int GREEN_EVEN = 1;
    public static final int GREEN_ODD = 2;
    public static final int RED;
    private final float mBlue;
    private final float mGreenEven;
    private final float mGreenOdd;
    private final float mRed;

    public RggbChannelVector(float f, float f2, float f3, float f4) {
        this.mRed = Preconditions.checkArgumentFinite(f, "red");
        this.mGreenEven = Preconditions.checkArgumentFinite(f2, "greenEven");
        this.mGreenOdd = Preconditions.checkArgumentFinite(f3, "greenOdd");
        this.mBlue = Preconditions.checkArgumentFinite(f4, "blue");
    }

    private String toShortString() {
        Object[] objectArray = new Object[]{Float.valueOf(this.mRed), Float.valueOf(this.mGreenEven), Float.valueOf(this.mGreenOdd), Float.valueOf(this.mBlue)};
        return String.format("{R:%f, G_even:%f, G_odd:%f, B:%f}", objectArray);
    }

    public void copyTo(float[] fArray, int n) {
        Preconditions.checkNotNull(fArray, "destination must not be null");
        if (fArray.length - n < 4) {
            throw new ArrayIndexOutOfBoundsException("destination too small to fit elements");
        }
        fArray[n + 0] = this.mRed;
        fArray[n + 1] = this.mGreenEven;
        fArray[n + 2] = this.mGreenOdd;
        fArray[n + 3] = this.mBlue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl = true;
        if (object == null) {
            return false;
        }
        if (this == object) {
            return bl;
        }
        if (!(object instanceof RggbChannelVector)) return false;
        RggbChannelVector rggbChannelVector = (RggbChannelVector)object;
        if (this.mRed != rggbChannelVector.mRed) return false;
        if (this.mGreenEven != rggbChannelVector.mGreenEven) return false;
        if (this.mGreenOdd != rggbChannelVector.mGreenOdd) return false;
        if (this.mBlue != rggbChannelVector.mBlue) return false;
        return bl;
    }

    public float getBlue() {
        return this.mBlue;
    }

    public float getComponent(int n) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("Color channel out of range");
        }
        switch (n) {
            default: {
                throw new AssertionError((Object)("Unhandled case " + n));
            }
            case 0: {
                return this.mRed;
            }
            case 1: {
                return this.mGreenEven;
            }
            case 2: {
                return this.mGreenOdd;
            }
            case 3: 
        }
        return this.mBlue;
    }

    public float getGreenEven() {
        return this.mGreenEven;
    }

    public float getGreenOdd() {
        return this.mGreenOdd;
    }

    public final float getRed() {
        return this.mRed;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.mRed) ^ Float.floatToIntBits(this.mGreenEven) ^ Float.floatToIntBits(this.mGreenOdd) ^ Float.floatToIntBits(this.mBlue);
    }

    public String toString() {
        Object[] objectArray = new Object[]{this.toShortString()};
        return String.format("RggbChannelVector%s", objectArray);
    }
}

