/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.utils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class Decorator<T>
implements InvocationHandler {
    private final DecoratorListener mListener;
    private final T mObject;

    private Decorator(T t, DecoratorListener decoratorListener) {
        this.mObject = t;
        this.mListener = decoratorListener;
    }

    public static <T> T newInstance(T t, DecoratorListener decoratorListener) {
        return (T)Proxy.newProxyInstance(t.getClass().getClassLoader(), t.getClass().getInterfaces(), new Decorator<T>(t, decoratorListener));
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Object object2 = null;
        try {
            this.mListener.onBeforeInvocation(method, objectArray);
            object2 = method.invoke(this.mObject, objectArray);
            this.mListener.onAfterInvocation(method, objectArray, object2);
            return object2;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (!this.mListener.onCatchException(method, objectArray, throwable)) {
                throw throwable;
            }
        }
        finally {
            this.mListener.onFinally(method, objectArray);
        }
        return object2;
    }

    public static interface DecoratorListener {
        public void onAfterInvocation(Method var1, Object[] var2, Object var3);

        public void onBeforeInvocation(Method var1, Object[] var2);

        public boolean onCatchException(Method var1, Object[] var2, Throwable var3);

        public void onFinally(Method var1, Object[] var2);
    }
}

