/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class Address
implements Parcelable {
    public static final Parcelable.Creator<Address> CREATOR = new Parcelable.Creator<Address>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Address createFromParcel(Parcel parcel) {
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Locale locale = string3.length() > 0 ? new Locale(string2, string3) : new Locale(string2);
            Address address = new Address(locale);
            int n = parcel.readInt();
            if (n > 0) {
                Address.access$002(address, new HashMap(n));
                for (int i = 0; i < n; ++i) {
                    int n2 = parcel.readInt();
                    String string4 = parcel.readString();
                    address.mAddressLines.put(n2, string4);
                    Address.access$102(address, Math.max(address.mMaxAddressLineIndex, n2));
                }
            } else {
                Address.access$002(address, null);
                Address.access$102(address, -1);
            }
            Address.access$202(address, parcel.readString());
            Address.access$302(address, parcel.readString());
            Address.access$402(address, parcel.readString());
            Address.access$502(address, parcel.readString());
            Address.access$602(address, parcel.readString());
            Address.access$702(address, parcel.readString());
            Address.access$802(address, parcel.readString());
            Address.access$902(address, parcel.readString());
            Address.access$1002(address, parcel.readString());
            Address.access$1102(address, parcel.readString());
            Address.access$1202(address, parcel.readString());
            boolean bl = parcel.readInt() != 0;
            Address.access$1302(address, bl);
            if (address.mHasLatitude) {
                Address.access$1402(address, parcel.readDouble());
            }
            int n3 = parcel.readInt();
            boolean bl2 = false;
            if (n3 != 0) {
                bl2 = true;
            }
            Address.access$1502(address, bl2);
            if (address.mHasLongitude) {
                Address.access$1602(address, parcel.readDouble());
            }
            Address.access$1702(address, parcel.readString());
            Address.access$1802(address, parcel.readString());
            Address.access$1902(address, parcel.readBundle());
            return address;
        }

        public Address[] newArray(int n) {
            return new Address[n];
        }
    };
    private HashMap<Integer, String> mAddressLines;
    private String mAdminArea;
    private String mCountryCode;
    private String mCountryName;
    private Bundle mExtras = null;
    private String mFeatureName;
    private boolean mHasLatitude = false;
    private boolean mHasLongitude = false;
    private double mLatitude;
    private Locale mLocale;
    private String mLocality;
    private double mLongitude;
    private int mMaxAddressLineIndex = -1;
    private String mPhone;
    private String mPostalCode;
    private String mPremises;
    private String mSubAdminArea;
    private String mSubLocality;
    private String mSubThoroughfare;
    private String mThoroughfare;
    private String mUrl;

    public Address(Locale locale) {
        this.mLocale = locale;
    }

    static /* synthetic */ HashMap access$002(Address address, HashMap hashMap) {
        address.mAddressLines = hashMap;
        return hashMap;
    }

    static /* synthetic */ String access$1002(Address address, String string2) {
        address.mPostalCode = string2;
        return string2;
    }

    static /* synthetic */ int access$102(Address address, int n) {
        address.mMaxAddressLineIndex = n;
        return n;
    }

    static /* synthetic */ String access$1102(Address address, String string2) {
        address.mCountryCode = string2;
        return string2;
    }

    static /* synthetic */ String access$1202(Address address, String string2) {
        address.mCountryName = string2;
        return string2;
    }

    static /* synthetic */ boolean access$1302(Address address, boolean bl) {
        address.mHasLatitude = bl;
        return bl;
    }

    static /* synthetic */ double access$1402(Address address, double d) {
        address.mLatitude = d;
        return d;
    }

    static /* synthetic */ boolean access$1502(Address address, boolean bl) {
        address.mHasLongitude = bl;
        return bl;
    }

    static /* synthetic */ double access$1602(Address address, double d) {
        address.mLongitude = d;
        return d;
    }

    static /* synthetic */ String access$1702(Address address, String string2) {
        address.mPhone = string2;
        return string2;
    }

    static /* synthetic */ String access$1802(Address address, String string2) {
        address.mUrl = string2;
        return string2;
    }

    static /* synthetic */ Bundle access$1902(Address address, Bundle bundle) {
        address.mExtras = bundle;
        return bundle;
    }

    static /* synthetic */ String access$202(Address address, String string2) {
        address.mFeatureName = string2;
        return string2;
    }

    static /* synthetic */ String access$302(Address address, String string2) {
        address.mAdminArea = string2;
        return string2;
    }

    static /* synthetic */ String access$402(Address address, String string2) {
        address.mSubAdminArea = string2;
        return string2;
    }

    static /* synthetic */ String access$502(Address address, String string2) {
        address.mLocality = string2;
        return string2;
    }

    static /* synthetic */ String access$602(Address address, String string2) {
        address.mSubLocality = string2;
        return string2;
    }

    static /* synthetic */ String access$702(Address address, String string2) {
        address.mThoroughfare = string2;
        return string2;
    }

    static /* synthetic */ String access$802(Address address, String string2) {
        address.mSubThoroughfare = string2;
        return string2;
    }

    static /* synthetic */ String access$902(Address address, String string2) {
        address.mPremises = string2;
        return string2;
    }

    public void clearLatitude() {
        this.mHasLatitude = false;
    }

    public void clearLongitude() {
        this.mHasLongitude = false;
    }

    @Override
    public int describeContents() {
        if (this.mExtras != null) {
            return this.mExtras.describeContents();
        }
        return 0;
    }

    public String getAddressLine(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index = " + n + " < 0");
        }
        if (this.mAddressLines == null) {
            return null;
        }
        return this.mAddressLines.get(n);
    }

    public String getAdminArea() {
        return this.mAdminArea;
    }

    public String getCountryCode() {
        return this.mCountryCode;
    }

    public String getCountryName() {
        return this.mCountryName;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public String getFeatureName() {
        return this.mFeatureName;
    }

    public double getLatitude() {
        if (this.mHasLatitude) {
            return this.mLatitude;
        }
        throw new IllegalStateException();
    }

    public Locale getLocale() {
        return this.mLocale;
    }

    public String getLocality() {
        return this.mLocality;
    }

    public double getLongitude() {
        if (this.mHasLongitude) {
            return this.mLongitude;
        }
        throw new IllegalStateException();
    }

    public int getMaxAddressLineIndex() {
        return this.mMaxAddressLineIndex;
    }

    public String getPhone() {
        return this.mPhone;
    }

    public String getPostalCode() {
        return this.mPostalCode;
    }

    public String getPremises() {
        return this.mPremises;
    }

    public String getSubAdminArea() {
        return this.mSubAdminArea;
    }

    public String getSubLocality() {
        return this.mSubLocality;
    }

    public String getSubThoroughfare() {
        return this.mSubThoroughfare;
    }

    public String getThoroughfare() {
        return this.mThoroughfare;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public boolean hasLatitude() {
        return this.mHasLatitude;
    }

    public boolean hasLongitude() {
        return this.mHasLongitude;
    }

    public void setAddressLine(int n, String string2) {
        if (n < 0) {
            throw new IllegalArgumentException("index = " + n + " < 0");
        }
        if (this.mAddressLines == null) {
            this.mAddressLines = new HashMap();
        }
        this.mAddressLines.put(n, string2);
        if (string2 == null) {
            this.mMaxAddressLineIndex = -1;
            for (Integer n2 : this.mAddressLines.keySet()) {
                this.mMaxAddressLineIndex = Math.max(this.mMaxAddressLineIndex, n2);
            }
        } else {
            this.mMaxAddressLineIndex = Math.max(this.mMaxAddressLineIndex, n);
        }
    }

    public void setAdminArea(String string2) {
        this.mAdminArea = string2;
    }

    public void setCountryCode(String string2) {
        this.mCountryCode = string2;
    }

    public void setCountryName(String string2) {
        this.mCountryName = string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setExtras(Bundle bundle) {
        Bundle bundle2 = bundle == null ? null : new Bundle(bundle);
        this.mExtras = bundle2;
    }

    public void setFeatureName(String string2) {
        this.mFeatureName = string2;
    }

    public void setLatitude(double d) {
        this.mLatitude = d;
        this.mHasLatitude = true;
    }

    public void setLocality(String string2) {
        this.mLocality = string2;
    }

    public void setLongitude(double d) {
        this.mLongitude = d;
        this.mHasLongitude = true;
    }

    public void setPhone(String string2) {
        this.mPhone = string2;
    }

    public void setPostalCode(String string2) {
        this.mPostalCode = string2;
    }

    public void setPremises(String string2) {
        this.mPremises = string2;
    }

    public void setSubAdminArea(String string2) {
        this.mSubAdminArea = string2;
    }

    public void setSubLocality(String string2) {
        this.mSubLocality = string2;
    }

    public void setSubThoroughfare(String string2) {
        this.mSubThoroughfare = string2;
    }

    public void setThoroughfare(String string2) {
        this.mThoroughfare = string2;
    }

    public void setUrl(String string2) {
        this.mUrl = string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Address[addressLines=[");
        int n = 0;
        while (true) {
            if (n > this.mMaxAddressLineIndex) {
                stringBuilder.append(']');
                stringBuilder.append(",feature=");
                stringBuilder.append(this.mFeatureName);
                stringBuilder.append(",admin=");
                stringBuilder.append(this.mAdminArea);
                stringBuilder.append(",sub-admin=");
                stringBuilder.append(this.mSubAdminArea);
                stringBuilder.append(",locality=");
                stringBuilder.append(this.mLocality);
                stringBuilder.append(",thoroughfare=");
                stringBuilder.append(this.mThoroughfare);
                stringBuilder.append(",postalCode=");
                stringBuilder.append(this.mPostalCode);
                stringBuilder.append(",countryCode=");
                stringBuilder.append(this.mCountryCode);
                stringBuilder.append(",countryName=");
                stringBuilder.append(this.mCountryName);
                stringBuilder.append(",hasLatitude=");
                stringBuilder.append(this.mHasLatitude);
                stringBuilder.append(",latitude=");
                stringBuilder.append(this.mLatitude);
                stringBuilder.append(",hasLongitude=");
                stringBuilder.append(this.mHasLongitude);
                stringBuilder.append(",longitude=");
                stringBuilder.append(this.mLongitude);
                stringBuilder.append(",phone=");
                stringBuilder.append(this.mPhone);
                stringBuilder.append(",url=");
                stringBuilder.append(this.mUrl);
                stringBuilder.append(",extras=");
                stringBuilder.append(this.mExtras);
                stringBuilder.append(']');
                return stringBuilder.toString();
            }
            if (n > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(n);
            stringBuilder.append(':');
            String string2 = this.mAddressLines.get(n);
            if (string2 == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append('\"');
                stringBuilder.append(string2);
                stringBuilder.append('\"');
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        parcel.writeString(this.mLocale.getLanguage());
        parcel.writeString(this.mLocale.getCountry());
        if (this.mAddressLines == null) {
            parcel.writeInt(0);
        } else {
            Set<Map.Entry<Integer, String>> set = this.mAddressLines.entrySet();
            parcel.writeInt(set.size());
            for (Map.Entry<Integer, String> entry : set) {
                parcel.writeInt(entry.getKey());
                parcel.writeString(entry.getValue());
            }
        }
        parcel.writeString(this.mFeatureName);
        parcel.writeString(this.mAdminArea);
        parcel.writeString(this.mSubAdminArea);
        parcel.writeString(this.mLocality);
        parcel.writeString(this.mSubLocality);
        parcel.writeString(this.mThoroughfare);
        parcel.writeString(this.mSubThoroughfare);
        parcel.writeString(this.mPremises);
        parcel.writeString(this.mPostalCode);
        parcel.writeString(this.mCountryCode);
        parcel.writeString(this.mCountryName);
        int n3 = this.mHasLatitude ? n2 : 0;
        parcel.writeInt(n3);
        if (this.mHasLatitude) {
            parcel.writeDouble(this.mLatitude);
        }
        if (!this.mHasLongitude) {
            n2 = 0;
        }
        parcel.writeInt(n2);
        if (this.mHasLongitude) {
            parcel.writeDouble(this.mLongitude);
        }
        parcel.writeString(this.mPhone);
        parcel.writeString(this.mUrl);
        parcel.writeBundle(this.mExtras);
    }
}

