/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.location.Criteria;
import com.android.internal.location.ProviderProperties;

public class LocationProvider {
    public static final int AVAILABLE = 2;
    public static final String BAD_CHARS_REGEX = "[^a-zA-Z0-9]";
    public static final int OUT_OF_SERVICE = 0;
    public static final int TEMPORARILY_UNAVAILABLE = 1;
    private final String mName;
    private final ProviderProperties mProperties;

    public LocationProvider(String string2, ProviderProperties providerProperties) {
        if (string2.matches(BAD_CHARS_REGEX)) {
            throw new IllegalArgumentException("provider name contains illegal character: " + string2);
        }
        this.mName = string2;
        this.mProperties = providerProperties;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean propertiesMeetCriteria(String string2, ProviderProperties providerProperties, Criteria criteria) {
        return !("passive".equals(string2) || providerProperties == null || criteria.getAccuracy() != 0 && criteria.getAccuracy() < providerProperties.mAccuracy || criteria.getPowerRequirement() != 0 && criteria.getPowerRequirement() < providerProperties.mPowerRequirement || criteria.isAltitudeRequired() && !providerProperties.mSupportsAltitude || criteria.isSpeedRequired() && !providerProperties.mSupportsSpeed || criteria.isBearingRequired() && !providerProperties.mSupportsBearing) && (criteria.isCostAllowed() || !providerProperties.mHasMonetaryCost);
    }

    public int getAccuracy() {
        return this.mProperties.mAccuracy;
    }

    public String getName() {
        return this.mName;
    }

    public int getPowerRequirement() {
        return this.mProperties.mPowerRequirement;
    }

    public boolean hasMonetaryCost() {
        return this.mProperties.mHasMonetaryCost;
    }

    public boolean meetsCriteria(Criteria criteria) {
        return LocationProvider.propertiesMeetCriteria(this.mName, this.mProperties, criteria);
    }

    public boolean requiresCell() {
        return this.mProperties.mRequiresCell;
    }

    public boolean requiresNetwork() {
        return this.mProperties.mRequiresNetwork;
    }

    public boolean requiresSatellite() {
        return this.mProperties.mRequiresSatellite;
    }

    public boolean supportsAltitude() {
        return this.mProperties.mSupportsAltitude;
    }

    public boolean supportsBearing() {
        return this.mProperties.mSupportsBearing;
    }

    public boolean supportsSpeed() {
        return this.mProperties.mSupportsSpeed;
    }
}

