/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public final class AudioAttributes
implements Parcelable {
    private static final int ALL_PARCEL_FLAGS = 1;
    public static final int CONTENT_TYPE_MOVIE = 3;
    public static final int CONTENT_TYPE_MUSIC = 2;
    public static final int CONTENT_TYPE_SONIFICATION = 4;
    public static final int CONTENT_TYPE_SPEECH = 1;
    public static final int CONTENT_TYPE_UNKNOWN = 0;
    public static final Parcelable.Creator<AudioAttributes> CREATOR = new Parcelable.Creator<AudioAttributes>(){

        @Override
        public AudioAttributes createFromParcel(Parcel parcel) {
            return new AudioAttributes(parcel);
        }

        public AudioAttributes[] newArray(int n) {
            return new AudioAttributes[n];
        }
    };
    private static final int FLAG_ALL = 63;
    private static final int FLAG_ALL_PUBLIC = 17;
    public static final int FLAG_AUDIBILITY_ENFORCED = 1;
    public static final int FLAG_BEACON = 8;
    public static final int FLAG_HW_AV_SYNC = 16;
    public static final int FLAG_HW_HOTWORD = 32;
    public static final int FLAG_SCO = 4;
    public static final int FLAG_SECURE = 2;
    public static final int FLATTEN_TAGS = 1;
    private static final String TAG = "AudioAttributes";
    public static final int USAGE_ALARM = 4;
    public static final int USAGE_ASSISTANCE_ACCESSIBILITY = 11;
    public static final int USAGE_ASSISTANCE_NAVIGATION_GUIDANCE = 12;
    public static final int USAGE_ASSISTANCE_SONIFICATION = 13;
    public static final int USAGE_GAME = 14;
    public static final int USAGE_MEDIA = 1;
    public static final int USAGE_NOTIFICATION = 5;
    public static final int USAGE_NOTIFICATION_COMMUNICATION_DELAYED = 9;
    public static final int USAGE_NOTIFICATION_COMMUNICATION_INSTANT = 8;
    public static final int USAGE_NOTIFICATION_COMMUNICATION_REQUEST = 7;
    public static final int USAGE_NOTIFICATION_EVENT = 10;
    public static final int USAGE_NOTIFICATION_RINGTONE = 6;
    public static final int USAGE_UNKNOWN = 0;
    public static final int USAGE_VOICE_COMMUNICATION = 2;
    public static final int USAGE_VOICE_COMMUNICATION_SIGNALLING = 3;
    private int mContentType;
    private int mFlags;
    private String mFormattedTags;
    private int mSource;
    private HashSet<String> mTags;
    private int mUsage;

    private AudioAttributes() {
        this.mUsage = 0;
        this.mContentType = 0;
        this.mSource = -1;
        this.mFlags = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private AudioAttributes(Parcel parcel) {
        int n = 1;
        this.mUsage = 0;
        this.mContentType = 0;
        this.mSource = -1;
        this.mFlags = 0;
        this.mUsage = parcel.readInt();
        this.mContentType = parcel.readInt();
        this.mSource = parcel.readInt();
        this.mFlags = parcel.readInt();
        if ((1 & parcel.readInt()) != n) {
            n = 0;
        }
        this.mTags = new HashSet();
        if (n != 0) {
            this.mFormattedTags = new String(parcel.readString());
            this.mTags.add(this.mFormattedTags);
            return;
        }
        String[] stringArray = parcel.readStringArray();
        int n2 = -1 + stringArray.length;
        while (true) {
            if (n2 < 0) {
                this.mFormattedTags = TextUtils.join((CharSequence)";", this.mTags);
                return;
            }
            this.mTags.add(stringArray[n2]);
            --n2;
        }
    }

    static /* synthetic */ int access$002(AudioAttributes audioAttributes, int n) {
        audioAttributes.mUsage = n;
        return n;
    }

    static /* synthetic */ int access$102(AudioAttributes audioAttributes, int n) {
        audioAttributes.mContentType = n;
        return n;
    }

    static /* synthetic */ int access$202(AudioAttributes audioAttributes, int n) {
        audioAttributes.mFlags = n;
        return n;
    }

    static /* synthetic */ HashSet access$302(AudioAttributes audioAttributes, HashSet hashSet) {
        audioAttributes.mTags = hashSet;
        return hashSet;
    }

    static /* synthetic */ int access$502(AudioAttributes audioAttributes, int n) {
        audioAttributes.mSource = n;
        return n;
    }

    static /* synthetic */ String access$602(AudioAttributes audioAttributes, String string2) {
        audioAttributes.mFormattedTags = string2;
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int toLegacyStreamType(AudioAttributes audioAttributes) {
        int n = 3;
        if ((1 & audioAttributes.getFlags()) == 1) {
            return 7;
        }
        if ((4 & audioAttributes.getFlags()) == 4) {
            return 6;
        }
        switch (audioAttributes.getUsage()) {
            case 1: 
            case 11: 
            case 12: 
            case 14: {
                return n;
            }
            default: {
                return n;
            }
            case 2: {
                return 0;
            }
            case 13: {
                return 1;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 4;
            }
            case 6: {
                return 2;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
        }
        return 5;
    }

    public static int usageForLegacyStreamType(int n) {
        int n2 = 2;
        switch (n) {
            default: {
                n2 = 0;
            }
            case 0: 
            case 6: {
                return n2;
            }
            case 1: 
            case 7: {
                return 13;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 8: {
                return 3;
            }
            case 9: 
        }
        return 11;
    }

    public static String usageToString(int n) {
        switch (n) {
            default: {
                return new String("unknown usage " + n);
            }
            case 0: {
                return new String("USAGE_UNKNOWN");
            }
            case 1: {
                return new String("USAGE_MEDIA");
            }
            case 2: {
                return new String("USAGE_VOICE_COMMUNICATION");
            }
            case 3: {
                return new String("USAGE_VOICE_COMMUNICATION");
            }
            case 4: {
                return new String("USAGE_ALARM");
            }
            case 5: {
                return new String("USAGE_NOTIFICATION");
            }
            case 6: {
                return new String("USAGE_NOTIFICATION");
            }
            case 7: {
                return new String("USAGE_NOTIFICATION");
            }
            case 8: {
                return new String("USAGE_NOTIFICATION_COMMUNICATION_INSTANT");
            }
            case 9: {
                return new String("USAGE_NOTIFICATION_COMMUNICATION_DELAYED");
            }
            case 10: {
                return new String("USAGE_NOTIFICATION_EVENT");
            }
            case 11: {
                return new String("USAGE_ASSISTANCE_ACCESSIBILITY");
            }
            case 12: {
                return new String("USAGE_ASSISTANCE_NAVIGATION_GUIDANCE");
            }
            case 13: {
                return new String("USAGE_ASSISTANCE_SONIFICATION");
            }
            case 14: 
        }
        return new String("USAGE_GAME");
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (this == object) break block4;
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                AudioAttributes audioAttributes = (AudioAttributes)object;
                if (this.mContentType != audioAttributes.mContentType || this.mFlags != audioAttributes.mFlags || this.mSource != audioAttributes.mSource || this.mUsage != audioAttributes.mUsage || !this.mFormattedTags.equals(audioAttributes.mFormattedTags)) break block5;
            }
            return true;
        }
        return false;
    }

    public int getAllFlags() {
        return 0x3F & this.mFlags;
    }

    public int getCapturePreset() {
        return this.mSource;
    }

    public int getContentType() {
        return this.mContentType;
    }

    public int getFlags() {
        return 0x11 & this.mFlags;
    }

    public Set<String> getTags() {
        return Collections.unmodifiableSet(this.mTags);
    }

    public int getUsage() {
        return this.mUsage;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.mContentType, this.mFlags, this.mSource, this.mUsage, this.mFormattedTags};
        return Objects.hash(objectArray);
    }

    public String toString() {
        return new String("AudioAttributes: usage=" + this.mUsage + " content=" + this.mContentType + " flags=0x" + Integer.toHexString(this.mFlags).toUpperCase() + " tags=" + this.mFormattedTags);
    }

    public String usageToString() {
        return AudioAttributes.usageToString(this.mUsage);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mUsage);
        parcel.writeInt(this.mContentType);
        parcel.writeInt(this.mSource);
        parcel.writeInt(this.mFlags);
        parcel.writeInt(n & 1);
        if ((n & 1) == 0) {
            String[] stringArray = new String[this.mTags.size()];
            this.mTags.toArray(stringArray);
            parcel.writeStringArray(stringArray);
            return;
        } else {
            if ((n & 1) != 1) return;
            parcel.writeString(this.mFormattedTags);
            return;
        }
    }

    public static class Builder {
        private int mContentType = 0;
        private int mFlags = 0;
        private int mSource = -1;
        private HashSet<String> mTags = new HashSet();
        private int mUsage = 0;

        public Builder() {
        }

        public Builder(AudioAttributes audioAttributes) {
            this.mUsage = audioAttributes.mUsage;
            this.mContentType = audioAttributes.mContentType;
            this.mFlags = audioAttributes.mFlags;
            this.mTags = (HashSet)audioAttributes.mTags.clone();
        }

        public Builder addTag(String string2) {
            this.mTags.add(string2);
            return this;
        }

        public AudioAttributes build() {
            AudioAttributes audioAttributes = new AudioAttributes();
            AudioAttributes.access$102(audioAttributes, this.mContentType);
            AudioAttributes.access$002(audioAttributes, this.mUsage);
            AudioAttributes.access$502(audioAttributes, this.mSource);
            AudioAttributes.access$202(audioAttributes, this.mFlags);
            AudioAttributes.access$302(audioAttributes, (HashSet)this.mTags.clone());
            AudioAttributes.access$602(audioAttributes, TextUtils.join((CharSequence)";", this.mTags));
            return audioAttributes;
        }

        public Builder setCapturePreset(int n) {
            switch (n) {
                default: {
                    Log.e(AudioAttributes.TAG, "Invalid capture preset " + n + " for AudioAttributes");
                    return this;
                }
                case 0: 
                case 1: 
                case 5: 
                case 6: 
                case 7: 
            }
            this.mSource = n;
            return this;
        }

        public Builder setContentType(int n) {
            switch (n) {
                default: {
                    this.mUsage = 0;
                    return this;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
            }
            this.mContentType = n;
            return this;
        }

        public Builder setFlags(int n) {
            this.mFlags = n & 0x3F | this.mFlags;
            return this;
        }

        public Builder setInternalCapturePreset(int n) {
            if (n == 1999 || n == 8) {
                this.mSource = n;
                return this;
            }
            this.setCapturePreset(n);
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Builder setInternalLegacyStreamType(int n) {
            switch (n) {
                default: {
                    Log.e(AudioAttributes.TAG, "Invalid stream type " + n + " for AudioAttributes");
                    break;
                }
                case 0: {
                    this.mContentType = 1;
                    break;
                }
                case 7: {
                    this.mFlags = 1 | this.mFlags;
                }
                case 1: {
                    this.mContentType = 4;
                    break;
                }
                case 2: {
                    this.mContentType = 4;
                    break;
                }
                case 3: {
                    this.mContentType = 2;
                    break;
                }
                case 4: {
                    this.mContentType = 4;
                    break;
                }
                case 5: {
                    this.mContentType = 4;
                    break;
                }
                case 6: {
                    this.mContentType = 1;
                    this.mFlags = 4 | this.mFlags;
                    break;
                }
                case 8: {
                    this.mContentType = 4;
                    break;
                }
                case 9: {
                    this.mContentType = 1;
                }
            }
            this.mUsage = AudioAttributes.usageForLegacyStreamType(n);
            return this;
        }

        public Builder setLegacyStreamType(int n) {
            return this.setInternalLegacyStreamType(n);
        }

        public Builder setUsage(int n) {
            switch (n) {
                default: {
                    this.mUsage = 0;
                    return this;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
            }
            this.mUsage = n;
            return this;
        }
    }
}

