/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import java.util.ArrayList;
import java.util.List;

public class DecoderCapabilities {
    static {
        System.loadLibrary("media_jni");
        DecoderCapabilities.native_init();
    }

    private DecoderCapabilities() {
    }

    public static List<AudioDecoder> getAudioDecoders() {
        ArrayList<AudioDecoder> arrayList = new ArrayList<AudioDecoder>();
        int n = DecoderCapabilities.native_get_num_audio_decoders();
        for (int i = 0; i < n; ++i) {
            arrayList.add(AudioDecoder.values()[DecoderCapabilities.native_get_audio_decoder_type(i)]);
        }
        return arrayList;
    }

    public static List<VideoDecoder> getVideoDecoders() {
        ArrayList<VideoDecoder> arrayList = new ArrayList<VideoDecoder>();
        int n = DecoderCapabilities.native_get_num_video_decoders();
        for (int i = 0; i < n; ++i) {
            arrayList.add(VideoDecoder.values()[DecoderCapabilities.native_get_video_decoder_type(i)]);
        }
        return arrayList;
    }

    private static final native int native_get_audio_decoder_type(int var0);

    private static final native int native_get_num_audio_decoders();

    private static final native int native_get_num_video_decoders();

    private static final native int native_get_video_decoder_type(int var0);

    private static final native void native_init();

    public static final class AudioDecoder
    extends Enum<AudioDecoder> {
        private static final /* synthetic */ AudioDecoder[] $VALUES;
        public static final /* enum */ AudioDecoder AUDIO_DECODER_WMA = new AudioDecoder();

        static {
            AudioDecoder[] audioDecoderArray = new AudioDecoder[]{AUDIO_DECODER_WMA};
            $VALUES = audioDecoderArray;
        }

        public static AudioDecoder valueOf(String string2) {
            return Enum.valueOf(AudioDecoder.class, string2);
        }

        public static AudioDecoder[] values() {
            return (AudioDecoder[])$VALUES.clone();
        }
    }

    public static final class VideoDecoder
    extends Enum<VideoDecoder> {
        private static final /* synthetic */ VideoDecoder[] $VALUES;
        public static final /* enum */ VideoDecoder VIDEO_DECODER_WMV = new VideoDecoder();

        static {
            VideoDecoder[] videoDecoderArray = new VideoDecoder[]{VIDEO_DECODER_WMV};
            $VALUES = videoDecoderArray;
        }

        public static VideoDecoder valueOf(String string2) {
            return Enum.valueOf(VideoDecoder.class, string2);
        }

        public static VideoDecoder[] values() {
            return (VideoDecoder[])$VALUES.clone();
        }
    }
}

