/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.media.MediaFormat;
import android.media.MediaTimeProvider;
import android.media.SubtitleTrack;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.accessibility.CaptioningManager;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;

public class SubtitleController {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private static final int WHAT_HIDE = 2;
    private static final int WHAT_SELECT_DEFAULT_TRACK = 4;
    private static final int WHAT_SELECT_TRACK = 3;
    private static final int WHAT_SHOW = 1;
    private Anchor mAnchor;
    private final Handler.Callback mCallback = new Handler.Callback(){

        @Override
        public boolean handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return false;
                }
                case 1: {
                    SubtitleController.this.doShow();
                    return true;
                }
                case 2: {
                    SubtitleController.this.doHide();
                    return true;
                }
                case 3: {
                    SubtitleController.this.doSelectTrack((SubtitleTrack)message.obj);
                    return true;
                }
                case 4: 
            }
            SubtitleController.this.doSelectDefaultTrack();
            return true;
        }
    };
    private CaptioningManager.CaptioningChangeListener mCaptioningChangeListener = new CaptioningManager.CaptioningChangeListener(){

        @Override
        public void onEnabledChanged(boolean bl) {
            SubtitleController.this.selectDefaultTrack();
        }

        @Override
        public void onLocaleChanged(Locale locale) {
            SubtitleController.this.selectDefaultTrack();
        }
    };
    private CaptioningManager mCaptioningManager;
    private Handler mHandler;
    private Listener mListener;
    private Vector<Renderer> mRenderers;
    private SubtitleTrack mSelectedTrack;
    private boolean mShowing;
    private MediaTimeProvider mTimeProvider;
    private boolean mTrackIsExplicit = false;
    private Vector<SubtitleTrack> mTracks;
    private boolean mVisibilityIsExplicit = false;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl = !SubtitleController.class.desiredAssertionStatus();
        $assertionsDisabled = bl;
    }

    public SubtitleController(Context context, MediaTimeProvider mediaTimeProvider, Listener listener) {
        this.mTimeProvider = mediaTimeProvider;
        this.mListener = listener;
        this.mRenderers = new Vector();
        this.mShowing = false;
        this.mTracks = new Vector();
        this.mCaptioningManager = (CaptioningManager)context.getSystemService("captioning");
    }

    private void checkAnchorLooper() {
        if (!$assertionsDisabled && this.mHandler == null) {
            throw new AssertionError((Object)"Should have a looper already");
        }
        if (!$assertionsDisabled && Looper.myLooper() != this.mHandler.getLooper()) {
            throw new AssertionError((Object)"Must be called from the anchor's looper");
        }
    }

    private void doHide() {
        this.mVisibilityIsExplicit = true;
        if (this.mSelectedTrack != null) {
            this.mSelectedTrack.hide();
        }
        this.mShowing = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doSelectDefaultTrack() {
        if (this.mTrackIsExplicit) {
            if (this.mVisibilityIsExplicit) return;
            if (this.mCaptioningManager.isEnabled() || this.mSelectedTrack != null && this.mSelectedTrack.getFormat().getInteger("is-forced-subtitle", 0) != 0) {
                this.show();
            } else if (this.mSelectedTrack != null && !this.mSelectedTrack.isTimedText()) {
                this.hide();
            }
            this.mVisibilityIsExplicit = false;
            return;
        }
        SubtitleTrack subtitleTrack = this.getDefaultTrack();
        if (subtitleTrack == null) return;
        this.selectTrack(subtitleTrack);
        this.mTrackIsExplicit = false;
        if (this.mVisibilityIsExplicit) return;
        this.show();
        this.mVisibilityIsExplicit = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doSelectTrack(SubtitleTrack subtitleTrack) {
        block7: {
            block6: {
                this.mTrackIsExplicit = true;
                if (this.mSelectedTrack == subtitleTrack) break block6;
                if (this.mSelectedTrack != null) {
                    this.mSelectedTrack.hide();
                    this.mSelectedTrack.setTimeProvider(null);
                }
                this.mSelectedTrack = subtitleTrack;
                if (this.mAnchor != null) {
                    this.mAnchor.setSubtitleWidget(this.getRenderingWidget());
                }
                if (this.mSelectedTrack != null) {
                    this.mSelectedTrack.setTimeProvider(this.mTimeProvider);
                    this.mSelectedTrack.show();
                }
                if (this.mListener != null) break block7;
            }
            return;
        }
        this.mListener.onSubtitleTrackSelected(subtitleTrack);
    }

    private void doShow() {
        this.mShowing = true;
        this.mVisibilityIsExplicit = true;
        if (this.mSelectedTrack != null) {
            this.mSelectedTrack.show();
        }
    }

    private SubtitleTrack.RenderingWidget getRenderingWidget() {
        if (this.mSelectedTrack == null) {
            return null;
        }
        return this.mSelectedTrack.getRenderingWidget();
    }

    private void processOnAnchor(Message message) {
        if (!$assertionsDisabled && this.mHandler == null) {
            throw new AssertionError((Object)"Should have a looper already");
        }
        if (Looper.myLooper() == this.mHandler.getLooper()) {
            this.mHandler.dispatchMessage(message);
            return;
        }
        this.mHandler.sendMessage(message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SubtitleTrack addTrack(MediaFormat mediaFormat) {
        Vector<Renderer> vector = this.mRenderers;
        synchronized (vector) {
            SubtitleTrack subtitleTrack;
            Renderer renderer;
            Iterator iterator = this.mRenderers.iterator();
            do {
                if (iterator.hasNext()) continue;
                return null;
            } while (!(renderer = (Renderer)iterator.next()).supports(mediaFormat) || (subtitleTrack = renderer.createTrack(mediaFormat)) == null);
            Vector<SubtitleTrack> vector2 = this.mTracks;
            synchronized (vector2) {
                if (this.mTracks.size() == 0) {
                    this.mCaptioningManager.addCaptioningChangeListener(this.mCaptioningChangeListener);
                }
                this.mTracks.add(subtitleTrack);
                return subtitleTrack;
            }
        }
    }

    protected void finalize() throws Throwable {
        this.mCaptioningManager.removeCaptioningChangeListener(this.mCaptioningChangeListener);
        super.finalize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SubtitleTrack getDefaultTrack() {
        SubtitleTrack subtitleTrack = null;
        int n = -1;
        Locale locale = this.mCaptioningManager.getLocale();
        Locale locale2 = locale;
        if (locale2 == null) {
            locale2 = Locale.getDefault();
        }
        boolean bl = !this.mCaptioningManager.isEnabled();
        Vector<SubtitleTrack> vector = this.mTracks;
        synchronized (vector) {
            Iterator iterator = this.mTracks.iterator();
            while (iterator.hasNext()) {
                SubtitleTrack subtitleTrack2 = (SubtitleTrack)iterator.next();
                MediaFormat mediaFormat = subtitleTrack2.getFormat();
                String string2 = mediaFormat.getString("language");
                boolean bl2 = mediaFormat.getInteger("is-forced-subtitle", 0) != 0;
                boolean bl3 = mediaFormat.getInteger("is-autoselect", 1) != 0;
                boolean bl4 = mediaFormat.getInteger("is-default", 0) != 0;
                boolean bl5 = locale2 == null || locale2.getLanguage().equals("") || locale2.getISO3Language().equals(string2) || locale2.getLanguage().equals(string2);
                int n2 = bl2 ? 0 : 8;
                int n3 = locale == null && bl4 ? 4 : 0;
                int n4 = n2 + n3;
                int n5 = bl3 ? 0 : 2;
                int n6 = n4 + n5;
                int n7 = bl5 ? 1 : 0;
                int n8 = n6 + n7;
                if (bl && !bl2 || (locale != null || !bl4) && (!bl5 || !bl3 && !bl2 && locale == null) || n8 <= n) continue;
                n = n8;
                subtitleTrack = subtitleTrack2;
            }
            return subtitleTrack;
        }
    }

    public SubtitleTrack getSelectedTrack() {
        return this.mSelectedTrack;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SubtitleTrack[] getTracks() {
        Vector<SubtitleTrack> vector = this.mTracks;
        synchronized (vector) {
            SubtitleTrack[] subtitleTrackArray = new SubtitleTrack[this.mTracks.size()];
            this.mTracks.toArray(subtitleTrackArray);
            return subtitleTrackArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasRendererFor(MediaFormat mediaFormat) {
        Vector<Renderer> vector = this.mRenderers;
        synchronized (vector) {
            Iterator iterator = this.mRenderers.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!((Renderer)iterator.next()).supports(mediaFormat));
            return true;
        }
    }

    public void hide() {
        this.processOnAnchor(this.mHandler.obtainMessage(2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerRenderer(Renderer renderer) {
        Vector<Renderer> vector = this.mRenderers;
        synchronized (vector) {
            if (!this.mRenderers.contains(renderer)) {
                this.mRenderers.add(renderer);
            }
            return;
        }
    }

    public void reset() {
        this.checkAnchorLooper();
        this.hide();
        this.selectTrack(null);
        this.mTracks.clear();
        this.mTrackIsExplicit = false;
        this.mVisibilityIsExplicit = false;
        this.mCaptioningManager.removeCaptioningChangeListener(this.mCaptioningChangeListener);
    }

    public void selectDefaultTrack() {
        this.processOnAnchor(this.mHandler.obtainMessage(4));
    }

    public boolean selectTrack(SubtitleTrack subtitleTrack) {
        if (subtitleTrack != null && !this.mTracks.contains(subtitleTrack)) {
            return false;
        }
        this.processOnAnchor(this.mHandler.obtainMessage(3, subtitleTrack));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setAnchor(Anchor anchor) {
        block5: {
            block4: {
                if (this.mAnchor == anchor) break block4;
                if (this.mAnchor != null) {
                    this.checkAnchorLooper();
                    this.mAnchor.setSubtitleWidget(null);
                }
                this.mAnchor = anchor;
                this.mHandler = null;
                if (this.mAnchor != null) break block5;
            }
            return;
        }
        this.mHandler = new Handler(this.mAnchor.getSubtitleLooper(), this.mCallback);
        this.checkAnchorLooper();
        this.mAnchor.setSubtitleWidget(this.getRenderingWidget());
    }

    public void show() {
        this.processOnAnchor(this.mHandler.obtainMessage(1));
    }

    public static interface Anchor {
        public Looper getSubtitleLooper();

        public void setSubtitleWidget(SubtitleTrack.RenderingWidget var1);
    }

    public static interface Listener {
        public void onSubtitleTrackSelected(SubtitleTrack var1);
    }

    public static abstract class Renderer {
        public abstract SubtitleTrack createTrack(MediaFormat var1);

        public abstract boolean supports(MediaFormat var1);
    }
}

