/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.TtmlNode;
import android.media.TtmlNodeListener;
import android.media.TtmlUtils;
import android.text.TextUtils;
import android.util.Log;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

class TtmlParser {
    private static final int DEFAULT_FRAMERATE = 30;
    private static final int DEFAULT_SUBFRAMERATE = 1;
    private static final int DEFAULT_TICKRATE = 1;
    static final String TAG = "TtmlParser";
    private long mCurrentRunId;
    private final TtmlNodeListener mListener;
    private XmlPullParser mParser;

    public TtmlParser(TtmlNodeListener ttmlNodeListener) {
        this.mListener = ttmlNodeListener;
    }

    private void extractAttribute(XmlPullParser xmlPullParser, int n, StringBuilder stringBuilder) {
        stringBuilder.append(" ");
        stringBuilder.append(xmlPullParser.getAttributeName(n));
        stringBuilder.append("=\"");
        stringBuilder.append(xmlPullParser.getAttributeValue(n));
        stringBuilder.append("\"");
    }

    private boolean isEndOfDoc() throws XmlPullParserException {
        return this.mParser.getEventType() == 1;
    }

    private static boolean isSupportedTag(String string2) {
        return string2.equals("tt") || string2.equals("head") || string2.equals("body") || string2.equals("div") || string2.equals("p") || string2.equals("span") || string2.equals("br") || string2.equals("style") || string2.equals("styling") || string2.equals("layout") || string2.equals("region") || string2.equals("metadata") || string2.equals("smpte:image") || string2.equals("smpte:data") || string2.equals("smpte:information");
    }

    private void loadParser(String string2) throws XmlPullParserException {
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
        xmlPullParserFactory.setNamespaceAware(false);
        this.mParser = xmlPullParserFactory.newPullParser();
        StringReader stringReader = new StringReader(string2);
        this.mParser.setInput(stringReader);
    }

    /*
     * Enabled aggressive block sorting
     */
    private TtmlNode parseNode(TtmlNode ttmlNode) throws XmlPullParserException, IOException {
        int n;
        if (this.mParser.getEventType() != 2) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        long l = 0L;
        long l2 = Long.MAX_VALUE;
        long l3 = 0L;
        for (int i = 0; i < (n = this.mParser.getAttributeCount()); ++i) {
            String string2 = this.mParser.getAttributeName(i);
            String string3 = this.mParser.getAttributeValue(i);
            String string4 = string2.replaceFirst("^.*:", "");
            if (string4.equals("begin")) {
                l = TtmlUtils.parseTimeExpression(string3, 30, 1, 1);
                continue;
            }
            if (string4.equals("end")) {
                l2 = TtmlUtils.parseTimeExpression(string3, 30, 1, 1);
                continue;
            }
            if (string4.equals("dur")) {
                l3 = TtmlUtils.parseTimeExpression(string3, 30, 1, 1);
                continue;
            }
            this.extractAttribute(this.mParser, i, stringBuilder);
        }
        if (ttmlNode != null) {
            l += ttmlNode.mStartTimeMs;
            if (l2 != Long.MAX_VALUE) {
                l2 += ttmlNode.mStartTimeMs;
            }
        }
        if (l3 > 0L) {
            if (l2 != Long.MAX_VALUE) {
                Log.e(TAG, "'dur' and 'end' attributes are defined at the same time.'end' value is ignored.");
            }
            l2 = l + l3;
        }
        if (ttmlNode != null && l2 == Long.MAX_VALUE && ttmlNode.mEndTimeMs != Long.MAX_VALUE && l2 > ttmlNode.mEndTimeMs) {
            l2 = ttmlNode.mEndTimeMs;
        }
        return new TtmlNode(this.mParser.getName(), stringBuilder.toString(), null, l, l2, ttmlNode, this.mCurrentRunId);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseTtml() throws XmlPullParserException, IOException {
        LinkedList<TtmlNode> linkedList = new LinkedList<TtmlNode>();
        int n = 0;
        boolean bl = true;
        while (true) {
            block17: {
                int n2;
                block15: {
                    TtmlNode ttmlNode;
                    block16: {
                        if (this.isEndOfDoc()) {
                            return;
                        }
                        n2 = this.mParser.getEventType();
                        ttmlNode = (TtmlNode)linkedList.peekLast();
                        if (!bl) break block15;
                        if (n2 != 2) break block16;
                        if (!TtmlParser.isSupportedTag(this.mParser.getName())) {
                            Log.w(TAG, "Unsupported tag " + this.mParser.getName() + " is ignored.");
                            ++n;
                            bl = false;
                            break block17;
                        } else {
                            TtmlNode ttmlNode2 = this.parseNode(ttmlNode);
                            linkedList.addLast(ttmlNode2);
                            if (ttmlNode != null) {
                                ttmlNode.mChildren.add(ttmlNode2);
                            }
                        }
                        break block17;
                    }
                    if (n2 == 4) {
                        String string2 = TtmlUtils.applyDefaultSpacePolicy(this.mParser.getText());
                        if (!TextUtils.isEmpty(string2)) {
                            ttmlNode.mChildren.add(new TtmlNode("#pcdata", "", string2, 0L, Long.MAX_VALUE, ttmlNode, this.mCurrentRunId));
                        }
                        break block17;
                    } else if (n2 == 3) {
                        if (this.mParser.getName().equals("p")) {
                            this.mListener.onTtmlNodeParsed((TtmlNode)linkedList.getLast());
                        } else if (this.mParser.getName().equals("tt")) {
                            this.mListener.onRootNodeParsed((TtmlNode)linkedList.getLast());
                        }
                        linkedList.removeLast();
                    }
                    break block17;
                }
                if (n2 == 2) {
                    ++n;
                } else if (n2 == 3 && --n == 0) {
                    bl = true;
                }
            }
            this.mParser.next();
        }
    }

    public void parse(String string2, long l) throws XmlPullParserException, IOException {
        this.mParser = null;
        this.mCurrentRunId = l;
        this.loadParser(string2);
        this.parseTtml();
    }
}

