/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiofx;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import java.lang.ref.WeakReference;

public class Visualizer {
    public static final int ALREADY_EXISTS = -2;
    public static final int ERROR = -1;
    public static final int ERROR_BAD_VALUE = -4;
    public static final int ERROR_DEAD_OBJECT = -7;
    public static final int ERROR_INVALID_OPERATION = -5;
    public static final int ERROR_NO_INIT = -3;
    public static final int ERROR_NO_MEMORY = -6;
    public static final int MEASUREMENT_MODE_NONE = 0;
    public static final int MEASUREMENT_MODE_PEAK_RMS = 1;
    private static final int NATIVE_EVENT_FFT_CAPTURE = 1;
    private static final int NATIVE_EVENT_PCM_CAPTURE = 0;
    private static final int NATIVE_EVENT_SERVER_DIED = 2;
    public static final int SCALING_MODE_AS_PLAYED = 1;
    public static final int SCALING_MODE_NORMALIZED = 0;
    public static final int STATE_ENABLED = 2;
    public static final int STATE_INITIALIZED = 1;
    public static final int STATE_UNINITIALIZED = 0;
    public static final int SUCCESS = 0;
    private static final String TAG = "Visualizer-JAVA";
    private OnDataCaptureListener mCaptureListener = null;
    private int mId;
    private long mJniData;
    private final Object mListenerLock;
    private NativeEventHandler mNativeEventHandler = null;
    private long mNativeVisualizer;
    private OnServerDiedListener mServerDiedListener = null;
    private int mState = 0;
    private final Object mStateLock = new Object();

    static {
        System.loadLibrary("audioeffect_jni");
        Visualizer.native_init();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Visualizer(int n) throws UnsupportedOperationException, RuntimeException {
        this.mListenerLock = new Object();
        int[] nArray = new int[1];
        Object object = this.mStateLock;
        synchronized (object) {
            this.mState = 0;
            int n2 = this.native_setup(new WeakReference<Visualizer>(this), n, nArray);
            if (n2 != 0 && n2 != -2) {
                Log.e(TAG, "Error code " + n2 + " when initializing Visualizer.");
                switch (n2) {
                    default: {
                        throw new RuntimeException("Cannot initialize Visualizer engine, error: " + n2);
                    }
                    case -5: 
                }
                throw new UnsupportedOperationException("Effect library not loaded");
            }
            this.mId = nArray[0];
            this.mState = this.native_getEnabled() ? 2 : 1;
            return;
        }
    }

    public static native int[] getCaptureSizeRange();

    public static native int getMaxCaptureRate();

    private final native void native_finalize();

    private final native int native_getCaptureSize();

    private final native boolean native_getEnabled();

    private final native int native_getFft(byte[] var1);

    private final native int native_getMeasurementMode();

    private final native int native_getPeakRms(MeasurementPeakRms var1);

    private final native int native_getSamplingRate();

    private final native int native_getScalingMode();

    private final native int native_getWaveForm(byte[] var1);

    private static final native void native_init();

    private final native void native_release();

    private final native int native_setCaptureSize(int var1);

    private final native int native_setEnabled(boolean var1);

    private final native int native_setMeasurementMode(int var1);

    private final native int native_setPeriodicCapture(int var1, boolean var2, boolean var3);

    private final native int native_setScalingMode(int var1);

    private final native int native_setup(Object var1, int var2, int[] var3);

    /*
     * Enabled aggressive block sorting
     */
    private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
        Visualizer visualizer = (Visualizer)((WeakReference)object).get();
        if (visualizer == null || visualizer.mNativeEventHandler == null) {
            return;
        }
        Message message = visualizer.mNativeEventHandler.obtainMessage(n, n2, n3, object2);
        visualizer.mNativeEventHandler.sendMessage(message);
    }

    protected void finalize() {
        this.native_finalize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getCaptureSize() throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != 0) return this.native_getCaptureSize();
            throw new IllegalStateException("getCaptureSize() called in wrong state: " + this.mState);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getEnabled() {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != 0) return this.native_getEnabled();
            throw new IllegalStateException("getEnabled() called in wrong state: " + this.mState);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getFft(byte[] byArray) throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == 2) return this.native_getFft(byArray);
            throw new IllegalStateException("getFft() called in wrong state: " + this.mState);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getMeasurementMode() throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != 0) return this.native_getMeasurementMode();
            throw new IllegalStateException("getMeasurementMode() called in wrong state: " + this.mState);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getMeasurementPeakRms(MeasurementPeakRms measurementPeakRms) {
        if (measurementPeakRms == null) {
            Log.e(TAG, "Cannot store measurements in a null object");
            return -4;
        }
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == 2) return this.native_getPeakRms(measurementPeakRms);
            throw new IllegalStateException("getMeasurementPeakRms() called in wrong state: " + this.mState);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getSamplingRate() throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != 0) return this.native_getSamplingRate();
            throw new IllegalStateException("getSamplingRate() called in wrong state: " + this.mState);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getScalingMode() throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != 0) return this.native_getScalingMode();
            throw new IllegalStateException("getScalingMode() called in wrong state: " + this.mState);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getWaveForm(byte[] byArray) throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == 2) return this.native_getWaveForm(byArray);
            throw new IllegalStateException("getWaveForm() called in wrong state: " + this.mState);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void release() {
        Object object = this.mStateLock;
        synchronized (object) {
            this.native_release();
            this.mState = 0;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int setCaptureSize(int n) throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == 1) return this.native_setCaptureSize(n);
            throw new IllegalStateException("setCaptureSize() called in wrong state: " + this.mState);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int setDataCaptureListener(OnDataCaptureListener onDataCaptureListener, int n, boolean bl, boolean bl2) {
        int n2;
        Object object = this.mListenerLock;
        // MONITORENTER : object
        this.mCaptureListener = onDataCaptureListener;
        // MONITOREXIT : object
        if (onDataCaptureListener == null) {
            bl = false;
            bl2 = false;
        }
        if ((n2 = this.native_setPeriodicCapture(n, bl, bl2)) != 0) return n2;
        if (onDataCaptureListener == null) return n2;
        if (this.mNativeEventHandler != null) return n2;
        Looper looper = Looper.myLooper();
        if (looper != null) {
            this.mNativeEventHandler = new NativeEventHandler(this, looper);
            return n2;
        }
        Looper looper2 = Looper.getMainLooper();
        if (looper2 != null) {
            this.mNativeEventHandler = new NativeEventHandler(this, looper2);
            return n2;
        }
        this.mNativeEventHandler = null;
        return -3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int setEnabled(boolean bl) throws IllegalStateException {
        int n = 2;
        Object object = this.mStateLock;
        synchronized (object) {
            int n2;
            block10: {
                block9: {
                    if (this.mState == 0) {
                        throw new IllegalStateException("setEnabled() called in wrong state: " + this.mState);
                    }
                    if (bl && this.mState == 1) break block9;
                    n2 = 0;
                    if (bl) break block10;
                    int n3 = this.mState;
                    n2 = 0;
                    if (n3 != n) break block10;
                }
                if ((n2 = this.native_setEnabled(bl)) == 0) {
                    if (!bl) {
                        n = 1;
                    }
                    this.mState = n;
                }
            }
            return n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int setMeasurementMode(int n) throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != 0) return this.native_setMeasurementMode(n);
            throw new IllegalStateException("setMeasurementMode() called in wrong state: " + this.mState);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int setScalingMode(int n) throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != 0) return this.native_setScalingMode(n);
            throw new IllegalStateException("setScalingMode() called in wrong state: " + this.mState);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int setServerDiedListener(OnServerDiedListener onServerDiedListener) {
        Object object = this.mListenerLock;
        synchronized (object) {
            this.mServerDiedListener = onServerDiedListener;
            return 0;
        }
    }

    public static final class MeasurementPeakRms {
        public int mPeak;
        public int mRms;
    }

    private class NativeEventHandler
    extends Handler {
        private Visualizer mVisualizer;

        public NativeEventHandler(Visualizer visualizer2, Looper looper) {
            super(looper);
            this.mVisualizer = visualizer2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void handleCaptureMessage(Message message) {
            Object object = Visualizer.this.mListenerLock;
            // MONITORENTER : object
            OnDataCaptureListener onDataCaptureListener = this.mVisualizer.mCaptureListener;
            // MONITOREXIT : object
            if (onDataCaptureListener == null) return;
            byte[] byArray = (byte[])message.obj;
            int n = message.arg1;
            switch (message.what) {
                default: {
                    Log.e(Visualizer.TAG, "Unknown native event in handleCaptureMessge: " + message.what);
                    return;
                }
                case 0: {
                    onDataCaptureListener.onWaveFormDataCapture(this.mVisualizer, byArray, n);
                    return;
                }
                case 1: 
            }
            onDataCaptureListener.onFftDataCapture(this.mVisualizer, byArray, n);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void handleServerDiedMessage(Message message) {
            Object object = Visualizer.this.mListenerLock;
            // MONITORENTER : object
            OnServerDiedListener onServerDiedListener = this.mVisualizer.mServerDiedListener;
            // MONITOREXIT : object
            if (onServerDiedListener == null) return;
            onServerDiedListener.onServerDied();
        }

        @Override
        public void handleMessage(Message message) {
            if (this.mVisualizer == null) {
                return;
            }
            switch (message.what) {
                default: {
                    Log.e(Visualizer.TAG, "Unknown native event: " + message.what);
                    return;
                }
                case 0: 
                case 1: {
                    this.handleCaptureMessage(message);
                    return;
                }
                case 2: 
            }
            this.handleServerDiedMessage(message);
        }
    }

    public static interface OnDataCaptureListener {
        public void onFftDataCapture(Visualizer var1, byte[] var2, int var3);

        public void onWaveFormDataCapture(Visualizer var1, byte[] var2, int var3);
    }

    public static interface OnServerDiedListener {
        public void onServerDied();
    }
}

