/*
 * Decompiled with CFR 0.152.
 */
package android.media.projection;

import android.media.projection.MediaProjectionInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IMediaProjectionWatcherCallback
extends IInterface {
    public void onStart(MediaProjectionInfo var1) throws RemoteException;

    public void onStop(MediaProjectionInfo var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMediaProjectionWatcherCallback {
        private static final String DESCRIPTOR = "android.media.projection.IMediaProjectionWatcherCallback";
        static final int TRANSACTION_onStart = 1;
        static final int TRANSACTION_onStop = 2;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IMediaProjectionWatcherCallback asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IMediaProjectionWatcherCallback) {
                return (IMediaProjectionWatcherCallback)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    MediaProjectionInfo mediaProjectionInfo = parcel.readInt() != 0 ? MediaProjectionInfo.CREATOR.createFromParcel(parcel) : null;
                    this.onStart(mediaProjectionInfo);
                    return true;
                }
                case 2: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            MediaProjectionInfo mediaProjectionInfo = parcel.readInt() != 0 ? MediaProjectionInfo.CREATOR.createFromParcel(parcel) : null;
            this.onStop(mediaProjectionInfo);
            return true;
        }

        private static class Proxy
        implements IMediaProjectionWatcherCallback {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onStart(MediaProjectionInfo mediaProjectionInfo) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (mediaProjectionInfo != null) {
                        parcel.writeInt(1);
                        mediaProjectionInfo.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(1, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onStop(MediaProjectionInfo mediaProjectionInfo) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (mediaProjectionInfo != null) {
                        parcel.writeInt(1);
                        mediaProjectionInfo.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(2, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }
        }
    }
}

