/*
 * Decompiled with CFR 0.152.
 */
package android.media.session;

import android.app.PendingIntent;
import android.content.Context;
import android.content.pm.ParceledListSlice;
import android.media.AudioAttributes;
import android.media.MediaMetadata;
import android.media.Rating;
import android.media.session.ISessionController;
import android.media.session.ISessionControllerCallback;
import android.media.session.MediaSession;
import android.media.session.ParcelableVolumeInfo;
import android.media.session.PlaybackState;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public final class MediaController {
    private static final int MSG_DESTROYED = 8;
    private static final int MSG_EVENT = 1;
    private static final int MSG_UPDATE_EXTRAS = 7;
    private static final int MSG_UPDATE_METADATA = 3;
    private static final int MSG_UPDATE_PLAYBACK_STATE = 2;
    private static final int MSG_UPDATE_QUEUE = 5;
    private static final int MSG_UPDATE_QUEUE_TITLE = 6;
    private static final int MSG_UPDATE_VOLUME = 4;
    private static final String TAG = "MediaController";
    private final ArrayList<MessageHandler> mCallbacks;
    private boolean mCbRegistered = false;
    private final CallbackStub mCbStub = new CallbackStub(this);
    private final Context mContext;
    private final Object mLock;
    private String mPackageName;
    private final ISessionController mSessionBinder;
    private String mTag;
    private final MediaSession.Token mToken;
    private final TransportControls mTransportControls;

    public MediaController(Context context, ISessionController iSessionController) {
        this.mCallbacks = new ArrayList();
        this.mLock = new Object();
        if (iSessionController == null) {
            throw new IllegalArgumentException("Session token cannot be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
        this.mSessionBinder = iSessionController;
        this.mTransportControls = new TransportControls();
        this.mToken = new MediaSession.Token(iSessionController);
        this.mContext = context;
    }

    public MediaController(Context context, MediaSession.Token token) {
        this(context, token.getBinder());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addCallbackLocked(Callback callback, Handler handler) {
        if (this.getHandlerForCallbackLocked(callback) != null) {
            Log.w(TAG, "Callback is already added, ignoring");
            return;
        } else {
            MessageHandler messageHandler = new MessageHandler(handler.getLooper(), callback);
            this.mCallbacks.add(messageHandler);
            if (this.mCbRegistered) return;
            try {
                this.mSessionBinder.registerCallbackListener(this.mCbStub);
                this.mCbRegistered = true;
                return;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Dead object in registerCallback", remoteException);
                return;
            }
        }
    }

    private MessageHandler getHandlerForCallbackLocked(Callback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback cannot be null");
        }
        for (int i = -1 + this.mCallbacks.size(); i >= 0; --i) {
            MessageHandler messageHandler = this.mCallbacks.get(i);
            if (callback != messageHandler.mCallback) continue;
            return messageHandler;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void postMessage(int n, Object object, Bundle bundle) {
        Object object2 = this.mLock;
        synchronized (object2) {
            int n2 = -1 + this.mCallbacks.size();
            while (n2 >= 0) {
                this.mCallbacks.get(n2).post(n, object, bundle);
                --n2;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean removeCallbackLocked(Callback callback) {
        boolean bl = false;
        for (int i = -1 + this.mCallbacks.size(); i >= 0; --i) {
            if (callback != this.mCallbacks.get(i).mCallback) continue;
            this.mCallbacks.remove(i);
            bl = true;
        }
        if (this.mCbRegistered && this.mCallbacks.size() == 0) {
            try {
                this.mSessionBinder.unregisterCallbackListener(this.mCbStub);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Dead object in removeCallbackLocked");
            }
            this.mCbRegistered = false;
        }
        return bl;
    }

    public void adjustVolume(int n, int n2) {
        try {
            this.mSessionBinder.adjustVolume(n, n2, this.mContext.getPackageName());
            return;
        }
        catch (RemoteException remoteException) {
            Log.wtf(TAG, "Error calling adjustVolumeBy.", remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean controlsSameSession(MediaController mediaController) {
        return mediaController != null && this.mSessionBinder.asBinder() == mediaController.getSessionBinder().asBinder();
    }

    public boolean dispatchMediaButtonEvent(KeyEvent keyEvent) {
        if (keyEvent == null) {
            throw new IllegalArgumentException("KeyEvent may not be null");
        }
        if (!KeyEvent.isMediaKey(keyEvent.getKeyCode())) {
            return false;
        }
        try {
            boolean bl = this.mSessionBinder.sendMediaButton(keyEvent);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public Bundle getExtras() {
        try {
            Bundle bundle = this.mSessionBinder.getExtras();
            return bundle;
        }
        catch (RemoteException remoteException) {
            Log.wtf(TAG, "Error calling getExtras", remoteException);
            return null;
        }
    }

    public long getFlags() {
        try {
            long l = this.mSessionBinder.getFlags();
            return l;
        }
        catch (RemoteException remoteException) {
            Log.wtf(TAG, "Error calling getFlags.", remoteException);
            return 0L;
        }
    }

    public MediaMetadata getMetadata() {
        try {
            MediaMetadata mediaMetadata = this.mSessionBinder.getMetadata();
            return mediaMetadata;
        }
        catch (RemoteException remoteException) {
            Log.wtf(TAG, "Error calling getMetadata.", remoteException);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getPackageName() {
        if (this.mPackageName != null) return this.mPackageName;
        try {
            this.mPackageName = this.mSessionBinder.getPackageName();
            return this.mPackageName;
        }
        catch (RemoteException remoteException) {
            Log.d(TAG, "Dead object in getPackageName.", remoteException);
            return this.mPackageName;
        }
    }

    public PlaybackInfo getPlaybackInfo() {
        try {
            ParcelableVolumeInfo parcelableVolumeInfo = this.mSessionBinder.getVolumeAttributes();
            PlaybackInfo playbackInfo = new PlaybackInfo(parcelableVolumeInfo.volumeType, parcelableVolumeInfo.audioAttrs, parcelableVolumeInfo.controlType, parcelableVolumeInfo.maxVolume, parcelableVolumeInfo.currentVolume);
            return playbackInfo;
        }
        catch (RemoteException remoteException) {
            Log.wtf(TAG, "Error calling getAudioInfo.", remoteException);
            return null;
        }
    }

    public PlaybackState getPlaybackState() {
        try {
            PlaybackState playbackState = this.mSessionBinder.getPlaybackState();
            return playbackState;
        }
        catch (RemoteException remoteException) {
            Log.wtf(TAG, "Error calling getPlaybackState.", remoteException);
            return null;
        }
    }

    public List<MediaSession.QueueItem> getQueue() {
        block3: {
            ParceledListSlice parceledListSlice = this.mSessionBinder.getQueue();
            if (parceledListSlice == null) break block3;
            try {
                List<MediaSession.QueueItem> list = parceledListSlice.getList();
                return list;
            }
            catch (RemoteException remoteException) {
                Log.wtf(TAG, "Error calling getQueue.", remoteException);
            }
        }
        return null;
    }

    public CharSequence getQueueTitle() {
        try {
            CharSequence charSequence = this.mSessionBinder.getQueueTitle();
            return charSequence;
        }
        catch (RemoteException remoteException) {
            Log.wtf(TAG, "Error calling getQueueTitle", remoteException);
            return null;
        }
    }

    public int getRatingType() {
        try {
            int n = this.mSessionBinder.getRatingType();
            return n;
        }
        catch (RemoteException remoteException) {
            Log.wtf(TAG, "Error calling getRatingType.", remoteException);
            return 0;
        }
    }

    public PendingIntent getSessionActivity() {
        try {
            PendingIntent pendingIntent = this.mSessionBinder.getLaunchPendingIntent();
            return pendingIntent;
        }
        catch (RemoteException remoteException) {
            Log.wtf(TAG, "Error calling getPendingIntent.", remoteException);
            return null;
        }
    }

    ISessionController getSessionBinder() {
        return this.mSessionBinder;
    }

    public MediaSession.Token getSessionToken() {
        return this.mToken;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getTag() {
        if (this.mTag != null) return this.mTag;
        try {
            this.mTag = this.mSessionBinder.getTag();
            return this.mTag;
        }
        catch (RemoteException remoteException) {
            Log.d(TAG, "Dead object in getTag.", remoteException);
            return this.mTag;
        }
    }

    public TransportControls getTransportControls() {
        return this.mTransportControls;
    }

    public void registerCallback(Callback callback) {
        this.registerCallback(callback, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerCallback(Callback callback, Handler handler) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        if (handler == null) {
            handler = new Handler();
        }
        Object object = this.mLock;
        synchronized (object) {
            this.addCallbackLocked(callback, handler);
            return;
        }
    }

    public void sendCommand(String string2, Bundle bundle, ResultReceiver resultReceiver) {
        if (TextUtils.isEmpty(string2)) {
            throw new IllegalArgumentException("command cannot be null or empty");
        }
        try {
            this.mSessionBinder.sendCommand(string2, bundle, resultReceiver);
            return;
        }
        catch (RemoteException remoteException) {
            Log.d(TAG, "Dead object in sendCommand.", remoteException);
            return;
        }
    }

    public void setVolumeTo(int n, int n2) {
        try {
            this.mSessionBinder.setVolumeTo(n, n2, this.mContext.getPackageName());
            return;
        }
        catch (RemoteException remoteException) {
            Log.wtf(TAG, "Error calling setVolumeTo.", remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterCallback(Callback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.removeCallbackLocked(callback);
            return;
        }
    }

    public static abstract class Callback {
        public void onAudioInfoChanged(PlaybackInfo playbackInfo) {
        }

        public void onExtrasChanged(Bundle bundle) {
        }

        public void onMetadataChanged(MediaMetadata mediaMetadata) {
        }

        public void onPlaybackStateChanged(PlaybackState playbackState) {
        }

        public void onQueueChanged(List<MediaSession.QueueItem> list) {
        }

        public void onQueueTitleChanged(CharSequence charSequence) {
        }

        public void onSessionDestroyed() {
        }

        public void onSessionEvent(String string2, Bundle bundle) {
        }
    }

    private static final class CallbackStub
    extends ISessionControllerCallback.Stub {
        private final WeakReference<MediaController> mController;

        public CallbackStub(MediaController mediaController) {
            this.mController = new WeakReference<MediaController>(mediaController);
        }

        @Override
        public void onEvent(String string2, Bundle bundle) {
            MediaController mediaController = (MediaController)this.mController.get();
            if (mediaController != null) {
                mediaController.postMessage(1, string2, bundle);
            }
        }

        @Override
        public void onExtrasChanged(Bundle bundle) {
            MediaController mediaController = (MediaController)this.mController.get();
            if (mediaController != null) {
                mediaController.postMessage(7, bundle, null);
            }
        }

        @Override
        public void onMetadataChanged(MediaMetadata mediaMetadata) {
            MediaController mediaController = (MediaController)this.mController.get();
            if (mediaController != null) {
                mediaController.postMessage(3, mediaMetadata, null);
            }
        }

        @Override
        public void onPlaybackStateChanged(PlaybackState playbackState) {
            MediaController mediaController = (MediaController)this.mController.get();
            if (mediaController != null) {
                mediaController.postMessage(2, playbackState, null);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onQueueChanged(ParceledListSlice parceledListSlice) {
            List list = parceledListSlice == null ? null : parceledListSlice.getList();
            MediaController mediaController = (MediaController)this.mController.get();
            if (mediaController != null) {
                mediaController.postMessage(5, list, null);
            }
        }

        @Override
        public void onQueueTitleChanged(CharSequence charSequence) {
            MediaController mediaController = (MediaController)this.mController.get();
            if (mediaController != null) {
                mediaController.postMessage(6, charSequence, null);
            }
        }

        @Override
        public void onSessionDestroyed() {
            MediaController mediaController = (MediaController)this.mController.get();
            if (mediaController != null) {
                mediaController.postMessage(8, null, null);
            }
        }

        @Override
        public void onVolumeInfoChanged(ParcelableVolumeInfo parcelableVolumeInfo) {
            MediaController mediaController = (MediaController)this.mController.get();
            if (mediaController != null) {
                mediaController.postMessage(4, new PlaybackInfo(parcelableVolumeInfo.volumeType, parcelableVolumeInfo.audioAttrs, parcelableVolumeInfo.controlType, parcelableVolumeInfo.maxVolume, parcelableVolumeInfo.currentVolume), null);
            }
        }
    }

    private static final class MessageHandler
    extends Handler {
        private final Callback mCallback;

        public MessageHandler(Looper looper, Callback callback) {
            super(looper, null, true);
            this.mCallback = callback;
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case 1: {
                    this.mCallback.onSessionEvent((String)message.obj, message.getData());
                    return;
                }
                case 2: {
                    this.mCallback.onPlaybackStateChanged((PlaybackState)message.obj);
                    return;
                }
                case 3: {
                    this.mCallback.onMetadataChanged((MediaMetadata)message.obj);
                    return;
                }
                case 5: {
                    this.mCallback.onQueueChanged((List)message.obj);
                    return;
                }
                case 6: {
                    this.mCallback.onQueueTitleChanged((CharSequence)message.obj);
                    return;
                }
                case 7: {
                    this.mCallback.onExtrasChanged((Bundle)message.obj);
                    return;
                }
                case 4: {
                    this.mCallback.onAudioInfoChanged((PlaybackInfo)message.obj);
                    return;
                }
                case 8: 
            }
            this.mCallback.onSessionDestroyed();
        }

        public void post(int n, Object object, Bundle bundle) {
            this.obtainMessage(n, object).sendToTarget();
        }
    }

    public static final class PlaybackInfo {
        public static final int PLAYBACK_TYPE_LOCAL = 1;
        public static final int PLAYBACK_TYPE_REMOTE = 2;
        private final AudioAttributes mAudioAttrs;
        private final int mCurrentVolume;
        private final int mMaxVolume;
        private final int mVolumeControl;
        private final int mVolumeType;

        public PlaybackInfo(int n, AudioAttributes audioAttributes, int n2, int n3, int n4) {
            this.mVolumeType = n;
            this.mAudioAttrs = audioAttributes;
            this.mVolumeControl = n2;
            this.mMaxVolume = n3;
            this.mCurrentVolume = n4;
        }

        public AudioAttributes getAudioAttributes() {
            return this.mAudioAttrs;
        }

        public int getCurrentVolume() {
            return this.mCurrentVolume;
        }

        public int getMaxVolume() {
            return this.mMaxVolume;
        }

        public int getPlaybackType() {
            return this.mVolumeType;
        }

        public int getVolumeControl() {
            return this.mVolumeControl;
        }
    }

    public final class TransportControls {
        private static final String TAG = "TransportController";

        private TransportControls() {
        }

        public void fastForward() {
            try {
                MediaController.this.mSessionBinder.fastForward();
                return;
            }
            catch (RemoteException remoteException) {
                Log.wtf(TAG, "Error calling fastForward.", remoteException);
                return;
            }
        }

        public void pause() {
            try {
                MediaController.this.mSessionBinder.pause();
                return;
            }
            catch (RemoteException remoteException) {
                Log.wtf(TAG, "Error calling pause.", remoteException);
                return;
            }
        }

        public void play() {
            try {
                MediaController.this.mSessionBinder.play();
                return;
            }
            catch (RemoteException remoteException) {
                Log.wtf(TAG, "Error calling play.", remoteException);
                return;
            }
        }

        public void playFromMediaId(String string2, Bundle bundle) {
            if (TextUtils.isEmpty(string2)) {
                throw new IllegalArgumentException("You must specify a non-empty String for playFromMediaId.");
            }
            try {
                MediaController.this.mSessionBinder.playFromMediaId(string2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                Log.wtf(TAG, "Error calling play(" + string2 + ").", remoteException);
                return;
            }
        }

        public void playFromSearch(String string2, Bundle bundle) {
            if (string2 == null) {
                string2 = "";
            }
            try {
                MediaController.this.mSessionBinder.playFromSearch(string2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                Log.wtf(TAG, "Error calling play(" + string2 + ").", remoteException);
                return;
            }
        }

        public void rewind() {
            try {
                MediaController.this.mSessionBinder.rewind();
                return;
            }
            catch (RemoteException remoteException) {
                Log.wtf(TAG, "Error calling rewind.", remoteException);
                return;
            }
        }

        public void seekTo(long l) {
            try {
                MediaController.this.mSessionBinder.seekTo(l);
                return;
            }
            catch (RemoteException remoteException) {
                Log.wtf(TAG, "Error calling seekTo.", remoteException);
                return;
            }
        }

        public void sendCustomAction(PlaybackState.CustomAction customAction, Bundle bundle) {
            if (customAction == null) {
                throw new IllegalArgumentException("CustomAction cannot be null.");
            }
            this.sendCustomAction(customAction.getAction(), bundle);
        }

        public void sendCustomAction(String string2, Bundle bundle) {
            if (TextUtils.isEmpty(string2)) {
                throw new IllegalArgumentException("CustomAction cannot be null.");
            }
            try {
                MediaController.this.mSessionBinder.sendCustomAction(string2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                Log.d(TAG, "Dead object in sendCustomAction.", remoteException);
                return;
            }
        }

        public void setRating(Rating rating) {
            try {
                MediaController.this.mSessionBinder.rate(rating);
                return;
            }
            catch (RemoteException remoteException) {
                Log.wtf(TAG, "Error calling rate.", remoteException);
                return;
            }
        }

        public void skipToNext() {
            try {
                MediaController.this.mSessionBinder.next();
                return;
            }
            catch (RemoteException remoteException) {
                Log.wtf(TAG, "Error calling next.", remoteException);
                return;
            }
        }

        public void skipToPrevious() {
            try {
                MediaController.this.mSessionBinder.previous();
                return;
            }
            catch (RemoteException remoteException) {
                Log.wtf(TAG, "Error calling previous.", remoteException);
                return;
            }
        }

        public void skipToQueueItem(long l) {
            try {
                MediaController.this.mSessionBinder.skipToQueueItem(l);
                return;
            }
            catch (RemoteException remoteException) {
                Log.wtf(TAG, "Error calling skipToItem(" + l + ").", remoteException);
                return;
            }
        }

        public void stop() {
            try {
                MediaController.this.mSessionBinder.stop();
                return;
            }
            catch (RemoteException remoteException) {
                Log.wtf(TAG, "Error calling stop.", remoteException);
                return;
            }
        }
    }
}

