/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;

public final class TvInputHardwareInfo
implements Parcelable {
    public static final Parcelable.Creator<TvInputHardwareInfo> CREATOR = new Parcelable.Creator<TvInputHardwareInfo>(){

        @Override
        public TvInputHardwareInfo createFromParcel(Parcel parcel) {
            try {
                TvInputHardwareInfo tvInputHardwareInfo = new TvInputHardwareInfo();
                tvInputHardwareInfo.readFromParcel(parcel);
                return tvInputHardwareInfo;
            }
            catch (Exception exception) {
                Log.e(TvInputHardwareInfo.TAG, "Exception creating TvInputHardwareInfo from parcel", exception);
                return null;
            }
        }

        public TvInputHardwareInfo[] newArray(int n) {
            return new TvInputHardwareInfo[n];
        }
    };
    static final String TAG = "TvInputHardwareInfo";
    public static final int TV_INPUT_TYPE_COMPONENT = 6;
    public static final int TV_INPUT_TYPE_COMPOSITE = 3;
    public static final int TV_INPUT_TYPE_DISPLAY_PORT = 10;
    public static final int TV_INPUT_TYPE_DVI = 8;
    public static final int TV_INPUT_TYPE_HDMI = 9;
    public static final int TV_INPUT_TYPE_OTHER_HARDWARE = 1;
    public static final int TV_INPUT_TYPE_SCART = 5;
    public static final int TV_INPUT_TYPE_SVIDEO = 4;
    public static final int TV_INPUT_TYPE_TUNER = 2;
    public static final int TV_INPUT_TYPE_VGA = 7;
    private String mAudioAddress;
    private int mAudioType;
    private int mDeviceId;
    private int mHdmiPortId;
    private int mType;

    private TvInputHardwareInfo() {
    }

    static /* synthetic */ int access$102(TvInputHardwareInfo tvInputHardwareInfo, int n) {
        tvInputHardwareInfo.mDeviceId = n;
        return n;
    }

    static /* synthetic */ int access$202(TvInputHardwareInfo tvInputHardwareInfo, int n) {
        tvInputHardwareInfo.mType = n;
        return n;
    }

    static /* synthetic */ int access$302(TvInputHardwareInfo tvInputHardwareInfo, int n) {
        tvInputHardwareInfo.mAudioType = n;
        return n;
    }

    static /* synthetic */ String access$402(TvInputHardwareInfo tvInputHardwareInfo, String string2) {
        tvInputHardwareInfo.mAudioAddress = string2;
        return string2;
    }

    static /* synthetic */ int access$502(TvInputHardwareInfo tvInputHardwareInfo, int n) {
        tvInputHardwareInfo.mHdmiPortId = n;
        return n;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String getAudioAddress() {
        return this.mAudioAddress;
    }

    public int getAudioType() {
        return this.mAudioType;
    }

    public int getDeviceId() {
        return this.mDeviceId;
    }

    public int getHdmiPortId() {
        if (this.mType != 9) {
            throw new IllegalStateException();
        }
        return this.mHdmiPortId;
    }

    public int getType() {
        return this.mType;
    }

    public void readFromParcel(Parcel parcel) {
        this.mDeviceId = parcel.readInt();
        this.mType = parcel.readInt();
        this.mAudioType = parcel.readInt();
        this.mAudioAddress = parcel.readString();
        if (this.mType == 9) {
            this.mHdmiPortId = parcel.readInt();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("TvInputHardwareInfo {id=").append(this.mDeviceId);
        stringBuilder.append(", type=").append(this.mType);
        stringBuilder.append(", audio_type=").append(this.mAudioType);
        stringBuilder.append(", audio_addr=").append(this.mAudioAddress);
        if (this.mType == 9) {
            stringBuilder.append(", hdmi_port=").append(this.mHdmiPortId);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mDeviceId);
        parcel.writeInt(this.mType);
        parcel.writeInt(this.mAudioType);
        parcel.writeString(this.mAudioAddress);
        if (this.mType == 9) {
            parcel.writeInt(this.mHdmiPortId);
        }
    }

    public static final class Builder {
        private String mAudioAddress = "";
        private int mAudioType = 0;
        private Integer mDeviceId = null;
        private Integer mHdmiPortId = null;
        private Integer mType = null;

        public Builder audioAddress(String string2) {
            this.mAudioAddress = string2;
            return this;
        }

        public Builder audioType(int n) {
            this.mAudioType = n;
            return this;
        }

        public TvInputHardwareInfo build() {
            if (this.mDeviceId == null || this.mType == null) {
                throw new UnsupportedOperationException();
            }
            if (this.mType == 9 && this.mHdmiPortId == null || this.mType != 9 && this.mHdmiPortId != null) {
                throw new UnsupportedOperationException();
            }
            TvInputHardwareInfo tvInputHardwareInfo = new TvInputHardwareInfo();
            TvInputHardwareInfo.access$102(tvInputHardwareInfo, this.mDeviceId);
            TvInputHardwareInfo.access$202(tvInputHardwareInfo, this.mType);
            TvInputHardwareInfo.access$302(tvInputHardwareInfo, this.mAudioType);
            if (tvInputHardwareInfo.mAudioType != 0) {
                TvInputHardwareInfo.access$402(tvInputHardwareInfo, this.mAudioAddress);
            }
            if (this.mHdmiPortId != null) {
                TvInputHardwareInfo.access$502(tvInputHardwareInfo, this.mHdmiPortId);
            }
            return tvInputHardwareInfo;
        }

        public Builder deviceId(int n) {
            this.mDeviceId = n;
            return this;
        }

        public Builder hdmiPortId(int n) {
            this.mHdmiPortId = n;
            return this;
        }

        public Builder type(int n) {
            this.mType = n;
            return this;
        }
    }
}

