/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.app.PendingIntent;
import android.content.Context;
import android.net.IConnectivityManager;
import android.net.LinkProperties;
import android.net.LinkQualityInfo;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkMisc;
import android.net.NetworkQuotaInfo;
import android.net.NetworkRequest;
import android.net.NetworkUtils;
import android.net.ProxyInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.INetworkActivityListener;
import android.os.INetworkManagementService;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.telephony.ITelephony;
import com.android.internal.util.Preconditions;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import libcore.net.event.NetworkEventDispatcher;

public class ConnectivityManager {
    @Deprecated
    public static final String ACTION_BACKGROUND_DATA_SETTING_CHANGED = "android.net.conn.BACKGROUND_DATA_SETTING_CHANGED";
    public static final String ACTION_CAPTIVE_PORTAL_TEST_COMPLETED = "android.net.conn.CAPTIVE_PORTAL_TEST_COMPLETED";
    public static final String ACTION_DATA_ACTIVITY_CHANGE = "android.net.conn.DATA_ACTIVITY_CHANGE";
    public static final String ACTION_TETHER_STATE_CHANGED = "android.net.conn.TETHER_STATE_CHANGED";
    private static final int BASE = 524288;
    public static final int CALLBACK_AVAILABLE = 524290;
    public static final int CALLBACK_CAP_CHANGED = 524294;
    public static final int CALLBACK_EXIT = 524297;
    public static final int CALLBACK_IP_CHANGED = 524295;
    public static final int CALLBACK_LOSING = 524291;
    public static final int CALLBACK_LOST = 524292;
    public static final int CALLBACK_PRECHECK = 524289;
    public static final int CALLBACK_RELEASED = 524296;
    public static final int CALLBACK_UNAVAIL = 524293;
    public static final String CONNECTIVITY_ACTION = "android.net.conn.CONNECTIVITY_CHANGE";
    public static final String CONNECTIVITY_ACTION_IMMEDIATE = "android.net.conn.CONNECTIVITY_CHANGE_IMMEDIATE";
    public static final int CONNECTIVITY_CHANGE_DELAY_DEFAULT = 3000;
    @Deprecated
    public static final int DEFAULT_NETWORK_PREFERENCE = 1;
    private static final int EXPIRE_LEGACY_REQUEST = 524298;
    public static final String EXTRA_ACTIVE_TETHER = "activeArray";
    public static final String EXTRA_AVAILABLE_TETHER = "availableArray";
    public static final String EXTRA_DEVICE_TYPE = "deviceType";
    public static final String EXTRA_ERRORED_TETHER = "erroredArray";
    public static final String EXTRA_EXTRA_INFO = "extraInfo";
    public static final String EXTRA_INET_CONDITION = "inetCondition";
    public static final String EXTRA_IS_ACTIVE = "isActive";
    public static final String EXTRA_IS_CAPTIVE_PORTAL = "captivePortal";
    public static final String EXTRA_IS_FAILOVER = "isFailover";
    @Deprecated
    public static final String EXTRA_NETWORK_INFO = "networkInfo";
    public static final String EXTRA_NETWORK_REQUEST_NETWORK = "networkRequestNetwork";
    public static final String EXTRA_NETWORK_REQUEST_NETWORK_REQUEST = "networkRequestNetworkRequest";
    public static final String EXTRA_NETWORK_TYPE = "networkType";
    public static final String EXTRA_NO_CONNECTIVITY = "noConnectivity";
    public static final String EXTRA_OTHER_NETWORK_INFO = "otherNetwork";
    public static final String EXTRA_REALTIME_NS = "tsNanos";
    public static final String EXTRA_REASON = "reason";
    public static final String INET_CONDITION_ACTION = "android.net.conn.INET_CONDITION_ACTION";
    private static final boolean LEGACY_DBG = true;
    private static final int LISTEN = 1;
    public static final int MAX_NETWORK_REQUEST_TIMEOUT_MS = 6000000;
    public static final int MAX_NETWORK_TYPE = 17;
    public static final int MAX_RADIO_TYPE = 17;
    public static final int NETID_UNSET = 0;
    private static final int REQUEST = 2;
    public static final int REQUEST_ID_UNSET = 0;
    private static final String TAG = "ConnectivityManager";
    public static final int TETHER_ERROR_DISABLE_NAT_ERROR = 9;
    public static final int TETHER_ERROR_ENABLE_NAT_ERROR = 8;
    public static final int TETHER_ERROR_IFACE_CFG_ERROR = 10;
    public static final int TETHER_ERROR_MASTER_ERROR = 5;
    public static final int TETHER_ERROR_NO_ERROR = 0;
    public static final int TETHER_ERROR_SERVICE_UNAVAIL = 2;
    public static final int TETHER_ERROR_TETHER_IFACE_ERROR = 6;
    public static final int TETHER_ERROR_UNAVAIL_IFACE = 4;
    public static final int TETHER_ERROR_UNKNOWN_IFACE = 1;
    public static final int TETHER_ERROR_UNSUPPORTED = 3;
    public static final int TETHER_ERROR_UNTETHER_IFACE_ERROR = 7;
    public static final int TYPE_BLUETOOTH = 7;
    public static final int TYPE_DUMMY = 8;
    public static final int TYPE_ETHERNET = 9;
    public static final int TYPE_MOBILE = 0;
    public static final int TYPE_MOBILE_CBS = 12;
    public static final int TYPE_MOBILE_DUN = 4;
    public static final int TYPE_MOBILE_EMERGENCY = 15;
    public static final int TYPE_MOBILE_FOTA = 10;
    public static final int TYPE_MOBILE_HIPRI = 5;
    public static final int TYPE_MOBILE_IA = 14;
    public static final int TYPE_MOBILE_IMS = 11;
    public static final int TYPE_MOBILE_MMS = 2;
    public static final int TYPE_MOBILE_SUPL = 3;
    public static final int TYPE_NONE = -1;
    public static final int TYPE_PROXY = 16;
    public static final int TYPE_VPN = 17;
    public static final int TYPE_WIFI = 1;
    public static final int TYPE_WIFI_P2P = 13;
    public static final int TYPE_WIMAX = 6;
    static CallbackHandler sCallbackHandler;
    static final AtomicInteger sCallbackRefCount;
    private static HashMap<NetworkCapabilities, LegacyRequest> sLegacyRequests;
    static final HashMap<NetworkRequest, NetworkCallback> sNetworkCallback;
    private INetworkManagementService mNMService;
    private final ArrayMap<OnNetworkActiveListener, INetworkActivityListener> mNetworkActivityListeners = new ArrayMap();
    private final IConnectivityManager mService;

    static {
        sLegacyRequests = new HashMap();
        sNetworkCallback = new HashMap();
        sCallbackRefCount = new AtomicInteger(0);
        sCallbackHandler = null;
    }

    public ConnectivityManager(IConnectivityManager iConnectivityManager) {
        this.mService = Preconditions.checkNotNull(iConnectivityManager, "missing IConnectivityManager");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decCallbackHandlerRefCount() {
        AtomicInteger atomicInteger = sCallbackRefCount;
        synchronized (atomicInteger) {
            if (sCallbackRefCount.decrementAndGet() == 0) {
                sCallbackHandler.obtainMessage(524297).sendToTarget();
                sCallbackHandler = null;
            }
            return;
        }
    }

    public static final void enforceTetherChangePermission(Context context) {
        if (context.getResources().getStringArray(17235989).length == 2) {
            context.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", "ConnectivityService");
            return;
        }
        context.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", "ConnectivityService");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void expireRequest(NetworkCapabilities networkCapabilities, int n) {
        int n2;
        HashMap<NetworkCapabilities, LegacyRequest> hashMap = sLegacyRequests;
        synchronized (hashMap) {
            LegacyRequest legacyRequest = sLegacyRequests.get(networkCapabilities);
            if (legacyRequest == null) {
                return;
            }
            n2 = legacyRequest.expireSequenceNumber;
            if (legacyRequest.expireSequenceNumber == n) {
                this.unregisterNetworkCallback(legacyRequest.networkCallback);
                sLegacyRequests.remove(networkCapabilities);
            }
        }
        Log.d(TAG, "expireRequest with " + n2 + ", " + n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NetworkRequest findRequestForFeature(NetworkCapabilities networkCapabilities) {
        HashMap<NetworkCapabilities, LegacyRequest> hashMap = sLegacyRequests;
        synchronized (hashMap) {
            LegacyRequest legacyRequest = sLegacyRequests.get(networkCapabilities);
            if (legacyRequest == null) return null;
            return legacyRequest.networkRequest;
        }
    }

    public static ConnectivityManager from(Context context) {
        return (ConnectivityManager)context.getSystemService("connectivity");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private INetworkManagementService getNetworkManagementService() {
        synchronized (this) {
            this.mNMService = INetworkManagementService.Stub.asInterface(ServiceManager.getService("network_management"));
            if (this.mNMService == null) return this.mNMService;
            return this.mNMService;
        }
    }

    public static String getNetworkTypeName(int n) {
        switch (n) {
            default: {
                return Integer.toString(n);
            }
            case 0: {
                return "MOBILE";
            }
            case 1: {
                return "WIFI";
            }
            case 2: {
                return "MOBILE_MMS";
            }
            case 3: {
                return "MOBILE_SUPL";
            }
            case 4: {
                return "MOBILE_DUN";
            }
            case 5: {
                return "MOBILE_HIPRI";
            }
            case 6: {
                return "WIMAX";
            }
            case 7: {
                return "BLUETOOTH";
            }
            case 8: {
                return "DUMMY";
            }
            case 9: {
                return "ETHERNET";
            }
            case 10: {
                return "MOBILE_FOTA";
            }
            case 11: {
                return "MOBILE_IMS";
            }
            case 12: {
                return "MOBILE_CBS";
            }
            case 13: {
                return "WIFI_P2P";
            }
            case 14: {
                return "MOBILE_IA";
            }
            case 15: {
                return "MOBILE_EMERGENCY";
            }
            case 16: 
        }
        return "PROXY";
    }

    public static Network getProcessDefaultNetwork() {
        int n = NetworkUtils.getNetworkBoundToProcess();
        if (n == 0) {
            return null;
        }
        return new Network(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void incCallbackHandlerRefCount() {
        AtomicInteger atomicInteger = sCallbackRefCount;
        synchronized (atomicInteger) {
            if (sCallbackRefCount.incrementAndGet() == 1) {
                HandlerThread handlerThread = new HandlerThread(TAG);
                handlerThread.start();
                sCallbackHandler = new CallbackHandler(handlerThread.getLooper(), sNetworkCallback, sCallbackRefCount, this);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int inferLegacyTypeForNetworkCapabilities(NetworkCapabilities networkCapabilities) {
        if (networkCapabilities == null || !networkCapabilities.hasTransport(0)) return -1;
        if (networkCapabilities.hasCapability(5)) {
            if (!networkCapabilities.equals(this.networkCapabilitiesForFeature(0, "enableCBS"))) return -1;
            return 12;
        }
        if (networkCapabilities.hasCapability(4)) {
            if (!networkCapabilities.equals(this.networkCapabilitiesForFeature(0, "enableIMS"))) return -1;
            return 11;
        }
        if (networkCapabilities.hasCapability(3)) {
            if (!networkCapabilities.equals(this.networkCapabilitiesForFeature(0, "enableFOTA"))) return -1;
            return 10;
        }
        if (networkCapabilities.hasCapability(2)) {
            if (!networkCapabilities.equals(this.networkCapabilitiesForFeature(0, "enableDUN"))) return -1;
            return 4;
        }
        if (networkCapabilities.hasCapability(1)) {
            if (!networkCapabilities.equals(this.networkCapabilitiesForFeature(0, "enableSUPL"))) return -1;
            return 3;
        }
        if (networkCapabilities.hasCapability(0)) {
            if (!networkCapabilities.equals(this.networkCapabilitiesForFeature(0, "enableMMS"))) return -1;
            return 2;
        }
        if (networkCapabilities.hasCapability(12) && networkCapabilities.equals(this.networkCapabilitiesForFeature(0, "enableHIPRI"))) return 5;
        return -1;
    }

    public static boolean isNetworkTypeMobile(int n) {
        switch (n) {
            default: {
                return false;
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
        }
        return true;
    }

    public static boolean isNetworkTypeValid(int n) {
        return n >= 0 && n <= 17;
    }

    public static boolean isNetworkTypeWifi(int n) {
        switch (n) {
            default: {
                return false;
            }
            case 1: 
            case 13: 
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int legacyTypeForNetworkCapabilities(NetworkCapabilities networkCapabilities) {
        block11: {
            block10: {
                if (networkCapabilities == null) break block10;
                if (networkCapabilities.hasCapability(5)) {
                    return 12;
                }
                if (networkCapabilities.hasCapability(4)) {
                    return 11;
                }
                if (networkCapabilities.hasCapability(3)) {
                    return 10;
                }
                if (networkCapabilities.hasCapability(2)) {
                    return 4;
                }
                if (networkCapabilities.hasCapability(1)) {
                    return 3;
                }
                if (networkCapabilities.hasCapability(0)) {
                    return 2;
                }
                if (networkCapabilities.hasCapability(12)) {
                    return 5;
                }
                if (networkCapabilities.hasCapability(6)) break block11;
            }
            return -1;
        }
        return 13;
    }

    public static void maybeMarkCapabilitiesRestricted(NetworkCapabilities networkCapabilities) {
        int[] nArray = networkCapabilities.getCapabilities();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            switch (nArray[i]) {
                default: {
                    return;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 13: 
            }
        }
        networkCapabilities.removeCapability(13);
    }

    /*
     * Enabled aggressive block sorting
     */
    private NetworkCapabilities networkCapabilitiesForFeature(int n, String string2) {
        NetworkCapabilities networkCapabilities;
        if (n == 0) {
            int n2;
            if ("enableMMS".equals(string2)) {
                n2 = 0;
            } else if ("enableSUPL".equals(string2)) {
                n2 = 1;
            } else if ("enableDUN".equals(string2) || "enableDUNAlways".equals(string2)) {
                n2 = 2;
            } else if ("enableHIPRI".equals(string2)) {
                n2 = 12;
            } else if ("enableFOTA".equals(string2)) {
                n2 = 3;
            } else if ("enableIMS".equals(string2)) {
                n2 = 4;
            } else {
                boolean bl = "enableCBS".equals(string2);
                networkCapabilities = null;
                if (!bl) return networkCapabilities;
                n2 = 5;
            }
            networkCapabilities = new NetworkCapabilities();
            networkCapabilities.addTransportType(0).addCapability(n2);
            ConnectivityManager.maybeMarkCapabilitiesRestricted(networkCapabilities);
            return networkCapabilities;
        }
        networkCapabilities = null;
        if (n != 1) return networkCapabilities;
        boolean bl = "p2p".equals(string2);
        networkCapabilities = null;
        if (!bl) return networkCapabilities;
        NetworkCapabilities networkCapabilities2 = new NetworkCapabilities();
        networkCapabilities2.addTransportType(1);
        networkCapabilities2.addCapability(6);
        ConnectivityManager.maybeMarkCapabilitiesRestricted(networkCapabilities2);
        return networkCapabilities2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NetworkCallback removeRequestForFeature(NetworkCapabilities networkCapabilities) {
        HashMap<NetworkCapabilities, LegacyRequest> hashMap = sLegacyRequests;
        synchronized (hashMap) {
            LegacyRequest legacyRequest = sLegacyRequests.remove(networkCapabilities);
            if (legacyRequest != null) return legacyRequest.networkCallback;
            return null;
        }
    }

    private void renewRequestLocked(LegacyRequest legacyRequest) {
        legacyRequest.expireSequenceNumber = 1 + legacyRequest.expireSequenceNumber;
        Log.d(TAG, "renewing request to seqNum " + legacyRequest.expireSequenceNumber);
        this.sendExpireMsgForFeature(legacyRequest.networkCapabilities, legacyRequest.expireSequenceNumber, legacyRequest.delay);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NetworkRequest requestNetworkForFeatureLocked(NetworkCapabilities networkCapabilities) {
        int n = -1;
        int n2 = this.legacyTypeForNetworkCapabilities(networkCapabilities);
        try {
            int n3;
            n = n3 = this.mService.getRestoreDefaultNetworkDelay(n2);
        }
        catch (RemoteException remoteException) {}
        LegacyRequest legacyRequest = new LegacyRequest();
        legacyRequest.networkCapabilities = networkCapabilities;
        legacyRequest.delay = n;
        legacyRequest.expireSequenceNumber = 0;
        legacyRequest.networkRequest = this.sendRequestForNetwork(networkCapabilities, legacyRequest.networkCallback, 0, 2, n2);
        if (legacyRequest.networkRequest == null) {
            return null;
        }
        sLegacyRequests.put(networkCapabilities, legacyRequest);
        this.sendExpireMsgForFeature(networkCapabilities, legacyRequest.expireSequenceNumber, n);
        return legacyRequest.networkRequest;
    }

    private void sendExpireMsgForFeature(NetworkCapabilities networkCapabilities, int n, int n2) {
        if (n2 >= 0) {
            Log.d(TAG, "sending expire msg with seqNum " + n + " and delay " + n2);
            Message message = sCallbackHandler.obtainMessage(524298, n, 0, networkCapabilities);
            sCallbackHandler.sendMessageDelayed(message, n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NetworkRequest sendRequestForNetwork(NetworkCapabilities networkCapabilities, NetworkCallback networkCallback, int n, int n2, int n3) {
        if (networkCallback == null) {
            throw new IllegalArgumentException("null NetworkCallback");
        }
        if (networkCapabilities == null) {
            throw new IllegalArgumentException("null NetworkCapabilities");
        }
        try {
            this.incCallbackHandlerRefCount();
            HashMap<NetworkRequest, NetworkCallback> hashMap = sNetworkCallback;
            synchronized (hashMap) {
                if (n2 != 1) break block10;
            }
        }
        catch (RemoteException remoteException) {}
        {
            block11: {
                block10: {
                    NetworkCallback.access$202(networkCallback, this.mService.listenForNetwork(networkCapabilities, new Messenger(sCallbackHandler), new Binder()));
                    break block11;
                }
                NetworkCallback.access$202(networkCallback, this.mService.requestNetwork(networkCapabilities, new Messenger(sCallbackHandler), n, new Binder(), n3));
            }
            if (networkCallback.networkRequest != null) {
                sNetworkCallback.put(networkCallback.networkRequest, networkCallback);
            }
        }
        if (networkCallback.networkRequest == null) {
            this.decCallbackHandlerRefCount();
        }
        return networkCallback.networkRequest;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean setProcessDefaultNetwork(Network network) {
        int n = network == null ? 0 : network.netId;
        if (n == NetworkUtils.getNetworkBoundToProcess()) {
            return true;
        }
        boolean bl = NetworkUtils.bindProcessToNetwork(n);
        boolean bl2 = false;
        if (!bl) return bl2;
        InetAddress.clearDnsCache();
        NetworkEventDispatcher.getInstance().onNetworkConfigurationChanged();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean setProcessDefaultNetworkForHostResolution(Network network) {
        int n;
        if (network == null) {
            n = 0;
            return NetworkUtils.bindProcessToNetworkForHostResolution(n);
        }
        n = network.netId;
        return NetworkUtils.bindProcessToNetworkForHostResolution(n);
    }

    public void addDefaultNetworkActiveListener(final OnNetworkActiveListener onNetworkActiveListener) {
        INetworkActivityListener.Stub stub = new INetworkActivityListener.Stub(){

            @Override
            public void onNetworkActive() throws RemoteException {
                onNetworkActiveListener.onNetworkActive();
            }
        };
        try {
            this.getNetworkManagementService().registerNetworkActivityListener(stub);
            this.mNetworkActivityListeners.put(onNetworkActiveListener, stub);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void captivePortalCheckCompleted(NetworkInfo networkInfo, boolean bl) {
        try {
            this.mService.captivePortalCheckCompleted(networkInfo, bl);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public int checkMobileProvisioning(int n) {
        try {
            int n2 = this.mService.checkMobileProvisioning(n);
            return n2;
        }
        catch (RemoteException remoteException) {
            return -1;
        }
    }

    public LinkProperties getActiveLinkProperties() {
        try {
            LinkProperties linkProperties = this.mService.getActiveLinkProperties();
            return linkProperties;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public LinkQualityInfo getActiveLinkQualityInfo() {
        try {
            LinkQualityInfo linkQualityInfo = this.mService.getActiveLinkQualityInfo();
            return linkQualityInfo;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public NetworkInfo getActiveNetworkInfo() {
        try {
            NetworkInfo networkInfo = this.mService.getActiveNetworkInfo();
            return networkInfo;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public NetworkInfo getActiveNetworkInfoForUid(int n) {
        try {
            NetworkInfo networkInfo = this.mService.getActiveNetworkInfoForUid(n);
            return networkInfo;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public NetworkQuotaInfo getActiveNetworkQuotaInfo() {
        try {
            NetworkQuotaInfo networkQuotaInfo = this.mService.getActiveNetworkQuotaInfo();
            return networkQuotaInfo;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public LinkQualityInfo[] getAllLinkQualityInfo() {
        try {
            LinkQualityInfo[] linkQualityInfoArray = this.mService.getAllLinkQualityInfo();
            return linkQualityInfoArray;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public NetworkInfo[] getAllNetworkInfo() {
        try {
            NetworkInfo[] networkInfoArray = this.mService.getAllNetworkInfo();
            return networkInfoArray;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public Network[] getAllNetworks() {
        try {
            Network[] networkArray = this.mService.getAllNetworks();
            return networkArray;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    @Deprecated
    public boolean getBackgroundDataSetting() {
        return true;
    }

    public ProxyInfo getGlobalProxy() {
        try {
            ProxyInfo proxyInfo = this.mService.getGlobalProxy();
            return proxyInfo;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public int getLastTetherError(String string2) {
        try {
            int n = this.mService.getLastTetherError(string2);
            return n;
        }
        catch (RemoteException remoteException) {
            return 2;
        }
    }

    public LinkProperties getLinkProperties(int n) {
        try {
            LinkProperties linkProperties = this.mService.getLinkPropertiesForType(n);
            return linkProperties;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public LinkProperties getLinkProperties(Network network) {
        try {
            LinkProperties linkProperties = this.mService.getLinkProperties(network);
            return linkProperties;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public LinkQualityInfo getLinkQualityInfo(int n) {
        try {
            LinkQualityInfo linkQualityInfo = this.mService.getLinkQualityInfo(n);
            return linkQualityInfo;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public boolean getMobileDataEnabled() {
        IBinder iBinder = ServiceManager.getService("phone");
        if (iBinder != null) {
            try {
                boolean bl = ITelephony.Stub.asInterface(iBinder).getDataEnabled();
                return bl;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    public String getMobileProvisioningUrl() {
        try {
            String string2 = this.mService.getMobileProvisioningUrl();
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public String getMobileRedirectedProvisioningUrl() {
        try {
            String string2 = this.mService.getMobileRedirectedProvisioningUrl();
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public NetworkCapabilities getNetworkCapabilities(Network network) {
        try {
            NetworkCapabilities networkCapabilities = this.mService.getNetworkCapabilities(network);
            return networkCapabilities;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public Network getNetworkForType(int n) {
        try {
            Network network = this.mService.getNetworkForType(n);
            return network;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public NetworkInfo getNetworkInfo(int n) {
        try {
            NetworkInfo networkInfo = this.mService.getNetworkInfo(n);
            return networkInfo;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public NetworkInfo getNetworkInfo(Network network) {
        try {
            NetworkInfo networkInfo = this.mService.getNetworkInfoForNetwork(network);
            return networkInfo;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public int getNetworkPreference() {
        return -1;
    }

    public NetworkInfo getProvisioningOrActiveNetworkInfo() {
        try {
            NetworkInfo networkInfo = this.mService.getProvisioningOrActiveNetworkInfo();
            return networkInfo;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public ProxyInfo getProxy() {
        try {
            ProxyInfo proxyInfo = this.mService.getProxy();
            return proxyInfo;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public String[] getTetherableBluetoothRegexs() {
        try {
            String[] stringArray = this.mService.getTetherableBluetoothRegexs();
            return stringArray;
        }
        catch (RemoteException remoteException) {
            return new String[0];
        }
    }

    public String[] getTetherableIfaces() {
        try {
            String[] stringArray = this.mService.getTetherableIfaces();
            return stringArray;
        }
        catch (RemoteException remoteException) {
            return new String[0];
        }
    }

    public String[] getTetherableUsbRegexs() {
        try {
            String[] stringArray = this.mService.getTetherableUsbRegexs();
            return stringArray;
        }
        catch (RemoteException remoteException) {
            return new String[0];
        }
    }

    public String[] getTetherableWifiRegexs() {
        try {
            String[] stringArray = this.mService.getTetherableWifiRegexs();
            return stringArray;
        }
        catch (RemoteException remoteException) {
            return new String[0];
        }
    }

    public String[] getTetheredDhcpRanges() {
        try {
            String[] stringArray = this.mService.getTetheredDhcpRanges();
            return stringArray;
        }
        catch (RemoteException remoteException) {
            return new String[0];
        }
    }

    public String[] getTetheredIfaces() {
        try {
            String[] stringArray = this.mService.getTetheredIfaces();
            return stringArray;
        }
        catch (RemoteException remoteException) {
            return new String[0];
        }
    }

    public String[] getTetheringErroredIfaces() {
        try {
            String[] stringArray = this.mService.getTetheringErroredIfaces();
            return stringArray;
        }
        catch (RemoteException remoteException) {
            return new String[0];
        }
    }

    public boolean isActiveNetworkMetered() {
        try {
            boolean bl = this.mService.isActiveNetworkMetered();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean isDefaultNetworkActive() {
        try {
            boolean bl = this.getNetworkManagementService().isNetworkActive();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean isNetworkSupported(int n) {
        try {
            boolean bl = this.mService.isNetworkSupported(n);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean isTetheringSupported() {
        try {
            boolean bl = this.mService.isTetheringSupported();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void registerNetworkAgent(Messenger messenger, NetworkInfo networkInfo, LinkProperties linkProperties, NetworkCapabilities networkCapabilities, int n, NetworkMisc networkMisc) {
        try {
            this.mService.registerNetworkAgent(messenger, networkInfo, linkProperties, networkCapabilities, n, networkMisc);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void registerNetworkCallback(NetworkRequest networkRequest, NetworkCallback networkCallback) {
        this.sendRequestForNetwork(networkRequest.networkCapabilities, networkCallback, 0, 1, -1);
    }

    public void registerNetworkFactory(Messenger messenger, String string2) {
        try {
            this.mService.registerNetworkFactory(messenger, string2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void removeDefaultNetworkActiveListener(OnNetworkActiveListener onNetworkActiveListener) {
        INetworkActivityListener iNetworkActivityListener = this.mNetworkActivityListeners.get(onNetworkActiveListener);
        if (iNetworkActivityListener == null) {
            throw new IllegalArgumentException("Listener not registered: " + onNetworkActiveListener);
        }
        try {
            this.getNetworkManagementService().unregisterNetworkActivityListener(iNetworkActivityListener);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void reportBadNetwork(Network network) {
        try {
            this.mService.reportBadNetwork(network);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void reportInetCondition(int n, int n2) {
        try {
            this.mService.reportInetCondition(n, n2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void requestNetwork(NetworkRequest networkRequest, PendingIntent pendingIntent) {
        try {
            this.mService.pendingRequestForNetwork(networkRequest.networkCapabilities, pendingIntent);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void requestNetwork(NetworkRequest networkRequest, NetworkCallback networkCallback) {
        this.sendRequestForNetwork(networkRequest.networkCapabilities, networkCallback, 0, 2, this.inferLegacyTypeForNetworkCapabilities(networkRequest.networkCapabilities));
    }

    public void requestNetwork(NetworkRequest networkRequest, NetworkCallback networkCallback, int n) {
        this.sendRequestForNetwork(networkRequest.networkCapabilities, networkCallback, n, 2, this.inferLegacyTypeForNetworkCapabilities(networkRequest.networkCapabilities));
    }

    public boolean requestRouteToHost(int n, int n2) {
        return this.requestRouteToHostAddress(n, NetworkUtils.intToInetAddress(n2));
    }

    public boolean requestRouteToHostAddress(int n, InetAddress inetAddress) {
        try {
            boolean bl = this.mService.requestRouteToHostAddress(n, inetAddress.getAddress());
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void setAirplaneMode(boolean bl) {
        try {
            this.mService.setAirplaneMode(bl);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Deprecated
    public void setBackgroundDataSetting(boolean bl) {
    }

    public void setDataDependency(int n, boolean bl) {
        try {
            this.mService.setDataDependency(n, bl);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void setGlobalProxy(ProxyInfo proxyInfo) {
        try {
            this.mService.setGlobalProxy(proxyInfo);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void setNetworkPreference(int n) {
    }

    public void setProvisioningNotificationVisible(boolean bl, int n, String string2) {
        try {
            this.mService.setProvisioningNotificationVisible(bl, n, string2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public int setUsbTethering(boolean bl) {
        try {
            int n = this.mService.setUsbTethering(bl);
            return n;
        }
        catch (RemoteException remoteException) {
            return 2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int startUsingNetworkFeature(int n, String string2) {
        NetworkCapabilities networkCapabilities = this.networkCapabilitiesForFeature(n, string2);
        if (networkCapabilities == null) {
            Log.d(TAG, "Can't satisfy startUsingNetworkFeature for " + n + ", " + string2);
            return 3;
        }
        HashMap<NetworkCapabilities, LegacyRequest> hashMap = sLegacyRequests;
        // MONITORENTER : hashMap
        Log.d(TAG, "Looking for legacyRequest for netCap with hash: " + networkCapabilities + " (" + networkCapabilities.hashCode() + ")");
        Log.d(TAG, "sLegacyRequests has:");
        for (NetworkCapabilities networkCapabilities2 : sLegacyRequests.keySet()) {
            Log.d(TAG, "  " + networkCapabilities2 + " (" + networkCapabilities2.hashCode() + ")");
        }
        LegacyRequest legacyRequest = sLegacyRequests.get(networkCapabilities);
        if (legacyRequest != null) {
            Log.d(TAG, "renewing startUsingNetworkFeature request " + legacyRequest.networkRequest);
            this.renewRequestLocked(legacyRequest);
            if (legacyRequest.currentNetwork != null) {
                // MONITOREXIT : hashMap
                return 0;
            }
            // MONITOREXIT : hashMap
            return 1;
        }
        NetworkRequest networkRequest = this.requestNetworkForFeatureLocked(networkCapabilities);
        // MONITOREXIT : hashMap
        if (networkRequest != null) {
            Log.d(TAG, "starting startUsingNetworkFeature for request " + networkRequest);
            return 1;
        }
        Log.d(TAG, " request Failed");
        return 3;
    }

    public int stopUsingNetworkFeature(int n, String string2) {
        NetworkCapabilities networkCapabilities = this.networkCapabilitiesForFeature(n, string2);
        if (networkCapabilities == null) {
            Log.d(TAG, "Can't satisfy stopUsingNetworkFeature for " + n + ", " + string2);
            return -1;
        }
        NetworkCallback networkCallback = this.removeRequestForFeature(networkCapabilities);
        if (networkCallback != null) {
            Log.d(TAG, "stopUsingNetworkFeature for " + n + ", " + string2);
            this.unregisterNetworkCallback(networkCallback);
        }
        return 1;
    }

    public void supplyMessenger(int n, Messenger messenger) {
        try {
            this.mService.supplyMessenger(n, messenger);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public int tether(String string2) {
        try {
            int n = this.mService.tether(string2);
            return n;
        }
        catch (RemoteException remoteException) {
            return 2;
        }
    }

    public void unregisterNetworkCallback(NetworkCallback networkCallback) {
        if (networkCallback == null || networkCallback.networkRequest == null || ((NetworkCallback)networkCallback).networkRequest.requestId == 0) {
            throw new IllegalArgumentException("Invalid NetworkCallback");
        }
        try {
            this.mService.releaseNetworkRequest(networkCallback.networkRequest);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void unregisterNetworkFactory(Messenger messenger) {
        try {
            this.mService.unregisterNetworkFactory(messenger);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public int untether(String string2) {
        try {
            int n = this.mService.untether(string2);
            return n;
        }
        catch (RemoteException remoteException) {
            return 2;
        }
    }

    public boolean updateLockdownVpn() {
        try {
            boolean bl = this.mService.updateLockdownVpn();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    private class CallbackHandler
    extends Handler {
        private static final String TAG = "ConnectivityManager.CallbackHandler";
        private final HashMap<NetworkRequest, NetworkCallback> mCallbackMap;
        private final ConnectivityManager mCm;
        private final AtomicInteger mRefCount;

        CallbackHandler(Looper looper, HashMap<NetworkRequest, NetworkCallback> hashMap, AtomicInteger atomicInteger, ConnectivityManager connectivityManager2) {
            super(looper);
            this.mCallbackMap = hashMap;
            this.mRefCount = atomicInteger;
            this.mCm = connectivityManager2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private NetworkCallback getCallbacks(NetworkRequest networkRequest) {
            HashMap<NetworkRequest, NetworkCallback> hashMap = this.mCallbackMap;
            synchronized (hashMap) {
                return this.mCallbackMap.get(networkRequest);
            }
        }

        private Object getObject(Message message, Class clazz) {
            return message.getData().getParcelable(clazz.getSimpleName());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void handleMessage(Message message) {
            Log.d(TAG, "CM callback handler got msg " + message.what);
            switch (message.what) {
                default: {
                    return;
                }
                case 524289: {
                    NetworkCallback networkCallback = this.getCallbacks((NetworkRequest)this.getObject(message, NetworkRequest.class));
                    if (networkCallback != null) {
                        networkCallback.onPreCheck((Network)this.getObject(message, Network.class));
                        return;
                    }
                    Log.e(TAG, "callback not found for PRECHECK message");
                    return;
                }
                case 524290: {
                    NetworkCallback networkCallback = this.getCallbacks((NetworkRequest)this.getObject(message, NetworkRequest.class));
                    if (networkCallback != null) {
                        networkCallback.onAvailable((Network)this.getObject(message, Network.class));
                        return;
                    }
                    Log.e(TAG, "callback not found for AVAILABLE message");
                    return;
                }
                case 524291: {
                    NetworkCallback networkCallback = this.getCallbacks((NetworkRequest)this.getObject(message, NetworkRequest.class));
                    if (networkCallback != null) {
                        networkCallback.onLosing((Network)this.getObject(message, Network.class), message.arg1);
                        return;
                    }
                    Log.e(TAG, "callback not found for LOSING message");
                    return;
                }
                case 524292: {
                    NetworkCallback networkCallback = this.getCallbacks((NetworkRequest)this.getObject(message, NetworkRequest.class));
                    if (networkCallback != null) {
                        networkCallback.onLost((Network)this.getObject(message, Network.class));
                        return;
                    }
                    Log.e(TAG, "callback not found for LOST message");
                    return;
                }
                case 524293: {
                    NetworkRequest networkRequest = (NetworkRequest)this.getObject(message, NetworkRequest.class);
                    HashMap<NetworkRequest, NetworkCallback> hashMap = this.mCallbackMap;
                    // MONITORENTER : hashMap
                    NetworkCallback networkCallback = this.mCallbackMap.get(networkRequest);
                    // MONITOREXIT : hashMap
                    if (networkCallback != null) {
                        networkCallback.onUnavailable();
                        return;
                    }
                    Log.e(TAG, "callback not found for UNAVAIL message");
                    return;
                }
                case 524294: {
                    NetworkCallback networkCallback = this.getCallbacks((NetworkRequest)this.getObject(message, NetworkRequest.class));
                    if (networkCallback != null) {
                        networkCallback.onCapabilitiesChanged((Network)this.getObject(message, Network.class), (NetworkCapabilities)this.getObject(message, NetworkCapabilities.class));
                        return;
                    }
                    Log.e(TAG, "callback not found for CAP_CHANGED message");
                    return;
                }
                case 524295: {
                    NetworkCallback networkCallback = this.getCallbacks((NetworkRequest)this.getObject(message, NetworkRequest.class));
                    if (networkCallback != null) {
                        networkCallback.onLinkPropertiesChanged((Network)this.getObject(message, Network.class), (LinkProperties)this.getObject(message, LinkProperties.class));
                        return;
                    }
                    Log.e(TAG, "callback not found for IP_CHANGED message");
                    return;
                }
                case 524296: {
                    NetworkRequest networkRequest = (NetworkRequest)this.getObject(message, NetworkRequest.class);
                    HashMap<NetworkRequest, NetworkCallback> hashMap = this.mCallbackMap;
                    // MONITORENTER : hashMap
                    NetworkCallback networkCallback = this.mCallbackMap.remove(networkRequest);
                    // MONITOREXIT : hashMap
                    if (networkCallback == null) {
                        Log.e(TAG, "callback not found for CANCELED message");
                        return;
                    }
                    AtomicInteger atomicInteger = this.mRefCount;
                    // MONITORENTER : atomicInteger
                    if (this.mRefCount.decrementAndGet() == 0) {
                        this.getLooper().quit();
                    }
                    // MONITOREXIT : atomicInteger
                    return;
                }
                case 524297: {
                    Log.d(TAG, "Listener quiting");
                    this.getLooper().quit();
                    return;
                }
                case 524298: 
            }
            ConnectivityManager.this.expireRequest((NetworkCapabilities)message.obj, message.arg1);
        }
    }

    private static class LegacyRequest {
        Network currentNetwork;
        int delay = -1;
        int expireSequenceNumber;
        NetworkCallback networkCallback = new NetworkCallback(){

            @Override
            public void onAvailable(Network network) {
                LegacyRequest.this.currentNetwork = network;
                Log.d(ConnectivityManager.TAG, "startUsingNetworkFeature got Network:" + network);
                ConnectivityManager.setProcessDefaultNetworkForHostResolution(network);
            }

            @Override
            public void onLost(Network network) {
                if (network.equals(LegacyRequest.this.currentNetwork)) {
                    LegacyRequest.this.currentNetwork = null;
                    ConnectivityManager.setProcessDefaultNetworkForHostResolution(null);
                }
                Log.d(ConnectivityManager.TAG, "startUsingNetworkFeature lost Network:" + network);
            }
        };
        NetworkCapabilities networkCapabilities;
        NetworkRequest networkRequest;

        private LegacyRequest() {
        }
    }

    public static class NetworkCallback {
        public static final int AVAILABLE = 2;
        public static final int CANCELED = 8;
        public static final int CAP_CHANGED = 6;
        public static final int LOSING = 3;
        public static final int LOST = 4;
        public static final int PRECHECK = 1;
        public static final int PROP_CHANGED = 7;
        public static final int UNAVAIL = 5;
        private NetworkRequest networkRequest;

        static /* synthetic */ NetworkRequest access$202(NetworkCallback networkCallback, NetworkRequest networkRequest) {
            networkCallback.networkRequest = networkRequest;
            return networkRequest;
        }

        public void onAvailable(Network network) {
        }

        public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
        }

        public void onLinkPropertiesChanged(Network network, LinkProperties linkProperties) {
        }

        public void onLosing(Network network, int n) {
        }

        public void onLost(Network network) {
        }

        public void onPreCheck(Network network) {
        }

        public void onUnavailable() {
        }
    }

    public static interface OnNetworkActiveListener {
        public void onNetworkActive();
    }
}

