/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.DhcpResults;
import android.net.NetworkUtils;
import android.os.Message;
import android.os.PowerManager;
import android.os.SystemClock;
import android.util.Log;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;

public class DhcpStateMachine
extends StateMachine {
    private static final String ACTION_DHCP_RENEW = "android.net.wifi.DHCP_RENEW";
    private static final int BASE = 196608;
    public static final int CMD_ON_QUIT = 196614;
    public static final int CMD_POST_DHCP_ACTION = 196613;
    public static final int CMD_PRE_DHCP_ACTION = 196612;
    public static final int CMD_PRE_DHCP_ACTION_COMPLETE = 196615;
    public static final int CMD_RENEW_DHCP = 196611;
    public static final int CMD_START_DHCP = 196609;
    public static final int CMD_STOP_DHCP = 196610;
    private static final boolean DBG = false;
    public static final int DHCP_FAILURE = 2;
    private static final int DHCP_RENEW = 0;
    public static final int DHCP_SUCCESS = 1;
    private static final int MIN_RENEWAL_TIME_SECS = 300;
    private static final String TAG = "DhcpStateMachine";
    private static final String WAKELOCK_TAG = "DHCP";
    private AlarmManager mAlarmManager;
    private BroadcastReceiver mBroadcastReceiver;
    private Context mContext;
    private StateMachine mController;
    private State mDefaultState = new DefaultState();
    private PowerManager.WakeLock mDhcpRenewWakeLock;
    private PendingIntent mDhcpRenewalIntent;
    private DhcpResults mDhcpResults;
    private final String mInterfaceName;
    private boolean mRegisteredForPreDhcpNotification = false;
    private State mRunningState;
    private State mStoppedState = new StoppedState();
    private State mWaitBeforeRenewalState;
    private State mWaitBeforeStartState = new WaitBeforeStartState();

    private DhcpStateMachine(Context context, StateMachine stateMachine, String string2) {
        super(TAG);
        this.mRunningState = new RunningState();
        this.mWaitBeforeRenewalState = new WaitBeforeRenewalState();
        this.mContext = context;
        this.mController = stateMachine;
        this.mInterfaceName = string2;
        this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        Intent intent = new Intent(ACTION_DHCP_RENEW, null);
        this.mDhcpRenewalIntent = PendingIntent.getBroadcast(this.mContext, 0, intent, 0);
        this.mDhcpRenewWakeLock = ((PowerManager)this.mContext.getSystemService("power")).newWakeLock(1, WAKELOCK_TAG);
        this.mDhcpRenewWakeLock.setReferenceCounted(false);
        this.mBroadcastReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                DhcpStateMachine.this.mDhcpRenewWakeLock.acquire(40000L);
                DhcpStateMachine.this.sendMessage(196611);
            }
        };
        this.mContext.registerReceiver(this.mBroadcastReceiver, new IntentFilter(ACTION_DHCP_RENEW));
        this.addState(this.mDefaultState);
        this.addState(this.mStoppedState, this.mDefaultState);
        this.addState(this.mWaitBeforeStartState, this.mDefaultState);
        this.addState(this.mRunningState, this.mDefaultState);
        this.addState(this.mWaitBeforeRenewalState, this.mDefaultState);
        this.setInitialState(this.mStoppedState);
    }

    public static DhcpStateMachine makeDhcpStateMachine(Context context, StateMachine stateMachine, String string2) {
        DhcpStateMachine dhcpStateMachine = new DhcpStateMachine(context, stateMachine, string2);
        dhcpStateMachine.start();
        return dhcpStateMachine;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean runDhcp(DhcpAction dhcpAction) {
        boolean bl;
        DhcpResults dhcpResults = new DhcpResults();
        if (dhcpAction == DhcpAction.START) {
            NetworkUtils.stopDhcp(this.mInterfaceName);
            bl = NetworkUtils.runDhcp(this.mInterfaceName, dhcpResults);
        } else {
            DhcpAction dhcpAction2 = DhcpAction.RENEW;
            bl = false;
            if (dhcpAction == dhcpAction2 && (bl = NetworkUtils.runDhcpRenew(this.mInterfaceName, dhcpResults))) {
                dhcpResults.updateFromDhcpRequest(this.mDhcpResults);
            }
        }
        if (!bl) {
            Log.e(TAG, "DHCP failed on " + this.mInterfaceName + ": " + NetworkUtils.getDhcpError());
            NetworkUtils.stopDhcp(this.mInterfaceName);
            this.mController.obtainMessage(196613, 2, 0).sendToTarget();
            return bl;
        }
        long l = dhcpResults.leaseDuration;
        if (l >= 0L) {
            if (l < 300L) {
                l = 300L;
            }
            this.mAlarmManager.setExact(2, SystemClock.elapsedRealtime() + 480L * l, this.mDhcpRenewalIntent);
        }
        this.mDhcpResults = dhcpResults;
        this.mController.obtainMessage(196613, 1, 0, dhcpResults).sendToTarget();
        return bl;
    }

    public void doQuit() {
        this.quit();
    }

    @Override
    protected void onQuitting() {
        this.mController.sendMessage(196614);
    }

    public void registerForPreDhcpNotification() {
        this.mRegisteredForPreDhcpNotification = true;
    }

    class DefaultState
    extends State {
        DefaultState() {
        }

        @Override
        public void exit() {
            DhcpStateMachine.this.mContext.unregisterReceiver(DhcpStateMachine.this.mBroadcastReceiver);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean processMessage(Message message) {
            switch (message.what) {
                default: {
                    Log.e(DhcpStateMachine.TAG, "Error! unhandled message  " + message);
                    return true;
                }
                case 196611: 
            }
            Log.e(DhcpStateMachine.TAG, "Error! Failed to handle a DHCP renewal on " + DhcpStateMachine.this.mInterfaceName);
            DhcpStateMachine.this.mDhcpRenewWakeLock.release();
            return true;
        }
    }

    private static final class DhcpAction
    extends Enum<DhcpAction> {
        private static final /* synthetic */ DhcpAction[] $VALUES;
        public static final /* enum */ DhcpAction RENEW;
        public static final /* enum */ DhcpAction START;

        static {
            START = new DhcpAction();
            RENEW = new DhcpAction();
            DhcpAction[] dhcpActionArray = new DhcpAction[]{START, RENEW};
            $VALUES = dhcpActionArray;
        }

        public static DhcpAction valueOf(String string2) {
            return Enum.valueOf(DhcpAction.class, string2);
        }

        public static DhcpAction[] values() {
            return (DhcpAction[])$VALUES.clone();
        }
    }

    class RunningState
    extends State {
        RunningState() {
        }

        @Override
        public void enter() {
        }

        @Override
        public boolean processMessage(Message message) {
            boolean bl = true;
            switch (message.what) {
                default: {
                    bl = false;
                }
                case 196609: {
                    return bl;
                }
                case 196610: {
                    DhcpStateMachine.this.mAlarmManager.cancel(DhcpStateMachine.this.mDhcpRenewalIntent);
                    if (!NetworkUtils.stopDhcp(DhcpStateMachine.this.mInterfaceName)) {
                        Log.e(DhcpStateMachine.TAG, "Failed to stop Dhcp on " + DhcpStateMachine.this.mInterfaceName);
                    }
                    DhcpStateMachine.this.transitionTo(DhcpStateMachine.this.mStoppedState);
                    return bl;
                }
                case 196611: 
            }
            if (DhcpStateMachine.this.mRegisteredForPreDhcpNotification) {
                DhcpStateMachine.this.mController.sendMessage(196612);
                DhcpStateMachine.this.transitionTo(DhcpStateMachine.this.mWaitBeforeRenewalState);
                return bl;
            }
            if (!DhcpStateMachine.this.runDhcp(DhcpAction.RENEW)) {
                DhcpStateMachine.this.transitionTo(DhcpStateMachine.this.mStoppedState);
            }
            DhcpStateMachine.this.mDhcpRenewWakeLock.release();
            return bl;
        }
    }

    class StoppedState
    extends State {
        StoppedState() {
        }

        @Override
        public void enter() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean processMessage(Message message) {
            boolean bl = true;
            switch (message.what) {
                default: {
                    bl = false;
                }
                case 196610: {
                    return bl;
                }
                case 196609: {
                    if (DhcpStateMachine.this.mRegisteredForPreDhcpNotification) {
                        DhcpStateMachine.this.mController.sendMessage(196612);
                        DhcpStateMachine.this.transitionTo(DhcpStateMachine.this.mWaitBeforeStartState);
                        return bl;
                    }
                    if (!DhcpStateMachine.this.runDhcp(DhcpAction.START)) return bl;
                    DhcpStateMachine.this.transitionTo(DhcpStateMachine.this.mRunningState);
                    return bl;
                }
            }
        }
    }

    class WaitBeforeRenewalState
    extends State {
        WaitBeforeRenewalState() {
        }

        @Override
        public void enter() {
        }

        @Override
        public void exit() {
            DhcpStateMachine.this.mDhcpRenewWakeLock.release();
        }

        @Override
        public boolean processMessage(Message message) {
            boolean bl = true;
            switch (message.what) {
                default: {
                    bl = false;
                }
                case 196609: {
                    return bl;
                }
                case 196610: {
                    DhcpStateMachine.this.mAlarmManager.cancel(DhcpStateMachine.this.mDhcpRenewalIntent);
                    if (!NetworkUtils.stopDhcp(DhcpStateMachine.this.mInterfaceName)) {
                        Log.e(DhcpStateMachine.TAG, "Failed to stop Dhcp on " + DhcpStateMachine.this.mInterfaceName);
                    }
                    DhcpStateMachine.this.transitionTo(DhcpStateMachine.this.mStoppedState);
                    return bl;
                }
                case 196615: 
            }
            if (DhcpStateMachine.this.runDhcp(DhcpAction.RENEW)) {
                DhcpStateMachine.this.transitionTo(DhcpStateMachine.this.mRunningState);
                return bl;
            }
            DhcpStateMachine.this.transitionTo(DhcpStateMachine.this.mStoppedState);
            return bl;
        }
    }

    class WaitBeforeStartState
    extends State {
        WaitBeforeStartState() {
        }

        @Override
        public void enter() {
        }

        @Override
        public boolean processMessage(Message message) {
            boolean bl = true;
            switch (message.what) {
                default: {
                    bl = false;
                }
                case 196609: {
                    return bl;
                }
                case 196615: {
                    if (DhcpStateMachine.this.runDhcp(DhcpAction.START)) {
                        DhcpStateMachine.this.transitionTo(DhcpStateMachine.this.mRunningState);
                        return bl;
                    }
                    DhcpStateMachine.this.transitionTo(DhcpStateMachine.this.mStoppedState);
                    return bl;
                }
                case 196610: 
            }
            DhcpStateMachine.this.transitionTo(DhcpStateMachine.this.mStoppedState);
            return bl;
        }
    }
}

