/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.BaseNetworkStateTracker;
import android.net.LinkProperties;
import android.net.LinkQualityInfo;
import android.net.MobileLinkQualityInfo;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.SamplingDataTracker;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Slog;
import com.android.internal.telephony.ITelephony;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.util.AsyncChannel;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicBoolean;

public class MobileDataStateTracker
extends BaseNetworkStateTracker {
    private static final boolean DBG = false;
    private static final String TAG = "MobileDataStateTracker";
    private static final int UNKNOWN = Integer.MAX_VALUE;
    private static final boolean VDBG;
    private static NetworkDataEntry[] mTheoreticalBWTable;
    private String mApnType;
    private Context mContext;
    private AsyncChannel mDataConnectionTrackerAc;
    private boolean mDefaultRouteSet = false;
    private Handler mHandler;
    private AtomicBoolean mIsCaptivePortal = new AtomicBoolean(false);
    private LinkProperties mLinkProperties;
    private PhoneConstants.DataState mMobileDataState;
    private NetworkInfo mNetworkInfo;
    private ITelephony mPhoneService;
    private final PhoneStateListener mPhoneStateListener;
    protected boolean mPolicyDataEnabled = true;
    private boolean mPrivateDnsRouteSet = false;
    private SamplingDataTracker mSamplingDataTracker = new SamplingDataTracker();
    private SignalStrength mSignalStrength;
    private Handler mTarget;
    private boolean mTeardownRequested = false;
    protected boolean mUserDataEnabled = true;

    static {
        NetworkDataEntry[] networkDataEntryArray = new NetworkDataEntry[]{new NetworkDataEntry(2, 237, 118, Integer.MAX_VALUE), new NetworkDataEntry(1, 48, 40, Integer.MAX_VALUE), new NetworkDataEntry(3, 384, 64, Integer.MAX_VALUE), new NetworkDataEntry(8, 14400, Integer.MAX_VALUE, Integer.MAX_VALUE), new NetworkDataEntry(9, 14400, 5760, Integer.MAX_VALUE), new NetworkDataEntry(10, 14400, 5760, Integer.MAX_VALUE), new NetworkDataEntry(15, 21000, 5760, Integer.MAX_VALUE), new NetworkDataEntry(4, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE), new NetworkDataEntry(7, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE), new NetworkDataEntry(5, 2468, 153, Integer.MAX_VALUE), new NetworkDataEntry(6, 3072, 1800, Integer.MAX_VALUE), new NetworkDataEntry(12, 14700, 1800, Integer.MAX_VALUE), new NetworkDataEntry(11, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE), new NetworkDataEntry(13, 100000, 50000, Integer.MAX_VALUE), new NetworkDataEntry(14, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE)};
        mTheoreticalBWTable = networkDataEntryArray;
    }

    public MobileDataStateTracker(int n, String string2) {
        this.mPhoneStateListener = new PhoneStateListener(){

            @Override
            public void onSignalStrengthsChanged(SignalStrength signalStrength) {
                MobileDataStateTracker.access$102(MobileDataStateTracker.this, signalStrength);
            }
        };
        this.mNetworkInfo = new NetworkInfo(n, TelephonyManager.getDefault().getNetworkType(), string2, TelephonyManager.getDefault().getNetworkTypeName());
        this.mApnType = MobileDataStateTracker.networkTypeToApnType(n);
    }

    static /* synthetic */ LinkProperties access$1002(MobileDataStateTracker mobileDataStateTracker, LinkProperties linkProperties) {
        mobileDataStateTracker.mLinkProperties = linkProperties;
        return linkProperties;
    }

    static /* synthetic */ SignalStrength access$102(MobileDataStateTracker mobileDataStateTracker, SignalStrength signalStrength) {
        mobileDataStateTracker.mSignalStrength = signalStrength;
        return signalStrength;
    }

    static /* synthetic */ AsyncChannel access$202(MobileDataStateTracker mobileDataStateTracker, AsyncChannel asyncChannel) {
        mobileDataStateTracker.mDataConnectionTrackerAc = asyncChannel;
        return asyncChannel;
    }

    static /* synthetic */ PhoneConstants.DataState access$402(MobileDataStateTracker mobileDataStateTracker, PhoneConstants.DataState dataState) {
        mobileDataStateTracker.mMobileDataState = dataState;
        return dataState;
    }

    private static NetworkDataEntry getNetworkDataEntry(int n) {
        for (NetworkDataEntry networkDataEntry : mTheoreticalBWTable) {
            if (networkDataEntry.networkType != n) continue;
            return networkDataEntry;
        }
        Slog.e(TAG, "Could not find Theoretical BW entry for " + String.valueOf(n));
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getNormalizedSignalStrength(int n, SignalStrength signalStrength) {
        int n2;
        switch (n) {
            default: {
                return Integer.MAX_VALUE;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 15: {
                n2 = signalStrength.getGsmLevel();
                return n2 * 100 / 5;
            }
            case 4: 
            case 7: {
                n2 = signalStrength.getCdmaLevel();
                return n2 * 100 / 5;
            }
            case 5: 
            case 6: 
            case 12: {
                n2 = signalStrength.getEvdoLevel();
                return n2 * 100 / 5;
            }
            case 13: 
        }
        n2 = signalStrength.getLteLevel();
        return n2 * 100 / 5;
    }

    private void getPhoneService(boolean bl) {
        if (this.mPhoneService == null || bl) {
            this.mPhoneService = ITelephony.Stub.asInterface(ServiceManager.getService("phone"));
        }
    }

    private void log(String string2) {
        Slog.d(TAG, this.mApnType + ": " + string2);
    }

    private void loge(String string2) {
        Slog.e(TAG, this.mApnType + ": " + string2);
    }

    public static String networkTypeToApnType(int n) {
        switch (n) {
            default: {
                MobileDataStateTracker.sloge("Error mapping networkType " + n + " to apnType.");
                return null;
            }
            case 0: {
                return "default";
            }
            case 2: {
                return "mms";
            }
            case 3: {
                return "supl";
            }
            case 4: {
                return "dun";
            }
            case 5: {
                return "hipri";
            }
            case 10: {
                return "fota";
            }
            case 11: {
                return "ims";
            }
            case 12: {
                return "cbs";
            }
            case 14: {
                return "ia";
            }
            case 15: 
        }
        return "emergency";
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setDetailedState(NetworkInfo.DetailedState detailedState, String string2, String string3) {
        if (detailedState != this.mNetworkInfo.getDetailedState()) {
            boolean bl = this.mNetworkInfo.getState() == NetworkInfo.State.CONNECTING;
            String string4 = this.mNetworkInfo.getReason();
            if (bl && detailedState == NetworkInfo.DetailedState.CONNECTED && string2 == null && string4 != null) {
                string2 = string4;
            }
            this.mNetworkInfo.setDetailedState(detailedState, string2, string3);
            this.mTarget.obtainMessage(458752, new NetworkInfo(this.mNetworkInfo)).sendToTarget();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int setEnableApn(String string2, boolean bl) {
        this.getPhoneService(false);
        int n = 0;
        while (true) {
            block4: {
                block3: {
                    if (n >= 2) break block3;
                    if (this.mPhoneService != null) break block4;
                    this.loge("Ignoring feature request because could not acquire PhoneService");
                }
                StringBuilder stringBuilder = new StringBuilder().append("Could not ");
                String string3 = bl ? "enable" : "disable";
                this.loge(stringBuilder.append(string3).append(" APN type \"").append(string2).append("\"").toString());
                return 3;
            }
            ++n;
        }
    }

    private static void sloge(String string2) {
        Slog.e(TAG, string2);
    }

    private void updateLinkProperitesAndCapatilities(Intent intent) {
        this.mLinkProperties = (LinkProperties)intent.getParcelableExtra("linkProperties");
        if (this.mLinkProperties == null) {
            this.loge("CONNECTED event did not supply link properties.");
            this.mLinkProperties = new LinkProperties();
        }
        this.mLinkProperties.setMtu(this.mContext.getResources().getInteger(17694833));
        this.mNetworkCapabilities = (NetworkCapabilities)intent.getParcelableExtra("networkCapabilities");
        if (this.mNetworkCapabilities == null) {
            this.loge("CONNECTED event did not supply network capabilities.");
            this.mNetworkCapabilities = new NetworkCapabilities();
        }
    }

    @Override
    public void addStackedLink(LinkProperties linkProperties) {
        this.mLinkProperties.addStackedLink(linkProperties);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void captivePortalCheckCompleted(boolean bl) {
        if (this.mIsCaptivePortal.getAndSet(bl) != bl) {
            int n = bl ? 1 : 0;
            this.setEnableFailFastMobileData(n);
        }
    }

    @Override
    public void defaultRouteSet(boolean bl) {
        this.mDefaultRouteSet = bl;
    }

    public void enableMobileProvisioning(String string2) {
        AsyncChannel asyncChannel = this.mDataConnectionTrackerAc;
        if (asyncChannel != null) {
            Message message = Message.obtain();
            message.what = 270373;
            message.setData(Bundle.forPair("provisioningUrl", string2));
            asyncChannel.sendMessage(message);
        }
    }

    @Override
    public LinkProperties getLinkProperties() {
        return new LinkProperties(this.mLinkProperties);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public LinkQualityInfo getLinkQualityInfo() {
        SignalStrength signalStrength;
        if (this.mNetworkInfo == null) return null;
        if (this.mNetworkInfo.getType() == -1) {
            return null;
        }
        MobileLinkQualityInfo mobileLinkQualityInfo = new MobileLinkQualityInfo();
        mobileLinkQualityInfo.setNetworkType(this.mNetworkInfo.getType());
        this.mSamplingDataTracker.setCommonLinkQualityInfoFields(mobileLinkQualityInfo);
        if (this.mNetworkInfo.getSubtype() != 0) {
            mobileLinkQualityInfo.setMobileNetworkType(this.mNetworkInfo.getSubtype());
            NetworkDataEntry networkDataEntry = MobileDataStateTracker.getNetworkDataEntry(this.mNetworkInfo.getSubtype());
            if (networkDataEntry != null) {
                mobileLinkQualityInfo.setTheoreticalRxBandwidth(networkDataEntry.downloadBandwidth);
                mobileLinkQualityInfo.setTheoreticalRxBandwidth(networkDataEntry.uploadBandwidth);
                mobileLinkQualityInfo.setTheoreticalLatency(networkDataEntry.latency);
            }
            if (this.mSignalStrength != null) {
                mobileLinkQualityInfo.setNormalizedSignalStrength(MobileDataStateTracker.getNormalizedSignalStrength(mobileLinkQualityInfo.getMobileNetworkType(), this.mSignalStrength));
            }
        }
        if ((signalStrength = this.mSignalStrength) == null) return mobileLinkQualityInfo;
        mobileLinkQualityInfo.setRssi(signalStrength.getGsmSignalStrength());
        mobileLinkQualityInfo.setGsmErrorRate(signalStrength.getGsmBitErrorRate());
        mobileLinkQualityInfo.setCdmaDbm(signalStrength.getCdmaDbm());
        mobileLinkQualityInfo.setCdmaEcio(signalStrength.getCdmaEcio());
        mobileLinkQualityInfo.setEvdoDbm(signalStrength.getEvdoDbm());
        mobileLinkQualityInfo.setEvdoEcio(signalStrength.getEvdoEcio());
        mobileLinkQualityInfo.setEvdoSnr(signalStrength.getEvdoSnr());
        mobileLinkQualityInfo.setLteSignalStrength(signalStrength.getLteSignalStrength());
        mobileLinkQualityInfo.setLteRsrp(signalStrength.getLteRsrp());
        mobileLinkQualityInfo.setLteRsrq(signalStrength.getLteRsrq());
        mobileLinkQualityInfo.setLteRssnr(signalStrength.getLteRssnr());
        mobileLinkQualityInfo.setLteCqi(signalStrength.getLteCqi());
        return mobileLinkQualityInfo;
    }

    @Override
    public NetworkInfo getNetworkInfo() {
        return this.mNetworkInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getTcpBufferSizesPropName() {
        String string2 = "unknown";
        TelephonyManager telephonyManager = new TelephonyManager(this.mContext);
        switch (telephonyManager.getNetworkType()) {
            default: {
                this.loge("unknown network type: " + telephonyManager.getNetworkType());
                return "net.tcp.buffersize." + string2;
            }
            case 1: {
                string2 = "gprs";
                return "net.tcp.buffersize." + string2;
            }
            case 2: {
                string2 = "edge";
                return "net.tcp.buffersize." + string2;
            }
            case 3: {
                string2 = "umts";
                return "net.tcp.buffersize." + string2;
            }
            case 8: {
                string2 = "hsdpa";
                return "net.tcp.buffersize." + string2;
            }
            case 9: {
                string2 = "hsupa";
                return "net.tcp.buffersize." + string2;
            }
            case 10: {
                string2 = "hspa";
                return "net.tcp.buffersize." + string2;
            }
            case 15: {
                string2 = "hspap";
                return "net.tcp.buffersize." + string2;
            }
            case 4: {
                string2 = "cdma";
                return "net.tcp.buffersize." + string2;
            }
            case 7: {
                string2 = "1xrtt";
                return "net.tcp.buffersize." + string2;
            }
            case 5: {
                string2 = "evdo";
                return "net.tcp.buffersize." + string2;
            }
            case 6: {
                string2 = "evdo";
                return "net.tcp.buffersize." + string2;
            }
            case 12: {
                string2 = "evdo";
                return "net.tcp.buffersize." + string2;
            }
            case 11: {
                string2 = "iden";
                return "net.tcp.buffersize." + string2;
            }
            case 13: {
                string2 = "lte";
                return "net.tcp.buffersize." + string2;
            }
            case 14: 
        }
        string2 = "ehrpd";
        return "net.tcp.buffersize." + string2;
    }

    @Override
    public boolean isAvailable() {
        return this.mNetworkInfo.isAvailable();
    }

    @Override
    public boolean isDefaultRouteSet() {
        return this.mDefaultRouteSet;
    }

    @Override
    public boolean isPrivateDnsRouteSet() {
        return this.mPrivateDnsRouteSet;
    }

    public boolean isProvisioningNetwork() {
        try {
            Message message = Message.obtain();
            message.what = 270374;
            message.setData(Bundle.forPair("apnType", this.mApnType));
            int n = this.mDataConnectionTrackerAc.sendMessageSynchronously((Message)message).arg1;
            return n == 1;
        }
        catch (NullPointerException nullPointerException) {
            this.loge("isProvisioningNetwork: X " + nullPointerException);
            return false;
        }
    }

    public boolean isReady() {
        return this.mDataConnectionTrackerAc != null;
    }

    @Override
    public boolean isTeardownRequested() {
        return this.mTeardownRequested;
    }

    @Override
    public void privateDnsRouteSet(boolean bl) {
        this.mPrivateDnsRouteSet = bl;
    }

    @Override
    public boolean reconnect() {
        this.setTeardownRequested(false);
        switch (this.setEnableApn(this.mApnType, true)) {
            default: {
                this.loge("Error in reconnect - unexpected response.");
            }
            case 2: 
            case 3: {
                return false;
            }
            case 0: {
                return true;
            }
            case 1: 
        }
        this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.IDLE, null, null);
        return true;
    }

    public void releaseWakeLock() {
    }

    @Override
    public void removeStackedLink(LinkProperties linkProperties) {
        this.mLinkProperties.removeStackedLink(linkProperties);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setDependencyMet(boolean bl) {
        Bundle bundle = Bundle.forPair("apnType", this.mApnType);
        try {
            Message message = Message.obtain();
            message.what = 270367;
            int n = bl ? 1 : 0;
            message.arg1 = n;
            message.setData(bundle);
            this.mDataConnectionTrackerAc.sendMessage(message);
            return;
        }
        catch (NullPointerException nullPointerException) {
            this.loge("setDependencyMet: X mAc was null" + nullPointerException);
            return;
        }
    }

    public void setEnableFailFastMobileData(int n) {
        AsyncChannel asyncChannel = this.mDataConnectionTrackerAc;
        if (asyncChannel != null) {
            asyncChannel.sendMessage(270372, n);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setInternalDataEnable(boolean bl) {
        AsyncChannel asyncChannel = this.mDataConnectionTrackerAc;
        if (asyncChannel != null) {
            int n = bl ? 1 : 0;
            asyncChannel.sendMessage(270363, n);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setPolicyDataEnable(boolean bl) {
        AsyncChannel asyncChannel = this.mDataConnectionTrackerAc;
        if (asyncChannel != null) {
            int n = bl ? 1 : 0;
            asyncChannel.sendMessage(270368, n);
            this.mPolicyDataEnabled = bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setRadio(boolean bl) {
        this.getPhoneService(false);
        int n = 0;
        while (true) {
            block8: {
                block7: {
                    if (n >= 2) break block7;
                    if (this.mPhoneService != null) break block8;
                    this.loge("Ignoring mobile radio request because could not acquire PhoneService");
                }
                StringBuilder stringBuilder = new StringBuilder().append("Could not set radio power to ");
                String string2 = bl ? "on" : "off";
                this.loge(stringBuilder.append(string2).toString());
                return false;
            }
            try {
                return this.mPhoneService.setRadio(bl);
            }
            catch (RemoteException remoteException) {
                if (n == 0) {
                    this.getPhoneService(true);
                }
                ++n;
                continue;
            }
            break;
        }
    }

    @Override
    public void setTeardownRequested(boolean bl) {
        this.mTeardownRequested = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setUserDataEnable(boolean bl) {
        AsyncChannel asyncChannel = this.mDataConnectionTrackerAc;
        if (asyncChannel != null) {
            int n = bl ? 1 : 0;
            asyncChannel.sendMessage(270366, n);
            this.mUserDataEnabled = bl;
        }
    }

    @Override
    public void startMonitoring(Context context, Handler handler) {
        this.mTarget = handler;
        this.mContext = context;
        this.mHandler = new MdstHandler(handler.getLooper(), this);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.ANY_DATA_STATE");
        intentFilter.addAction("android.intent.action.DATA_CONNECTION_CONNECTED_TO_PROVISIONING_APN");
        intentFilter.addAction("android.intent.action.DATA_CONNECTION_FAILED");
        this.mContext.registerReceiver(new MobileDataStateReceiver(), intentFilter);
        this.mMobileDataState = PhoneConstants.DataState.DISCONNECTED;
        ((TelephonyManager)this.mContext.getSystemService("phone")).listen(this.mPhoneStateListener, 256);
    }

    @Override
    public void startSampling(SamplingDataTracker.SamplingSnapshot samplingSnapshot) {
        this.mSamplingDataTracker.startSampling(samplingSnapshot);
    }

    @Override
    public void stopSampling(SamplingDataTracker.SamplingSnapshot samplingSnapshot) {
        this.mSamplingDataTracker.stopSampling(samplingSnapshot);
    }

    @Override
    public void supplyMessenger(Messenger messenger) {
        new AsyncChannel().connect(this.mContext, this.mHandler, messenger);
    }

    @Override
    public boolean teardown() {
        this.setTeardownRequested(true);
        return this.setEnableApn(this.mApnType, false) != 3;
    }

    public String toString() {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        printWriter.print("Mobile data state: ");
        printWriter.println((Object)this.mMobileDataState);
        printWriter.print("Data enabled: user=");
        printWriter.print(this.mUserDataEnabled);
        printWriter.print(", policy=");
        printWriter.println(this.mPolicyDataEnabled);
        return charArrayWriter.toString();
    }

    static class MdstHandler
    extends Handler {
        private MobileDataStateTracker mMdst;

        MdstHandler(Looper looper, MobileDataStateTracker mobileDataStateTracker) {
            super(looper);
            this.mMdst = mobileDataStateTracker;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                case 69632: {
                    if (message.arg1 == 0) {
                        MobileDataStateTracker.access$202(this.mMdst, (AsyncChannel)message.obj);
                        return;
                    }
                }
                default: {
                    return;
                }
                case 69636: 
            }
            MobileDataStateTracker.access$202(this.mMdst, null);
        }
    }

    private class MobileDataStateReceiver
    extends BroadcastReceiver {
        private MobileDataStateReceiver() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            boolean bl = true;
            if (intent.getAction().equals("android.intent.action.DATA_CONNECTION_CONNECTED_TO_PROVISIONING_APN")) {
                String string2 = intent.getStringExtra("apn");
                String string3 = intent.getStringExtra("apnType");
                if (!TextUtils.equals(MobileDataStateTracker.this.mApnType, string3)) return;
                MobileDataStateTracker.access$402(MobileDataStateTracker.this, PhoneConstants.DataState.CONNECTING);
                MobileDataStateTracker.this.updateLinkProperitesAndCapatilities(intent);
                MobileDataStateTracker.this.mNetworkInfo.setIsConnectedToProvisioningNetwork(bl);
                MobileDataStateTracker.this.setDetailedState(NetworkInfo.DetailedState.SUSPENDED, "", string2);
                return;
            }
            if (intent.getAction().equals("android.intent.action.ANY_DATA_STATE")) {
                if (!TextUtils.equals(intent.getStringExtra("apnType"), MobileDataStateTracker.this.mApnType)) return;
                MobileDataStateTracker.this.mNetworkInfo.setIsConnectedToProvisioningNetwork(false);
                int n = MobileDataStateTracker.this.mNetworkInfo.getSubtype();
                int n2 = TelephonyManager.getDefault().getNetworkType();
                String string4 = TelephonyManager.getDefault().getNetworkTypeName();
                MobileDataStateTracker.this.mNetworkInfo.setSubtype(n2, string4);
                if (n2 != n && MobileDataStateTracker.this.mNetworkInfo.isConnected()) {
                    MobileDataStateTracker.this.mTarget.obtainMessage(458755, n, 0, MobileDataStateTracker.this.mNetworkInfo).sendToTarget();
                }
                PhoneConstants.DataState dataState = Enum.valueOf(PhoneConstants.DataState.class, intent.getStringExtra("state"));
                String string5 = intent.getStringExtra("reason");
                String string6 = intent.getStringExtra("apn");
                MobileDataStateTracker.this.mNetworkInfo.setRoaming(intent.getBooleanExtra("networkRoaming", false));
                NetworkInfo networkInfo = MobileDataStateTracker.this.mNetworkInfo;
                if (intent.getBooleanExtra("networkUnvailable", false)) {
                    bl = false;
                }
                networkInfo.setIsAvailable(bl);
                if (MobileDataStateTracker.this.mMobileDataState != dataState) {
                    MobileDataStateTracker.access$402(MobileDataStateTracker.this, dataState);
                    switch (2.$SwitchMap$com$android$internal$telephony$PhoneConstants$DataState[dataState.ordinal()]) {
                        case 1: {
                            if (MobileDataStateTracker.this.isTeardownRequested()) {
                                MobileDataStateTracker.this.setTeardownRequested(false);
                            }
                            MobileDataStateTracker.this.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, string5, string6);
                            break;
                        }
                        case 2: {
                            MobileDataStateTracker.this.setDetailedState(NetworkInfo.DetailedState.CONNECTING, string5, string6);
                            break;
                        }
                        case 3: {
                            MobileDataStateTracker.this.setDetailedState(NetworkInfo.DetailedState.SUSPENDED, string5, string6);
                            break;
                        }
                        case 4: {
                            MobileDataStateTracker.this.updateLinkProperitesAndCapatilities(intent);
                            MobileDataStateTracker.this.setDetailedState(NetworkInfo.DetailedState.CONNECTED, string5, string6);
                            break;
                        }
                    }
                    MobileDataStateTracker.this.mSamplingDataTracker.resetSamplingData();
                    return;
                }
                if (!TextUtils.equals(string5, "linkPropertiesChanged")) return;
                MobileDataStateTracker.access$1002(MobileDataStateTracker.this, (LinkProperties)intent.getParcelableExtra("linkProperties"));
                if (MobileDataStateTracker.this.mLinkProperties == null) {
                    MobileDataStateTracker.this.loge("No link property in LINK_PROPERTIES change event.");
                    MobileDataStateTracker.access$1002(MobileDataStateTracker.this, new LinkProperties());
                }
                MobileDataStateTracker.this.mNetworkInfo.setDetailedState(MobileDataStateTracker.this.mNetworkInfo.getDetailedState(), string5, MobileDataStateTracker.this.mNetworkInfo.getExtraInfo());
                MobileDataStateTracker.this.mTarget.obtainMessage(458753, MobileDataStateTracker.this.mNetworkInfo).sendToTarget();
                return;
            }
            if (!intent.getAction().equals("android.intent.action.DATA_CONNECTION_FAILED") || !TextUtils.equals(intent.getStringExtra("apnType"), MobileDataStateTracker.this.mApnType)) {
                return;
            }
            MobileDataStateTracker.this.mNetworkInfo.setIsConnectedToProvisioningNetwork(false);
            String string7 = intent.getStringExtra("reason");
            String string8 = intent.getStringExtra("apn");
            MobileDataStateTracker.this.setDetailedState(NetworkInfo.DetailedState.FAILED, string7, string8);
        }
    }

    static class NetworkDataEntry {
        public int downloadBandwidth;
        public int latency;
        public int networkType;
        public int uploadBandwidth;

        NetworkDataEntry(int n, int n2, int n3, int n4) {
            this.networkType = n;
            this.downloadBandwidth = n2;
            this.uploadBandwidth = n3;
            this.latency = n4;
        }
    }
}

