/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.res.Resources;
import android.net.NetworkIdentity;
import android.net.wifi.WifiInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.TelephonyManager;
import com.android.internal.util.ArrayUtils;
import java.util.Objects;

public class NetworkTemplate
implements Parcelable {
    public static final Parcelable.Creator<NetworkTemplate> CREATOR;
    private static final int[] DATA_USAGE_NETWORK_TYPES;
    public static final int MATCH_ETHERNET = 5;
    public static final int MATCH_MOBILE_3G_LOWER = 2;
    public static final int MATCH_MOBILE_4G = 3;
    public static final int MATCH_MOBILE_ALL = 1;
    public static final int MATCH_MOBILE_WILDCARD = 6;
    public static final int MATCH_WIFI = 4;
    public static final int MATCH_WIFI_WILDCARD = 7;
    private static boolean sForceAllNetworkTypes;
    private final int mMatchRule;
    private final String mNetworkId;
    private final String mSubscriberId;

    static {
        DATA_USAGE_NETWORK_TYPES = Resources.getSystem().getIntArray(17235983);
        sForceAllNetworkTypes = false;
        CREATOR = new Parcelable.Creator<NetworkTemplate>(){

            @Override
            public NetworkTemplate createFromParcel(Parcel parcel) {
                return new NetworkTemplate(parcel);
            }

            public NetworkTemplate[] newArray(int n) {
                return new NetworkTemplate[n];
            }
        };
    }

    public NetworkTemplate(int n, String string2, String string3) {
        this.mMatchRule = n;
        this.mSubscriberId = string2;
        this.mNetworkId = string3;
    }

    private NetworkTemplate(Parcel parcel) {
        this.mMatchRule = parcel.readInt();
        this.mSubscriberId = parcel.readString();
        this.mNetworkId = parcel.readString();
    }

    public static NetworkTemplate buildTemplateEthernet() {
        return new NetworkTemplate(5, null, null);
    }

    @Deprecated
    public static NetworkTemplate buildTemplateMobile3gLower(String string2) {
        return new NetworkTemplate(2, string2, null);
    }

    @Deprecated
    public static NetworkTemplate buildTemplateMobile4g(String string2) {
        return new NetworkTemplate(3, string2, null);
    }

    public static NetworkTemplate buildTemplateMobileAll(String string2) {
        return new NetworkTemplate(1, string2, null);
    }

    public static NetworkTemplate buildTemplateMobileWildcard() {
        return new NetworkTemplate(6, null, null);
    }

    @Deprecated
    public static NetworkTemplate buildTemplateWifi() {
        return NetworkTemplate.buildTemplateWifiWildcard();
    }

    public static NetworkTemplate buildTemplateWifi(String string2) {
        return new NetworkTemplate(4, null, string2);
    }

    public static NetworkTemplate buildTemplateWifiWildcard() {
        return new NetworkTemplate(7, null, null);
    }

    private static void ensureSubtypeAvailable() {
        throw new IllegalArgumentException("Unable to enforce 3G_LOWER template on combined data.");
    }

    public static void forceAllNetworkTypes() {
        sForceAllNetworkTypes = true;
    }

    private static String getMatchRuleName(int n) {
        switch (n) {
            default: {
                return "UNKNOWN";
            }
            case 2: {
                return "MOBILE_3G_LOWER";
            }
            case 3: {
                return "MOBILE_4G";
            }
            case 1: {
                return "MOBILE_ALL";
            }
            case 4: {
                return "WIFI";
            }
            case 5: {
                return "ETHERNET";
            }
            case 6: {
                return "MOBILE_WILDCARD";
            }
            case 7: 
        }
        return "WIFI_WILDCARD";
    }

    private boolean matchesEthernet(NetworkIdentity networkIdentity) {
        return networkIdentity.mType == 9;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean matchesMobile(NetworkIdentity networkIdentity) {
        return networkIdentity.mType == 6 || (sForceAllNetworkTypes || ArrayUtils.contains(DATA_USAGE_NETWORK_TYPES, networkIdentity.mType)) && Objects.equals(this.mSubscriberId, networkIdentity.mSubscriberId);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean matchesMobile3gLower(NetworkIdentity networkIdentity) {
        NetworkTemplate.ensureSubtypeAvailable();
        if (networkIdentity.mType == 6 || !this.matchesMobile(networkIdentity)) {
            return false;
        }
        switch (TelephonyManager.getNetworkClass(networkIdentity.mSubType)) {
            default: {
                return false;
            }
            case 0: 
            case 1: 
            case 2: 
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean matchesMobile4g(NetworkIdentity networkIdentity) {
        NetworkTemplate.ensureSubtypeAvailable();
        if (networkIdentity.mType == 6) {
            return true;
        }
        if (!this.matchesMobile(networkIdentity)) return false;
        switch (TelephonyManager.getNetworkClass(networkIdentity.mSubType)) {
            case 3: {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean matchesMobileWildcard(NetworkIdentity networkIdentity) {
        return networkIdentity.mType == 6 || sForceAllNetworkTypes || ArrayUtils.contains(DATA_USAGE_NETWORK_TYPES, networkIdentity.mType);
    }

    private boolean matchesWifi(NetworkIdentity networkIdentity) {
        switch (networkIdentity.mType) {
            default: {
                return false;
            }
            case 1: 
        }
        return Objects.equals(WifiInfo.removeDoubleQuotes(this.mNetworkId), WifiInfo.removeDoubleQuotes(networkIdentity.mNetworkId));
    }

    private boolean matchesWifiWildcard(NetworkIdentity networkIdentity) {
        switch (networkIdentity.mType) {
            default: {
                return false;
            }
            case 1: 
            case 13: 
        }
        return true;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object object) {
        boolean bl = object instanceof NetworkTemplate;
        boolean bl2 = false;
        if (bl) {
            NetworkTemplate networkTemplate = (NetworkTemplate)object;
            int n = this.mMatchRule;
            int n2 = networkTemplate.mMatchRule;
            bl2 = false;
            if (n == n2) {
                boolean bl3 = Objects.equals(this.mSubscriberId, networkTemplate.mSubscriberId);
                bl2 = false;
                if (bl3) {
                    boolean bl4 = Objects.equals(this.mNetworkId, networkTemplate.mNetworkId);
                    bl2 = false;
                    if (bl4) {
                        bl2 = true;
                    }
                }
            }
        }
        return bl2;
    }

    public int getMatchRule() {
        return this.mMatchRule;
    }

    public String getNetworkId() {
        return this.mNetworkId;
    }

    public String getSubscriberId() {
        return this.mSubscriberId;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.mMatchRule, this.mSubscriberId, this.mNetworkId};
        return Objects.hash(objectArray);
    }

    public boolean matches(NetworkIdentity networkIdentity) {
        switch (this.mMatchRule) {
            default: {
                throw new IllegalArgumentException("unknown network template");
            }
            case 1: {
                return this.matchesMobile(networkIdentity);
            }
            case 2: {
                return this.matchesMobile3gLower(networkIdentity);
            }
            case 3: {
                return this.matchesMobile4g(networkIdentity);
            }
            case 4: {
                return this.matchesWifi(networkIdentity);
            }
            case 5: {
                return this.matchesEthernet(networkIdentity);
            }
            case 6: {
                return this.matchesMobileWildcard(networkIdentity);
            }
            case 7: 
        }
        return this.matchesWifiWildcard(networkIdentity);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("NetworkTemplate: ");
        stringBuilder.append("matchRule=").append(NetworkTemplate.getMatchRuleName(this.mMatchRule));
        if (this.mSubscriberId != null) {
            stringBuilder.append(", subscriberId=").append(NetworkIdentity.scrubSubscriberId(this.mSubscriberId));
        }
        if (this.mNetworkId != null) {
            stringBuilder.append(", networkId=").append(this.mNetworkId);
        }
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mMatchRule);
        parcel.writeString(this.mSubscriberId);
        parcel.writeString(this.mNetworkId);
    }
}

