/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.android.net.IProxyService;
import com.google.android.collect.Lists;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class PacProxySelector
extends ProxySelector {
    private static final String PROXY = "PROXY ";
    public static final String PROXY_SERVICE = "com.android.net.IProxyService";
    private static final String SOCKS = "SOCKS ";
    private static final String TAG = "PacProxySelector";
    private final List<Proxy> mDefaultList;
    private IProxyService mProxyService = IProxyService.Stub.asInterface(ServiceManager.getService("com.android.net.IProxyService"));

    public PacProxySelector() {
        if (this.mProxyService == null) {
            Log.e(TAG, "PacManager: no proxy service");
        }
        Proxy[] proxyArray = new Proxy[]{Proxy.NO_PROXY};
        this.mDefaultList = Lists.newArrayList(proxyArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static List<Proxy> parseResponse(String string2) {
        String[] stringArray = string2.split(";");
        ArrayList<Proxy> arrayList = Lists.newArrayList();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            Proxy proxy;
            String string3 = stringArray[i].trim();
            if (string3.equals("DIRECT")) {
                arrayList.add(Proxy.NO_PROXY);
                continue;
            }
            if (string3.startsWith(PROXY)) {
                Proxy proxy2 = PacProxySelector.proxyFromHostPort(Proxy.Type.HTTP, string3.substring(PROXY.length()));
                if (proxy2 == null) continue;
                arrayList.add(proxy2);
                continue;
            }
            if (!string3.startsWith(SOCKS) || (proxy = PacProxySelector.proxyFromHostPort(Proxy.Type.SOCKS, string3.substring(SOCKS.length()))) == null) continue;
            arrayList.add(proxy);
        }
        if (arrayList.size() == 0) {
            arrayList.add(Proxy.NO_PROXY);
        }
        return arrayList;
    }

    /*
     * Unable to fully structure code
     */
    private static Proxy proxyFromHostPort(Proxy.Type var0, String var1_1) {
        try {
            var4_2 = var1_1.split(":");
            var5_3 = new Proxy(var0, InetSocketAddress.createUnresolved(var4_2[0], Integer.parseInt(var4_2[1])));
            return var5_3;
        }
        catch (ArrayIndexOutOfBoundsException var2_4) lbl-1000:
        // 2 sources

        {
            while (true) {
                Log.d("PacProxySelector", "Unable to parse proxy " + var1_1 + " " + var2_5);
                return null;
            }
        }
        catch (NumberFormatException var2_6) {
            ** continue;
        }
    }

    @Override
    public void connectFailed(URI uRI, SocketAddress socketAddress, IOException iOException) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Proxy> select(URI uRI) {
        String string2;
        String string3;
        if (this.mProxyService == null) {
            this.mProxyService = IProxyService.Stub.asInterface(ServiceManager.getService(PROXY_SERVICE));
        }
        if (this.mProxyService == null) {
            Log.e(TAG, "select: no proxy service return NO_PROXY");
            Proxy[] proxyArray = new Proxy[]{Proxy.NO_PROXY};
            return Lists.newArrayList(proxyArray);
        }
        try {
            String string4;
            string3 = string4 = uRI.toURL().toString();
        }
        catch (MalformedURLException malformedURLException) {
            string3 = uRI.getHost();
        }
        try {
            String string5;
            string2 = string5 = this.mProxyService.resolvePacFile(uRI.getHost(), string3);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            string2 = null;
        }
        if (string2 == null) {
            return this.mDefaultList;
        }
        return PacProxySelector.parseResponse(string2);
    }
}

