/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.SSLSessionCache;
import android.os.SystemProperties;
import android.util.Log;
import com.android.org.conscrypt.OpenSSLContextImpl;
import com.android.org.conscrypt.OpenSSLSocketImpl;
import com.android.org.conscrypt.SSLClientSessionCache;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyManagementException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.SocketFactory;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SSLCertificateSocketFactory
extends SSLSocketFactory {
    private static final TrustManager[] INSECURE_TRUST_MANAGER;
    private static final String TAG = "SSLCertificateSocketFactory";
    private byte[] mAlpnProtocols = null;
    private PrivateKey mChannelIdPrivateKey = null;
    private final int mHandshakeTimeoutMillis;
    private SSLSocketFactory mInsecureFactory = null;
    private KeyManager[] mKeyManagers = null;
    private byte[] mNpnProtocols = null;
    private final boolean mSecure;
    private SSLSocketFactory mSecureFactory = null;
    private final SSLClientSessionCache mSessionCache;
    private TrustManager[] mTrustManagers = null;

    static {
        TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string2) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string2) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        INSECURE_TRUST_MANAGER = trustManagerArray;
    }

    @Deprecated
    public SSLCertificateSocketFactory(int n) {
        this(n, null, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private SSLCertificateSocketFactory(int n, SSLSessionCache sSLSessionCache, boolean bl) {
        this.mHandshakeTimeoutMillis = n;
        SSLClientSessionCache sSLClientSessionCache = null;
        if (sSLSessionCache != null) {
            sSLClientSessionCache = sSLSessionCache.mSessionCache;
        }
        this.mSessionCache = sSLClientSessionCache;
        this.mSecure = bl;
    }

    private static OpenSSLSocketImpl castToOpenSSLSocket(Socket socket) {
        if (!(socket instanceof OpenSSLSocketImpl)) {
            throw new IllegalArgumentException("Socket not created by this factory: " + socket);
        }
        return (OpenSSLSocketImpl)socket;
    }

    public static SocketFactory getDefault(int n) {
        return new SSLCertificateSocketFactory(n, null, true);
    }

    public static SSLSocketFactory getDefault(int n, SSLSessionCache sSLSessionCache) {
        return new SSLCertificateSocketFactory(n, sSLSessionCache, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SSLSocketFactory getDelegate() {
        synchronized (this) {
            if (!this.mSecure || SSLCertificateSocketFactory.isSslCheckRelaxed()) {
                if (this.mInsecureFactory != null) return this.mInsecureFactory;
                if (this.mSecure) {
                    Log.w(TAG, "*** BYPASSING SSL SECURITY CHECKS (socket.relaxsslcheck=yes) ***");
                } else {
                    Log.w(TAG, "Bypassing SSL security checks at caller's request");
                }
                this.mInsecureFactory = this.makeSocketFactory(this.mKeyManagers, INSECURE_TRUST_MANAGER);
                return this.mInsecureFactory;
            }
            if (this.mSecureFactory != null) return this.mSecureFactory;
            this.mSecureFactory = this.makeSocketFactory(this.mKeyManagers, this.mTrustManagers);
            return this.mSecureFactory;
        }
    }

    public static org.apache.http.conn.ssl.SSLSocketFactory getHttpSocketFactory(int n, SSLSessionCache sSLSessionCache) {
        return new org.apache.http.conn.ssl.SSLSocketFactory((SSLSocketFactory)new SSLCertificateSocketFactory(n, sSLSessionCache, true));
    }

    public static SSLSocketFactory getInsecure(int n, SSLSessionCache sSLSessionCache) {
        return new SSLCertificateSocketFactory(n, sSLSessionCache, false);
    }

    private static boolean isSslCheckRelaxed() {
        return "1".equals(SystemProperties.get("ro.debuggable")) && "yes".equals(SystemProperties.get("socket.relaxsslcheck"));
    }

    private SSLSocketFactory makeSocketFactory(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray) {
        try {
            OpenSSLContextImpl openSSLContextImpl = new OpenSSLContextImpl();
            openSSLContextImpl.engineInit(keyManagerArray, trustManagerArray, null);
            openSSLContextImpl.engineGetClientSessionContext().setPersistentCache(this.mSessionCache);
            SSLSocketFactory sSLSocketFactory = openSSLContextImpl.engineGetSocketFactory();
            return sSLSocketFactory;
        }
        catch (KeyManagementException keyManagementException) {
            Log.wtf(TAG, keyManagementException);
            return (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
    }

    static byte[] toLengthPrefixedList(byte[] ... byArray) {
        if (byArray.length == 0) {
            throw new IllegalArgumentException("items.length == 0");
        }
        int n = 0;
        int n2 = byArray.length;
        for (int i = 0; i < n2; ++i) {
            byte[] byArray2 = byArray[i];
            if (byArray2.length == 0 || byArray2.length > 255) {
                throw new IllegalArgumentException("s.length == 0 || s.length > 255: " + byArray2.length);
            }
            n += 1 + byArray2.length;
        }
        byte[] byArray3 = new byte[n];
        int n3 = byArray.length;
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            byte[] byArray4 = byArray[i];
            int n5 = n4 + 1;
            byArray3[n4] = (byte)byArray4.length;
            int n6 = byArray4.length;
            n4 = n5;
            for (int j = 0; j < n6; ++j) {
                byte by = byArray4[j];
                int n7 = n4 + 1;
                byArray3[n4] = by;
                n4 = n7;
            }
        }
        return byArray3;
    }

    public static void verifyHostname(Socket socket, String string2) throws IOException {
        if (!(socket instanceof SSLSocket)) {
            throw new IllegalArgumentException("Attempt to verify non-SSL socket");
        }
        if (!SSLCertificateSocketFactory.isSslCheckRelaxed()) {
            SSLSocket sSLSocket = (SSLSocket)socket;
            sSLSocket.startHandshake();
            SSLSession sSLSession = sSLSocket.getSession();
            if (sSLSession == null) {
                throw new SSLException("Cannot verify SSL socket without session");
            }
            if (!HttpsURLConnection.getDefaultHostnameVerifier().verify(string2, sSLSession)) {
                throw new SSLPeerUnverifiedException("Cannot verify hostname: " + string2);
            }
        }
    }

    @Override
    public Socket createSocket() throws IOException {
        OpenSSLSocketImpl openSSLSocketImpl = (OpenSSLSocketImpl)this.getDelegate().createSocket();
        openSSLSocketImpl.setNpnProtocols(this.mNpnProtocols);
        openSSLSocketImpl.setAlpnProtocols(this.mAlpnProtocols);
        openSSLSocketImpl.setHandshakeTimeout(this.mHandshakeTimeoutMillis);
        openSSLSocketImpl.setChannelIdPrivateKey(this.mChannelIdPrivateKey);
        return openSSLSocketImpl;
    }

    @Override
    public Socket createSocket(String string2, int n) throws IOException {
        OpenSSLSocketImpl openSSLSocketImpl = (OpenSSLSocketImpl)this.getDelegate().createSocket(string2, n);
        openSSLSocketImpl.setNpnProtocols(this.mNpnProtocols);
        openSSLSocketImpl.setAlpnProtocols(this.mAlpnProtocols);
        openSSLSocketImpl.setHandshakeTimeout(this.mHandshakeTimeoutMillis);
        openSSLSocketImpl.setChannelIdPrivateKey(this.mChannelIdPrivateKey);
        if (this.mSecure) {
            SSLCertificateSocketFactory.verifyHostname((Socket)openSSLSocketImpl, string2);
        }
        return openSSLSocketImpl;
    }

    @Override
    public Socket createSocket(String string2, int n, InetAddress inetAddress, int n2) throws IOException {
        OpenSSLSocketImpl openSSLSocketImpl = (OpenSSLSocketImpl)this.getDelegate().createSocket(string2, n, inetAddress, n2);
        openSSLSocketImpl.setNpnProtocols(this.mNpnProtocols);
        openSSLSocketImpl.setAlpnProtocols(this.mAlpnProtocols);
        openSSLSocketImpl.setHandshakeTimeout(this.mHandshakeTimeoutMillis);
        openSSLSocketImpl.setChannelIdPrivateKey(this.mChannelIdPrivateKey);
        if (this.mSecure) {
            SSLCertificateSocketFactory.verifyHostname((Socket)openSSLSocketImpl, string2);
        }
        return openSSLSocketImpl;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        OpenSSLSocketImpl openSSLSocketImpl = (OpenSSLSocketImpl)this.getDelegate().createSocket(inetAddress, n);
        openSSLSocketImpl.setNpnProtocols(this.mNpnProtocols);
        openSSLSocketImpl.setAlpnProtocols(this.mAlpnProtocols);
        openSSLSocketImpl.setHandshakeTimeout(this.mHandshakeTimeoutMillis);
        openSSLSocketImpl.setChannelIdPrivateKey(this.mChannelIdPrivateKey);
        return openSSLSocketImpl;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        OpenSSLSocketImpl openSSLSocketImpl = (OpenSSLSocketImpl)this.getDelegate().createSocket(inetAddress, n, inetAddress2, n2);
        openSSLSocketImpl.setNpnProtocols(this.mNpnProtocols);
        openSSLSocketImpl.setAlpnProtocols(this.mAlpnProtocols);
        openSSLSocketImpl.setHandshakeTimeout(this.mHandshakeTimeoutMillis);
        openSSLSocketImpl.setChannelIdPrivateKey(this.mChannelIdPrivateKey);
        return openSSLSocketImpl;
    }

    @Override
    public Socket createSocket(Socket socket, String string2, int n, boolean bl) throws IOException {
        OpenSSLSocketImpl openSSLSocketImpl = (OpenSSLSocketImpl)this.getDelegate().createSocket(socket, string2, n, bl);
        openSSLSocketImpl.setNpnProtocols(this.mNpnProtocols);
        openSSLSocketImpl.setAlpnProtocols(this.mAlpnProtocols);
        openSSLSocketImpl.setHandshakeTimeout(this.mHandshakeTimeoutMillis);
        openSSLSocketImpl.setChannelIdPrivateKey(this.mChannelIdPrivateKey);
        if (this.mSecure) {
            SSLCertificateSocketFactory.verifyHostname((Socket)openSSLSocketImpl, string2);
        }
        return openSSLSocketImpl;
    }

    public byte[] getAlpnSelectedProtocol(Socket socket) {
        return SSLCertificateSocketFactory.castToOpenSSLSocket(socket).getAlpnSelectedProtocol();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.getDelegate().getDefaultCipherSuites();
    }

    public byte[] getNpnSelectedProtocol(Socket socket) {
        return SSLCertificateSocketFactory.castToOpenSSLSocket(socket).getNpnSelectedProtocol();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.getDelegate().getSupportedCipherSuites();
    }

    public void setAlpnProtocols(byte[][] byArray) {
        this.mAlpnProtocols = SSLCertificateSocketFactory.toLengthPrefixedList(byArray);
    }

    public void setChannelIdPrivateKey(PrivateKey privateKey) {
        this.mChannelIdPrivateKey = privateKey;
    }

    public void setHostname(Socket socket, String string2) {
        SSLCertificateSocketFactory.castToOpenSSLSocket(socket).setHostname(string2);
    }

    public void setKeyManagers(KeyManager[] keyManagerArray) {
        this.mKeyManagers = keyManagerArray;
        this.mSecureFactory = null;
        this.mInsecureFactory = null;
    }

    public void setNpnProtocols(byte[][] byArray) {
        this.mNpnProtocols = SSLCertificateSocketFactory.toLengthPrefixedList(byArray);
    }

    public void setSoWriteTimeout(Socket socket, int n) throws SocketException {
        SSLCertificateSocketFactory.castToOpenSSLSocket(socket).setSoWriteTimeout(n);
    }

    public void setTrustManagers(TrustManager[] trustManagerArray) {
        this.mTrustManagers = trustManagerArray;
        this.mSecureFactory = null;
    }

    public void setUseSessionTickets(Socket socket, boolean bl) {
        SSLCertificateSocketFactory.castToOpenSSLSocket(socket).setUseSessionTickets(bl);
    }
}

