/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.util.Log;
import com.android.org.conscrypt.ClientSessionContext;
import com.android.org.conscrypt.FileClientSessionCache;
import com.android.org.conscrypt.SSLClientSessionCache;
import java.io.File;
import java.io.IOException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSessionContext;

public final class SSLSessionCache {
    private static final String TAG = "SSLSessionCache";
    final SSLClientSessionCache mSessionCache;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SSLSessionCache(Context context) {
        SSLClientSessionCache sSLClientSessionCache;
        File file = context.getDir("sslcache", 0);
        try {
            SSLClientSessionCache sSLClientSessionCache2;
            sSLClientSessionCache = sSLClientSessionCache2 = FileClientSessionCache.usingDirectory((File)file);
        }
        catch (IOException iOException) {
            Log.w(TAG, "Unable to create SSL session cache in " + file, iOException);
            sSLClientSessionCache = null;
        }
        this.mSessionCache = sSLClientSessionCache;
    }

    public SSLSessionCache(File file) throws IOException {
        this.mSessionCache = FileClientSessionCache.usingDirectory((File)file);
    }

    public SSLSessionCache(Object object) {
        this.mSessionCache = (SSLClientSessionCache)object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void install(SSLSessionCache sSLSessionCache, SSLContext sSLContext) {
        SSLSessionContext sSLSessionContext = sSLContext.getClientSessionContext();
        if (!(sSLSessionContext instanceof ClientSessionContext)) {
            throw new IllegalArgumentException("Incompatible SSLContext: " + sSLContext);
        }
        ClientSessionContext clientSessionContext = (ClientSessionContext)sSLSessionContext;
        SSLClientSessionCache sSLClientSessionCache = sSLSessionCache == null ? null : sSLSessionCache.mSessionCache;
        clientSessionContext.setPersistentCache(sSLClientSessionCache);
    }
}

