/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.NetworkUtils;
import android.net.RouteInfo;
import android.os.Parcel;
import android.os.Parcelable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class StaticIpConfiguration
implements Parcelable {
    public static Parcelable.Creator<StaticIpConfiguration> CREATOR = new Parcelable.Creator<StaticIpConfiguration>(){

        @Override
        public StaticIpConfiguration createFromParcel(Parcel parcel) {
            StaticIpConfiguration staticIpConfiguration = new StaticIpConfiguration();
            StaticIpConfiguration.readFromParcel(staticIpConfiguration, parcel);
            return staticIpConfiguration;
        }

        public StaticIpConfiguration[] newArray(int n) {
            return new StaticIpConfiguration[n];
        }
    };
    public final ArrayList<InetAddress> dnsServers = new ArrayList();
    public String domains;
    public InetAddress gateway;
    public LinkAddress ipAddress;

    public StaticIpConfiguration() {
    }

    public StaticIpConfiguration(StaticIpConfiguration staticIpConfiguration) {
        this();
        if (staticIpConfiguration != null) {
            this.ipAddress = staticIpConfiguration.ipAddress;
            this.gateway = staticIpConfiguration.gateway;
            this.dnsServers.addAll(staticIpConfiguration.dnsServers);
            this.domains = staticIpConfiguration.domains;
        }
    }

    protected static void readFromParcel(StaticIpConfiguration staticIpConfiguration, Parcel parcel) {
        staticIpConfiguration.ipAddress = (LinkAddress)parcel.readParcelable(null);
        staticIpConfiguration.gateway = NetworkUtils.unparcelInetAddress(parcel);
        staticIpConfiguration.dnsServers.clear();
        int n = parcel.readInt();
        for (int i = 0; i < n; ++i) {
            staticIpConfiguration.dnsServers.add(NetworkUtils.unparcelInetAddress(parcel));
        }
    }

    public void clear() {
        this.ipAddress = null;
        this.gateway = null;
        this.dnsServers.clear();
        this.domains = null;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (this == object) break block4;
                if (!(object instanceof StaticIpConfiguration)) {
                    return false;
                }
                StaticIpConfiguration staticIpConfiguration = (StaticIpConfiguration)object;
                if (staticIpConfiguration == null || !Objects.equals(this.ipAddress, staticIpConfiguration.ipAddress) || !Objects.equals(this.gateway, staticIpConfiguration.gateway) || !this.dnsServers.equals(staticIpConfiguration.dnsServers) || !Objects.equals(this.domains, staticIpConfiguration.domains)) break block5;
            }
            return true;
        }
        return false;
    }

    public List<RouteInfo> getRoutes(String string2) {
        ArrayList<RouteInfo> arrayList = new ArrayList<RouteInfo>(2);
        if (this.ipAddress != null) {
            arrayList.add(new RouteInfo(this.ipAddress, null, string2));
        }
        if (this.gateway != null) {
            arrayList.add(new RouteInfo((LinkAddress)null, this.gateway, string2));
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int hashCode() {
        int n = this.ipAddress == null ? 0 : this.ipAddress.hashCode();
        int n2 = 47 * (n + 611);
        int n3 = this.gateway == null ? 0 : this.gateway.hashCode();
        int n4 = 47 * (n2 + n3);
        String string2 = this.domains;
        int n5 = 0;
        if (string2 == null) {
            return 47 * (n4 + n5) + this.dnsServers.hashCode();
        }
        n5 = this.domains.hashCode();
        return 47 * (n4 + n5) + this.dnsServers.hashCode();
    }

    public LinkProperties toLinkProperties(String string2) {
        LinkProperties linkProperties = new LinkProperties();
        linkProperties.setInterfaceName(string2);
        if (this.ipAddress != null) {
            linkProperties.addLinkAddress(this.ipAddress);
        }
        Iterator<RouteInfo> iterator = this.getRoutes(string2).iterator();
        while (iterator.hasNext()) {
            linkProperties.addRoute(iterator.next());
        }
        Iterator<InetAddress> iterator2 = this.dnsServers.iterator();
        while (iterator2.hasNext()) {
            linkProperties.addDnsServer(iterator2.next());
        }
        return linkProperties;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IP address ");
        if (this.ipAddress != null) {
            stringBuffer.append(this.ipAddress).append(" ");
        }
        stringBuffer.append("Gateway ");
        if (this.gateway != null) {
            stringBuffer.append(this.gateway.getHostAddress()).append(" ");
        }
        stringBuffer.append(" DNS servers: [");
        for (InetAddress inetAddress : this.dnsServers) {
            stringBuffer.append(" ").append(inetAddress.getHostAddress());
        }
        stringBuffer.append(" ] Domains");
        if (this.domains != null) {
            stringBuffer.append(this.domains);
        }
        return stringBuffer.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeParcelable(this.ipAddress, n);
        NetworkUtils.parcelInetAddress(parcel, this.gateway, n);
        parcel.writeInt(this.dnsServers.size());
        Iterator<InetAddress> iterator = this.dnsServers.iterator();
        while (iterator.hasNext()) {
            NetworkUtils.parcelInetAddress(parcel, iterator.next(), n);
        }
    }
}

