/*
 * Decompiled with CFR 0.152.
 */
package android.net.dhcp;

import android.net.dhcp.DhcpPacket;
import android.net.dhcp.DhcpStateMachine;
import java.net.Inet4Address;
import java.nio.ByteBuffer;

class DhcpDiscoverPacket
extends DhcpPacket {
    DhcpDiscoverPacket(int n, byte[] byArray, boolean bl) {
        super(n, Inet4Address.ANY, Inet4Address.ANY, Inet4Address.ANY, Inet4Address.ANY, byArray, bl);
    }

    @Override
    public ByteBuffer buildPacket(int n, short s, short s2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(1500);
        this.fillInPacket(n, Inet4Address.ALL, Inet4Address.ANY, s, s2, byteBuffer, (byte)1, true);
        byteBuffer.flip();
        return byteBuffer;
    }

    @Override
    public void doNextOp(DhcpStateMachine dhcpStateMachine) {
        dhcpStateMachine.onDiscoverReceived(this.mBroadcast, this.mTransId, this.mClientMac, this.mRequestedParams);
    }

    @Override
    void finishPacket(ByteBuffer byteBuffer) {
        this.addTlv(byteBuffer, (byte)53, (byte)1);
        this.addTlv(byteBuffer, (byte)55, this.mRequestedParams);
        this.addTlvEnd(byteBuffer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String toString() {
        String string2;
        String string3 = super.toString();
        StringBuilder stringBuilder = new StringBuilder().append(string3).append(" DISCOVER ");
        if (this.mBroadcast) {
            string2 = "broadcast ";
            return stringBuilder.append(string2).toString();
        }
        string2 = "unicast ";
        return stringBuilder.append(string2).toString();
    }
}

